/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.imp.JavaLocationEffigy;
import com.ibm.dtfj.sov.java.JavaLocationProxy;
import com.ibm.dtfj.sov.java.JavaMethodProxy;
import com.ibm.dtfj.sov.java.imp.JavaMethodProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import java.util.TreeMap;

public class JavaLocationProxyImpl
implements JavaLocationProxy {
    private long methodBlockAddress;
    private AddressSpaceProxy context;
    private JavaMethodProxyImpl method = null;
    private long pc;
    private long sp;
    private long args;
    private long vars;
    private String name;
    private String myFileName = "";
    private int myLineNumber = -1;
    private TreeMap compiledMethods;
    private ImagePointerProxy addressPointer;

    public JavaLocationProxyImpl(AddressSpaceProxy context) {
        this.context = context;
        this.compiledMethods = ((JavaRuntimeProxyImpl)context.getJavaRuntimeProxy()).getJITCompiledMethods();
    }

    public ImagePointerProxy getAddress() throws CorruptDataException {
        return this.addressPointer;
    }

    public int getLineNumber() throws DataUnavailable, CorruptDataException {
        if (this.myLineNumber == -1) {
            throw new DataUnavailable("line_no not available");
        }
        return this.myLineNumber;
    }

    public String getFilename() throws DataUnavailable, CorruptDataException {
        return this.myFileName;
    }

    public int getCompilationLevel() throws CorruptDataException {
        if (this.method == null) {
            this.method = (JavaMethodProxyImpl)this.getMethod();
        }
        return this.method.getCompilationLevel();
    }

    public String toString() {
        if (this.name == null || this.name.equals("pseudo frame")) {
            return "pseudo frame";
        }
        return this.name;
    }

    public JavaMethodProxy getMethod() throws CorruptDataException {
        try {
            if (this.name.equals("pseudo frame")) {
                if (this.method == null) {
                    this.method = new JavaMethodProxyImpl(this.methodBlockAddress, this.context, this.name);
                }
                return this.method;
            }
            if (this.method != null) {
                if (this.methodBlockAddress != this.method.getAddress()) {
                    if (this.compiledMethods != null) {
                        this.method = (JavaMethodProxyImpl)this.compiledMethods.get(String.valueOf(this.methodBlockAddress));
                        if (this.method == null) {
                            this.method = new JavaMethodProxyImpl(this.methodBlockAddress, this.context, this.name);
                        }
                    } else {
                        this.method = new JavaMethodProxyImpl(this.methodBlockAddress, this.context, this.name);
                    }
                }
            } else if (this.compiledMethods != null) {
                this.method = (JavaMethodProxyImpl)this.compiledMethods.get(String.valueOf(this.methodBlockAddress));
                if (this.method == null) {
                    this.method = new JavaMethodProxyImpl(this.methodBlockAddress, this.context, this.name);
                }
            } else {
                this.method = new JavaMethodProxyImpl(this.methodBlockAddress, this.context, this.name);
            }
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
        return this.method;
    }

    public void setMb(long mb) {
        this.methodBlockAddress = mb;
    }

    public void setPc(long pc) {
        this.pc = pc;
        this.addressPointer = new ImagePointerProxy(pc, this.context);
    }

    public void setSp(long sp) {
        this.sp = sp;
    }

    public void setArgs(long args) {
        this.args = args;
    }

    public void setVars(long vars) {
        this.vars = vars;
    }

    public ImagePointerProxy getBasePointer() {
        return new ImagePointerProxy(this.sp, this.context);
    }

    public void setName(String name) {
        this.name = name;
        if (!(name.equals("pseudo frame") || name.equals("__unknown__") || name.equals("empty frame"))) {
            if (name.indexOf(58) > 0) {
                this.myFileName = name.substring(name.indexOf(40) + 1, name.indexOf(58));
                String linenumber = name.substring(name.lastIndexOf(58) + 1, name.indexOf(41));
                this.myLineNumber = !linenumber.equals("Compiled method") ? Integer.parseInt(linenumber) : -1;
            } else {
                this.myFileName = name.substring(name.indexOf(40) + 1, name.indexOf(41));
                this.myLineNumber = -1;
            }
        } else {
            this.myFileName = "";
            this.myLineNumber = -1;
        }
    }

    public int hashCode() {
        return this.context.hashCode() ^ this.addressPointer.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaLocationEffigy) {
            JavaLocationEffigy local = (JavaLocationEffigy)obj;
            return this.context.equals(((JavaLocationProxyImpl)local.getProxy()).context) && this.addressPointer.equals(((JavaLocationProxyImpl)local.getProxy()).addressPointer) && this.method.equals(((JavaLocationProxyImpl)local.getProxy()).method);
        }
        return false;
    }
}

