/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.data.StructuredDataLocator;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.image.ImageSectionImpl;
import com.ibm.dtfj.sov.imp.ImagePointerEffigy;
import com.ibm.dtfj.sov.imp.JavaMethodEffigy;
import com.ibm.dtfj.sov.java.JavaClassProxy;
import com.ibm.dtfj.sov.java.JavaMethodProxy;
import com.ibm.dtfj.sov.java.imp.JavaClassProxyImpl;
import java.util.Iterator;
import java.util.Vector;

public class JavaMethodProxyImpl
implements JavaMethodProxy {
    private AddressSpaceProxy context;
    private DataObject myDataObject;
    private StructuredDataLocator myReader;
    private JavaClassProxyImpl myDeclaringClass;
    private long address;
    private int compilationLevel;
    static final int JIT_Not_Compiled = 0;
    static final int JIT_FAST_COMPILATION = 1;
    static final int JIT_FULLOPT_COMPILATION = 8;
    private String mySignature = null;
    short myModifiers;
    private String myName = null;
    long offset;
    long staticAddress;
    long start = 0L;
    long end = 0L;
    Vector compiledSections = new Vector();

    public JavaMethodProxyImpl(long address, AddressSpaceProxy context, String name) throws MemoryAccessException, CorruptDataException {
        this.address = address;
        this.myDataObject = new DataObject(null, "methodblock", context);
        this.myDataObject.setAddress(address);
        this.context = context;
        this.myReader = this.myDataObject.getReader();
        if (name.equals("__unknown__")) {
            this.myName = "__unknown__";
        } else if (address != 0L) {
            this.fixup();
        } else {
            this.myName = "pseudo frame";
        }
    }

    public JavaMethodProxyImpl(long methodBlockAddress, AddressSpaceProxy context) throws MemoryAccessException, CorruptDataException {
        this.address = methodBlockAddress;
        this.context = context;
        this.myDataObject = new DataObject(null, "methodblock", context);
        this.myDataObject.setAddress(this.address);
        this.myReader = this.myDataObject.getReader();
        this.fixup();
    }

    public JavaMethodProxyImpl(long methodBlockAddress, AddressSpaceProxy context, long start, long end) throws MemoryAccessException, CorruptDataException {
        this.address = methodBlockAddress;
        this.context = context;
        this.myDataObject = new DataObject(null, "methodblock", context);
        this.myDataObject.setAddress(this.address);
        this.myReader = this.myDataObject.getReader();
        this.start = start;
        this.end = end;
        this.fixup();
    }

    private void fixup() throws CorruptDataException, MemoryAccessException {
        this.myDeclaringClass = new JavaClassProxyImpl(new DataObject(this.myDataObject, "member.clazz", this.context), this.context);
        this.mySignature = this.myReader.getString("member.signature");
        this.myName = this.myReader.getString("member.name");
        this.myModifiers = this.myReader.getshort("member.access");
        int cl = this.myReader.getint("xe.jit_data.CompiledCodeFlags");
        if (cl == 0) {
            this.compilationLevel = 0;
        } else {
            this.compilationLevel = (cl & 8) != 0 ? 8 : 1;
            this.setCompiledSections();
        }
    }

    public Iterator getBytecodeSections() {
        Vector<Object> bytecodeSections = new Vector<Object>();
        try {
            long bytecodeAddress = 0L;
            short size = 0;
            bytecodeAddress = this.myReader.getlong("(long)code");
            size = this.myReader.getshort("code_length");
            ImagePointerProxy base = null;
            base = new ImagePointerProxy(bytecodeAddress, this.context);
            ImagePointerEffigy myBasePointer = (ImagePointerEffigy)Effigy.create("ImagePointerEffigy", base, this.context, this.context.getPlatformName());
            bytecodeSections.add(new ImageSectionImpl(myBasePointer, size, "ByteCode Section : ", false, false, false, false));
        }
        catch (CorruptDataException e) {
            bytecodeSections.add(new CorruptDataImpl(e.getMessage()));
        }
        catch (MemoryAccessException e) {
            bytecodeSections.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
        return bytecodeSections.iterator();
    }

    public Iterator getCompiledSections() {
        return this.compiledSections.iterator();
    }

    public void setCompiledSections() {
        if (this.compilationLevel > 0) {
            if (this.start == 0L && this.end == 0L) {
                ImagePointerProxy base = new ImagePointerProxy(this.address, this.context);
                ImagePointerEffigy myBasePointer = (ImagePointerEffigy)Effigy.create("ImagePointerEffigy", base, this.context, this.context.getPlatformName());
                this.compiledSections.add(new CorruptDataImpl(myBasePointer, "No entry in the AVL tree of committed code for the compiled method at (0x" + Long.toHexString(this.address) + ")"));
            } else {
                ImagePointerProxy base = new ImagePointerProxy(this.start, this.context);
                ImagePointerEffigy myBasePointer = (ImagePointerEffigy)Effigy.create("ImagePointerEffigy", base, this.context, this.context.getPlatformName());
                this.compiledSections.add(new ImageSectionImpl(myBasePointer, this.end - this.start, "Compiled Code Section : ", false, false, false, false));
            }
        }
    }

    public int getModifiers() throws CorruptDataException {
        return this.myModifiers;
    }

    public JavaClassProxy getDeclaringClass() throws DataUnavailable {
        if (this.myDeclaringClass == null) {
            throw new DataUnavailable("Class that declared this method is missing");
        }
        return this.myDeclaringClass;
    }

    public String getName() throws CorruptDataException {
        return this.myName;
    }

    public long getAddress() {
        return this.address;
    }

    public String getSignature() {
        return this.mySignature;
    }

    public int hashCode() {
        return this.myDataObject.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaMethodEffigy) {
            return ((JavaMethodProxyImpl)((JavaMethodEffigy)obj).getProxy()).myDataObject.equals(this.myDataObject);
        }
        if (obj instanceof JavaMethodProxyImpl) {
            return ((JavaMethodProxyImpl)obj).myDataObject.equals(this.myDataObject);
        }
        return false;
    }

    public int getCompilationLevel() {
        return this.compilationLevel;
    }
}

