/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.image.ImageSectionImpl;
import com.ibm.dtfj.sov.imp.JavaObjectEffigy;
import com.ibm.dtfj.sov.java.ArrayAccessor;
import com.ibm.dtfj.sov.java.JavaClassProxy;
import com.ibm.dtfj.sov.java.JavaObjectProxy;
import com.ibm.dtfj.sov.java.imp.FieldIterator;
import com.ibm.dtfj.sov.java.imp.HeapChunk;
import com.ibm.dtfj.sov.java.imp.JavaClassLoaderProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaClassProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import com.ibm.dtfj.sov.java.imp.NullIterator;
import com.ibm.dtfj.sov.java.imp.SyntheticArrayClassProxyImpl;
import java.util.Iterator;
import java.util.Vector;

public class JavaObjectProxyImpl
implements JavaObjectProxy {
    private long olinkAddress;
    private long objectAddress;
    private long methodTableAddress;
    private long classBlockAddress;
    private long olink;
    private int locknflags;
    private int objectType = 0;
    static long WORD_LENGTH;
    AddressSpaceProxy context;
    private boolean GCedHeap;
    private static final long OBJECTGRAIN = 8L;
    private static final long OLINK_IsSwapped = 1L;
    private static final long OLINK_IsDosed = 2L;
    private static final long OLINK_IsPinned = 4L;
    private static long OLINK_IsContendedFor;
    private static long OLINK_IsHashed;
    private static long OLINK_LenMask;
    private static final long flatLockMask = -256L;
    private static final long monitorMask = 0x7FFFFF00L;
    private static final long threadMask = 0x7FFF0000L;
    private static final long countMask = 65280L;
    private static final long shapeMask = Integer.MIN_VALUE;
    private static final long isHashedAndMoved = 4L;
    private static final long isArrayMask = 2L;
    private static final long typeMask = 255L;
    private static final long typeShift = 3L;
    private static final long threadShift = 16L;
    private static final long countShift = 8L;
    private static final long monitorShift = 8L;
    private static final int T_TMASK = 28;
    private static final int T_LMASK = 3;
    private static final int T_LSIZE = 2;
    private static int N_TYPECODES;
    private static String[] typeCodeDescriptions;
    private static final int T_NORMAL_OBJECT = 0;
    private static final int T_CLASS = 2;
    private static final int T_BOOLEAN = 4;
    private static final int T_FLOATING = 4;
    private static final int T_CHAR = 5;
    private static final int T_INTEGER = 8;
    private static final int T_UINTEGER = 12;
    private static final int T_FLOAT;
    private static final int T_DOUBLE;
    private static final int T_BYTE;
    private static final int T_UBYTE;
    private static final int T_SHORT;
    private static final int T_INT;
    private static final int T_LONG;
    DataObject classBlockDO;
    int sharedClassId;
    private JavaClassProxy syntheticArrayClass;
    private static AddressSpaceProxy lastContext;
    private static JavaRuntimeProxyImpl jvm;
    private JavaRuntimeProxyImpl jvmProxyImpl;
    private boolean isClass;
    JavaClassProxyImpl thisAsClass;
    private Vector sections;

    private static int T_MKTYPE(int baseType, int length) {
        return baseType & 0x1C | length & 3;
    }

    private static void initStatics(AddressSpaceProxy context) {
        if (lastContext != null && context == lastContext) {
            return;
        }
        WORD_LENGTH = context.getWordLength().size;
        OLINK_IsHashed = 1 << (int)(WORD_LENGTH * 8L - 1L);
        OLINK_IsContendedFor = 1 << (int)(WORD_LENGTH * 8L - 2L);
        OLINK_LenMask = (OLINK_IsHashed | OLINK_IsContendedFor | 7L) ^ 0xFFFFFFFFFFFFFFFFL;
        jvm = (JavaRuntimeProxyImpl)context.getJavaRuntimeProxy();
    }

    public static JavaObjectProxyImpl getInstance(long objectAddress, AddressSpaceProxy context) throws MemoryAccessException, CorruptDataException {
        JavaObjectProxyImpl.initStatics(context);
        long olinkAddress = objectAddress - WORD_LENGTH;
        if (jvm.isLiveChunk(olinkAddress)) {
            return JavaObjectProxyImpl.getInstance(objectAddress, context, true);
        }
        throw new MemoryAccessException((ImagePointer)((Object)Effigy.create("ImagePointerEffigy", new ImagePointerProxy(objectAddress, context), context, context.getPlatformName())), "Invalid object address");
    }

    public static JavaObjectProxyImpl getInstance(long objectAddress, AddressSpaceProxy context, boolean GCedHeap) throws MemoryAccessException, CorruptDataException {
        JavaObjectProxyImpl.initStatics(context);
        return new JavaObjectProxyImpl(objectAddress, context, GCedHeap);
    }

    private JavaObjectProxyImpl(long objectAddress, AddressSpaceProxy context, boolean GCedHeap) throws MemoryAccessException, CorruptDataException {
        JavaObjectProxyImpl.typeCodeDescriptions[0] = "T_NORMAL_OBJECT";
        JavaObjectProxyImpl.typeCodeDescriptions[1] = "T_XXUNUSEDXX1";
        JavaObjectProxyImpl.typeCodeDescriptions[2] = "T_CLASS";
        JavaObjectProxyImpl.typeCodeDescriptions[4] = "T_BOOLEAN";
        JavaObjectProxyImpl.typeCodeDescriptions[5] = "T_CHAR";
        JavaObjectProxyImpl.typeCodeDescriptions[JavaObjectProxyImpl.T_FLOAT] = "T_FLOAT";
        JavaObjectProxyImpl.typeCodeDescriptions[JavaObjectProxyImpl.T_DOUBLE] = "T_DOUBLE";
        JavaObjectProxyImpl.typeCodeDescriptions[JavaObjectProxyImpl.T_BYTE] = "T_BYTE";
        JavaObjectProxyImpl.typeCodeDescriptions[JavaObjectProxyImpl.T_UBYTE] = "T_UBYTE";
        JavaObjectProxyImpl.typeCodeDescriptions[JavaObjectProxyImpl.T_SHORT] = "T_SHORT";
        JavaObjectProxyImpl.typeCodeDescriptions[JavaObjectProxyImpl.T_INT] = "T_INT";
        JavaObjectProxyImpl.typeCodeDescriptions[JavaObjectProxyImpl.T_LONG] = "T_LONG";
        JavaObjectProxyImpl.typeCodeDescriptions[16] = "T_XXUNUSEDXX2";
        JavaObjectProxyImpl.typeCodeDescriptions[17] = "T_VOID";
        JavaObjectProxyImpl.typeCodeDescriptions[18] = "T_FUNC";
        JavaObjectProxyImpl.typeCodeDescriptions[19] = "T_UNKNOWN";
        JavaObjectProxyImpl.typeCodeDescriptions[20] = "T_ERROR";
        this.classBlockDO = null;
        this.syntheticArrayClass = null;
        this.isClass = false;
        this.thisAsClass = null;
        this.sections = null;
        this.initializeHeapObject(objectAddress, context, GCedHeap);
    }

    private void initializeHeapObject(long objectAddress, AddressSpaceProxy context, boolean GCedHeap) throws MemoryAccessException, CorruptDataException {
        this.GCedHeap = GCedHeap;
        if (this.classBlockDO == null) {
            this.classBlockDO = new DataObject(null, "Hjava_lang_Class", context);
        }
        this.context = context;
        this.jvmProxyImpl = (JavaRuntimeProxyImpl)context.getJavaRuntimeProxy();
        JavaObjectProxyImpl.initStatics(context);
        this.objectAddress = objectAddress;
        this.olinkAddress = objectAddress - WORD_LENGTH;
        this.olink = context.readPointer(this.olinkAddress);
        this.methodTableAddress = context.readPointer(objectAddress);
        this.locknflags = (int)context.readInt(objectAddress + WORD_LENGTH);
        this.objectType = (int)((long)this.locknflags & 0xFFL) >> 3;
        if (this.isArray()) {
            if (this.objectType == 2) {
                this.classBlockAddress = context.readPointer(objectAddress + WORD_LENGTH * (2L + this.methodTableAddress));
                this.classBlockDO.setAddress(this.classBlockAddress);
                long elementClassAddress = this.classBlockAddress;
                long array_of_me = this.classBlockDO.getReader().getlong("obj.(long)array_of_me");
                if (array_of_me == 0L) {
                    String className;
                    JavaClassProxyImpl jcpi = new JavaClassProxyImpl(this.classBlockDO, context);
                    JavaClassLoaderProxyImpl myClassLoader = (JavaClassLoaderProxyImpl)jcpi.getClassLoader();
                    JavaClassProxyImpl myArrayClass = (JavaClassProxyImpl)myClassLoader.findClass(className = (className = this.classBlockDO.getReader().getString("obj.name")).charAt(0) == '[' ? "[" + className : "[L" + className + ";");
                    if (myArrayClass != null) {
                        this.classBlockAddress = myArrayClass.getCBAddress();
                        this.classBlockDO.setAddress(this.classBlockAddress);
                    } else {
                        this.classBlockAddress = 0L;
                        this.syntheticArrayClass = new SyntheticArrayClassProxyImpl(className, new JavaClassProxyImpl(elementClassAddress, context), context);
                    }
                } else {
                    this.classBlockAddress = array_of_me;
                    this.classBlockDO.setAddress(this.classBlockAddress);
                }
            } else {
                long offset = 0L;
                if (this.objectType == 4) {
                    offset = 1L;
                } else if (this.objectType == T_BYTE) {
                    offset = 2L;
                } else if (this.objectType == 5) {
                    offset = 3L;
                } else if (this.objectType == T_SHORT) {
                    offset = 4L;
                } else if (this.objectType == T_INT) {
                    offset = 5L;
                } else if (this.objectType == T_LONG) {
                    offset = 6L;
                } else if (this.objectType == T_FLOAT) {
                    offset = 7L;
                } else if (this.objectType == T_DOUBLE) {
                    offset = 8L;
                }
                this.classBlockAddress = ((JavaRuntimeProxyImpl)context.getJavaRuntimeProxy()).getPrimitiveArray(offset);
            }
            this.classBlockDO.setAddress(this.classBlockAddress);
        } else if (this.objectType == 0) {
            String className = null;
            this.classBlockAddress = context.readPointer(this.methodTableAddress + 8L);
            this.classBlockDO.setAddress(this.classBlockAddress);
            className = this.classBlockDO.getReader().getString("obj.name");
            if (className.equals("java/lang/Class")) {
                this.isClass = true;
            }
            this.sharedClassId = this.classBlockDO.getReader().getInteger("obj.shared_class_id");
        }
    }

    public boolean isArray() throws CorruptDataException {
        return ((long)this.locknflags & 2L) == 2L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void arraycopy(int srcStart, Object dst, int dstStart, int length) throws CorruptDataException, MemoryAccessException {
        if (srcStart + length > this.getArraySize()) {
            throw new IndexOutOfBoundsException();
        }
        ArrayAccessor arrayAccessor = null;
        if (!this.isArray()) throw new IllegalArgumentException();
        try {
            arrayAccessor = this.getArrayAccessor();
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException("Source is an unrecognized array type - " + this.objectType);
        }
        if (this.objectType == 2) {
            if (!(dst instanceof JavaObject[])) throw new IllegalArgumentException();
            if (((JavaObject[])dst).length < dstStart + length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = srcStart; i < srcStart + length; ++i) {
                long objAddress = (Long)arrayAccessor.getElement(i);
                JavaObject obj = null;
                if (objAddress != 0L) {
                    obj = (JavaObject)((Object)Effigy.create("JavaObjectEffigy", JavaObjectProxyImpl.getInstance(objAddress, this.context), this.context, this.context.getPlatformName()));
                }
                ((JavaObject[])dst)[dstStart] = obj;
                ++dstStart;
            }
            return;
        } else if (this.objectType == T_FLOAT) {
            if (!(dst instanceof float[])) throw new IllegalArgumentException();
            if (((float[])dst).length < dstStart + length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = srcStart; i < srcStart + length; ++i) {
                ((float[])dst)[dstStart] = ((Float)arrayAccessor.getElement(i)).floatValue();
                ++dstStart;
            }
            return;
        } else if (this.objectType == T_DOUBLE) {
            if (!(dst instanceof double[])) throw new IllegalArgumentException();
            if (((double[])dst).length < dstStart + length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = srcStart; i < srcStart + length; ++i) {
                ((double[])dst)[dstStart] = (Double)arrayAccessor.getElement(i);
                ++dstStart;
            }
            return;
        } else if (this.objectType == T_BYTE) {
            if (!(dst instanceof byte[])) throw new IllegalArgumentException();
            if (((byte[])dst).length < dstStart + length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = srcStart; i < srcStart + length; ++i) {
                ((byte[])dst)[dstStart] = (Byte)arrayAccessor.getElement(i);
                ++dstStart;
            }
            return;
        } else if (this.objectType == T_SHORT) {
            if (!(dst instanceof short[])) throw new IllegalArgumentException();
            if (((short[])dst).length < dstStart + length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = srcStart; i < srcStart + length; ++i) {
                ((short[])dst)[dstStart] = (Short)arrayAccessor.getElement(i);
                ++dstStart;
            }
            return;
        } else if (this.objectType == 5) {
            if (!(dst instanceof char[])) throw new IllegalArgumentException();
            if (((char[])dst).length < dstStart + length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = srcStart; i < srcStart + length; ++i) {
                ((char[])dst)[dstStart] = ((Character)arrayAccessor.getElement(i)).charValue();
                ++dstStart;
            }
            return;
        } else if (this.objectType == T_INT) {
            if (!(dst instanceof float[])) throw new IllegalArgumentException();
            if (((float[])dst).length < dstStart + length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = srcStart; i < srcStart + length; ++i) {
                ((int[])dst)[dstStart] = (Integer)arrayAccessor.getElement(i);
                ++dstStart;
            }
            return;
        } else if (this.objectType == 4) {
            if (!(dst instanceof boolean[])) throw new IllegalArgumentException();
            if (((boolean[])dst).length < dstStart + length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = srcStart; i < srcStart + length; ++i) {
                ((boolean[])dst)[dstStart] = (Boolean)arrayAccessor.getElement(i);
                ++dstStart;
            }
            return;
        } else {
            if (this.objectType != T_LONG) return;
            if (!(dst instanceof long[])) throw new IllegalArgumentException();
            if (((long[])dst).length < dstStart + length) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = srcStart; i < srcStart + length; ++i) {
                ((long[])dst)[dstStart] = (Long)arrayAccessor.getElement(i);
                ++dstStart;
            }
        }
    }

    public boolean isClass() {
        return this.isClass;
    }

    public long getAddress() {
        return this.objectAddress;
    }

    public ImagePointerProxy getID() {
        return new ImagePointerProxy(this.objectAddress, this.context);
    }

    public long getDataAddress() {
        return this.objectAddress + WORD_LENGTH * 2L;
    }

    public String getHeapAttributes() throws CorruptDataException {
        StringBuffer heapAttributes = new StringBuffer(128);
        if (this.isMarked()) {
            heapAttributes.append("Marked ");
        }
        if (this.isHashed()) {
            heapAttributes.append("Hashed");
            if (this.isMoved()) {
                heapAttributes.append("&Moved ");
            } else {
                heapAttributes.append(" ");
            }
        }
        if (this.isDosed()) {
            heapAttributes.append("Dosed ");
        }
        if (this.isPinned()) {
            heapAttributes.append("Pinned ");
        }
        if (this.isSwapped()) {
            heapAttributes.append("Swapped ");
        }
        if (this.isArray()) {
            heapAttributes.append("ArrayOf");
            if (this.objectType == 2) {
                heapAttributes.append("Object ");
            } else {
                heapAttributes.append("Primitive ");
            }
            heapAttributes.append("ArraySize=" + this.methodTableAddress + " ");
        } else if (this.objectType == 0) {
            heapAttributes.append("className= " + this.getClassName() + " ");
        }
        if (this.objectType < N_TYPECODES && typeCodeDescriptions[this.objectType] != null) {
            heapAttributes.append("Type= " + typeCodeDescriptions[this.objectType] + " ");
        } else {
            heapAttributes.append("Type=" + this.objectType + " ");
        }
        return heapAttributes.toString();
    }

    public boolean isPinned() {
        return (this.olink & 4L) != 0L;
    }

    public boolean isDosed() {
        return (this.olink & 2L) != 0L;
    }

    public boolean isSwapped() {
        return (this.olink & 1L) != 0L;
    }

    public boolean isHashed() {
        return (this.olink & OLINK_IsHashed) != 0L;
    }

    public boolean isMoved() {
        if (this.isHashed()) {
            return ((long)this.locknflags & 4L) != 0L;
        }
        return false;
    }

    public boolean isMarked() throws CorruptDataException {
        return this.GCedHeap && this.context.getJavaRuntimeProxy().isMarkedChunk(this.olinkAddress);
    }

    public String getClassName() throws CorruptDataException {
        try {
            return this.classBlockDO.getReader().getString("obj.name");
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
    }

    public String getLockAttributes() {
        StringBuffer lockAttributes = new StringBuffer(128);
        if (this.isContendedFor()) {
            lockAttributes.append("Contended ");
        }
        if (this.isUninflated()) {
            int flatThread = this.getFlatThread();
            if (flatThread != 0) {
                int flatCount = (int)((long)this.locknflags & 0xFF00L) >> 8;
                lockAttributes.append("FlatLocked ");
                lockAttributes.append("FlatThread=" + flatThread + " ");
                lockAttributes.append("FlatCount=" + flatCount + " ");
            }
        } else {
            int monitorIndex = (int)((long)this.locknflags & 0x7FFFFF00L) >> 8;
            if (monitorIndex == 0) {
                lockAttributes.append("InflatedLocked ");
                lockAttributes.append("MonitorIndex=" + monitorIndex + " ");
            }
        }
        return lockAttributes.toString();
    }

    public boolean isContendedFor() {
        return (this.olink & OLINK_IsContendedFor) != 0L;
    }

    public boolean isFlatLocked() {
        int flatThread = this.getFlatThread();
        return flatThread != 0;
    }

    public boolean isInflatedLocked() {
        int monitorIndex;
        return !this.isUninflated() && (monitorIndex = (int)((long)this.locknflags & 0x7FFFFF00L) >> 8) == 0;
    }

    int getFlatThread() {
        if (this.isUninflated()) {
            return (int)((long)this.locknflags & 0x7FFF0000L) >> 16;
        }
        return 0;
    }

    private boolean isUninflated() {
        return ((long)this.locknflags & Integer.MIN_VALUE) == 0L;
    }

    public long getClassAddress() {
        return this.classBlockAddress;
    }

    public int getArraySize() throws IllegalArgumentException, CorruptDataException {
        if (!this.isArray()) {
            throw new IllegalArgumentException("The current object is not an array");
        }
        return (int)this.methodTableAddress;
    }

    public Iterator getFields() throws CorruptDataException {
        if (this.isArray()) {
            return new NullIterator();
        }
        if (this.isClass()) {
            return new FieldIterator((JavaClassProxyImpl)this.getJavaClass());
        }
        return new FieldIterator(this);
    }

    public JavaClassProxy getJavaClass() throws CorruptDataException {
        if (this.syntheticArrayClass != null) {
            return this.syntheticArrayClass;
        }
        if (this.thisAsClass == null) {
            this.thisAsClass = new JavaClassProxyImpl(this.classBlockDO, this.context);
        }
        return this.thisAsClass;
    }

    public ArrayAccessor getArrayAccessor() throws UnsupportedOperationException {
        return new ArrayAccessorImpl();
    }

    public long getHashcode() throws DataUnavailable, CorruptDataException {
        long hashCode = -1L;
        if (((long)this.locknflags & 4L) == 4L) {
            try {
                hashCode = this.jvmProxyImpl.MANGLE((int)this.context.readInt(this.olinkAddress + HeapChunk.olinkLen(this.olinkAddress, this.context) - 4L));
            }
            catch (MemoryAccessException e1) {
                throw new CorruptDataException(new CorruptDataImpl(e1.getPointer(), e1.getMessage()));
            }
        } else {
            hashCode = this.jvmProxyImpl.MANGLE(this.jvmProxyImpl.Handle2Hash(this.objectAddress));
        }
        return hashCode;
    }

    public long getPersistentHashcode() throws DataUnavailable, CorruptDataException {
        if (!this.isHashed()) {
            throw new DataUnavailable("Object's hashcode is not persistent.");
        }
        return this.getHashcode();
    }

    long getMethodTableAddress() {
        return this.methodTableAddress;
    }

    public AddressSpaceProxy getContext() {
        return this.context;
    }

    int getLocknflags() {
        return this.locknflags;
    }

    public long getSize() {
        long len = this.jvmProxyImpl.tlhChunkLength(this.olinkAddress);
        if (len == -1L) {
            return this.olink & OLINK_LenMask;
        }
        return len;
    }

    private Vector getVectorOfSections() {
        if (this.sections == null) {
            this.sections = new Vector();
            this.sections.add(new ImageSectionImpl(this.context, this.objectAddress, this.getSize(), null, false, false, false, false));
        }
        return this.sections;
    }

    public Iterator getSections() {
        return this.getVectorOfSections().iterator();
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaObjectEffigy) {
            JavaObjectEffigy local = (JavaObjectEffigy)obj;
            isEqual = this.context.equals(((JavaObjectProxyImpl)local.getProxy()).context) && this.objectAddress == ((JavaObjectProxyImpl)local.getProxy()).objectAddress;
        }
        return isEqual;
    }

    public int hashCode() {
        return this.context.hashCode() ^ (int)this.objectAddress;
    }

    public JavaClassProxy getJavaObjectClass() throws CorruptDataException {
        if (!this.isClass()) {
            throw new IllegalArgumentException("Tried to get JavaClass from JavaObject that was not of type java/lang/Class.");
        }
        return new JavaClassProxyImpl(this.objectAddress, this.context);
    }

    static {
        N_TYPECODES = 64;
        typeCodeDescriptions = new String[N_TYPECODES];
        T_FLOAT = JavaObjectProxyImpl.T_MKTYPE(4, 2);
        T_DOUBLE = JavaObjectProxyImpl.T_MKTYPE(4, 3);
        T_BYTE = JavaObjectProxyImpl.T_MKTYPE(8, 0);
        T_UBYTE = JavaObjectProxyImpl.T_MKTYPE(12, 0);
        T_SHORT = JavaObjectProxyImpl.T_MKTYPE(8, 1);
        T_INT = JavaObjectProxyImpl.T_MKTYPE(8, 2);
        T_LONG = JavaObjectProxyImpl.T_MKTYPE(8, 3);
        lastContext = null;
        jvm = null;
    }

    class ArrayAccessorImpl
    implements ArrayAccessor {
        int elementSize = 0;

        ArrayAccessorImpl() {
            if (JavaObjectProxyImpl.this.objectType == 2) {
                this.elementSize = (int)WORD_LENGTH;
            } else if (JavaObjectProxyImpl.this.objectType == T_FLOAT) {
                this.elementSize = 4;
            } else if (JavaObjectProxyImpl.this.objectType == T_DOUBLE) {
                this.elementSize = 8;
            } else if (JavaObjectProxyImpl.this.objectType == T_BYTE) {
                this.elementSize = 1;
            } else if (JavaObjectProxyImpl.this.objectType == T_UBYTE) {
                this.elementSize = 1;
            } else if (JavaObjectProxyImpl.this.objectType == T_SHORT) {
                this.elementSize = 2;
            } else if (JavaObjectProxyImpl.this.objectType == 5) {
                this.elementSize = 2;
            } else if (JavaObjectProxyImpl.this.objectType == T_INT) {
                this.elementSize = 4;
            } else if (JavaObjectProxyImpl.this.objectType == 4) {
                this.elementSize = 4;
            } else if (JavaObjectProxyImpl.this.objectType == T_LONG) {
                this.elementSize = 8;
            } else {
                throw new UnsupportedOperationException("Unrecognized array type - " + JavaObjectProxyImpl.this.objectType);
            }
        }

        public Object getElement(int elementNumber) throws MemoryAccessException {
            if ((long)elementNumber > JavaObjectProxyImpl.this.getMethodTableAddress() || elementNumber < 0) {
                throw new IndexOutOfBoundsException("elementNumber must be between 0 and " + JavaObjectProxyImpl.this.getMethodTableAddress());
            }
            long elementAddress = JavaObjectProxyImpl.this.getDataAddress() + (long)(elementNumber * this.elementSize);
            if (JavaObjectProxyImpl.this.objectType == 2) {
                return new Long(JavaObjectProxyImpl.this.getContext().readPointer(elementAddress));
            }
            if (JavaObjectProxyImpl.this.objectType == T_FLOAT) {
                return new Double(Float.intBitsToFloat((int)JavaObjectProxyImpl.this.getContext().readInt(elementAddress)));
            }
            if (JavaObjectProxyImpl.this.objectType == T_DOUBLE) {
                return new Double(Double.longBitsToDouble(JavaObjectProxyImpl.this.getContext().readLong(elementAddress)));
            }
            if (JavaObjectProxyImpl.this.objectType == T_BYTE) {
                return new Long(JavaObjectProxyImpl.this.getContext().readByte(elementAddress));
            }
            if (JavaObjectProxyImpl.this.objectType == T_SHORT) {
                return new Long(JavaObjectProxyImpl.this.getContext().readShort(elementAddress));
            }
            if (JavaObjectProxyImpl.this.objectType == 5) {
                return new Character((char)JavaObjectProxyImpl.this.getContext().readShort(elementAddress));
            }
            if (JavaObjectProxyImpl.this.objectType == T_INT) {
                return new Long(JavaObjectProxyImpl.this.getContext().readInt(elementAddress));
            }
            if (JavaObjectProxyImpl.this.objectType == T_LONG) {
                return new Long(JavaObjectProxyImpl.this.getContext().readLong(elementAddress));
            }
            if (JavaObjectProxyImpl.this.objectType == 4) {
                return new Boolean(JavaObjectProxyImpl.this.getContext().readInt(elementAddress) != 0L);
            }
            return null;
        }
    }
}

