/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.data.StructuredDataLocator;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.image.ImageProcessProxy;
import com.ibm.dtfj.sov.image.ImageThreadProxy;
import com.ibm.dtfj.sov.image.LittleEnd;
import com.ibm.dtfj.sov.imp.ImageThreadEffigy;
import com.ibm.dtfj.sov.imp.JavaRuntimeEffigy;
import com.ibm.dtfj.sov.java.JavaHeapProxy;
import com.ibm.dtfj.sov.java.JavaRuntimeProxy;
import com.ibm.dtfj.sov.java.JavaThreadProxy;
import com.ibm.dtfj.sov.java.JavaVMInitArgsProxy;
import com.ibm.dtfj.sov.java.imp.HeapChunk;
import com.ibm.dtfj.sov.java.imp.JavaClassLoaderProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaClassProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaHeapProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaMethodProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaObjectProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaVMInitArgsProxyImpl;
import com.ibm.dtfj.sov.java.imp.ObjectLock;
import com.ibm.dtfj.sov.java.imp.RegisteredMonitor;
import com.ibm.dtfj.sov.java.imp.SystemMonitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;

public class JavaRuntimeProxyImpl
implements JavaRuntimeProxy {
    private DataObject myDataObject;
    private ImageProcessProxy process = null;
    private long jvm = -1L;
    private JavaHeapProxy[] heaps = new JavaHeapProxy[3];
    private Map tlhMap;
    protected AddressSpaceProxy context;
    private boolean littleEndian;
    private long mh_heapbase;
    private long mh_heaplimit;
    private long th_heapbase;
    private long th_heaplimit;
    private long allocBitsAddress;
    private long allocBitsMax;
    private long markBitsAddress;
    private long markBitsMax;
    private StructuredDataLocator jvmReader;
    private int WORD_LENGTH;
    private int random1;
    private int random2;
    private TraceSpec traceSpec;
    private Vector registeredMonitors = null;
    private HashMap objectLocks = null;
    private HashMap execenvsByLockId = new HashMap();
    private HashMap execenvsBySysThread = new HashMap();
    private TreeMap compiledMethodsMap = null;
    private String myVersion = null;
    HashMap execenv_to_threads = new HashMap();
    private Vector primitiveClasses;
    private Vector primitiveArrays;
    private Vector classLoaders = null;

    public JavaRuntimeProxyImpl(DataObject dataObject, AddressSpaceProxy context) throws CorruptDataException {
        this.myDataObject = dataObject;
        this.context = context;
        context.setJavaRuntimeProxy(this);
        this.littleEndian = context.getWordType() instanceof LittleEnd;
        this.WORD_LENGTH = context.getWordLength().size;
        this.loadTLHs();
        this.jvmReader = this.myDataObject.getReader();
        try {
            long stGlobal = this.jvmReader.getLong("facade.st.(Long)dataP");
            DataObject stGlobalDO = new DataObject(null, "STGlobal", context);
            stGlobalDO.setAddress(stGlobal);
            StructuredDataLocator stGlobalReader = stGlobalDO.getReader();
            this.th_heapbase = stGlobalReader.getLong("(Long)TH_heapbase");
            this.th_heaplimit = stGlobalReader.getLong("(Long)TH_heaplimit");
            this.mh_heapbase = stGlobalReader.getLong("(Long)curHeapMin");
            this.mh_heaplimit = stGlobalReader.getLong("(Long)curHeapMax");
            this.allocBitsAddress = stGlobalReader.getLong("(Long)allocbits");
            this.allocBitsMax = stGlobalReader.getLong("(Long)allocmax");
            this.markBitsAddress = stGlobalReader.getLong("(Long)markbits");
            this.markBitsMax = stGlobalReader.getLong("(Long)markmax");
            this.random1 = stGlobalReader.getInteger("random1");
            this.random2 = stGlobalReader.getInteger("random2");
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
        this.heaps[0] = new JavaHeapProxyImpl("System Heap", -1L, -1L, context, this);
        this.heaps[1] = new JavaHeapProxyImpl("Transient Heap", this.th_heapbase, this.th_heaplimit, context, this);
        this.heaps[2] = new JavaHeapProxyImpl("Middleware Heap", this.mh_heapbase, this.mh_heaplimit, context, this);
        this.traceSpec = new TraceSpec();
    }

    public Iterator getHeaps() {
        return new Iterator(){
            int heapNumber = 0;

            public boolean hasNext() {
                return this.heapNumber < JavaRuntimeProxyImpl.this.heaps.length;
            }

            public Object next() {
                return JavaRuntimeProxyImpl.this.heaps[this.heapNumber++];
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private boolean isBitSetForChunk(long chunk, long bitsAddress) throws CorruptDataException {
        int bits;
        int offset = (int)(chunk - this.mh_heapbase);
        int bitsIndex = offset >> 8;
        int bitsOffset = offset >> 3 & 0x1F;
        try {
            bits = (int)this.context.readInt(bitsAddress + (long)(bitsIndex << 2));
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
        int bit = this.littleEndian ? 1 << bitsOffset : Integer.MIN_VALUE >>> bitsOffset;
        return (bits & bit) != 0;
    }

    public boolean isLiveChunk(long chunk) throws CorruptDataException {
        TlhChunk tlhChunk = (TlhChunk)this.tlhMap.get(new Long(chunk));
        if (tlhChunk == null) {
            if (chunk >= this.mh_heapbase && chunk < this.mh_heaplimit || chunk >= this.th_heapbase && chunk < this.th_heaplimit) {
                return this.isBitSetForChunk(chunk, this.allocBitsAddress);
            }
            return true;
        }
        return tlhChunk.allocated;
    }

    public long tlhChunkLength(long chunk) {
        TlhChunk tlhChunk = (TlhChunk)this.tlhMap.get(new Long(chunk));
        if (tlhChunk == null) {
            return -1L;
        }
        return tlhChunk.length;
    }

    public boolean isMarkedChunk(long chunk) throws CorruptDataException {
        if (chunk >= this.mh_heapbase && chunk < this.mh_heaplimit) {
            return this.isBitSetForChunk(chunk, this.markBitsAddress);
        }
        return true;
    }

    public StructuredDataLocator getReader() {
        return this.jvmReader;
    }

    private void loadTLHs() {
        ImageProcessProxy thisProcess = this.context.getCurrentProcessProxy();
        Iterator threadIterator = thisProcess.getThreads();
        DataObject execEnvDO = null;
        try {
            execEnvDO = new DataObject(null, "execenv", this.context);
        }
        catch (CorruptDataException e1) {
            // empty catch block
        }
        this.tlhMap = new HashMap();
        while (threadIterator.hasNext()) {
            ImageThreadProxy thisThread = (ImageThreadProxy)threadIterator.next();
            if (!thisThread.getIsJava()) continue;
            long execEnvAddress = thisThread.getEEAddress();
            execEnvDO.setAddress(execEnvAddress);
            try {
                this.extendTlh(execEnvDO.getReader());
            }
            catch (CorruptDataException e) {}
        }
    }

    private void extendTlh(StructuredDataLocator locator) throws CorruptDataException {
        long tlhEntrySize;
        long tlhStart = -1L;
        int tlhSize = -1;
        int tlhOrigSize = -1;
        try {
            tlhStart = locator.getLong("alloc_cache.c.tc.(Long)cache_block");
            tlhSize = locator.getInteger("alloc_cache.c.tc.cache_size");
            tlhOrigSize = locator.getInteger("alloc_cache.c.tc.cache_orig_size");
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
        if (tlhStart == 0L) {
            return;
        }
        long tlhTail = tlhStart + (long)tlhOrigSize;
        this.tlhMap.put(new Long(tlhStart - (long)(this.WORD_LENGTH * 3)), new TlhChunk(tlhSize + this.WORD_LENGTH * 3, false));
        for (long nextTlhEntry = tlhStart + (long)tlhSize; nextTlhEntry < tlhTail; nextTlhEntry += tlhEntrySize) {
            tlhEntrySize = 0L;
            tlhEntrySize = HeapChunk.olinkLen(nextTlhEntry, this.context);
            if (tlhEntrySize <= 0L) {
                throw new CorruptDataException(new CorruptDataImpl("Invalid length " + tlhEntrySize + " for TLH entry @ 0x" + Long.toHexString(nextTlhEntry)));
            }
            this.tlhMap.put(new Long(nextTlhEntry), new TlhChunk(tlhEntrySize, true));
        }
    }

    protected long hand2link(long address) {
        return address - (long)this.WORD_LENGTH;
    }

    protected int Handle2Hash(long address) {
        return (int)(address >>> 3);
    }

    protected int ROTATE(int value, int n) {
        return value >>> n | value << 32 - n;
    }

    protected int MANGLE(int hashCode) {
        return (this.ROTATE(hashCode ^ this.random1, 17) ^ this.random2) >>> 1;
    }

    public TreeMap getJITCompiledMethods() {
        if (this.compiledMethodsMap == null) {
            this.compiledMethodsMap = new TreeMap();
            CompiledMethodsIterator itCM = null;
            try {
                itCM = new CompiledMethodsIterator();
            }
            catch (CorruptDataException e) {
                this.compiledMethodsMap.put("DataCorruption", e.getCorruptData());
                return this.compiledMethodsMap;
            }
            while (itCM.hasNext()) {
                CompiledMethod cm = (CompiledMethod)itCM.next();
                long mb = cm.getMb();
                long start = cm.getStartAddress();
                long end = cm.getEndAddress();
                try {
                    this.compiledMethodsMap.put(String.valueOf(mb), new JavaMethodProxyImpl(mb, this.context, start, end));
                }
                catch (MemoryAccessException e) {
                    this.compiledMethodsMap.put(String.valueOf(mb), new CorruptDataImpl(e.getPointer(), e.getMessage()));
                }
                catch (CorruptDataException e) {
                    this.compiledMethodsMap.put(String.valueOf(mb), e.getCorruptData());
                }
            }
        }
        return this.compiledMethodsMap;
    }

    public Iterator getCompiledMethods() {
        if (this.compiledMethodsMap == null) {
            return this.getJITCompiledMethods().values().iterator();
        }
        return this.compiledMethodsMap.values().iterator();
    }

    public boolean isTraceEnabled() {
        return this.traceSpec.isTraceEnabled();
    }

    public byte[] getTraceHeader() throws MemoryAccessException {
        return this.traceSpec.getTraceHeader();
    }

    public Long getExecenvForLockId(Long ownerThreadid) {
        return (Long)this.execenvsByLockId.get(ownerThreadid);
    }

    public Long getExecenvForThread(Long sysThread) {
        return (Long)this.execenvsBySysThread.get(sysThread);
    }

    public Iterator getMonitors() {
        try {
            this.buildWaitingThreadsList();
        }
        catch (CorruptDataException e) {
            Vector<CorruptData> monitors = new Vector<CorruptData>();
            monitors.add(e.getCorruptData());
            return monitors.iterator();
        }
        return new Iterator(){
            final int REGISTERED_MONITORS = 0;
            final int OBJECT_LOCKS = 1;
            final int FINISHED = 2;
            int state = 0;
            Iterator currentIterator = JavaRuntimeProxyImpl.this.getRegisteredMonitors();

            public boolean hasNext() {
                while (this.state != 2) {
                    if (this.currentIterator.hasNext()) {
                        return true;
                    }
                    switch (this.state) {
                        case 0: {
                            this.currentIterator = JavaRuntimeProxyImpl.this.getObjectLocks();
                            this.state = 1;
                            break;
                        }
                        case 1: {
                            this.currentIterator = null;
                            this.state = 2;
                        }
                    }
                }
                return false;
            }

            public Object next() {
                if (this.currentIterator != null) {
                    return this.currentIterator.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator getRegisteredMonitors() {
        if (this.registeredMonitors == null) {
            this.registeredMonitors = new Vector();
            DataObject regMonDO = null;
            long regMonAddress = 0L;
            try {
                regMonDO = new DataObject(null, "reg_mon", this.context);
                regMonAddress = this.jvmReader.getLong("facade.lk.(_lkgldata*)dataP.(Long)reg");
                regMonAddress = this.jvmReader.getPointerAt(regMonAddress);
            }
            catch (CorruptDataException e) {
                this.registeredMonitors.add(e.getCorruptData());
                return this.registeredMonitors.iterator();
            }
            catch (MemoryAccessException e) {
                this.registeredMonitors.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
                return this.registeredMonitors.iterator();
            }
            while (regMonAddress != 0L) {
                regMonDO.setAddress(regMonAddress);
                try {
                    String name = regMonDO.getReader().getString("name");
                    long systemMonitorAddress = regMonDO.getReader().getLong("(Long)mid");
                    this.registeredMonitors.add(new RegisteredMonitor(name, SystemMonitor.getInstance(systemMonitorAddress, this, this.context), this.context));
                    regMonAddress = regMonDO.getReader().getLong("(Long)next");
                }
                catch (CorruptDataException e) {
                    this.registeredMonitors.add(e.getCorruptData());
                }
                catch (MemoryAccessException e) {
                    this.registeredMonitors.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
                }
            }
        }
        return new Iterator(){
            private Iterator registeredMonitorsIterator;
            {
                this.registeredMonitorsIterator = JavaRuntimeProxyImpl.this.registeredMonitors.iterator();
            }

            public boolean hasNext() {
                return this.registeredMonitorsIterator.hasNext();
            }

            public Object next() {
                return this.registeredMonitorsIterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator getObjectLocks() {
        if (this.objectLocks == null) {
            this.objectLocks = new HashMap();
            DataObject inflMonDO = null;
            int inflMonCount = 0;
            long inflMonTableAddress = 0L;
            Vector<CorruptData> corruptData = new Vector<CorruptData>();
            try {
                inflMonDO = new DataObject(null, "infl_mon", this.context);
                inflMonCount = this.jvmReader.getLong("facade.lk.(_lkgldata*)dataP.micb.count").intValue();
                inflMonTableAddress = this.jvmReader.getLong("facade.lk.(_lkgldata*)dataP.micb.(long)table");
                inflMonTableAddress += (long)this.context.getWordLength().size;
            }
            catch (CorruptDataException e) {
                corruptData.add(e.getCorruptData());
                return corruptData.iterator();
            }
            catch (MemoryAccessException e) {
                corruptData.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
                return corruptData.iterator();
            }
            int i = 1;
            while (i < inflMonCount) {
                block9: {
                    Long objectAddress = null;
                    try {
                        long inflMonAddress = this.context.readPointer(inflMonTableAddress);
                        inflMonDO.setAddress(inflMonAddress);
                        long systemMonitorAddress = inflMonDO.getReader().getLong("(long)_sysmon");
                        objectAddress = inflMonDO.getReader().getLong("(long)object");
                        if (objectAddress == 0L) break block9;
                        ObjectLock objectLock = (ObjectLock)this.objectLocks.get(objectAddress);
                        if (objectLock == null) {
                            objectLock = new ObjectLock(this, this.context);
                        }
                        SystemMonitor systemMonitor = SystemMonitor.getInstance(systemMonitorAddress, this, this.context);
                        objectLock.setSystemMonitor(systemMonitor);
                        objectLock.setLockedObject(objectAddress, this.context);
                        this.objectLocks.put(objectAddress, objectLock);
                        inflMonAddress = inflMonDO.getReader().getLong("(long)next");
                    }
                    catch (MemoryAccessException e) {
                        this.objectLocks.put(e.getPointer(), new CorruptDataImpl(e.getPointer(), e.getMessage()));
                        break;
                    }
                    catch (CorruptDataException e) {
                        this.objectLocks.put(objectAddress, e.getCorruptData());
                        break;
                    }
                }
                ++i;
                inflMonTableAddress += (long)this.context.getWordLength().size;
            }
        }
        final JavaRuntimeProxyImpl parent = this;
        return new Iterator(){
            boolean finished = false;
            Iterator itheap = parent.getHeaps();
            JavaHeapProxyImpl thisHeap = (JavaHeapProxyImpl)this.itheap.next();
            Iterator objIt = this.thisHeap.getLockedObjects();

            public boolean hasNext() {
                while (!this.finished) {
                    if (this.objIt.hasNext()) {
                        return true;
                    }
                    if (this.itheap.hasNext()) {
                        this.thisHeap = (JavaHeapProxyImpl)this.itheap.next();
                        this.objIt = this.thisHeap.getLockedObjects();
                        continue;
                    }
                    this.finished = true;
                }
                return false;
            }

            public Object next() {
                if (!this.hasNext()) {
                    return null;
                }
                Object obj = this.objIt.next();
                if (obj instanceof CorruptData) {
                    return obj;
                }
                JavaObjectProxyImpl thisObject = (JavaObjectProxyImpl)obj;
                Long objectAddress = new Long(thisObject.getAddress());
                ObjectLock objectLock = (ObjectLock)JavaRuntimeProxyImpl.this.objectLocks.get(objectAddress);
                if (objectLock == null) {
                    objectLock = new ObjectLock(parent, JavaRuntimeProxyImpl.this.context);
                }
                objectLock.setLockedObject(objectAddress, JavaRuntimeProxyImpl.this.context);
                return objectLock;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void buildWaitingThreadsList() throws CorruptDataException {
        Iterator itthread = this.context.getCurrentProcess().getThreads();
        DataObject execenvDO = null;
        execenvDO = new DataObject(null, "execenv", this.context);
        while (itthread.hasNext()) {
            ImageThreadProxy thread = ((ImageThreadEffigy)itthread.next()).getProxy();
            if (!thread.getIsJava()) continue;
            execenvDO.setAddress(thread.getEEAddress());
            Long eeAddress = new Long(thread.getEEAddress());
            try {
                int lockId = (int)execenvDO.getReader().getLong("lk_thread_local.lk.flc.thread_ident").longValue();
                this.execenvsByLockId.put(new Long(lockId >> 16), eeAddress);
                long sysThreadAddress = execenvDO.getMemberAddress("sys_thr");
                this.execenvsBySysThread.put(new Long(sysThreadAddress), eeAddress);
                long waitMonitor = execenvDO.getReader().getLong("(sys_thread)sys_thr.(Long)mon_enter|(sys_thread)sys_thr.(Long)enter_monitor|(sys_thread)sys_thr.(Long)wait_monitor");
                if (waitMonitor == 0L) continue;
                SystemMonitor systemMonitor = SystemMonitor.getInstance(waitMonitor, this, this.context);
                JavaThreadProxy javaThread = this.getJavaThread(eeAddress);
                systemMonitor.addEnterWaiter(javaThread);
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage() + " exception detected when building list of waiting threads"));
            }
        }
    }

    public Object getTraceBuffer(String name, boolean formatted) throws CorruptDataException {
        if (name == "VerboseGcBuffer") {
            try {
                return this.myDataObject.getReader().getString("facade.st.(STGlobal*)dataP.verbosegc_buffer");
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(null);
            }
        }
        if (name == "UTETracebuffers") {
            return this.traceSpec.getTraceBuffers();
        }
        return null;
    }

    public Iterator getThreads() {
        return this.process.getJavaThreads();
    }

    public ImagePointerProxy getJavaVM() throws CorruptDataException {
        return new ImagePointerProxy(this.jvm, this.context);
    }

    public String getVersion() throws CorruptDataException {
        if (this.myVersion == null) {
            try {
                this.myVersion = this.myDataObject.getReader().getString("fullVersion");
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }
        return this.myVersion;
    }

    public void setProcessAndJVM(ImageProcessProxy process, long jvm) {
        this.process = process;
        this.jvm = jvm;
    }

    public JavaThreadProxy getJavaThread(Long eeAddress) {
        return this.process.getJavaThread(eeAddress);
    }

    public int hashCode() {
        return this.myDataObject.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaRuntimeEffigy) {
            return ((JavaRuntimeProxyImpl)((JavaRuntimeEffigy)obj).getProxy()).myDataObject.equals(this.myDataObject);
        }
        if (obj instanceof JavaRuntimeProxyImpl) {
            return ((JavaRuntimeProxyImpl)obj).myDataObject.equals(this.myDataObject);
        }
        return false;
    }

    public long getPrimitiveArray(long offset) throws CorruptDataException, MemoryAccessException {
        long jvmAddress = this.getJavaVM().getAddress();
        DataObject jvmDO = new DataObject(null, "Jvm", this.context);
        jvmDO.setAddress(jvmAddress);
        long primitive_array_classes = jvmDO.getMemberAddress("facade.cl.class_tables.primitive_array_classes");
        long classBlockAddress = this.context.readPointer(primitive_array_classes + offset * (long)this.context.getWordLength().size);
        return classBlockAddress;
    }

    public long getPrimitiveArray(char label) throws CorruptDataException, MemoryAccessException {
        switch (label) {
            case 'Z': {
                return this.getPrimitiveArray(1L);
            }
            case 'B': {
                return this.getPrimitiveArray(2L);
            }
            case 'C': {
                return this.getPrimitiveArray(3L);
            }
            case 'S': {
                return this.getPrimitiveArray(4L);
            }
            case 'I': {
                return this.getPrimitiveArray(5L);
            }
            case 'J': {
                return this.getPrimitiveArray(6L);
            }
            case 'F': {
                return this.getPrimitiveArray(7L);
            }
            case 'D': {
                return this.getPrimitiveArray(8L);
            }
        }
        return 0L;
    }

    public long getPrimitiveClass(char label) throws CorruptDataException, MemoryAccessException {
        long offset = 0L;
        switch (label) {
            case 'V': {
                offset = 0L;
                break;
            }
            case 'Z': {
                offset = 1L;
                break;
            }
            case 'B': {
                offset = 2L;
                break;
            }
            case 'C': {
                offset = 3L;
                break;
            }
            case 'S': {
                offset = 4L;
                break;
            }
            case 'I': {
                offset = 5L;
                break;
            }
            case 'J': {
                offset = 6L;
                break;
            }
            case 'F': {
                offset = 7L;
                break;
            }
            case 'D': {
                offset = 8L;
                break;
            }
            default: {
                return 0L;
            }
        }
        long jvmAddress = this.getJavaVM().getAddress();
        DataObject jvmDO = new DataObject(null, "Jvm", this.context);
        jvmDO.setAddress(jvmAddress);
        long primitive_array_classes = jvmDO.getMemberAddress("facade.cl.class_tables.primitive_classes");
        long classBlockAddress = this.context.readPointer(primitive_array_classes + offset * (long)this.context.getWordLength().size);
        return classBlockAddress;
    }

    public long getPrimitiveClass(long offset) throws CorruptDataException, MemoryAccessException {
        long jvmAddress = this.getJavaVM().getAddress();
        DataObject jvmDO = new DataObject(null, "Jvm", this.context);
        jvmDO.setAddress(jvmAddress);
        long primitive_array_classes = jvmDO.getMemberAddress("facade.cl.class_tables.primitive_classes");
        long classBlockAddress = this.context.readPointer(primitive_array_classes + offset * (long)this.context.getWordLength().size);
        return classBlockAddress;
    }

    public Vector getPrimitiveClasses() throws CorruptDataException, MemoryAccessException {
        if (this.primitiveClasses == null) {
            this.primitiveClasses = new Vector(9);
            for (int i = 0; i <= 8; ++i) {
                this.primitiveClasses.add(new JavaClassProxyImpl(this.getPrimitiveClass(i), this.context));
            }
        }
        return this.primitiveClasses;
    }

    Vector getPrimitiveArrays() throws CorruptDataException, MemoryAccessException {
        if (this.primitiveArrays == null) {
            this.primitiveArrays = new Vector(8);
            for (int i = 1; i <= 8; ++i) {
                this.primitiveArrays.add(new JavaClassProxyImpl(this.getPrimitiveArray(i), this.context));
            }
        }
        return this.primitiveArrays;
    }

    public DataObject getMyObject() {
        return this.myDataObject;
    }

    public Iterator getJavaClassLoaders() {
        if (this.classLoaders == null) {
            this.classLoaders = new Vector();
            try {
                DataObject shadow = new DataObject(null, "ClassLoaderShadow", this.context);
                long address = this.myDataObject.getReader().getlong("facade.cl.(ClData*)dataP.(long)class_loader_shadows");
                shadow.setAddress(address);
                while (address != 0L) {
                    this.classLoaders.add(new JavaClassLoaderProxyImpl(address, this.context));
                    address = shadow.getReader().getlong("(long)next");
                    shadow.setAddress(address);
                }
            }
            catch (CorruptDataException e) {
                this.classLoaders.add(e.getCorruptData());
            }
            catch (MemoryAccessException e) {
                this.classLoaders.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }
        return this.classLoaders.iterator();
    }

    public JavaClassLoaderProxyImpl findClassLoader(long address) {
        Iterator its = this.getJavaClassLoaders();
        while (its.hasNext()) {
            JavaClassLoaderProxyImpl jclpi;
            Object obj = its.next();
            if (!(obj instanceof JavaClassLoaderProxyImpl) || (jclpi = (JavaClassLoaderProxyImpl)obj).getAddress() != address) continue;
            return jclpi;
        }
        return null;
    }

    public JavaVMInitArgsProxy getJavaVMInitArgs() throws DataUnavailable, CorruptDataException {
        DataObject JVMRasDO = new DataObject(null, "jvm_ras_t", this.context);
        JVMRasDO.setAddress(this.context.getRas().jvmRas);
        long properties = 0L;
        try {
            properties = JVMRasDO.getReader().getlong("ras.data.(long)properties");
        }
        catch (MemoryAccessException e) {
            CorruptDataException cde = new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.toString()));
            cde.initCause(e);
            throw cde;
        }
        try {
            long user_args = properties + (long)(7 * this.context.getWordLength().size);
            JavaVMInitArgsProxyImpl jviapi = new JavaVMInitArgsProxyImpl(user_args, this.context);
            if (((long)jviapi.getVersion() & 0xFFFF0000L) != 65536L || ((long)jviapi.getVersion() & 0xFFFFL) > 4L) {
                user_args = properties + (long)(6 * this.context.getWordLength().size);
                jviapi = new JavaVMInitArgsProxyImpl(user_args, this.context);
            }
            return jviapi;
        }
        catch (MemoryAccessException e) {
            CorruptDataException cde = new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.toString()));
            cde.initCause(e);
            throw cde;
        }
    }

    private class TraceSpec {
        DataObject traceFileHeaderDO = null;
        DataObject traceBufferDO = null;
        StructuredDataLocator traceBufferReader = null;
        DataObject traceDataDO = null;
        int traceBufferSize = 0;
        long traceFileHeaderAddr = 0L;
        int traceFileHeaderLength = 0;
        long traceGlobal = 0L;

        TraceSpec() {
            long utGlobalData = 0L;
            try {
                long dgData = JavaRuntimeProxyImpl.this.jvmReader.getLong("facade.dg.(Long)dataP");
                DataObject dgDataDO = new DataObject(null, "DgData", JavaRuntimeProxyImpl.this.context);
                dgDataDO.setAddress(dgData);
                utGlobalData = dgDataDO.getMemberAddress("utGlobalDataP");
                if (utGlobalData != 0L) {
                    DataObject utGlobalDataDO;
                    this.traceDataDO = utGlobalDataDO = new DataObject(null, "utGlobalData", JavaRuntimeProxyImpl.this.context);
                    utGlobalDataDO.setAddress(utGlobalData);
                    StructuredDataLocator utGlobalDataReader = utGlobalDataDO.getReader();
                    this.traceFileHeaderDO = new DataObject(null, "utTraceFileHdr", JavaRuntimeProxyImpl.this.context);
                    this.traceFileHeaderAddr = utGlobalDataReader.getLong("(Long)traceHeader");
                    this.traceFileHeaderDO.setAddress(this.traceFileHeaderAddr);
                    this.traceBufferDO = new DataObject(null, "utTraceBuffer", JavaRuntimeProxyImpl.this.context);
                } else {
                    this.traceDataDO = dgDataDO;
                    StructuredDataLocator dgDataReader = dgDataDO.getReader();
                    this.traceFileHeaderDO = new DataObject(null, "TraceFileHeader", JavaRuntimeProxyImpl.this.context);
                    this.traceFileHeaderAddr = dgDataReader.getLong("(Long)traceHeader");
                    this.traceFileHeaderDO.setAddress(this.traceFileHeaderAddr);
                    this.traceBufferDO = new DataObject(null, "DgTraceBuffer", JavaRuntimeProxyImpl.this.context);
                }
                this.traceGlobal = this.traceDataDO.getReader().getLong("(Long)traceGlobal");
                if (this.traceGlobal != 0L) {
                    this.traceBufferReader = this.traceBufferDO.getReader();
                    this.traceBufferSize = this.traceFileHeaderDO.getReader().getInteger("bufferSize");
                    this.traceFileHeaderLength = this.traceFileHeaderDO.getReader().getInteger("header.length");
                    this.traceGlobal = this.traceDataDO.getReader().getLong("(Long)traceGlobal");
                }
            }
            catch (NullPointerException e) {
                utGlobalData = 0L;
            }
            catch (CorruptDataException e) {
                utGlobalData = 0L;
            }
            catch (MemoryAccessException e) {
                utGlobalData = 0L;
            }
        }

        boolean isTraceEnabled() {
            return this.traceGlobal != 0L;
        }

        byte[] getTraceHeader() throws MemoryAccessException {
            if (!this.isTraceEnabled()) {
                return null;
            }
            return JavaRuntimeProxyImpl.this.context.readBytes(this.traceFileHeaderAddr, this.traceFileHeaderLength);
        }

        Iterator getTraceBuffers() {
            if (!this.isTraceEnabled()) {
                return new Vector().iterator();
            }
            TreeMap<Long, Object> buffersBySequence = new TreeMap<Long, Object>();
            try {
                long traceBufferAddr = this.traceGlobal;
                while (traceBufferAddr != 0L) {
                    this.traceBufferDO.setAddress(traceBufferAddr);
                    Long traceSequence = this.traceBufferReader.getLong("record.sequence");
                    Long traceRecordAddr = new Long(this.traceBufferDO.getMemberAddress("record"));
                    buffersBySequence.put(traceSequence, traceRecordAddr);
                    traceBufferAddr = this.traceBufferReader.getLong("(Long)globalNext");
                }
            }
            catch (MemoryAccessException e) {
                buffersBySequence.put(new Long(Long.MAX_VALUE), new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
            catch (CorruptDataException e) {
                buffersBySequence.put(new Long(Long.MAX_VALUE), e.getCorruptData());
            }
            Iterator bufferBySequenceIterator = buffersBySequence.entrySet().iterator();
            return new Iterator(this, bufferBySequenceIterator){
                private final /* synthetic */ Iterator val$bufferBySequenceIterator;
                private final /* synthetic */ TraceSpec this$1;
                {
                    this.this$1 = this$1;
                    this.val$bufferBySequenceIterator = val$bufferBySequenceIterator;
                }

                public boolean hasNext() {
                    return this.val$bufferBySequenceIterator.hasNext();
                }

                public Object next() {
                    Map.Entry recordEntry = (Map.Entry)this.val$bufferBySequenceIterator.next();
                    long traceRecordAddr = (Long)recordEntry.getValue();
                    try {
                        return TraceSpec.access$200((TraceSpec)this.this$1).context.readBytes(traceRecordAddr, this.this$1.traceBufferSize);
                    }
                    catch (MemoryAccessException e) {
                        return new CorruptDataImpl(e.getPointer(), e.getMessage());
                    }
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        static /* synthetic */ JavaRuntimeProxyImpl access$200(TraceSpec x0) {
            return x0.JavaRuntimeProxyImpl.this;
        }
    }

    private class CompiledMethodsIterator
    implements Iterator {
        private DataObject committedCodeDO;
        private CompiledMethod currentMethod;
        private Stack visited;
        private StackEntry currentStackEntry;
        private boolean isAVL = false;
        private long AVLRoot;

        CompiledMethodsIterator() throws CorruptDataException {
            this.committedCodeDO = new DataObject(null, "committed_code", JavaRuntimeProxyImpl.this.context);
            if (this.committedCodeDO.getDescriptor().getMember("left") != null) {
                this.isAVL = true;
            }
            this.visited = new Stack();
            long jvmRasAddress = JavaRuntimeProxyImpl.this.context.getRas().jvmRas;
            DataObject jvmRasDO = null;
            jvmRasDO = new DataObject(null, "jvm_ras_t", JavaRuntimeProxyImpl.this.context);
            jvmRasDO.setAddress(jvmRasAddress);
            long jitRasAddress = -1L;
            try {
                jitRasAddress = jvmRasDO.getReader().getLong("ras.data.(Long)jitRas");
                jitRasAddress = JavaRuntimeProxyImpl.this.context.readPointer(jitRasAddress);
                DataObject jitRasDO = null;
                jitRasDO = new DataObject(null, "jit_ras_t", JavaRuntimeProxyImpl.this.context);
                jitRasDO.setAddress(jitRasAddress);
                this.AVLRoot = jitRasDO.getReader().getLong("ras.data.(Long)avl_tree_root");
                this.AVLRoot = JavaRuntimeProxyImpl.this.context.readPointer(this.AVLRoot);
            }
            catch (MemoryAccessException e1) {
                throw new CorruptDataException(new CorruptDataImpl(e1.getPointer(), e1.getMessage()));
            }
            if (this.AVLRoot > 0L) {
                this.currentMethod = this.getCompiledMethod(this.AVLRoot);
                if (this.isAVL) {
                    this.currentStackEntry = new StackEntry(this.currentMethod.left, this.currentMethod.right);
                }
            } else {
                this.currentMethod = null;
            }
        }

        private CompiledMethod getCompiledMethod(long committedCodeAddress) throws CorruptDataException {
            this.committedCodeDO.setAddress(committedCodeAddress);
            try {
                if (this.isAVL) {
                    long left = this.committedCodeDO.getReader().getLong("(Long)left");
                    long right = this.committedCodeDO.getReader().getLong("(Long)right");
                    long mb = this.committedCodeDO.getReader().getLong("(Long)mb");
                    long start = this.committedCodeDO.getReader().getLong("(Long)start");
                    long end = this.committedCodeDO.getReader().getLong("(Long)end");
                    return new CompiledMethod(committedCodeAddress, left, right, mb, start, end);
                }
                long next = this.committedCodeDO.getReader().getLong("(Long)next");
                long mb = this.committedCodeDO.getReader().getLong("(Long)mb");
                long start = this.committedCodeDO.getReader().getLong("(Long)start");
                long end = this.committedCodeDO.getReader().getLong("(Long)end");
                return new CompiledMethod(committedCodeAddress, next, mb, start, end);
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }

        public boolean hasNext() {
            return this.currentMethod != null;
        }

        public Object next() {
            CompiledMethod returnMethod;
            block14: {
                if (this.currentMethod == null) {
                    return null;
                }
                returnMethod = this.currentMethod;
                if (this.isAVL) {
                    while (true) {
                        if (this.currentStackEntry.left != 0L) {
                            this.visited.push(this.currentStackEntry);
                            try {
                                this.currentMethod = this.getCompiledMethod(this.currentStackEntry.left);
                            }
                            catch (CorruptDataException e) {
                                break block14;
                            }
                            this.currentStackEntry.left = 0L;
                            this.currentStackEntry = new StackEntry(this.currentMethod.left, this.currentMethod.right);
                            break block14;
                        }
                        if (this.currentStackEntry.right != 0L) {
                            try {
                                this.currentMethod = this.getCompiledMethod(this.currentStackEntry.right);
                            }
                            catch (CorruptDataException e) {
                                break block14;
                            }
                            this.currentStackEntry.right = 0L;
                            this.currentStackEntry = new StackEntry(this.currentMethod.left, this.currentMethod.right);
                            break block14;
                        }
                        if (this.visited.empty()) {
                            this.currentMethod = null;
                            break block14;
                        }
                        this.currentStackEntry = (StackEntry)this.visited.pop();
                    }
                }
                if (this.currentMethod.next != 0L && this.currentMethod.next != this.AVLRoot) {
                    try {
                        this.currentMethod = this.getCompiledMethod(this.currentMethod.next);
                    }
                    catch (CorruptDataException e) {
                        this.currentMethod = null;
                    }
                } else {
                    this.currentMethod = null;
                }
            }
            return returnMethod;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class StackEntry {
            long right;
            long left;

            StackEntry(long left, long right) {
                this.left = left;
                this.right = right;
            }
        }
    }

    private class CompiledMethod {
        long address;
        long mb;
        long left;
        long right;
        long next;
        long start;
        long end;

        CompiledMethod(long address, long left, long right, long mb, long start, long end) {
            this.address = address;
            this.left = left;
            this.right = right;
            this.mb = mb;
            this.start = start;
            this.end = end;
        }

        public CompiledMethod(long address, long next, long mb, long start, long end) {
            this.address = address;
            this.next = next;
            this.mb = mb;
            this.start = start;
            this.end = end;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("CompiledMethodImpl\n ");
            sb.append("\tLeft node @ 0x" + Long.toHexString(this.left));
            sb.append("\tRight node @ 0x" + Long.toHexString(this.right));
            return sb.toString();
        }

        public Long getAddress() {
            return new Long(this.address);
        }

        public long getMb() {
            return this.mb;
        }

        public long getEndAddress() {
            return this.end;
        }

        public long getStartAddress() {
            return this.start;
        }

        public Long getLeft() {
            return new Long(this.left);
        }

        public Long getRight() {
            return new Long(this.right);
        }
    }

    private class TlhChunk {
        long length;
        boolean allocated;

        TlhChunk(long length, boolean allocated) {
            this.length = length;
            this.allocated = allocated;
        }
    }
}

