/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.image.ImageSectionImpl;
import com.ibm.dtfj.sov.image.ImageThreadProxy;
import com.ibm.dtfj.sov.imp.ImagePointerEffigy;
import com.ibm.dtfj.sov.imp.JavaThreadEffigy;
import com.ibm.dtfj.sov.java.JavaObjectProxy;
import com.ibm.dtfj.sov.java.JavaThreadProxy;
import com.ibm.dtfj.sov.java.imp.JavaObjectProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import java.util.Iterator;
import java.util.Vector;

public class JavaThreadProxyImpl
implements JavaThreadProxy {
    private ImageThreadProxy imageThread;
    private AddressSpaceProxy context;
    public DataObject dobj = null;
    private String myThreadName = null;
    String platformName = null;
    private JavaObjectProxy threadObject = null;
    private JavaRuntimeProxyImpl jvm = null;
    private int myThreadPriority = -1;
    public static final int AIX_RUNNABLE = 0;
    public static final int AIX_SUSPENDED = 1;
    public static final int AIX_CONDVAR_WAIT = 2;
    public static final int AIX_STARTING = 3;
    public static final int LINUX_RUNNABLE = 0;
    public static final int LINUX_SUSPENDED = 16;
    public static final int LINUX131_SUSPENDED = 1;
    public static final int LINUX_CONDVAR_WAIT = 4096;
    public static final int LINUX131_CONDVAR_WAIT = 2;
    public static final int LINUX_SUSPENDED_CONVAR = 4112;
    public static final int WIN_RUNNABLE = 0;
    public static final int WIN_SUSPENDED = 1;
    public static final int WIN_SUSPENDED_CONDVAR = 2;
    public static final int WIN_CONDVAR_WAIT = 3;
    public static final int ZOS_STARTING = 1;
    public static final int ZOS_READY = 2;
    public static final int ZOS_EXITING = 3;
    public static final int ZOS_STOPPED = 11;
    public static final int ZOS_RUNNING = 21;
    public static final int ZOS_WAITING = 22;
    public static final int ZOS_SLEEPING = 23;
    public static final int ZOS_CONDVAR_WAIT = 24;
    public static final int ZOS_BLOCKING = 25;
    private int myThreadState;
    boolean myThreadStateSet = false;

    public JavaThreadProxyImpl(ImageThreadProxy imageThread, AddressSpaceProxy context, JavaRuntimeProxyImpl jvm) throws CorruptDataException {
        this.imageThread = imageThread;
        this.context = context;
        this.jvm = jvm;
        this.dobj = new DataObject(null, "execenv", context);
        this.dobj.setAddress(imageThread.getEEAddress());
        this.platformName = context.getPlatformName();
    }

    public ImagePointerProxy getJNIEnv() {
        return new ImagePointerProxy(this.imageThread.getEEAddress(), this.context);
    }

    public int getPriority() throws CorruptDataException {
        if (this.myThreadPriority == -1) {
            try {
                this.myThreadPriority = this.dobj.getReader().getInteger("thread_priority|(sys_thread)sys_thr.java_priority|\"5\"");
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }
        return this.myThreadPriority;
    }

    public JavaObjectProxy getObject() throws CorruptDataException {
        if (this.threadObject == null) {
            try {
                long objectAddress = this.dobj.getReader().getLong("(Long)thread");
                this.threadObject = JavaObjectProxyImpl.getInstance(objectAddress, this.context);
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }
        return this.threadObject;
    }

    public int getState() throws CorruptDataException {
        if (!this.myThreadStateSet) {
            this.myThreadStateSet = true;
            try {
                if (this.platformName.equals("windows") || this.platformName.equals("linux")) {
                    this.myThreadState = this.dobj.getReader().getint("(sys_thread)sys_thr.state.value|(sys_thread)sys_thr.state");
                } else if (this.platformName.equals("aix") || this.platformName.equals("zos")) {
                    this.myThreadState = this.dobj.getReader().getint("(sys_thread)sys_thr.state");
                }
                if (this.platformName.equals("aix")) {
                    switch (this.myThreadState) {
                        case 0: {
                            this.myThreadState = 5;
                            break;
                        }
                        case 3: {
                            this.myThreadState = 0;
                            break;
                        }
                        case 1: {
                            this.myThreadState = 0x100001;
                            break;
                        }
                        case 2: {
                            this.myThreadState = 129;
                        }
                    }
                } else if (this.platformName.equals("zos")) {
                    switch (this.myThreadState) {
                        case 1: {
                            this.myThreadState = 0;
                            break;
                        }
                        case 2: {
                            this.myThreadState = 4;
                            break;
                        }
                        case 3: 
                        case 11: {
                            this.myThreadState = 2;
                            break;
                        }
                        case 21: {
                            this.myThreadState = 5;
                            break;
                        }
                        case 22: {
                            this.myThreadState = 129;
                            break;
                        }
                        case 23: {
                            this.myThreadState = 65;
                            break;
                        }
                        case 24: {
                            this.myThreadState = 129;
                            break;
                        }
                        case 25: {
                            this.myThreadState = 1025;
                        }
                    }
                } else if (this.platformName.equals("linux")) {
                    switch (this.myThreadState) {
                        case 0: {
                            this.myThreadState = 5;
                            break;
                        }
                        case 1: 
                        case 16: 
                        case 4112: {
                            this.myThreadState = 0x100001;
                            break;
                        }
                        case 2: 
                        case 4096: {
                            this.myThreadState = 129;
                            break;
                        }
                        default: {
                            this.myThreadState = -1160716161;
                            break;
                        }
                    }
                } else if (this.platformName.equals("windows")) {
                    switch (this.myThreadState) {
                        case 0: {
                            this.myThreadState = 5;
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.myThreadState = 0x100001;
                            break;
                        }
                        case 3: {
                            this.myThreadState = 129;
                        }
                    }
                }
                if (this.dobj.getReader().getint("isSleeping") != 0 && (this.myThreadState & 1) != 0) {
                    this.myThreadState = 193;
                }
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }
        return this.myThreadState;
    }

    public ImageThreadProxy getImageThread() {
        return this.imageThread;
    }

    public Iterator getStackSections() {
        Vector<Object> javaStackSections = new Vector<Object>();
        long currentAddress = -1L;
        long endOfSection = -1L;
        int size = 0;
        try {
            currentAddress = this.dobj.getReader().getlong("(long)initial_stack");
            DataObject stackDO = new DataObject(null, "JavaStack", this.context);
            while (currentAddress != 0L) {
                stackDO.setAddress(currentAddress);
                endOfSection = stackDO.getReader().getlong("(long)end_data");
                size = (int)(endOfSection - currentAddress);
                ImagePointerProxy base = new ImagePointerProxy(currentAddress, this.context);
                ImagePointerEffigy myBasePointer = (ImagePointerEffigy)Effigy.create("ImagePointerEffigy", base, this.context, this.context.getPlatformName());
                javaStackSections.add(new ImageSectionImpl(myBasePointer, size, "JavaStackSection", false, false, false, false));
                currentAddress = stackDO.getReader().getlong("(long)next");
            }
        }
        catch (CorruptDataException e) {
            javaStackSections.add(e.getCorruptData());
        }
        catch (MemoryAccessException e) {
            javaStackSections.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
        return javaStackSections.iterator();
    }

    public Iterator getStackFrames() {
        return this.imageThread.getJavaFrames();
    }

    public String getName() throws CorruptDataException {
        if (this.myThreadName == null) {
            try {
                this.myThreadName = this.dobj.getReader().getString("(Hjava_lang_Thread*)thread.obj.name");
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), "Thread name corrupt"));
            }
        }
        return this.myThreadName;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaThread) {
            JavaThreadEffigy local = (JavaThreadEffigy)obj;
            isEqual = this.dobj.equals(((JavaThreadProxyImpl)local.getProxy()).dobj);
        }
        return isEqual;
    }

    public int hashCode() {
        return this.dobj.hashCode();
    }
}

