/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.java.JavaVMInitArgsProxy;
import com.ibm.dtfj.sov.java.imp.JavaVMOptionProxyImpl;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class JavaVMInitArgsProxyImpl
implements JavaVMInitArgsProxy {
    private long address;
    private AddressSpaceProxy context;

    public JavaVMInitArgsProxyImpl(long address, AddressSpaceProxy context) throws CorruptDataException, MemoryAccessException {
        this.context = context;
        this.address = address;
    }

    public int getVersion() throws DataUnavailable, CorruptDataException {
        try {
            return (int)this.context.readInt(this.address);
        }
        catch (MemoryAccessException e) {
            CorruptDataException cde = new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.toString()));
            cde.initCause(e);
            throw cde;
        }
    }

    public boolean getIgnoreUnrecognized() throws DataUnavailable, CorruptDataException {
        try {
            return this.context.readInt(this.address + 4L + 4L + (long)this.context.getWordLength().size) == 0L;
        }
        catch (MemoryAccessException e) {
            CorruptDataException cde = new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.toString()));
            cde.initCause(e);
            throw cde;
        }
    }

    public int getNOptions() throws MemoryAccessException {
        return (int)this.context.readInt(this.address + 4L);
    }

    public Iterator getOptions() throws DataUnavailable {
        try {
            long options = 0L;
            options = this.context.getWordLength().size == 8 ? this.context.readLong(this.address + 4L + 4L) : this.context.readInt(this.address + 4L + 4L);
            return new OptionIterator(this.getNOptions(), options, this.context);
        }
        catch (MemoryAccessException e) {
            Vector<CorruptDataImpl> badVector = new Vector<CorruptDataImpl>(1);
            badVector.add(new CorruptDataImpl(e.getPointer(), e.toString()));
            return badVector.iterator();
        }
    }

    class OptionIterator
    implements Iterator {
        private long address;
        private AddressSpaceProxy context;
        private int nOptions;

        OptionIterator(int nOptions, long firstAddress, AddressSpaceProxy context) {
            this.address = firstAddress;
            this.context = context;
            this.nOptions = nOptions;
        }

        public boolean hasNext() {
            return this.nOptions > 0;
        }

        public Object next() throws NoSuchElementException {
            if (this.hasNext()) {
                try {
                    JavaVMOptionProxyImpl jvopi = new JavaVMOptionProxyImpl(this.address, this.context);
                    this.address += (long)(this.context.getWordLength().size * 2);
                    --this.nOptions;
                    return jvopi;
                }
                catch (CorruptDataException e) {
                    this.nOptions = 0;
                    return e.getCorruptData();
                }
            }
            throw new NoSuchElementException();
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

