/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.java.JavaVMOptionProxy;

public class JavaVMOptionProxyImpl
implements JavaVMOptionProxy {
    private long address;
    private AddressSpaceProxy context;

    public JavaVMOptionProxyImpl(long address, AddressSpaceProxy context) throws CorruptDataException {
        this.address = address;
        this.context = context;
    }

    public String getOptionString() throws DataUnavailable, CorruptDataException {
        try {
            if (this.context.getWordLength().size == 4) {
                return this.context.readString(this.context.readInt(this.address));
            }
            return this.context.readString(this.context.readLong(this.address));
        }
        catch (MemoryAccessException e) {
            CorruptDataException cde = new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.toString()));
            cde.initCause(e);
            throw cde;
        }
    }

    public ImagePointerProxy getExtraInfo() throws DataUnavailable, CorruptDataException {
        try {
            if (this.context.getWordLength().size == 4) {
                return new ImagePointerProxy(this.context.readInt(this.address + (long)this.context.getWordLength().size), this.context);
            }
            return new ImagePointerProxy(this.context.readLong(this.address + (long)this.context.getWordLength().size), this.context);
        }
        catch (MemoryAccessException e) {
            CorruptDataException cde = new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.toString()));
            cde.initCause(e);
            throw cde;
        }
    }
}

