/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.data.StructuredDataLocator;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.java.ObjectFieldProxy;
import com.ibm.dtfj.sov.java.imp.JavaObjectProxyImpl;
import java.util.Map;
import java.util.TreeMap;

public class ObjectFieldProxyImpl
implements ObjectFieldProxy {
    private static final int JVM_ACC_PUBLIC = 1;
    private static final int JVM_ACC_PRIVATE = 2;
    private static final int JVM_ACC_PROTECTED = 4;
    private static final int JVM_ACC_STATIC = 8;
    private static final int JVM_ACC_FINAL = 16;
    private static final int JVM_ACC_SUPER = 32;
    private static final int JVM_ACC_VOLATILE = 64;
    private static final int JVM_ACC_TRANSIENT = 128;
    private static int MBF_FB_IsTwoWordValue = 1;
    private static int MBF_FB_IsReferenceValue = 2;
    private static int MBF_FB_IsMarkedExcluded = 4;
    private TreeMap attributes;
    private long fieldBlockAddress;
    private long objectDataAddress;
    private AddressSpaceProxy context;
    private int sharedClassId;
    private String name;
    private int access;
    private int flags;
    private long offset;
    private long static_address;
    private boolean isStatic = false;
    private boolean isReference = false;
    private int slotSize = 1;
    private static DataObject fieldBlockDO = null;
    private static DataObject classBlockDO = null;
    private static DataObject stringDO = null;
    private String signature;

    public ObjectFieldProxyImpl(long fieldBlockAddress, long objectDataAddress, int sharedClassId, AddressSpaceProxy context) throws CorruptDataException, MemoryAccessException {
        this.fieldBlockAddress = fieldBlockAddress;
        this.objectDataAddress = objectDataAddress;
        this.context = context;
        this.sharedClassId = sharedClassId;
        if (fieldBlockDO == null) {
            fieldBlockDO = new DataObject(null, "fieldblock", context);
        }
        fieldBlockDO.setAddress(fieldBlockAddress);
        StructuredDataLocator fieldBlockReader = fieldBlockDO.getReader();
        this.name = fieldBlockReader.getString("member.name");
        this.access = fieldBlockReader.getshort("member.access");
        this.flags = fieldBlockReader.getshort("member.flags");
        this.offset = fieldBlockReader.getint("value.instance_offset");
        this.static_address = fieldBlockDO.getMemberAddress("value.(Hjava_lang_Object*)nonshared_static");
        if ((this.flags & MBF_FB_IsReferenceValue) == MBF_FB_IsReferenceValue) {
            this.isReference = true;
        } else {
            this.signature = fieldBlockReader.getString("member.signature");
        }
        this.attributes = new TreeMap();
        if ((this.access & 1) == 1) {
            this.attributes.put("Public", Boolean.TRUE);
        } else {
            this.attributes.put("Public", Boolean.FALSE);
        }
        if ((this.access & 2) == 2) {
            this.attributes.put("Private", Boolean.TRUE);
        } else {
            this.attributes.put("Private", Boolean.FALSE);
        }
        if ((this.access & 4) == 4) {
            this.attributes.put("Protected", Boolean.TRUE);
        } else {
            this.attributes.put("Protected", Boolean.FALSE);
        }
        if ((this.access & 8) == 8) {
            this.attributes.put("Static", Boolean.TRUE);
            this.isStatic = true;
        } else {
            this.attributes.put("Static", Boolean.FALSE);
            this.isStatic = false;
        }
        if ((this.access & 0x10) == 16) {
            this.attributes.put("Final", Boolean.TRUE);
        } else {
            this.attributes.put("Final", Boolean.FALSE);
        }
        if ((this.access & 0x20) == 32) {
            this.attributes.put("Super", Boolean.TRUE);
        } else {
            this.attributes.put("Super", Boolean.FALSE);
        }
        if ((this.access & 0x40) == 64) {
            this.attributes.put("Volatile", Boolean.TRUE);
        } else {
            this.attributes.put("Volatile", Boolean.FALSE);
        }
        if ((this.access & 0x80) == 128) {
            this.attributes.put("Transient", Boolean.TRUE);
        } else {
            this.attributes.put("Transient", Boolean.FALSE);
        }
        if ((this.flags & MBF_FB_IsTwoWordValue) == MBF_FB_IsTwoWordValue) {
            this.attributes.put("TwoWord", Boolean.TRUE);
            this.slotSize = 2;
        } else {
            this.attributes.put("TwoWord", Boolean.FALSE);
            this.slotSize = 1;
        }
        if ((this.flags & MBF_FB_IsReferenceValue) == MBF_FB_IsReferenceValue) {
            this.attributes.put("Reference", Boolean.TRUE);
        } else {
            this.attributes.put("Reference", Boolean.FALSE);
        }
        if ((this.flags & MBF_FB_IsMarkedExcluded) == MBF_FB_IsMarkedExcluded) {
            this.attributes.put("MarkedExcluded", Boolean.TRUE);
        } else {
            this.attributes.put("MarkedExcluded", Boolean.FALSE);
        }
    }

    public long getAddress() {
        if (this.isStatic) {
            return this.static_address;
        }
        return this.objectDataAddress + this.offset;
    }

    public long getFieldDescriptorAddress() {
        return this.fieldBlockAddress;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Object getValue() throws MemoryAccessException, CorruptDataException {
        if (this.isStatic && this.sharedClassId != 0) {
            return "CANNOT ACCESS SHARED CLASS STATIC DATA YET";
        }
        long returnValueAddress = this.isStatic ? this.static_address : this.objectDataAddress + this.offset;
        long returnValue = this.slotSize == 2 ? this.context.readLong(returnValueAddress) : this.context.readInt(returnValueAddress);
        if (this.isReference) {
            return new Long(returnValue);
        }
        switch (this.signature.charAt(0)) {
            case 'Z': {
                return new Boolean(returnValue != 0L);
            }
            case 'C': {
                return new Character((char)returnValue);
            }
            case 'B': 
            case 'I': 
            case 'J': 
            case 'S': {
                return new Long(returnValue);
            }
            case 'F': {
                return new Double(Float.intBitsToFloat((int)returnValue));
            }
            case 'D': {
                return new Double(Double.longBitsToDouble(returnValue));
            }
        }
        throw new CorruptDataException(new CorruptDataImpl("Invalid field signature " + this));
    }

    public String getValueAsString() throws CorruptDataException, MemoryAccessException {
        if (this.isStatic && this.sharedClassId != 0) {
            return "CANNOT ACCESS SHARED CLASS STATIC DATA YET";
        }
        if (!this.isReference) {
            return this.getValue().toString();
        }
        long referenceAddress = this.isStatic ? this.static_address : this.objectDataAddress + this.offset;
        long reference = this.slotSize == 2 ? this.context.readLong(referenceAddress) : this.context.readInt(referenceAddress);
        JavaObjectProxyImpl hopi = JavaObjectProxyImpl.getInstance(reference, this.context);
        if (hopi.isArray()) {
            return "Array@0x" + Long.toHexString(reference);
        }
        long classBlockAddress = hopi.getClassAddress();
        if (classBlockDO == null) {
            classBlockDO = new DataObject(null, "Hjava_lang_Class", this.context);
        }
        classBlockDO.setAddress(classBlockAddress);
        String className = classBlockDO.getReader().getString("obj.name");
        if (!className.equals("java/lang/String")) {
            return className + "@0x" + Long.toHexString(reference);
        }
        if (stringDO == null) {
            stringDO = new DataObject(null, "Hjava_lang_String", this.context);
        }
        stringDO.setAddress(reference);
        String resultString = stringDO.getReader().getString("obj.value");
        return resultString.substring(0, stringDO.getReader().getLong("obj.count").intValue());
    }

    public String getName() {
        return this.name;
    }

    boolean isStatic() {
        return this.isStatic;
    }

    static boolean isStatic(long fieldBlockAddress, AddressSpaceProxy context) throws MemoryAccessException, CorruptDataException {
        if (fieldBlockDO == null) {
            fieldBlockDO = new DataObject(null, "fieldblock", context);
        }
        fieldBlockDO.setAddress(fieldBlockAddress);
        StructuredDataLocator fieldBlockReader = fieldBlockDO.getReader();
        short access = (short)fieldBlockReader.getShort("member.access").intValue();
        return (access & 8) == 8;
    }

    public String toString() {
        return "ObjectField: " + this.signature + ", " + this.name;
    }
}

