/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.imp.JavaMonitorEffigy;
import com.ibm.dtfj.sov.java.JavaMonitorProxy;
import com.ibm.dtfj.sov.java.JavaObjectProxy;
import com.ibm.dtfj.sov.java.JavaThreadProxy;
import com.ibm.dtfj.sov.java.imp.JavaObjectProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import com.ibm.dtfj.sov.java.imp.SystemMonitor;
import java.util.Iterator;
import java.util.Vector;

public class ObjectLock
implements JavaMonitorProxy {
    private JavaRuntimeProxyImpl jvm;
    private JavaThreadProxy owner = null;
    private Iterator allThreads = null;
    private JavaObjectProxyImpl lockedObject = null;
    private SystemMonitor systemMonitor;
    private AddressSpaceProxy context;
    private Boolean flatLockedFlag = null;

    public void setLockedObject(Long objectAddress, AddressSpaceProxy context) {
        if (this.lockedObject == null && objectAddress != 0L) {
            try {
                this.lockedObject = JavaObjectProxyImpl.getInstance(objectAddress, context);
            }
            catch (MemoryAccessException e) {
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
    }

    public void setSystemMonitor(SystemMonitor systemMonitor) {
        this.systemMonitor = systemMonitor;
    }

    ObjectLock(JavaRuntimeProxyImpl jvm, AddressSpaceProxy context) {
        this.jvm = jvm;
        this.context = context;
    }

    private boolean isFlatLocked() {
        if (this.flatLockedFlag == null) {
            this.flatLockedFlag = this.lockedObject == null ? Boolean.FALSE : new Boolean(this.lockedObject.getFlatThread() != 0);
        }
        return this.flatLockedFlag;
    }

    public String getLockType() {
        if (this.isFlatLocked()) {
            return "Flat Lock";
        }
        return "Inflated Lock";
    }

    public String getName() throws CorruptDataException {
        if (this.lockedObject == null) {
            return "unassigned";
        }
        String className = this.lockedObject.getClassName();
        return className + "@0x" + Long.toHexString(this.lockedObject.getAddress());
    }

    public Long getObjectAddress() {
        return new Long(this.lockedObject.getAddress());
    }

    public JavaObjectProxy getObject() {
        return this.lockedObject;
    }

    public JavaThreadProxy getOwner() throws CorruptDataException {
        if (this.owner == null) {
            if (this.isFlatLocked()) {
                Long flatThread = new Long(this.lockedObject.getFlatThread());
                Long execenv = this.jvm.getExecenvForLockId(flatThread);
                this.owner = this.jvm.getJavaThread(execenv);
            } else {
                this.owner = this.systemMonitor.getOwner();
            }
        }
        return this.owner;
    }

    public Iterator getNotifyWaiters() {
        if (this.systemMonitor != null) {
            return this.systemMonitor.getNotifyWaiters();
        }
        return new Vector().iterator();
    }

    public Iterator getEnterWaiters() {
        if (this.systemMonitor != null) {
            return this.systemMonitor.getEnterWaiters();
        }
        return new Vector().iterator();
    }

    public int hashCode() {
        return this.jvm.hashCode() ^ this.lockedObject.hashCode();
    }

    public boolean equals(Object obj) {
        JavaMonitorEffigy local;
        JavaMonitorProxy proxy;
        boolean isEqual = false;
        if (obj instanceof JavaMonitorEffigy && (proxy = (local = (JavaMonitorEffigy)obj).getProxy()) instanceof ObjectLock) {
            isEqual = this.jvm.equals(((ObjectLock)proxy).jvm) && this.lockedObject.equals(((ObjectLock)proxy).lockedObject);
        }
        return isEqual;
    }

    public ImagePointerProxy getID() {
        if (this.isFlatLocked()) {
            return new ImagePointerProxy(this.lockedObject.getAddress() + (long)this.context.getWordLength().size, this.context);
        }
        return new ImagePointerProxy(this.systemMonitor.getID(), this.context);
    }
}

