/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.java.JavaThreadProxy;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class SystemMonitor {
    private HashSet waiterExecenvs = new HashSet();
    protected DataObject systemMonitorDO;
    protected JavaRuntimeProxyImpl jvm;
    protected AddressSpaceProxy context;
    protected String ownerSpec;
    protected String entryCountSpec;
    protected String monitorWaiterSpec;
    protected String queueHeadSpec;
    protected String waitingThreadSpec;
    protected String nextWaiterSpec;

    protected SystemMonitor(long systemMonitorAddress, JavaRuntimeProxyImpl jvm, AddressSpaceProxy context) throws CorruptDataException {
        this.jvm = jvm;
        this.context = context;
        this.systemMonitorDO = new DataObject(null, "sys_mon", context);
        this.systemMonitorDO.setAddress(systemMonitorAddress);
    }

    public JavaThreadProxy getOwner() throws CorruptDataException {
        try {
            Long sysThread = this.systemMonitorDO.getReader().getLong(this.ownerSpec);
            Long execenv = this.jvm.getExecenvForThread(sysThread);
            return this.jvm.getJavaThread(execenv);
        }
        catch (MemoryAccessException e) {
            CorruptDataException cde = new CorruptDataException(new CorruptDataImpl(e.getPointer(), "Memory access exception: " + e.getMessage()));
            cde.initCause(e);
            throw cde;
        }
    }

    public int getEntryCount() throws MemoryAccessException, CorruptDataException {
        return this.systemMonitorDO.getReader().getInteger(this.entryCountSpec);
    }

    public Iterator getNotifyWaiters() {
        Vector<CorruptData> badVec;
        try {
            return new NotifyWaiterIterator();
        }
        catch (CorruptDataException e) {
            badVec = new Vector<CorruptData>(1);
            badVec.add(e.getCorruptData());
        }
        catch (MemoryAccessException e) {
            badVec = new Vector(1);
            badVec.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
        return badVec.iterator();
    }

    public Iterator getEnterWaiters() {
        return this.waiterExecenvs.iterator();
    }

    public void addEnterWaiter(JavaThreadProxy javaThread) {
        this.waiterExecenvs.add(javaThread);
    }

    public static SystemMonitor getInstance(long systemMonitorAddress, JavaRuntimeProxyImpl jvm, AddressSpaceProxy context) {
        String packageName = jvm.getClass().getPackage().getName();
        String platform = context.getPlatformName();
        String className = packageName + "." + platform + ".SystemMonitor";
        try {
            Class<?> platformClass = Class.forName(className);
            Class[] constructorDef = new Class[]{Long.TYPE, Class.forName("com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl"), Class.forName("com.ibm.dtfj.sov.image.AddressSpaceProxy")};
            Constructor<?> platformClassConstructor = platformClass.getConstructor(constructorDef);
            Object[] constructorArgs = new Object[]{new Long(systemMonitorAddress), jvm, context};
            SystemMonitor systemMonitor = (SystemMonitor)platformClassConstructor.newInstance(constructorArgs);
            return systemMonitor;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            RuntimeException re = new RuntimeException("Exception " + e);
            re.initCause(e);
            if (e instanceof InvocationTargetException) {
                ((InvocationTargetException)e).getTargetException().printStackTrace(System.err);
            }
            throw re;
        }
    }

    public int hashCode() {
        return this.systemMonitorDO.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SystemMonitor) {
            return ((SystemMonitor)obj).systemMonitorDO.equals(this.systemMonitorDO);
        }
        return false;
    }

    public long getID() {
        return this.systemMonitorDO.getAddress();
    }

    public class NotifyWaiterIterator
    implements Iterator {
        DataObject monitorWaiterDO;
        long firstWaiterAddress;
        long thisWaiterAddress;
        Long thisWaiterExecenv = null;
        JavaThreadProxy thisWaiterThread = null;
        CorruptDataImpl corruptData = null;
        boolean deliveredCorruptData = false;

        public NotifyWaiterIterator() throws CorruptDataException, MemoryAccessException {
            this.monitorWaiterDO = new DataObject(null, SystemMonitor.this.monitorWaiterSpec, SystemMonitor.this.context);
            this.thisWaiterAddress = this.firstWaiterAddress = SystemMonitor.this.systemMonitorDO.getReader().getLong(SystemMonitor.this.queueHeadSpec).longValue();
        }

        public boolean hasNext() {
            if (this.thisWaiterAddress == 0L) {
                return false;
            }
            if (this.deliveredCorruptData) {
                return false;
            }
            this.monitorWaiterDO.setAddress(this.thisWaiterAddress);
            Long sysThread = null;
            try {
                sysThread = this.monitorWaiterDO.getReader().getLong(SystemMonitor.this.waitingThreadSpec);
            }
            catch (CorruptDataException e) {
                this.corruptData = (CorruptDataImpl)e.getCorruptData();
                return true;
            }
            catch (MemoryAccessException e) {
                this.corruptData = new CorruptDataImpl(e.getPointer(), "Memory access exception: " + e.getMessage());
                return true;
            }
            this.thisWaiterExecenv = SystemMonitor.this.jvm.getExecenvForThread(sysThread);
            this.thisWaiterThread = SystemMonitor.this.jvm.getJavaThread(this.thisWaiterExecenv);
            return this.thisWaiterExecenv != null;
        }

        public Object next() {
            if (!this.hasNext() || this.deliveredCorruptData) {
                throw new NoSuchElementException();
            }
            if (this.corruptData != null) {
                this.deliveredCorruptData = true;
                return this.corruptData;
            }
            this.getNext();
            if (this.corruptData != null) {
                this.deliveredCorruptData = true;
                return this.corruptData;
            }
            return this.thisWaiterThread;
        }

        private void getNext() {
            try {
                this.thisWaiterAddress = this.monitorWaiterDO.getReader().getLong(SystemMonitor.this.nextWaiterSpec);
            }
            catch (CorruptDataException e) {
                this.corruptData = (CorruptDataImpl)e.getCorruptData();
                return;
            }
            catch (MemoryAccessException e) {
                this.corruptData = new CorruptDataImpl(e.getPointer(), "Memory access exception: " + e.getMessage());
                return;
            }
            if (this.thisWaiterAddress == this.firstWaiterAddress) {
                this.thisWaiterAddress = 0L;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

