/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp.windows;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.java.JavaThreadProxy;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import java.util.Iterator;
import java.util.Vector;

public class SystemMonitor
extends com.ibm.dtfj.sov.java.imp.SystemMonitor {
    public SystemMonitor(long systemMonitorAddress, JavaRuntimeProxyImpl jvm, AddressSpaceProxy context) throws CorruptDataException {
        super(systemMonitorAddress, jvm, context);
        this.ownerSpec = "(Long)monitor_owner";
        this.entryCountSpec = "entry_count";
    }

    public Iterator getNotifyWaiters() {
        try {
            return new Iterator(){
                DataObject monitorWaiterDO;
                long firstWaiterAddress;
                long thisWaiterAddress;
                Long thisWaiterExecenv;
                JavaThreadProxy thisWaiterThread;
                {
                    this.monitorWaiterDO = new DataObject(null, "sys_thread", SystemMonitor.this.context);
                    this.thisWaiterAddress = this.firstWaiterAddress = SystemMonitor.this.systemMonitorDO.getReader().getLong("(Long)monitor_waiter").longValue();
                    this.thisWaiterExecenv = null;
                    this.thisWaiterThread = null;
                }

                public boolean hasNext() {
                    return this.thisWaiterAddress != 0L;
                }

                public Object next() {
                    this.monitorWaiterDO.setAddress(this.thisWaiterAddress);
                    Long thisThread = new Long(this.thisWaiterAddress);
                    try {
                        this.getNext();
                    }
                    catch (CorruptDataException e) {
                        return e.getCorruptData();
                    }
                    catch (MemoryAccessException e) {
                        return new CorruptDataImpl(e.getPointer(), e.getMessage());
                    }
                    this.thisWaiterExecenv = SystemMonitor.this.jvm.getExecenvForThread(thisThread);
                    this.thisWaiterThread = SystemMonitor.this.jvm.getJavaThread(this.thisWaiterExecenv);
                    return this.thisWaiterThread;
                }

                private void getNext() throws CorruptDataException, MemoryAccessException {
                    this.thisWaiterAddress = this.monitorWaiterDO.getReader().getLong("(Long)next_waiter");
                    if (this.thisWaiterAddress == this.firstWaiterAddress) {
                        this.thisWaiterAddress = 0L;
                    }
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (CorruptDataException e) {
            Vector<CorruptData> waiters = new Vector<CorruptData>();
            waiters.add(e.getCorruptData());
            return waiters.iterator();
        }
        catch (MemoryAccessException e) {
            Vector<CorruptDataImpl> waiters = new Vector<CorruptDataImpl>();
            waiters.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            return waiters.iterator();
        }
    }
}

