/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.nativeXML;

import com.ibm.dtfj.sov.utils.Trace;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public class AllCtypes {
    public static final int TYPE_PRIMITIVE = 1;
    public static final int TYPE_STRUCT = 2;
    public static final int TYPE_UNION = 3;
    public static final int TYPE_ENUM = 4;
    public static final int TYPE_POINTER = 5;
    public static final int TYPE_ARRAY = 6;
    public static final int TYPE_FUNCTION = 7;
    public static final int TYPE_ALIAS = 8;
    public static final int TYPE_STRUCTTAG = 9;
    Writer xmlStream;
    public static String[] baseTypeName = new String[]{"PRIMITIVE", "Primitive", "Structure", "Union", "Enum", "Pointer", "Array", "Function", "Alias", "StructureTag"};
    HashSet seenItems = new HashSet();
    HashSet seenNames = new HashSet();
    TreeMap allTypes = new TreeMap();
    LinkedList fieldsToDump;
    private int indentLevel = 0;
    private static String manySpaces = "                                        ";
    private static final int INDENTBY = 4;

    CType create(int typeNum) {
        CType t = this.find(typeNum);
        if (t == null) {
            t = new CType();
            t.typeNum = typeNum;
            this.allTypes.put(new Integer(typeNum), t);
        }
        return t;
    }

    private CType parseTypeNum(String t, int offset) {
        String tnum = t.substring(offset);
        int typeNum = Integer.parseInt(tnum);
        return this.create(typeNum);
    }

    public CType create(int typeNum, int baseType, int size, String name, String description) {
        CType t = this.create(typeNum);
        t.baseType = baseType;
        t.size = size;
        t.name = name;
        t.definition = description;
        if (description != null && description.length() > 0) {
            t.parseStab(description);
        }
        return t;
    }

    public CType find(int typeNum) {
        return (CType)this.allTypes.get(new Integer(typeNum));
    }

    public void postProcess() {
        CType t;
        Iterator iter = this.allTypes.values().iterator();
        while (iter.hasNext()) {
            t = (CType)iter.next();
            if (t.baseType == 8) continue;
            if (t.baseType == 6) {
                t.arrayInfo.type = t.arrayInfo.type.unAlias();
                t.arrayInfo.type.arrayElementOf.add(t);
            }
            if (t.baseType == 5 || t.baseType == 7) {
                t.derefType = t.derefType.unAlias();
                if (t.derefType != null) {
                    t.derefType.directReferees.add(t);
                }
            }
            for (int i = 0; i < t.numFields; ++i) {
                String fieldName = t.fieldNames[i];
                if (fieldName == null) continue;
                FieldInfo fieldInfo = (FieldInfo)t.fields.get(fieldName);
                if (fieldName.equals("next")) {
                    t.linkedForward = true;
                }
                if (fieldName.equals("prev")) {
                    t.linkedBackward = true;
                }
                CType fieldType = fieldInfo.type;
                fieldInfo.type = fieldType = fieldType.unAlias();
                fieldInfo.parent = fieldInfo.parent.unAlias();
                if (fieldType != t) {
                    fieldType.usedIn.add(fieldInfo);
                }
                if (fieldInfo.type.baseType != 5) continue;
                while (fieldType.derefType != null) {
                    fieldType = fieldType.derefType;
                }
                if (fieldType == t) continue;
                fieldType.referees.add(fieldInfo);
            }
        }
        iter = this.allTypes.values().iterator();
        while (iter.hasNext()) {
            t = (CType)iter.next();
            if (t.baseType != 8) continue;
            CType base = t.unAlias();
            if (base != null && (base.name == null || base.name.length() == 0)) {
                base.name = t.name;
            }
            iter.remove();
        }
    }

    public void dumpAllTypes(Writer where) {
        Iterator iter = this.allTypes.values().iterator();
        while (iter.hasNext()) {
            CType t = (CType)iter.next();
            try {
                where.write(t.toString());
                where.write(System.getProperty("line.separator"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void dumpAllTypesAsXML(Writer xmlStream) {
        this.xmlStream = xmlStream;
        this.indentAndPrint("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.indentAndPrint("<Map xmlns=\"http://www.ibm.com/jtc/jformat\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/jtc/jformat nativeStructure.xsd \">");
        boolean FIRST_PASS = true;
        int LAST_PASS = 2;
        for (int pass = 1; pass <= 2; ++pass) {
            Iterator iter = this.allTypes.values().iterator();
            while (iter.hasNext()) {
                CType t = (CType)iter.next();
                if (pass == 1 && (!t.referees.isEmpty() || !t.directReferees.isEmpty() || !t.usedIn.isEmpty() || !t.arrayElementOf.isEmpty()) || t.baseType <= 1 || t.name == null || t.name.length() == 0 || t.name.equals("__unnamed") || t.name.equals("(null)")) continue;
                this.fieldsToDump = new LinkedList();
                t.xmlDumpDataObject();
                while (!this.fieldsToDump.isEmpty()) {
                    CType ft = (CType)this.fieldsToDump.removeFirst();
                    if (ft.baseType <= 1) continue;
                    ft.xmlDumpDataObject();
                }
            }
        }
        this.indentAndPrint("</Map>");
    }

    void indentAndPrint(String toPrint) {
        if (toPrint.regionMatches(0, "<?", 0, 2)) {
            this.indentedPrint(toPrint);
        } else if (toPrint.regionMatches(0, "</", 0, 2)) {
            this.indentLevel -= 4;
            this.indentedPrint(toPrint);
        } else if (toPrint.regionMatches(toPrint.length() - 2, "/>", 0, 2)) {
            this.indentedPrint(toPrint);
        } else {
            this.indentedPrint(toPrint);
            this.indentLevel += 4;
        }
    }

    private void indentedPrint(String toPrint) {
        try {
            int i;
            for (i = this.indentLevel; i > manySpaces.length(); i -= manySpaces.length()) {
                this.xmlStream.write(manySpaces);
            }
            this.xmlStream.write(manySpaces.substring(0, i) + toPrint);
            this.xmlStream.write(System.getProperty("line.separator"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class CaseIndependentStringComparator
    implements Comparator {
        CaseIndependentStringComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((String)o1).toUpperCase().compareTo(((String)o2).toUpperCase());
        }
    }

    class EnumValue {
        String name;
        int value;

        EnumValue(String name, int value) {
            this.name = name;
            this.value = value;
        }

        void xmlDump() {
            AllCtypes.this.indentAndPrint("<EnumerationValue name=\"" + this.name + "\" value=\"" + this.value + "\" />");
        }
    }

    class ArrayInfo {
        int dimensions;
        int[] start;
        int[] end;
        CType type;

        ArrayInfo() {
        }

        public String toString() {
            return "dimensions : " + this.dimensions + " start[0] : " + this.start[0] + "end[0]" + this.end[0] + " type : " + this.type.typeNum;
        }
    }

    class FieldInfo {
        CType parent;
        CType type;
        int fieldNum;
        int offset;
        int size;
        String name;

        FieldInfo(CType parent, CType type, int fieldNum, int offset, int size, String name) {
            this.parent = parent;
            this.type = type;
            this.fieldNum = fieldNum;
            this.offset = offset;
            this.size = size;
            this.name = name;
        }
    }

    class Referee {
        CType type;
        FieldInfo field;

        Referee(CType t, FieldInfo f) {
            this.type = t;
            this.field = f;
        }
    }

    public class CType {
        int typeNum;
        int size;
        int baseType;
        String name;
        String definition;
        CType aliasType;
        HashSet referees = new HashSet();
        HashSet usedIn = new HashSet();
        HashSet directReferees = new HashSet();
        HashSet arrayElementOf = new HashSet();
        boolean linkedForward = false;
        boolean linkedBackward = false;
        int numFields;
        HashMap fields;
        String[] fieldNames;
        CType derefType;
        ArrayInfo arrayInfo;
        ArrayList enumValues;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("CType # : " + this.typeNum + "(" + this.name + ")\n");
            sb.append("\tbase type : " + this.baseType + "\n");
            sb.append("\tSize : " + this.size + "\n");
            if (this.aliasType != null) {
                sb.append("\tAlias for : " + this.aliasType.typeNum + "\n");
            }
            if (this.numFields > 0) {
                for (int i = 0; i < this.numFields; ++i) {
                    FieldInfo fi = (FieldInfo)this.fields.get(this.fieldNames[i]);
                    sb.append("\tfield[" + i + "] name : " + this.fieldNames[i] + " type : " + fi.type.typeNum + " at offset : " + fi.offset + "\n");
                }
            }
            if (this.derefType != null) {
                sb.append("\tderefType : " + this.derefType.typeNum + "\n");
            }
            if (this.arrayInfo != null) {
                sb.append("\t ArrayInfo : " + this.arrayInfo.toString() + "\n");
            }
            return sb.toString();
        }

        private int parseField(String t, int currentChar, int fieldNum) {
            int start;
            int end = start = currentChar;
            end = t.indexOf(58, start);
            if (end < 0) {
                return t.length();
            }
            String name = t.substring(start, end);
            start = ++end;
            end = t.indexOf(44, start);
            int typeNum = Integer.parseInt(t.substring(start, end));
            CType type = AllCtypes.this.create(typeNum);
            start = ++end;
            end = t.indexOf(44, start);
            int fieldOffset = Integer.parseInt(t.substring(start, end));
            start = ++end;
            end = t.indexOf(59, start);
            int size = Integer.parseInt(t.substring(start, end));
            this.fields.put(name, new FieldInfo(this, type, fieldNum, fieldOffset /= 8, size /= 8, name));
            return ++end;
        }

        private void parseStruct(String t, int currentChar) {
            int fieldNum = 0;
            int start = currentChar + 1;
            this.fields = new HashMap();
            if (t.equals("s0")) {
                if (this.name == null) {
                    this.name = "void";
                }
                return;
            }
            while (t.charAt(start) >= '0' && t.charAt(start) <= '9') {
                ++start;
            }
            if (this.size == 0) {
                this.size = Integer.parseInt(t.substring(currentChar + 1, start));
            }
            while (start < t.length()) {
                start = this.parseField(t, start, fieldNum);
                ++fieldNum;
            }
            this.numFields = this.fields.size();
            this.fieldNames = new String[this.numFields];
            Iterator it = this.fields.keySet().iterator();
            while (it.hasNext()) {
                String fieldName = (String)it.next();
                fieldNum = ((FieldInfo)this.fields.get((Object)fieldName)).fieldNum;
                this.fieldNames[fieldNum] = fieldName;
            }
        }

        private void parseArray(String t) {
            this.arrayInfo = new ArrayInfo();
            int start = t.indexOf(59) + 1;
            this.arrayInfo.dimensions = 1;
            this.arrayInfo.start = new int[1];
            this.arrayInfo.end = new int[1];
            int end = t.indexOf(59, start);
            this.arrayInfo.start[0] = Integer.parseInt(t.substring(start, end));
            start = ++end;
            end = t.indexOf(59, start);
            this.arrayInfo.end[0] = Integer.parseInt(t.substring(start, end));
            start = ++end;
            while (end < t.length() && t.charAt(end) != ';') {
                ++end;
            }
            this.arrayInfo.type = AllCtypes.this.create(Integer.parseInt(t.substring(start, end)));
        }

        private void parseEnum(String t, int offset) {
            int start;
            this.enumValues = new ArrayList();
            if (t.charAt(++offset) == '-') {
                ++offset;
            }
            while (t.charAt(offset) >= '0' && t.charAt(offset) <= '9') {
                ++offset;
            }
            if (t.charAt(offset) == ':') {
                ++offset;
            }
            int end = start = offset;
            while (end < t.length() && (end = t.indexOf(58, start)) >= 0 && end != start) {
                String name = t.substring(start, end);
                ++end;
                start = end;
                String enumVal = t.substring(start, end = t.indexOf(44, start));
                if (enumVal.equals("2147483648")) {
                    enumVal = "-2147483648";
                }
                int val = Integer.parseInt(enumVal);
                start = ++end;
                this.enumValues.add(new EnumValue(name, val));
            }
        }

        private void parseStab(String description) {
            int index = 0;
            if (description == null || description.length() == 0) {
                return;
            }
            if (description.charAt(index) == 'V' || description.charAt(index) == 'k') {
                ++index;
            }
            switch (description.charAt(index)) {
                case '*': {
                    this.baseType = 5;
                    this.derefType = AllCtypes.this.parseTypeNum(description, index + 1);
                    break;
                }
                case 's': {
                    this.baseType = 2;
                    this.parseStruct(description, index);
                    break;
                }
                case 'u': {
                    this.baseType = 3;
                    this.parseStruct(description, index);
                    break;
                }
                case 'e': {
                    this.baseType = 4;
                    Trace.writeToTrace("Found an enum " + description);
                    this.parseEnum(description, index);
                    break;
                }
                case 'a': {
                    this.baseType = 6;
                    this.parseArray(description);
                    break;
                }
                case 'f': {
                    this.baseType = 7;
                    this.derefType = AllCtypes.this.parseTypeNum(description, index + 1);
                    break;
                }
                case '-': {
                    String tnum = description.substring(index);
                    this.baseType = Integer.parseInt(tnum);
                    break;
                }
                case 'Y': 
                case 'r': {
                    break;
                }
                default: {
                    this.baseType = 8;
                    this.aliasType = AllCtypes.this.parseTypeNum(description, index);
                    if (this.aliasType != this) break;
                    this.aliasType = null;
                    if (this.name != null) break;
                    this.name = "void";
                }
            }
        }

        private CType() {
        }

        CType unAlias() {
            CType base;
            CType previous = null;
            CType t = this;
            while (t.baseType == 8) {
                if (t == previous) {
                    System.err.println(this.name + " " + this.typeNum);
                    System.err.println(t.name + " " + t.typeNum);
                    return null;
                }
                if (t.aliasType == null) break;
                previous = t;
                t = t.aliasType;
            }
            if (t.baseType < 0 && (base = AllCtypes.this.find(t.baseType)) != null) {
                t = base;
            }
            return t;
        }

        private void getParentNames(FieldInfo parent, ArrayList allParents, String nameSoFar) {
            HashSet usedIn = parent.parent.usedIn;
            if (usedIn.isEmpty()) {
                allParents.add(parent.parent.name + "." + nameSoFar);
                return;
            }
            Iterator iP = usedIn.iterator();
            while (iP.hasNext()) {
                FieldInfo nextParent = (FieldInfo)iP.next();
                this.getParentNames(nextParent, allParents, parent.name + "." + nameSoFar);
            }
        }

        public String getName() {
            if (this.name != null && this.name.length() != 0) {
                return this.name;
            }
            return "null name for type " + this.typeNum;
        }

        private String getBaseTypeName(int baseType) {
            if (baseType >= 0 && baseType < baseTypeName.length) {
                return baseTypeName[baseType];
            }
            CType base = AllCtypes.this.find(baseType);
            if (base != null) {
                this.name = base.name;
                if (this.name != null && this.name.length() != 0) {
                    return this.name;
                }
            }
            return "unknown baseType " + baseType;
        }

        public void xmlDumpDataObject() {
            if (AllCtypes.this.seenItems.contains(this)) {
                return;
            }
            String name = this.getName();
            if (name.equals("(null)")) {
                return;
            }
            if (name.equals("void")) {
                return;
            }
            if (AllCtypes.this.seenNames.contains(name)) {
                AllCtypes.this.seenItems.add(this);
                return;
            }
            AllCtypes.this.seenNames.add(name);
            AllCtypes.this.indentAndPrint("<DataObject name=\"" + this.getName() + "\" type=\"CTypeObject\" size=\"" + this.size + "\" >");
            this.whatToDump(true);
            AllCtypes.this.indentAndPrint("</DataObject>\n");
        }

        private void whatToDump(boolean topLevel) {
            switch (this.baseType) {
                case 6: {
                    this.xmlDumpArray();
                    AllCtypes.this.seenItems.add(this);
                    break;
                }
                case 7: {
                    this.xmlDumpFunction();
                    AllCtypes.this.seenItems.add(this);
                    break;
                }
                case 5: {
                    this.xmlDumpReference();
                    AllCtypes.this.seenItems.add(this);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.name == null || this.name.length() == 0 || topLevel || this.name.equals("__unnamed")) {
                        this.xmlDumpFields();
                        AllCtypes.this.seenItems.add(this);
                        break;
                    }
                    AllCtypes.this.indentAndPrint("<" + this.getBaseTypeName(this.baseType) + " type=\"" + this.getName() + "\" />");
                    AllCtypes.this.fieldsToDump.addLast(this);
                    break;
                }
                case 4: {
                    this.xmlDumpEnum();
                    AllCtypes.this.seenItems.add(this);
                    break;
                }
                default: {
                    AllCtypes.this.indentAndPrint("<Primitive type=\"" + (this.baseType != 0 ? this.getBaseTypeName(this.baseType) : this.name) + "(" + this.baseType + ")" + "\" size=\"" + this.size + "\" />");
                    AllCtypes.this.seenItems.add(this);
                }
            }
        }

        private void xmlDumpFunction() {
        }

        private void xmlDumpEnum() {
            AllCtypes.this.indentAndPrint("<Enumeration size=\"" + this.size + "\">");
            Iterator iE = this.enumValues.iterator();
            while (iE.hasNext()) {
                ((EnumValue)iE.next()).xmlDump();
            }
            AllCtypes.this.indentAndPrint("</Enumeration>");
        }

        private void xmlDumpFields() {
            for (int i = 0; i < this.numFields; ++i) {
                String fieldName = this.fieldNames[i];
                FieldInfo fieldInfo = (FieldInfo)this.fields.get(fieldName);
                CType fieldType = fieldInfo.type;
                fieldType.dumpMember(fieldInfo);
            }
        }

        private void dumpMember(FieldInfo fieldInfo) {
            String memberPrefix = "<Member name=\"" + fieldInfo.name + "\" offset=\"" + fieldInfo.offset + "\" type=\"";
            switch (this.baseType) {
                case 6: {
                    memberPrefix = memberPrefix + "Array\" dimensions=\"1\" indexFirst=\"" + this.arrayInfo.start[0] + "\" indexLast=\"" + this.arrayInfo.end[0] + "\" " + "elementType=\"";
                    this.arrayInfo.type.dumpArrayElement(memberPrefix);
                    AllCtypes.this.seenItems.add(this);
                    break;
                }
                case 7: {
                    AllCtypes.this.indentAndPrint(memberPrefix + "Function\" size=\"" + this.size + "\" returnType=\"" + this.derefType.getName() + "\" />");
                    AllCtypes.this.fieldsToDump.add(this.derefType);
                    break;
                }
                case 5: {
                    boolean isFunction = false;
                    int indirectionCount = 0;
                    CType referencedType = this;
                    while (referencedType.derefType != null) {
                        AllCtypes.this.seenItems.add(referencedType);
                        referencedType = referencedType.derefType;
                        if (referencedType.baseType == 7) {
                            isFunction = true;
                        }
                        ++indirectionCount;
                    }
                    if (this.size == 0) {
                        this.size = 4;
                    }
                    if (isFunction) {
                        AllCtypes.this.indentAndPrint(memberPrefix + "FunctionPointer\" size=\"" + this.size + "\" returnType=\"" + referencedType.getName() + "\" />");
                    } else {
                        AllCtypes.this.indentAndPrint(memberPrefix + "ReferenceTo\" size=\"" + this.size + "\" indirectionCount=\"" + indirectionCount + "\" ReferencedType=\"" + referencedType.getName() + "\" />");
                    }
                    AllCtypes.this.fieldsToDump.add(referencedType);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.name == null || this.name.length() == 0 || this.name.equals("__unnamed")) {
                        this.name = "generatedTypeName_" + this.typeNum;
                    }
                    AllCtypes.this.indentAndPrint(memberPrefix + this.getName() + "\" size=\"" + this.size + "\" />");
                    AllCtypes.this.fieldsToDump.addLast(this);
                    break;
                }
                case 4: {
                    AllCtypes.this.indentAndPrint(memberPrefix + "uint\" size=\"" + this.size + "\" />");
                    AllCtypes.this.seenItems.add(this);
                    break;
                }
                default: {
                    CType base;
                    AllCtypes.this.indentAndPrint(memberPrefix + (this.baseType != 0 ? this.getBaseTypeName(this.baseType) : this.name) + "\" size=\"" + this.size + "\" />");
                    AllCtypes.this.seenItems.add(this);
                    if (this.baseType == 0 || (base = AllCtypes.this.find(this.baseType)) == null) break;
                    AllCtypes.this.seenItems.add(base);
                }
            }
        }

        private void dumpArrayElement(String memberPrefix) {
            switch (this.baseType) {
                case 6: {
                    if (this.name == null || this.name.length() == 0 || this.name.equals("__unnamed")) {
                        this.name = "null Name " + this.typeNum;
                    }
                    AllCtypes.this.indentAndPrint(memberPrefix + this.getName() + "\" size=\"" + this.size + "\" />");
                    AllCtypes.this.seenItems.add(this);
                    break;
                }
                case 7: {
                    AllCtypes.this.indentAndPrint(memberPrefix + "Function\" returnType=\"" + this.derefType.getName() + "\" />");
                    AllCtypes.this.fieldsToDump.add(this.derefType);
                    AllCtypes.this.seenItems.add(this);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.name != null && this.name.length() != 0 && !this.name.equals("__unnamed")) {
                        AllCtypes.this.indentAndPrint(memberPrefix + this.getBaseTypeName(this.baseType) + "\" " + this.getBaseTypeName(this.baseType) + "Type=\"" + this.getName() + "\" " + "size=\"" + this.size + "\" />");
                        AllCtypes.this.fieldsToDump.add(this);
                        break;
                    }
                    AllCtypes.this.indentAndPrint(memberPrefix + this.getBaseTypeName(this.baseType) + "\" >");
                    this.xmlDumpDataObject();
                    AllCtypes.this.indentAndPrint("</Member>");
                    break;
                }
                case 5: {
                    int indirectionCount = 0;
                    CType referencedType = this;
                    while (referencedType.derefType != null) {
                        AllCtypes.this.seenItems.add(referencedType);
                        referencedType = referencedType.derefType;
                        ++indirectionCount;
                    }
                    AllCtypes.this.indentAndPrint(memberPrefix + "ReferenceTo\" size=\"" + this.size + "\" indirectionCount=\"" + indirectionCount + "\" ReferencedType=\"" + referencedType.getName() + "\" />");
                    AllCtypes.this.fieldsToDump.add(referencedType);
                    AllCtypes.this.seenItems.add(this);
                    break;
                }
                default: {
                    CType base;
                    AllCtypes.this.indentAndPrint(memberPrefix + (this.baseType != 0 ? this.getBaseTypeName(this.baseType) : this.name) + "\" size=\"" + this.size + "\" />");
                    AllCtypes.this.seenItems.add(this);
                    if (this.baseType == 0 || (base = AllCtypes.this.find(this.baseType)) == null) break;
                    AllCtypes.this.seenItems.add(base);
                }
            }
        }

        private void xmlDumpReference() {
            int indirectionCount = 0;
            CType referencedType = this;
            while (referencedType.derefType != null) {
                referencedType = referencedType.derefType;
                ++indirectionCount;
            }
            AllCtypes.this.indentAndPrint("<ReferenceTo indirectionCount=\"" + indirectionCount + "\">");
            referencedType.whatToDump(false);
            AllCtypes.this.indentAndPrint("</ReferenceTo>");
        }

        private void xmlDumpArray() {
            AllCtypes.this.indentAndPrint("<Array dimensions=\"1\" indexFirst=\"" + this.arrayInfo.start[0] + "\" indexLast=\"" + this.arrayInfo.end[0] + "\" >");
            if (AllCtypes.this.seenItems.contains(this.arrayInfo.type)) {
                AllCtypes.this.indentAndPrint("<ArrayElement type=\"" + this.arrayInfo.type.name + "\" />");
            } else {
                this.arrayInfo.type.xmlDumpDataObject();
            }
            AllCtypes.this.indentAndPrint("</Array>");
        }

        private void xmlDumpEmbedded(String fieldName) {
            AllCtypes.this.indentAndPrint("<DataObject name=\"" + fieldName + "\" type=\"CTypeObject\">");
            this.whatToDump(false);
            AllCtypes.this.indentAndPrint("</DataObject>");
        }

        private void dumpReferees() {
            ArrayList<String> allRefs = new ArrayList<String>(this.referees.size());
            Iterator iT = this.referees.iterator();
            while (iT.hasNext()) {
                FieldInfo ref = (FieldInfo)iT.next();
                String fieldName = ref.name;
                ArrayList allParents = new ArrayList();
                this.getParentNames(ref, allParents, "");
                Iterator iP = allParents.iterator();
                while (iP.hasNext()) {
                    allRefs.add((String)iP.next() + fieldName);
                }
            }
            Object[] refsArray = allRefs.toArray();
            Arrays.sort(refsArray, new CaseIndependentStringComparator());
            Iterator<Object> iR = Arrays.asList(refsArray).iterator();
            while (iR.hasNext()) {
                AllCtypes.this.indentAndPrint("<Reference ref=\"" + (String)iR.next() + "\" />");
            }
        }
    }
}

