/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.nativeXML;

import com.ibm.dtfj.image.sov.ImageFactory;
import com.ibm.dtfj.sov.image.ImageProxy;
import com.ibm.dtfj.sov.image.UnsupportedFormatException;
import com.ibm.dtfj.sov.imp.ImageEffigy;
import com.ibm.dtfj.sov.nativeXML.AllCtypes;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Generator {
    private static boolean debug = false;

    private Generator() {
    }

    private static String getString(byte[] strings, int offset, String encoding) {
        int len = 0;
        int i = offset;
        while (strings[i] != 0) {
            ++i;
            ++len;
        }
        if (len == 0) {
            return null;
        }
        if (strings[offset + len - 1] == 59) {
            --len;
        }
        try {
            String str = new String(strings, offset, len, encoding);
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] arg) throws UnsupportedFormatException {
        String fileName = arg[0];
        if (arg.length > 1 && arg[1].equals("-debug")) {
            System.err.println("Generator.main(): setting debug to true");
            debug = true;
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(System.out);
            if (fileName.endsWith(".sdff")) {
                ImageFactory imageFactory = new ImageFactory();
                ImageProxy theImage = ((ImageEffigy)imageFactory.getImage(new File(fileName))).getProxy();
                fileName = Generator.extractFromDump(theImage, writer);
            } else {
                Generator.processTypes(fileName, writer);
            }
        }
        catch (IOException e) {
            System.err.println("Error processing .sdff");
            e.printStackTrace();
        }
    }

    public static String extractFromDump(ImageProxy theImage, Writer xmlStream) {
        block5: {
            byte[] types = theImage.getCTypedefs();
            if (types == null) {
                return null;
            }
            File tmpFile = null;
            try {
                ZipEntry zipEntry;
                ByteArrayInputStream b = new ByteArrayInputStream(types);
                tmpFile = File.createTempFile("tmp", ".types");
                FileOutputStream out = new FileOutputStream(tmpFile);
                ZipInputStream zip = new ZipInputStream(b);
                while ((zipEntry = zip.getNextEntry()) != null) {
                    int len;
                    if (!zipEntry.getName().startsWith("jvmdcf")) continue;
                    byte[] tmp = new byte[1024];
                    while ((len = zip.read(tmp, 0, 1024)) != -1) {
                        out.write(tmp, 0, len);
                    }
                }
                out.close();
                Generator.processTypes(tmpFile.getPath(), xmlStream);
                tmpFile.delete();
            }
            catch (IOException e) {
                System.err.println("Could not read typedefs :" + e);
                if (tmpFile == null) break block5;
                tmpFile.delete();
            }
        }
        return null;
    }

    public static void processTypes(String fileName, Writer xmlStream) {
        byte[] magic = new byte[8];
        AllCtypes myCtypes = new AllCtypes();
        try {
            RandomAccessFile in = new RandomAccessFile(fileName, "r");
            in.read(magic, 0, 8);
            in.readInt();
            int enc = in.readInt();
            String encoding = enc == 1 ? "Cp037" : "ascii";
            String magicStr = new String(magic, 0, 7, encoding);
            if (!magicStr.equals("JVMSYMS")) {
                System.err.println("Unrecognized symbol file " + fileName);
                return;
            }
            int numSyms = in.readInt();
            in.readInt();
            in.readInt();
            int strOffset = in.readInt();
            int strSize = in.readInt();
            long cur = in.getFilePointer();
            in.seek(strOffset);
            byte[] strings = new byte[strSize];
            in.read(strings, 0, strSize);
            in.seek(cur);
            for (int i = 0; i < numSyms; ++i) {
                String description;
                int typeNum = in.readInt();
                int baseType = in.readInt();
                int size = in.readInt();
                int nameOffset = in.readInt();
                int descriptionOffset = in.readInt();
                if (descriptionOffset == 0) {
                    if (typeNum >= 0) continue;
                    description = "";
                } else {
                    description = Generator.getString(strings, descriptionOffset, encoding);
                }
                String name = Generator.getString(strings, nameOffset, encoding);
                if (nameOffset == 0) {
                    name = "";
                }
                myCtypes.create(typeNum, baseType, size, name, description);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (debug) {
            myCtypes.dumpAllTypes(xmlStream);
        }
        myCtypes.postProcess();
        myCtypes.dumpAllTypesAsXML(xmlStream);
    }
}

