/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.sdffReader;

import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.data.DataObjectDescriptor;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.image.ImageProcessProxy;
import com.ibm.dtfj.sov.image.ImageSectionImpl;
import com.ibm.dtfj.sov.image.WordLength;
import com.ibm.dtfj.sov.image.WordType;
import com.ibm.dtfj.sov.imp.ImagePointerEffigy;
import com.ibm.dtfj.sov.imp.ImageProcessEffigy;
import com.ibm.dtfj.sov.java.JavaRuntimeProxy;
import com.ibm.dtfj.sov.java.Ras;
import com.ibm.dtfj.sov.sdffReader.SDFFDump;
import com.ibm.dtfj.sov.sdffReader.SDFFProcess;
import com.ibm.dtfj.sov.sdffReader.SdffConstants;
import com.ibm.dtfj.sov.sdffReader.SdffStd;
import com.ibm.dtfj.sov.utils.DumpReader;
import com.ibm.dtfj.sov.utils.ErrorLog;
import com.ibm.dtfj.sov.utils.Mapper;
import com.ibm.dtfj.sov.utils.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Vector;

public class SDFFAddressSpace
implements AddressSpaceProxy,
Mapper {
    private SDFFDump image;
    private int currentProcessIndex;
    private String platformName;
    MemRange[] memRanges;
    private RandomAccessFile sdffFile;
    private RandomAccessFile memoryFile;
    DumpReader dumpReader;
    private JavaRuntimeProxy jvmProxy;
    private Vector processes = new Vector();
    private long id;
    private int arrayPosition;
    private static final int MEMRANGE_SIZE = 64;
    private Vector imageSections = null;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id " + this.id + "\n");
        sb.append("There are " + this.memRanges.length + " Memory Ranges\n");
        for (int i = 0; i < this.memRanges.length; ++i) {
            sb.append("Memory Range " + i + "\n");
            sb.append("======================\n");
            sb.append(this.memRanges[i].toString());
        }
        sb.append("There are " + this.processes.size() + " Processes \n");
        Iterator processIterator = this.processes.iterator();
        while (processIterator.hasNext()) {
            sb.append("Next Process\n============\n");
            sb.append(((SDFFProcess)processIterator.next()).toString());
        }
        return sb.toString();
    }

    private void getMemRanges(RandomAccessFile raf, long offset, long length) {
        int i;
        Vector<MemRange> myMemRanges = new Vector<MemRange>();
        int count = 0;
        Trace.writeToTrace("Entry getMemRanges - offset = " + offset + "  length= " + length);
        long work_offset = offset + length - 8L;
        boolean metaDataPresent = true;
        try {
            raf.seek(work_offset);
            work_offset = raf.readLong();
            if (0L >= work_offset) {
                metaDataPresent = false;
            } else {
                byte[] bytes = new byte[8];
                raf.seek(work_offset);
                raf.read(bytes, 0, 8);
                String eye = new String(bytes, "ASCII");
                if (!eye.equals(SdffConstants.SEGMENT_Eye_SdffMeta)) {
                    Trace.writeToTrace("getMemRanges : invalid METADATA Eyecatcher");
                }
                metaDataPresent = true;
            }
        }
        catch (IOException ioe) {
            System.out.println("!!!!! IOEXception out of getMemRanges");
            metaDataPresent = false;
        }
        if (metaDataPresent) {
            count = (int)(length - 64L);
            count -= (int)(offset + length - work_offset);
        } else {
            count = (int)(length - 8L);
        }
        count /= 64;
        long offset_in_file = offset + SdffStd.getSize();
        MemRange currentMemRange = null;
        Trace.writeToTrace("MEMRANGES START");
        for (i = 0; i < count; ++i) {
            try {
                raf.seek(offset_in_file);
                long as_id = raf.readLong();
                raf.readLong();
                long start_address = raf.readLong();
                long memory_length = raf.readLong();
                long memOffset = raf.readLong();
                Trace.writeToTrace("--Got start 0x" + Long.toHexString(start_address) + " length 0x" + Long.toHexString(memory_length) + " offset 0x" + Long.toHexString(memOffset) + " as_id " + as_id + " arrayPosition " + this.arrayPosition);
                if (as_id == (long)this.arrayPosition) {
                    if (currentMemRange != null) {
                        if (currentMemRange.mergeRanges(start_address, memory_length, memOffset)) {
                            Trace.writeToTrace("--Merged " + currentMemRange);
                        } else {
                            myMemRanges.add(currentMemRange);
                            Trace.writeToTrace("--Added " + currentMemRange);
                            currentMemRange = new MemRange(start_address, memory_length, memOffset);
                            Trace.writeToTrace("--Created " + currentMemRange);
                        }
                    } else {
                        currentMemRange = new MemRange(start_address, memory_length, memOffset);
                        Trace.writeToTrace("--Created " + currentMemRange);
                    }
                } else {
                    Trace.writeToTrace("--Ignoring");
                }
            }
            catch (IOException e) {
                Trace.writeToTrace(e.toString());
                Thread.dumpStack();
            }
            offset_in_file += 64L;
        }
        if (currentMemRange != null) {
            myMemRanges.add(currentMemRange);
            Trace.writeToTrace("--Added " + currentMemRange);
        }
        this.memRanges = new MemRange[myMemRanges.size()];
        i = 0;
        Iterator memRangeIterator = myMemRanges.iterator();
        while (memRangeIterator.hasNext()) {
            this.memRanges[i++] = (MemRange)memRangeIterator.next();
        }
        Trace.writeToTrace("MEMRANGES END");
    }

    public long getOffset(long address) throws IOException {
        for (int i = 0; i < this.memRanges.length; ++i) {
            long offset = this.memRanges[i].addrToOffset(address);
            if (offset == -1L) continue;
            return offset;
        }
        return -1L;
    }

    public long getAddress(long offset) throws IOException {
        for (int i = 0; i < this.memRanges.length; ++i) {
            long address = this.memRanges[i].offsetToAddr(offset);
            if (address == -1L) continue;
            return address;
        }
        return -1L;
    }

    public SDFFAddressSpace(SDFFDump theDump, long mmo, long mml, RandomAccessFile sdffRaf, RandomAccessFile memoryRaf, int position) {
        this.image = theDump;
        this.arrayPosition = position;
        this.memoryFile = memoryRaf;
        this.sdffFile = sdffRaf;
        this.platformName = theDump.getSystemType().toLowerCase();
        if (memoryRaf == null) {
            throw new RuntimeException("No memory file");
        }
        this.dumpReader = new DumpReader(this.memoryFile, theDump.getWordType(), theDump.getWordLength(), this);
        boolean format_problem_found = false;
        try {
            this.id = sdffRaf.readLong();
            Trace.writeToTrace("ADDRSPC id is: " + this.id);
            long prCount = sdffRaf.readLong();
            long temp_pos = sdffRaf.getFilePointer();
            sdffRaf.readLong();
            if (sdffRaf.readByte() != 80) {
                sdffRaf.seek(temp_pos);
                this.currentProcessIndex = sdffRaf.readInt();
                Trace.writeToTrace("There appear to be " + prCount + " processes and current process index is " + this.currentProcessIndex);
                byte[] ba = new byte[60];
                sdffRaf.read(ba);
            } else {
                Trace.writeToTrace("There appear to be " + prCount + " processes ");
                sdffRaf.seek(temp_pos);
            }
            long prOffset_in_file = sdffRaf.getFilePointer();
            format_problem_found = this.loadProcesses(prOffset_in_file, sdffRaf, prCount);
            if (format_problem_found) {
                Trace.writeToTrace("First pass at loadProcesses failed ... retry using different format ");
                format_problem_found = this.loadProcesses(prOffset_in_file + 64L, sdffRaf, prCount);
                if (format_problem_found) {
                    ErrorLog.output("PROCESSS eyecatcher invalid\nFurther failures expected");
                }
            }
        }
        catch (IOException e) {
            ErrorLog.output("IOException " + e);
            Thread.dumpStack();
        }
        this.getMemRanges(this.sdffFile, mmo, mml);
    }

    public static int countThem(long o, RandomAccessFile raf) {
        byte[] asEyeCatcher = new byte[8];
        int count = 0;
        long asOffset_in_file = o + SdffStd.getSize();
        try {
            raf.seek(asOffset_in_file);
            count = (int)raf.readLong();
            raf.readLong();
            raf.readFully(asEyeCatcher);
            String y = new String(asEyeCatcher);
            if (!y.equals(SdffConstants.SEGMENT_Eye_SdffAs)) {
                ErrorLog.output("ADDRSPC eyecatcher invalid");
                count = 0;
            }
        }
        catch (IOException e) {
            System.out.println("\nIOException caught in SDFFAddressSpace:countThem");
            count = 0;
        }
        return count;
    }

    public Iterator getProcesses() {
        return this.processes.iterator();
    }

    public String id() {
        return Long.toString(this.id);
    }

    private ImagePointer getImagePointer(long address) {
        ImagePointerEffigy myPointer = (ImagePointerEffigy)Effigy.create("ImagePointerEffigy", this.getPointer(address), (AddressSpaceProxy)this, this.getPlatformName());
        return myPointer;
    }

    public byte[] readBytes(long address, long len) throws MemoryAccessException {
        try {
            return this.dumpReader.readBytes(address, len);
        }
        catch (IOException e) {
            throw new MemoryAccessException(this.getImagePointer(address), "IOException " + e + ", could not read address 0x" + Long.toHexString(address));
        }
    }

    public long readByte(long address) throws MemoryAccessException {
        try {
            return this.dumpReader.readByte(address);
        }
        catch (IOException e) {
            throw new MemoryAccessException(this.getImagePointer(address), "IOException " + e + ", could not read address 0x" + Long.toHexString(address));
        }
    }

    public long readInt(long address) throws MemoryAccessException {
        try {
            return this.dumpReader.readInt(address);
        }
        catch (IOException e) {
            throw new MemoryAccessException(this.getImagePointer(address), "IOException " + e + ", could not read address 0x" + Long.toHexString(address));
        }
    }

    public long readLong(long address) throws MemoryAccessException {
        try {
            return this.dumpReader.readLong(address);
        }
        catch (IOException e) {
            throw new MemoryAccessException(this.getImagePointer(address), "IOException " + e + ", could not read address 0x" + Long.toHexString(address));
        }
    }

    public long readShort(long address) throws MemoryAccessException {
        try {
            return this.dumpReader.Short(address);
        }
        catch (IOException e) {
            throw new MemoryAccessException(this.getImagePointer(address), "IOException " + e + ", could not read address 0x" + Long.toHexString(address));
        }
    }

    public long readPointer(long address) throws MemoryAccessException {
        try {
            return this.dumpReader.readPointer(address);
        }
        catch (IOException e) {
            throw new MemoryAccessException(this.getImagePointer(address), "IOException " + e + ", could not read address 0x" + Long.toHexString(address));
        }
    }

    public String readString(long address) throws MemoryAccessException {
        try {
            return this.dumpReader.readString(address);
        }
        catch (IOException e) {
            throw new MemoryAccessException(this.getImagePointer(address), "IOException " + e + ", could not read address 0x" + Long.toHexString(address));
        }
    }

    public char[] readCharArray(long address) throws MemoryAccessException {
        try {
            return this.dumpReader.readCharArray(address);
        }
        catch (IOException e) {
            throw new MemoryAccessException(this.getImagePointer(address), "IOException " + e + ", could not read address 0x" + Long.toHexString(address));
        }
    }

    public ImageProcess getCurrentProcess() {
        return (ImageProcess)this.processes.get(this.currentProcessIndex);
    }

    public ImageProcessProxy getCurrentProcessProxy() {
        return ((ImageProcessEffigy)this.processes.get(this.currentProcessIndex)).getProxy();
    }

    private boolean loadProcesses(long start, RandomAccessFile raf, long prCount) {
        boolean format_problem_found = false;
        long prOffset_in_file = start;
        byte[] prEyeCatcher = new byte[8];
        try {
            raf.seek(prOffset_in_file);
            int j = 0;
            while ((long)j < prCount) {
                Trace.writeToTrace("Checking PROCESS with index " + j);
                this.processes.clear();
                long prLength = raf.readLong();
                Trace.writeToTrace("Process length is " + prLength);
                Trace.writeToTrace("Checking PROCESS eyecatcher @ offset " + raf.getFilePointer());
                raf.readFully(prEyeCatcher);
                String y = new String(prEyeCatcher);
                if (y.equals(SdffConstants.SEGMENT_Eye_SdffProc)) {
                    Trace.writeToTrace("PROCESS eyecatcher is valid");
                } else {
                    format_problem_found = true;
                    j = (int)prCount;
                }
                if (!format_problem_found) {
                    ImageProcessEffigy myProcess = (ImageProcessEffigy)Effigy.create("ImageProcessEffigy", new SDFFProcess(prOffset_in_file, prLength, raf, this, this.image), (AddressSpaceProxy)this, this.getPlatformName());
                    this.processes.add(myProcess);
                    prOffset_in_file += prLength;
                }
                ++j;
            }
        }
        catch (IOException e) {
            System.err.println("\nIOException caught in SDFFAddressSpace:loadProcesses");
            format_problem_found = true;
        }
        return format_problem_found;
    }

    public byte[] getMetaData() {
        return null;
    }

    public Ras getRas() {
        return this.image.getRas();
    }

    public WordLength getWordLength() {
        return this.image.getWordLength();
    }

    public void setJavaRuntimeProxy(JavaRuntimeProxy jvmProxy) {
        this.jvmProxy = jvmProxy;
    }

    public JavaRuntimeProxy getJavaRuntimeProxy() {
        return this.jvmProxy;
    }

    public WordType getWordType() {
        return this.image.getWordType();
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public ImagePointerProxy getPointer(long address) {
        return new ImagePointerProxy(address, this);
    }

    public DataObjectDescriptor getDescriptor(String name) {
        return this.image.getDescriptor(name);
    }

    public Iterator getImageSections() {
        if (this.imageSections == null) {
            this.imageSections = new Vector(this.memRanges.length);
            for (int i = 0; i < this.memRanges.length; ++i) {
                this.imageSections.add(new ImageSectionImpl((ImagePointer)((Object)Effigy.create("ImagePointerEffigy", new ImagePointerProxy(this.memRanges[i].start_address, this), (AddressSpaceProxy)this, this.getPlatformName())), this.memRanges[i].memory_length, "Memory Range " + i, false, false, false, false));
            }
        }
        return this.imageSections.iterator();
    }

    public AddressSpaceProxy getCopy() {
        try {
            return (AddressSpaceProxy)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("SDFFAddressSpace.getCopy() couldn't clone oneself.");
            e.printStackTrace();
            return null;
        }
    }

    private class MemRange {
        long start_address;
        long memory_length;
        long end_address;
        long offset;
        long end_offset;

        MemRange(long start_address, long memory_length, long offset) {
            this.start_address = start_address;
            this.memory_length = memory_length;
            this.end_address = start_address + memory_length - 1L;
            this.offset = offset;
            this.end_offset = offset + memory_length - 1L;
        }

        boolean mergeRanges(long start_address, long memory_length, long offset) {
            if (start_address >= this.start_address && start_address <= this.end_address + 1L) {
                if (start_address + memory_length - 1L <= this.end_address) {
                    return true;
                }
                long start_difference = start_address - this.start_address;
                if (offset == this.offset + start_difference) {
                    this.end_address = start_address + memory_length - 1L;
                    this.memory_length = this.end_address - this.start_address + 1L;
                    return true;
                }
            }
            return false;
        }

        long addrToOffset(long addr) {
            if (addr >= this.start_address && addr <= this.end_address) {
                return this.offset + (addr - this.start_address);
            }
            return -1L;
        }

        long offsetToAddr(long offset) {
            if (offset >= this.offset && offset <= this.end_offset) {
                return this.start_address + (offset - this.offset);
            }
            return -1L;
        }

        public String toString() {
            return "Start Address 0x" + Long.toHexString(this.start_address) + " length " + this.memory_length + " end Address 0x" + Long.toHexString(this.end_address) + " offset " + this.offset + "\n";
        }
    }
}

