/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.sdffReader;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.data.DataLocator;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.BigEnd;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.ImageProxy;
import com.ibm.dtfj.sov.image.ImageProxyImpl;
import com.ibm.dtfj.sov.image.LittleEnd;
import com.ibm.dtfj.sov.image.UnsupportedFormatException;
import com.ibm.dtfj.sov.image.WordLength;
import com.ibm.dtfj.sov.image.WordType;
import com.ibm.dtfj.sov.java.ProxyFactory;
import com.ibm.dtfj.sov.java.Ras;
import com.ibm.dtfj.sov.sdffReader.SDFFAddressSpace;
import com.ibm.dtfj.sov.sdffReader.SDFFRas;
import com.ibm.dtfj.sov.sdffReader.SdffArchiveInputStream;
import com.ibm.dtfj.sov.sdffReader.SdffConstants;
import com.ibm.dtfj.sov.sdffReader.SdffStd;
import com.ibm.dtfj.sov.utils.ErrorLog;
import com.ibm.dtfj.sov.utils.Trace;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Vector;

public class SDFFDump
extends ImageProxyImpl
implements ImageProxy {
    private RandomAccessFile sdffRaf;
    private RandomAccessFile dumpRaf;
    private long prthOffset = -1L;
    private long prthLength = -1L;
    private long mmapOffset = -1L;
    private long mmapLength = -1L;
    private long memOffset = -1L;
    private long memLength = -1L;
    private long rasOffset = -1L;
    private long rasLength = -1L;
    private long sizeOfFile = -1L;
    private String nameOfFile;
    Vector addressSpaces;
    SDFFRas ras;
    private WordType wordType;
    private WordLength wordLength;
    private int system = -1;
    private int architecture = -1;
    private int subsystem = -1;
    private int processor = -1;
    private int processorSubtype = -1;
    private int numProcessors = -1;
    private int currentProcessor = -1;
    private long provider = -1L;
    private int processorSubType;
    private int currentAsIndex;
    private boolean oldFormat;
    private int dumpFormatVersion;
    private long dumpTimeStamp = -1L;

    public SDFFDump(File sourceFile) throws UnsupportedFormatException, CorruptDataException {
        if (!this.isSupportedSource(sourceFile)) {
            throw new UnsupportedFormatException(sourceFile.getName() + " cannot be processed as an SDFF-format dump");
        }
        ProxyFactory.setImageType(this.getImageType());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Dump file:" + this.nameOfFile + " has " + this.addressSpaces.size() + " Address Spaces\n");
        sb.append("Architecture of dumping system :\n");
        sb.append("\t" + this.getProcessorType() + "(" + this.getProcessorSubType() + ")\n");
        sb.append("\t" + this.getSystemType() + "(" + this.getSystemSubType() + ")\n");
        sb.append(this.ras.toString());
        Iterator spacesIt = this.addressSpaces.iterator();
        int i = 0;
        while (spacesIt.hasNext()) {
            sb.append("Address Space : " + i + "\n");
            sb.append("======================\n");
            sb.append(spacesIt.next().toString());
            ++i;
        }
        return sb.toString();
    }

    public Iterator getAddressSpaces() {
        return this.addressSpaces.iterator();
    }

    public String getSystemType() {
        if (this.system >= 0 && this.system < ImageProxy.SYSTEM_DESCRIPTION.length) {
            return ImageProxy.SYSTEM_DESCRIPTION[this.system];
        }
        return "UNKNOWN SYSTEM TYPE (" + this.system + ")";
    }

    public String getSystemSubType() {
        if (this.subsystem >= 0 && this.subsystem < ImageProxy.SUBSYSTEM_DESCRIPTION.length) {
            return ImageProxy.SUBSYSTEM_DESCRIPTION[this.subsystem];
        }
        return "UNKNOWN SUBSYSTEM TYPE (" + this.subsystem + ")";
    }

    public String getProcessorType() {
        if (this.processor >= 0 && this.processor < ImageProxy.PROCESSOR_DESCRIPTION.length) {
            return ImageProxy.PROCESSOR_DESCRIPTION[this.processor];
        }
        return "UNKNOWN PROCESSOR TYPE (" + this.processor + ")";
    }

    protected int getProcessor() {
        return this.processor;
    }

    public long getProvider() {
        return this.provider;
    }

    public int getImageType() {
        if (-1L == this.provider) {
            return 1;
        }
        if (0x7F7F7F7F7F7F7F7FL == this.provider) {
            return 1;
        }
        if (0L == this.provider || -4294967296L == this.provider) {
            return 1;
        }
        if (1L == this.provider) {
            return 2;
        }
        return -1;
    }

    public boolean isSupportedSource(File theSource) throws CorruptDataException {
        Trace.writeToTrace("Entry to SDFFDump:isSupportedSource(" + theSource + ")");
        if (SDFFDump.looksLikeAJarFile(theSource)) {
            SdffArchiveInputStream nis;
            this.oldFormat = false;
            Trace.writeToTrace("SDFFDump:isSupportedSource opening NewSDFFInputStream(" + theSource + ")");
            try {
                nis = new SdffArchiveInputStream(theSource);
            }
            catch (IOException e) {
                Trace.writeToTrace("SDFFDump:isSupportedSource Exception " + e + " opening NewSDFFInputStream(" + theSource + ")");
                return false;
            }
            String sdffHeader = nis.getExtractSdffHeaderName();
            String originalDump = nis.getExtractOriginalDumpName();
            this.dumpFormatVersion = nis.getNewSdffFormatVersion();
            this.dumpTimeStamp = nis.getDumpTimestamp();
            try {
                nis.extractHeader(true, null, null, null);
            }
            catch (IOException e) {
                Trace.writeToTrace("SDFFDump:isSupportedSource Exception " + e + " extracting from NewSDFFInputStream(" + theSource + ")");
                return false;
            }
            try {
                this.dumpRaf = new RandomAccessFile(originalDump, "r");
            }
            catch (FileNotFoundException e) {
                Trace.writeToTrace("SDFFDump:isSupportedSource Exception " + e + " opening NewSDFFInputStream(" + theSource + ") original dump (" + originalDump + ")");
                return false;
            }
            if (this.isValidSdffHeader(new File(sdffHeader), false)) {
                Trace.writeToTrace("Exit from SDFFDump:isSupportedSource(true - jar)");
                return true;
            }
            Trace.writeToTrace("Exit from SDFFDump:isSupportedSource(false - jar)");
            return false;
        }
        this.oldFormat = true;
        if (this.isValidSdffHeader(theSource, true)) {
            Trace.writeToTrace("Exit from SDFFDump:isSupportedSource(true - flat file)");
            return true;
        }
        Trace.writeToTrace("Exit from SDFFDump:isSupportedSource(false - flat file)");
        return false;
    }

    private static boolean looksLikeAJarFile(File theSource) {
        try {
            Trace.writeToTrace("SDFFDump:looksLikeAJarFile - opening DataInputStream for (" + theSource + ")");
            DataInputStream dis = new DataInputStream(new FileInputStream(theSource));
            Trace.writeToTrace("SDFFDump:looksLikeAJarFile reading 2 bytes from (" + theSource + ")");
            byte byte1 = dis.readByte();
            byte byte2 = dis.readByte();
            dis.close();
            if (byte1 == 80 && byte2 == 75) {
                return true;
            }
        }
        catch (IOException e) {
            Trace.writeToTrace("SDFFDump:looksLikeAJarFile IOException " + e + " accessing (" + theSource + ")");
            return false;
        }
        return false;
    }

    private boolean isValidSdffHeader(File file, boolean oldFormat) throws CorruptDataException {
        SdffStd sdffstd;
        Trace.writeToTrace("Entry to SDFFDump:isValidSdffHeader(" + file.getName() + ")");
        try {
            this.sdffRaf = new RandomAccessFile(file, "r");
            if (oldFormat) {
                this.dumpRaf = this.sdffRaf;
            }
            byte[] bytes = new byte[32];
            this.sdffRaf.read(bytes, 0, 32);
            sdffstd = new SdffStd(bytes);
            String y = new String(sdffstd.sectionEye);
            if (!y.equals(SdffConstants.SEGMENT_Eye_SdffHead)) {
                Trace.writeToTrace("  SDFFHEAD eyecatcher not detected");
                Trace.writeToTrace("Exit from SDFFDump:isValidSdffHeader(false)");
                return false;
            }
            Trace.writeToTrace("  SDFFHEAD eyecatcher detected - its an SDFF dump");
            this.sdffRaf.seek(32L);
            this.system = this.sdffRaf.readInt();
            if (this.system == 100) {
                this.system = 2;
            }
            this.architecture = this.sdffRaf.readInt();
            if ((this.architecture & 1) == 1) {
                this.wordLength = new WordLength(32);
            } else if ((this.architecture & 2) == 2) {
                this.wordLength = new WordLength(64);
            } else {
                throw new CorruptDataException(new CorruptDataImpl("Can't open dump - word size is undefined"));
            }
            if ((this.architecture & 8) == 8) {
                this.wordType = new LittleEnd();
            } else if ((this.architecture & 4) == 4) {
                this.wordType = new BigEnd();
            } else {
                throw new CorruptDataException(new CorruptDataImpl("Can't open dump - endianness is undefined"));
            }
            this.subsystem = this.sdffRaf.readInt();
            this.processor = this.sdffRaf.readInt();
            this.processorSubType = this.sdffRaf.readInt();
            this.numProcessors = this.sdffRaf.readInt();
            this.currentProcessor = this.sdffRaf.readInt();
            this.currentAsIndex = this.sdffRaf.readInt();
            this.provider = sdffstd.sectionLen < 60L ? 0L : this.sdffRaf.readLong();
            if (!sdffstd.checkMatch()) {
                ErrorLog.output("Looks like SDFF format Error");
                Trace.writeToTrace("Exit from SDFFDump:isValidSdffHeader(false)");
                return false;
            }
        }
        catch (IOException e) {
            Trace.writeToTrace("Exit from SDFFDump:isValidSdffHeader(false)");
            return false;
        }
        Trace.writeToTrace("Dump recognised as " + (oldFormat ? "an old " : "a new ") + "format " + "SDFF dump");
        this.sizeOfFile = file.length();
        this.nameOfFile = file.getName();
        boolean done = false;
        long ongoing_offset = sdffstd.sectionLen;
        while (!done) {
            try {
                this.sdffRaf.seek(ongoing_offset);
                byte[] bytes = new byte[32];
                this.sdffRaf.read(bytes, 0, 32);
                sdffstd = new SdffStd(bytes);
                if (!sdffstd.checkMatch()) {
                    done = true;
                    continue;
                }
                if (sdffstd.sectionType == (long)SdffConstants.SEGMENT_SdffHead) {
                    ErrorLog.output("Two Sdffheads - not nice");
                    done = true;
                } else if (sdffstd.sectionType == (long)SdffConstants.SEGMENT_SdffRas) {
                    if (this.rasOffset == -1L) {
                        this.rasOffset = ongoing_offset;
                        this.rasLength = sdffstd.sectionLen;
                    } else {
                        ErrorLog.output("Two SdffRas sections - not nice");
                        done = true;
                    }
                } else if (sdffstd.sectionType == (long)SdffConstants.SEGMENT_Sdffprth) {
                    if (this.prthOffset == -1L) {
                        this.prthOffset = ongoing_offset;
                        this.prthLength = sdffstd.sectionLen;
                    } else {
                        ErrorLog.output("Two Sdffprths - not nice");
                        done = true;
                    }
                } else if (sdffstd.sectionType == (long)SdffConstants.SEGMENT_Sdffmmap) {
                    if (this.mmapOffset == -1L) {
                        this.mmapOffset = ongoing_offset;
                        this.mmapLength = sdffstd.sectionLen;
                    } else {
                        ErrorLog.output("Two Sdffmmaps - not nice");
                        done = true;
                    }
                } else if (sdffstd.sectionType == (long)SdffConstants.SEGMENT_Sdffmem) {
                    if (this.memOffset == -1L) {
                        this.memOffset = ongoing_offset;
                        this.memLength = sdffstd.sectionLen;
                    } else {
                        ErrorLog.output("Two Sdffmems - not nice");
                        done = true;
                    }
                }
                ongoing_offset += sdffstd.sectionLen;
            }
            catch (IOException e) {
                done = true;
            }
        }
        String spaceFailure = "\n ... Possibe cause: lack of space during SDFF file creation.";
        if (-1L == this.prthOffset) {
            Trace.writeToTrace("\n*** Error in dump format\nPrth offset/length is " + this.prthOffset + ":" + this.prthLength + spaceFailure);
        }
        if (-1L == this.mmapOffset) {
            Trace.writeToTrace("\n*** Error in dump format\nMmap offset/length is " + this.mmapOffset + ":" + this.mmapLength + spaceFailure);
        }
        if (oldFormat && -1L == this.memOffset) {
            Trace.writeToTrace("\n*** Error in dump format\nMem  offset/length is " + this.memOffset + ":" + this.memLength + spaceFailure);
        }
        if (-1L == this.rasOffset) {
            Trace.writeToTrace("\n*** Error in dump format\nRas  offset/length is " + this.rasOffset + ":" + this.rasLength + spaceFailure);
        }
        try {
            this.ras = new SDFFRas(this.rasOffset, this.sdffRaf);
        }
        catch (IOException e1) {
            CorruptDataException cde = new CorruptDataException(new CorruptDataImpl("IOException in SDFFRas. " + e1));
            cde.initCause(e1);
            throw cde;
        }
        this.loadAddressSpaces();
        Trace.writeToTrace("Exit from SDFFDump:isValidSdffHeader(true)");
        return true;
    }

    private void loadAddressSpaces() {
        long asOffset_in_file = this.prthOffset + SdffStd.getSize();
        byte[] asEyeCatcher = new byte[8];
        try {
            this.sdffRaf.seek(asOffset_in_file);
            long asCount = this.sdffRaf.readLong();
            Trace.writeToTrace("Count of address spaces is: " + asCount);
            this.addressSpaces = new Vector((int)asCount);
            long this_as = this.sdffRaf.getFilePointer();
            int i = 0;
            while ((long)i < asCount) {
                this.sdffRaf.seek(this_as);
                long asLength = this.sdffRaf.readLong();
                Trace.writeToTrace("Length of address space (index " + i + ") is: " + asLength);
                Trace.writeToTrace("Checking ADDRSPC eyecatcher @ offset " + this.sdffRaf.getFilePointer());
                this.sdffRaf.readFully(asEyeCatcher);
                String y = new String(asEyeCatcher);
                if (!y.equals(SdffConstants.SEGMENT_Eye_SdffAs)) {
                    throw new CorruptDataException(new CorruptDataImpl("ADDRSPC eyecatcher invalid"));
                }
                this.addressSpaces.add(new SDFFAddressSpace(this, this.mmapOffset, this.mmapLength, this.sdffRaf, this.dumpRaf, i));
                this_as += asLength;
                ++i;
            }
        }
        catch (IOException e) {
            this.addressSpaces.add(new CorruptDataImpl("Corrupt SDFF reading address spaces: " + e.toString()));
        }
        catch (CorruptDataException e) {
            this.addressSpaces.add(e.getCorruptData());
        }
        this.context = (AddressSpaceProxy)this.addressSpaces.elementAt(0);
    }

    public String getProcessorSubType() {
        if (this.processorSubType >= 0 && this.processorSubType < ImageProxy.PROC_SUBTYPE_DESCRIPTION.length) {
            return ImageProxy.PROC_SUBTYPE_DESCRIPTION[this.processorSubType];
        }
        return "UNKNOWN PROCESSOR SUBTYPE (" + this.processorSubType + ")";
    }

    public int getCurrentProcessor() {
        return this.currentProcessor;
    }

    public int getProcessorCount() throws DataUnavailable {
        if (-1 == this.numProcessors) {
            throw new DataUnavailable();
        }
        return this.numProcessors;
    }

    public String getGeneratingJVMType() {
        String retString = null;
        if (-1L == this.provider) {
            retString = new String("sov");
        }
        if (0x7F7F7F7F7F7F7F7FL == this.provider) {
            retString = new String("sov");
        }
        if (0L == this.provider || -4294967296L == this.provider) {
            retString = new String("sov");
        }
        if (1L == this.provider) {
            retString = new String("j9");
        }
        return retString;
    }

    public Ras getRas() {
        return this.ras;
    }

    public WordType getWordType() {
        return this.wordType;
    }

    public WordLength getWordLength() {
        return this.wordLength;
    }

    public byte[] getMetaData() {
        return null;
    }

    public byte[] getCTypedefs() {
        byte[] types = null;
        AddressSpaceProxy addressSpace = (AddressSpaceProxy)this.addressSpaces.elementAt(0);
        try {
            types = addressSpace.readBytes(this.ras.typedefs, this.ras.typedefsLen);
            if (types[0] != 80 || types[1] != 75) {
                System.err.println("*** WARNING: Location for jvmdcf appears suspect -- searching backwards");
                int pos = -1;
                byte[] previous512 = addressSpace.readBytes(this.ras.typedefs - 512L, 512L);
                if (null != previous512) {
                    int i;
                    for (i = 503; i >= 256 && -1 == pos; --i) {
                        byte[] bytesEight = new byte[]{previous512[i], previous512[i + 1], previous512[i + 2], previous512[i + 3], previous512[i + 4], previous512[i + 5], previous512[i + 6], previous512[i + 7]};
                        String x = new String(bytesEight);
                        if (!x.equals("jvmdcf.X")) continue;
                        pos = i;
                    }
                    if (-1 != pos) {
                        for (i = pos; i >= 0; --i) {
                            if (previous512[i] != 80 || previous512[i + 1] != 75) continue;
                            System.err.println("*** WARNING: Location for jvmdcf found using backward search");
                            pos = i;
                            i = 0;
                        }
                    }
                }
                if (-1 == pos) {
                    return null;
                }
                types = addressSpace.readBytes(this.ras.typedefs - 512L + (long)pos, this.ras.typedefsLen);
            }
        }
        catch (MemoryAccessException e) {
            System.err.println("Unable to read typedef data from the dump for address 0x" + Long.toHexString(this.ras.typedefs));
        }
        return types;
    }

    public String getImageDescription() {
        if (this.oldFormat) {
            return "Old (flat-file) format SDFF file";
        }
        return "New (JAR archive) format [version " + this.dumpFormatVersion + "] SDFF file";
    }

    public long getInstalledMemory() throws DataUnavailable {
        throw new DataUnavailable("Unimplemented method getInstalledMemory()");
    }

    public long getCreationTime() throws DataUnavailable {
        if (this.dumpTimeStamp == -1L) {
            throw new DataUnavailable("Dump's file stamp was not stored in SDFF file.");
        }
        return this.dumpTimeStamp;
    }

    protected DataLocator getHpiReader() throws CorruptDataException {
        DataLocator hpiReader = null;
        DataObject hpiras = new DataObject(null, "hpi_ras_t", this.context);
        hpiras.setAddress(this.getRas().hpiRas);
        hpiReader = (DataLocator)hpiras.getReader();
        return hpiReader;
    }
}

