/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.sdffReader;

import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.java.JavaStackFrameProxy;
import com.ibm.dtfj.sov.java.JavaStackProxy;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import com.ibm.dtfj.sov.utils.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Vector;

public class SDFFJavaStack
extends JavaStackProxy {
    private long nullMetaData = -1L;
    private byte[] metadata;
    private long offset_in_file;
    private int numFrames;
    private RandomAccessFile sdffHeaderFile;
    private AddressSpaceProxy context;
    private JavaRuntimeProxyImpl jvm;
    private Vector badJavaStack = null;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator frameIterator = this.iterator();
        while (frameIterator.hasNext()) {
            sb.append(((JavaStackFrameProxy)frameIterator.next()).toString() + "\n");
        }
        return sb.toString();
    }

    public SDFFJavaStack(long offset, RandomAccessFile sdffHeaderFile, AddressSpaceProxy context) {
        super(0);
        this.context = context;
        Trace.writeToTrace("Entry to SDFFJavaStack:constructor...");
        this.offset_in_file = offset;
        this.sdffHeaderFile = sdffHeaderFile;
        try {
            sdffHeaderFile.seek(this.offset_in_file);
            long length = sdffHeaderFile.readLong();
            sdffHeaderFile.skipBytes(8);
            sdffHeaderFile.seek(this.offset_in_file + length - 8L);
            long metadata_offset = sdffHeaderFile.readLong();
            if (metadata_offset != -1L) {
                byte[] metadata = new byte[(int)metadata_offset];
                sdffHeaderFile.seek(this.offset_in_file + length - 8L - metadata_offset);
                sdffHeaderFile.read(metadata);
            }
            sdffHeaderFile.seek(this.offset_in_file + 16L);
            this.numFrames = (int)sdffHeaderFile.readLong();
        }
        catch (IOException e) {
            this.badJavaStack = new Vector(1);
            this.badJavaStack.add(new CorruptDataImpl("IOException while creating SDFFJavaStack " + e));
        }
        Trace.writeToTrace("Exit from SDFFJavaStack:constructor");
    }

    public void setRuntime(JavaRuntimeProxyImpl jvm) {
        this.jvm = jvm;
    }

    public Iterator iterator() {
        if (this.badJavaStack != null) {
            return this.badJavaStack.iterator();
        }
        return new Iterator(){
            private int currentFrame = 0;
            private long currentFrameOffset = SDFFJavaStack.access$000(SDFFJavaStack.this) + 16L + 8L;

            public Object next() {
                JavaStackFrameProxy jframe = new JavaStackFrameProxy(this.currentFrameOffset, SDFFJavaStack.this.context);
                if (!this.hasNext()) {
                    return null;
                }
                try {
                    int nameLen;
                    SDFFJavaStack.this.sdffHeaderFile.seek(this.currentFrameOffset);
                    jframe.setMb(SDFFJavaStack.this.sdffHeaderFile.readLong());
                    jframe.setPc(SDFFJavaStack.this.sdffHeaderFile.readLong());
                    jframe.setSp(SDFFJavaStack.this.sdffHeaderFile.readLong());
                    jframe.setArgs(SDFFJavaStack.this.sdffHeaderFile.readLong());
                    jframe.setVars(SDFFJavaStack.this.sdffHeaderFile.readLong());
                    jframe.setFrameType((int)SDFFJavaStack.this.sdffHeaderFile.readLong());
                    if (nameLen > 0) {
                        byte[] name = new byte[nameLen];
                        if (name != null) {
                            SDFFJavaStack.this.sdffHeaderFile.read(name);
                            for (nameLen = (int)SDFFJavaStack.this.sdffHeaderFile.readLong(); nameLen > 1 && name[nameLen - 1] == 0; --nameLen) {
                            }
                        }
                        jframe.setName(new String(name, 0, nameLen, "ASCII"));
                    }
                    this.currentFrameOffset = SDFFJavaStack.this.sdffHeaderFile.getFilePointer();
                }
                catch (IOException e) {
                    this.currentFrame = SDFFJavaStack.this.numFrames;
                    return new CorruptDataImpl("IOException while reading JavaStackFrames" + e);
                }
                ++this.currentFrame;
                return jframe;
            }

            public boolean hasNext() {
                return this.currentFrame < SDFFJavaStack.this.numFrames;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public long getNumFrames() {
        return this.numFrames;
    }

    static /* synthetic */ long access$000(SDFFJavaStack x0) {
        return x0.offset_in_file;
    }
}

