/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.sdffReader;

import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.ImageStackFrameProxy;
import com.ibm.dtfj.sov.image.NativeStackProxy;
import com.ibm.dtfj.sov.utils.ErrorLog;
import com.ibm.dtfj.sov.utils.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class SDFFNativeStack
extends NativeStackProxy {
    private long nullMetaData = -1L;
    private byte[] metadata;
    private long offset_in_file;
    private RandomAccessFile sdffHeaderFile;
    private int numFrames;
    private AddressSpaceProxy context;
    private Vector badNativeStack = null;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator frameIterator = this.iterator();
        while (frameIterator.hasNext()) {
            sb.append(((ImageStackFrameProxy)frameIterator.next()).toString() + "\n");
        }
        return sb.toString();
    }

    public SDFFNativeStack(long offset, RandomAccessFile sdffHeaderFile, AddressSpaceProxy context) {
        super(0);
        Trace.writeToTrace("Entry to SDFFNativeStack:loadFromFile...");
        this.context = context;
        this.offset_in_file = offset;
        Trace.writeToTrace("  .... Loading SDFFNativeStack object from file :" + offset);
        this.sdffHeaderFile = sdffHeaderFile;
        try {
            sdffHeaderFile.seek(this.offset_in_file);
            long length = sdffHeaderFile.readLong();
            sdffHeaderFile.skipBytes(8);
            sdffHeaderFile.seek(this.offset_in_file + length - 8L);
            long metadata_offset = sdffHeaderFile.readLong();
            if (metadata_offset != -1L) {
                this.metadata = new byte[(int)metadata_offset];
                sdffHeaderFile.seek(this.offset_in_file + length - 8L - metadata_offset);
                sdffHeaderFile.read(this.metadata);
                String s = new String(this.metadata);
                System.out.println("nstackmd:" + s);
            }
            sdffHeaderFile.seek(this.offset_in_file + 16L);
            this.numFrames = (int)sdffHeaderFile.readLong();
        }
        catch (IOException e) {
            ErrorLog.output("IOException in SDFFNativeStack: loadFromFile");
            this.badNativeStack = new Vector(1);
            this.badNativeStack.add(new CorruptDataImpl("Initialization of SDFFNative stack failed due to IOException: " + e));
        }
        Trace.writeToTrace("Exit from SDFFNativeStack:loadFromFile");
    }

    public Iterator iterator() {
        if (this.badNativeStack != null) {
            return this.badNativeStack.iterator();
        }
        return new Iterator(){
            private int currentFrame = 0;
            private long currentFrameOffset = SDFFNativeStack.access$000(SDFFNativeStack.this) + 16L + 8L;

            public Object next() {
                if (!this.hasNext()) {
                    return null;
                }
                ImageStackFrameProxy nframe = new ImageStackFrameProxy(SDFFNativeStack.this.context);
                try {
                    int nameLen;
                    SDFFNativeStack.this.sdffHeaderFile.seek(this.currentFrameOffset);
                    nframe.setMb(SDFFNativeStack.this.sdffHeaderFile.readLong());
                    nframe.setPc(SDFFNativeStack.this.sdffHeaderFile.readLong());
                    nframe.setBp(SDFFNativeStack.this.sdffHeaderFile.readLong());
                    nframe.setFrameType((int)SDFFNativeStack.this.sdffHeaderFile.readLong());
                    if (nameLen > 0) {
                        byte[] name = new byte[nameLen];
                        if (name != null) {
                            SDFFNativeStack.this.sdffHeaderFile.read(name);
                            for (nameLen = (int)SDFFNativeStack.this.sdffHeaderFile.readLong(); nameLen > 1 && name[nameLen - 1] == 0; --nameLen) {
                            }
                        }
                        nframe.setName(SDFFNativeStack.this.transformProcedureName(new String(name, 0, nameLen, "ASCII")));
                    }
                    this.currentFrameOffset = SDFFNativeStack.this.sdffHeaderFile.getFilePointer();
                }
                catch (IOException e) {
                    this.currentFrame = SDFFNativeStack.this.numFrames;
                    return new CorruptDataImpl("IOException while reading ImageStackFrameProxy: " + e);
                }
                ++this.currentFrame;
                return nframe;
            }

            public boolean hasNext() {
                return this.currentFrame < SDFFNativeStack.this.numFrames;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public long getNumFrames() {
        return this.numFrames;
    }

    public String transformProcedureName(String procname) {
        String libname = null;
        String sourcefile = null;
        String entrypoint = null;
        if (this.context.getPlatformName().equals("linux") || this.context.getPlatformName().equals("windows")) {
            int plusInd = procname.indexOf(43);
            if (plusInd == -1) {
                int parenInd = procname.indexOf(40);
                if (parenInd != -1) {
                    entrypoint = procname.substring(0, parenInd);
                    sourcefile = procname.substring(parenInd + 1, procname.indexOf(41));
                    if (sourcefile.endsWith(":Compiled method")) {
                        sourcefile = sourcefile.substring(0, sourcefile.indexOf(58));
                    }
                    if ((sourcefile = sourcefile.replace(':', '+')).equals("Native method") || sourcefile.equals("")) {
                        sourcefile = null;
                    }
                } else {
                    entrypoint = procname;
                }
            } else {
                entrypoint = procname.substring(0, procname.indexOf(32));
                libname = procname.substring(procname.indexOf(40) + 1, procname.indexOf(41));
            }
        } else if (this.context.getPlatformName().equals("aix")) {
            StringTokenizer st = new StringTokenizer(procname, "{}");
            if (st.hasMoreElements()) {
                libname = st.nextToken();
            }
            if (st.hasMoreElements()) {
                entrypoint = st.nextToken();
            }
            if (entrypoint.equals("???")) {
                entrypoint = null;
            }
            if (libname.equals("???")) {
                libname = null;
            }
        }
        StringBuffer returnValue = new StringBuffer(procname.length());
        if (libname != null) {
            returnValue.append(libname);
        }
        if (sourcefile != null) {
            returnValue.append('(');
            returnValue.append(sourcefile);
            returnValue.append(')');
        }
        if (entrypoint != null) {
            returnValue.append("::");
            returnValue.append(entrypoint);
        }
        return returnValue.toString();
    }

    static /* synthetic */ long access$000(SDFFNativeStack x0) {
        return x0.offset_in_file;
    }
}

