/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.sdffReader;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.EnvVarProxy;
import com.ibm.dtfj.sov.image.ImageModuleProxy;
import com.ibm.dtfj.sov.image.ImageProcessProxy;
import com.ibm.dtfj.sov.image.ImageSectionImpl;
import com.ibm.dtfj.sov.image.ImageThreadProxy;
import com.ibm.dtfj.sov.imp.JavaRuntimeEffigy;
import com.ibm.dtfj.sov.java.JavaThreadProxy;
import com.ibm.dtfj.sov.java.Ras;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaThreadProxyImpl;
import com.ibm.dtfj.sov.sdffReader.SDFFDump;
import com.ibm.dtfj.sov.sdffReader.SDFFThread;
import com.ibm.dtfj.sov.sdffReader.SdffConstants;
import com.ibm.dtfj.sov.utils.ErrorLog;
import com.ibm.dtfj.sov.utils.FileSearcher;
import com.ibm.dtfj.sov.utils.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class SDFFProcess
implements ImageProcessProxy {
    private static HashMap processByAddressSpace = new HashMap();
    private AddressSpaceProxy context;
    long id;
    long numThreads;
    long currentThread;
    private long signalNumber;
    String signalName;
    String signalNameException = null;
    String commandLine = null;
    String envMetaData;
    boolean hasJavaThreads;
    boolean populatedJavaThreads = false;
    private long jvm = -1L;
    Vector threads = new Vector();
    Vector javaThreads = new Vector();
    Vector libraries = new Vector();
    HashMap execenv_and_threads = new HashMap();
    JavaRuntimeEffigy javaVM = null;
    Properties envVars = null;
    Iterator envVarsIterator = null;
    private int java_version_size;
    private byte[] java_version;
    private int jhd_size;
    private byte[] java_home_dir;
    private int jdd_size;
    private byte[] java_dll_dir;
    private int classpath_size;
    private byte[] classpath;
    Vector envVarsVector = null;
    Vector runtimes = null;

    public String javaHomeDir() {
        String retString = null;
        if (null != this.java_home_dir) {
            try {
                retString = new String(this.java_home_dir, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                retString = " !!! Encoding exception caught !!!";
            }
        }
        return retString;
    }

    public String javaDllDir() {
        String retString = null;
        if (null != this.java_dll_dir) {
            try {
                retString = new String(this.java_dll_dir, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                retString = " !!! Encoding exception caught !!!";
            }
        }
        return retString;
    }

    public String javaVersion() {
        String retString = null;
        if (null != this.java_version) {
            try {
                retString = new String(this.java_version, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                retString = " !!! Encoding exception caught !!!";
            }
        }
        return retString;
    }

    public String classPath() {
        String retString = null;
        if (null != this.classpath) {
            try {
                retString = new String(this.classpath, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                retString = " !!! Encoding exception caught !!!";
            }
        }
        return retString;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Process id " + this.id + "\n");
        sb.append("commandLine " + this.getCommandLine() + "\n");
        sb.append("Signal " + this.signalName + "(" + this.signalNumber + ")\n");
        sb.append("ThreadCount " + this.numThreads + "\n");
        sb.append("CurrentThread " + this.currentThread + "(" + Long.toHexString(this.currentThread) + ")" + "\n");
        Iterator threadIterator = this.threads.iterator();
        while (threadIterator.hasNext()) {
            sb.append(((SDFFThread)threadIterator.next()).toString());
        }
        sb.append("Environment\n");
        sb.append("MetaData: " + this.envMetaData + "\n");
        sb.append("Java version: " + this.javaVersion() + "\n");
        sb.append("Java Home: " + this.javaHomeDir() + "\n");
        sb.append("Java DLL dir: " + this.javaDllDir() + "\n");
        sb.append("ClassPath : " + this.classPath() + "\n");
        sb.append("Environment variables :\n");
        Iterator envVarIterator = this.getEnvVarsIterator();
        while (envVarIterator.hasNext()) {
            sb.append("\t" + (EnvVarProxy)envVarIterator.next() + "\n");
        }
        sb.append("Loaded Libraries\n");
        Iterator libraryIterator = this.libraries.iterator();
        while (libraryIterator.hasNext()) {
            sb.append("\t" + ((ImageModuleProxy)libraryIterator.next()).toString() + "\n");
        }
        return sb.toString();
    }

    public SDFFProcess(long offset, long length, RandomAccessFile sdffRaf, AddressSpaceProxy context, SDFFDump theDump) throws IOException {
        processByAddressSpace.put(context, this);
        byte[] signal_Name = new byte[8];
        byte[] command_line = new byte[256];
        this.context = context;
        this.id = sdffRaf.readLong();
        this.numThreads = sdffRaf.readLong();
        this.currentThread = sdffRaf.readLong();
        this.signalNumber = sdffRaf.readLong();
        sdffRaf.readFully(signal_Name);
        try {
            this.signalName = new String(signal_Name, "ASCII");
        }
        catch (UnsupportedEncodingException e1) {
            this.signalNameException = e1.toString();
        }
        sdffRaf.readFully(command_line);
        sdffRaf.readLong();
        long processOffset = offset;
        long processLength = length;
        this.hasJavaThreads = false;
        byte[] envEye = SdffConstants.SEGMENT_Eye_SdffEnvData.getBytes();
        long whereToEndSearch = processOffset + processLength;
        long envOffset = processOffset;
        Trace.writeToTrace("Looking for EnvData eyecatcher...");
        envOffset = FileSearcher.findNextInFile(sdffRaf, envEye, envOffset, whereToEndSearch, 1);
        Trace.writeToTrace("... returned offset is x" + Long.toHexString(envOffset));
        byte[] envLoaded = SdffConstants.SEGMENT_Eye_SdffLoaded.getBytes();
        whereToEndSearch = processOffset + processLength;
        long loadedOffset = processOffset;
        Trace.writeToTrace("Looking for Loaded eyecatcher...");
        loadedOffset = FileSearcher.findNextInFile(sdffRaf, envLoaded, loadedOffset, whereToEndSearch, 1);
        Trace.writeToTrace("... returned offset is x" + Long.toHexString(loadedOffset));
        if (-1L != loadedOffset) {
            this.loadLibraries(loadedOffset - 8L, sdffRaf);
        }
        whereToEndSearch = processOffset + processLength;
        int threadCount = 0;
        byte[] eyeCatcher = SdffConstants.SEGMENT_Eye_SdffThread.getBytes();
        long x = processOffset;
        try {
            while (x != -1L) {
                Trace.writeToTrace("  Looking for Thread eyecatcher...");
                x = FileSearcher.findNextInFile(sdffRaf, eyeCatcher, x, whereToEndSearch, 1);
                Trace.writeToTrace("  ... returned offset is x" + Long.toHexString(x));
                if (x == -1L) continue;
                ++threadCount;
                SDFFThread t = new SDFFThread(x - 8L, sdffRaf, context, theDump);
                this.threads.add(t);
                if (t.getIsJava() && !this.hasJavaThreads) {
                    this.hasJavaThreads = true;
                }
                sdffRaf.seek(x - 8L);
                x += sdffRaf.readLong();
            }
        }
        catch (IOException e) {
            this.threads.add(new CorruptDataImpl("IOException while reading SDFFThreads: " + e));
        }
    }

    private void loadLibraries(long offset_in_file, RandomAccessFile raf) {
        try {
            long real_data_length;
            raf.seek(offset_in_file);
            long length = raf.readLong();
            Trace.writeToTrace("\tOffest of loaded subsection is " + offset_in_file + " :  length=" + length);
            raf.seek(offset_in_file + length - 8L);
            long metadata_offset = raf.readLong();
            if (-1L != metadata_offset) {
                byte[] dummy = new byte[(int)metadata_offset];
                raf.seek(offset_in_file + length - 8L - metadata_offset);
                raf.read(dummy);
            }
            if ((real_data_length = length - 24L) > 0L) {
                raf.seek(offset_in_file + 16L);
                boolean bDone = false;
                boolean bFormatError = false;
                while (!bDone && !bFormatError) {
                    String s;
                    try {
                        long modAddr = raf.readLong();
                        long modSize = raf.readLong();
                        int modnameSize = (int)raf.readLong();
                        String modName = "";
                        if (modnameSize > 0) {
                            byte[] baName = new byte[modnameSize];
                            raf.read(baName);
                            modName = new String(baName, "ASCII");
                        }
                        Vector<ImageSectionImpl> sectionVec = new Vector<ImageSectionImpl>();
                        sectionVec.add(new ImageSectionImpl(this.context, modAddr, modSize, "unknown", false, false, false, false));
                        this.libraries.add(new ImageModuleProxy(modName, sectionVec));
                        int hack = modnameSize % 8;
                        if (hack > 0) {
                            byte[] baHack = new byte[8 - hack];
                            raf.read(baHack);
                        }
                        if (raf.getFilePointer() < offset_in_file + real_data_length + 16L) continue;
                        bDone = true;
                    }
                    catch (Exception e1) {
                        ErrorLog.output("Exception in SDFFProcess.loadLibraries() (format error whilst loading module names/addresses)");
                        s = e1.getMessage();
                        if (null != s) {
                            System.out.println(s);
                        }
                        e1.printStackTrace(System.out);
                        bFormatError = true;
                        bDone = true;
                    }
                    catch (Error err) {
                        ErrorLog.output("Error in SDFFProcess.loadLibraries() (format error whilst loading module names/addresses)");
                        s = err.getMessage();
                        if (null != s) {
                            System.out.println(s);
                        }
                        err.printStackTrace(System.out);
                        bFormatError = true;
                        bDone = true;
                    }
                }
            }
        }
        catch (IOException e) {
            ErrorLog.output("IOException in SDFFProcess.loadLibraries()");
            String s = e.getMessage();
            if (null != s) {
                System.out.println(s);
            }
            e.printStackTrace(System.out);
        }
    }

    public String getID() {
        return Long.toString(this.id);
    }

    public Iterator getThreads() {
        return this.threads.iterator();
    }

    public boolean isJava() {
        return this.hasJavaThreads;
    }

    public byte[] getMetaData() {
        return null;
    }

    public String getSignalName() throws DataUnavailable {
        if (this.signalNameException != null) {
            throw new DataUnavailable(this.signalNameException);
        }
        return this.signalName;
    }

    public ImageThreadProxy getCurrentThread() throws CorruptDataException {
        if (this.currentThread == -1L) {
            return null;
        }
        for (int i = 0; i < this.threads.size(); ++i) {
            ImageThreadProxy retThread = (ImageThreadProxy)this.threads.get(i);
            if (!retThread.getID().equals(Long.toHexString(this.currentThread))) continue;
            return retThread;
        }
        return null;
    }

    private Iterator getEnvVarsIterator() {
        if (this.envVars == null) {
            this.envVarsVector = new Vector();
            try {
                Iterator<Map.Entry<Object, Object>> envIterator = this.getEnvironment().entrySet().iterator();
                while (envIterator.hasNext()) {
                    this.envVarsVector.addElement(new EnvVarProxy(envIterator.next().toString()));
                }
            }
            catch (CorruptDataException e) {
                this.envVarsVector.add(e.getCorruptData());
            }
            catch (DataUnavailable e) {
                this.envVarsVector.add(new CorruptDataImpl("DataUnavailable Exception: " + e));
            }
        }
        return this.envVarsVector.iterator();
    }

    public Properties getEnvironment() throws DataUnavailable, CorruptDataException {
        if (this.envVars == null) {
            try {
                this.loadEnvVars();
            }
            catch (MemoryAccessException e) {
                this.envVars = null;
                CorruptDataException cde = new CorruptDataException(new CorruptDataImpl(e.getPointer(), "Error getting envVars " + e.getMessage()));
                cde.initCause(e);
                throw cde;
            }
        }
        return this.envVars;
    }

    private void loadEnvVars() throws MemoryAccessException {
        long envStringPtr;
        this.envVars = new Properties();
        long envPtr = -1L;
        long jvmRasAddress = this.context.getRas().jvmRas;
        this.context.readPointer(jvmRasAddress += 24L);
        this.context.readPointer(jvmRasAddress + (long)this.context.getWordLength().size);
        this.context.readPointer(jvmRasAddress + (long)(this.context.getWordLength().size * 2));
        envPtr = this.context.readPointer(jvmRasAddress + (long)(this.context.getWordLength().size * 3));
        Trace.writeToTrace("SDFFProcess.loadEnvVars(): envPtr is 0x" + Long.toHexString(envPtr));
        while ((envStringPtr = this.context.readPointer(envPtr)) != 0L) {
            String envString = this.context.readString(envStringPtr);
            int equalsPos = envString.indexOf(61);
            this.envVars.setProperty(envString.substring(0, equalsPos), envString.substring(equalsPos + 1));
            envPtr += (long)this.context.getWordLength().size;
        }
    }

    public Iterator getLocks() {
        return new Vector().iterator();
    }

    public boolean getIsJava() {
        return this.hasJavaThreads;
    }

    public String getCommandLine() {
        if (this.commandLine == null) {
            this.commandLine = "Not Available";
            Iterator envVarIterator = this.getEnvVarsIterator();
            while (envVarIterator.hasNext()) {
                EnvVarProxy envVar = (EnvVarProxy)envVarIterator.next();
                if (!envVar.getName().equals("IBM_JAVA_COMMAND_LINE")) continue;
                this.commandLine = envVar.getValue();
            }
        }
        return this.commandLine;
    }

    public Iterator getLibraries() {
        return this.libraries.iterator();
    }

    public Iterator getRuntimes() {
        if (this.runtimes == null) {
            this.runtimes = new Vector();
        }
        Iterator threadsIterator = this.getThreads();
        SDFFThread t = null;
        while (threadsIterator.hasNext()) {
            t = (SDFFThread)threadsIterator.next();
            if (!t.getIsJava()) continue;
            try {
                DataObject execEnvDO = new DataObject(null, "execenv", this.context);
                execEnvDO.setAddress(t.getEEAddress());
                this.jvm = execEnvDO.getReader().getLong("(Long)jvmP");
                this.javaVM = (JavaRuntimeEffigy)Effigy.create("JavaRuntimeEffigy", this.context.getPointer(this.jvm).getAddress(), this.context, this.context.getPlatformName());
                this.javaVM.setProcessAndJVM(this, this.jvm);
                this.runtimes.add(this.javaVM);
                break;
            }
            catch (CorruptDataException e) {
                this.runtimes.add(e.getCorruptData());
            }
            catch (MemoryAccessException e) {
                this.runtimes.add(new CorruptDataImpl(e.getPointer(), "Error getting Runtimes: " + e.getMessage()));
            }
        }
        return this.runtimes.iterator();
    }

    public Ras getRas() {
        return this.context.getRas();
    }

    public int getSignalNumber() {
        return (int)this.signalNumber;
    }

    public ImageModuleProxy getExecutable() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("SDFFProcess.getExecutable() missing executable information.");
    }

    public int getPointerSize() {
        return this.context.getWordLength().size * 8;
    }

    public Iterator getJavaThreads() {
        if (!this.populatedJavaThreads) {
            if (!this.hasJavaThreads) {
                return new Vector().iterator();
            }
            this.populateVectorOfJavaThreads();
        }
        return this.javaThreads.iterator();
    }

    public JavaThreadProxy getJavaThread(Long eeAddress) {
        if (!this.populatedJavaThreads) {
            if (!this.hasJavaThreads) {
                return null;
            }
            this.populateVectorOfJavaThreads();
        }
        return (JavaThreadProxy)this.execenv_and_threads.get(eeAddress);
    }

    public void populateVectorOfJavaThreads() {
        Iterator thrs = this.threads.iterator();
        this.javaThreads = new Vector();
        JavaRuntimeProxyImpl runtime = (JavaRuntimeProxyImpl)this.javaVM.getProxy();
        while (thrs.hasNext()) {
            SDFFThread t = (SDFFThread)thrs.next();
            if (!t.getIsJava()) continue;
            try {
                JavaThreadProxyImpl jt = new JavaThreadProxyImpl(t, this.context, runtime);
                this.javaThreads.add(jt);
                this.execenv_and_threads.put(new Long(t.getEEAddress()), jt);
            }
            catch (CorruptDataException e) {
                this.javaThreads.add(e.getCorruptData());
            }
        }
        this.populatedJavaThreads = true;
    }
}

