/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.sdffReader;

import com.ibm.dtfj.sov.image.RegisterSet;
import com.ibm.dtfj.sov.utils.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Vector;

class SDFFRegisterSet
implements RegisterSet {
    private Vector names = new Vector();
    private Vector values = new Vector();
    private long count;
    private long size;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator namesIterator = this.names.iterator();
        Iterator valuesIterator = this.values.iterator();
        int i = 0;
        while ((long)i < this.count) {
            sb.append("Register name " + (String)namesIterator.next() + " value " + (Long)valuesIterator.next() + "\n");
            ++i;
        }
        return sb.toString();
    }

    public long getValue(int index) {
        return (Long)this.values.get(index);
    }

    public String getName(int index) {
        return (String)this.names.get(index);
    }

    public long getCount() {
        return this.count;
    }

    public SDFFRegisterSet(long offset, RandomAccessFile sdffHeaderFile) throws IOException {
        Trace.writeToTrace("Entry to SDFFRegisterSet:constructor...");
        long offset_in_file = offset;
        Trace.writeToTrace("  .... Loading SDFFRegisterSet object from file :" + offset);
        sdffHeaderFile.seek(offset_in_file);
        sdffHeaderFile.readLong();
        sdffHeaderFile.skipBytes(8);
        this.count = sdffHeaderFile.readLong();
        this.size = sdffHeaderFile.readLong();
        Trace.writeToTrace("  .... count of registers in this section is:" + this.count + " with size " + this.size);
        if (this.size != 4L && this.size != 8L && this.size != 16L) {
            this.count = 0L;
            this.size = 0L;
        }
        int howMany = (int)this.count;
        for (int i = 0; i < howMany; ++i) {
            byte[] name = new byte[8];
            sdffHeaderFile.read(name);
            String s = new String(name, "ASCII");
            long value = sdffHeaderFile.readLong();
            this.names.add(s);
            this.values.add(new Long(value));
        }
        Trace.writeToTrace("Exit from SDFFRegister:constructor");
    }
}

