/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.sdffReader;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.data.DataLocator;
import com.ibm.dtfj.sov.data.StructuredDataLocator;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.image.ImageRegisterProxy;
import com.ibm.dtfj.sov.image.ImageSectionImpl;
import com.ibm.dtfj.sov.image.ImageThreadProxy;
import com.ibm.dtfj.sov.image.NativeStackProxy;
import com.ibm.dtfj.sov.imp.ImagePointerEffigy;
import com.ibm.dtfj.sov.imp.ImageThreadEffigy;
import com.ibm.dtfj.sov.java.JavaStackProxy;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import com.ibm.dtfj.sov.sdffReader.SDFFDump;
import com.ibm.dtfj.sov.sdffReader.SDFFJavaStack;
import com.ibm.dtfj.sov.sdffReader.SDFFNativeStack;
import com.ibm.dtfj.sov.sdffReader.SDFFRegisterSet;
import com.ibm.dtfj.sov.sdffReader.SdffConstants;
import com.ibm.dtfj.sov.utils.FileSearcher;
import com.ibm.dtfj.sov.utils.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class SDFFThread
implements ImageThreadProxy {
    private long length;
    private long threadID;
    private int threadType;
    private long stackptr;
    private long execEnv;
    private long pc;
    private byte[] metadata;
    private long metadata_offset;
    private AddressSpaceProxy context;
    private SDFFJavaStack javaStack;
    private SDFFNativeStack nativeStack;
    private Vector registers = new Vector();
    private String platformName;
    private Long myStackBase = null;
    private Long myStackLimit = null;
    protected StructuredDataLocator MyDataLocator = null;
    Vector stackSections = null;
    private JavaRuntimeProxyImpl jvm;

    public SDFFThread(long offset, RandomAccessFile sdffHeaderFile, AddressSpaceProxy context, SDFFDump theDump) throws IOException {
        this.context = context;
        this.platformName = context.getPlatformName();
        long offset_in_file = offset;
        Trace.writeToTrace(" Loading SDFFThread object from file offset " + offset);
        sdffHeaderFile.seek(offset_in_file);
        this.length = sdffHeaderFile.readLong();
        sdffHeaderFile.seek(offset_in_file + this.length - 8L);
        this.metadata_offset = sdffHeaderFile.readLong();
        if (-1L != this.metadata_offset) {
            this.metadata = new byte[(int)this.metadata_offset];
            sdffHeaderFile.seek(offset_in_file + this.length - 8L - this.metadata_offset);
            sdffHeaderFile.read(this.metadata);
        }
        sdffHeaderFile.seek(offset_in_file + 8L);
        sdffHeaderFile.skipBytes(8);
        this.threadID = sdffHeaderFile.readLong();
        this.threadType = sdffHeaderFile.readInt();
        sdffHeaderFile.readInt();
        this.stackptr = sdffHeaderFile.readLong();
        this.pc = sdffHeaderFile.readLong();
        this.execEnv = sdffHeaderFile.readLong();
        Trace.writeToTrace(" Looking for REGISTER sections " + offset);
        long x = offset_in_file;
        long whereToEndSearch = offset_in_file + this.length;
        byte[] eyeCatcher = SdffConstants.SEGMENT_Eye_SdffRegister.getBytes();
        while (x != -1L) {
            Trace.writeToTrace("  Looking for Register eyecatcher...");
            x = FileSearcher.findNextInFile(sdffHeaderFile, eyeCatcher, x, whereToEndSearch, 1);
            Trace.writeToTrace("  ... returned offset is x" + Long.toHexString(x));
            if (x == -1L || x >= whereToEndSearch) continue;
            try {
                SDFFRegisterSet r = new SDFFRegisterSet(x - 8L, sdffHeaderFile);
                int regNo = 0;
                while ((long)regNo < r.getCount()) {
                    String regName = r.getName(regNo).trim();
                    if (context.getPlatformName().equals("aix")) {
                        regName = this.ppcRegNameTransform(regName);
                    } else if (context.getPlatformName().equals("windows")) {
                        regName = this.ia32RegNameTransform(regName);
                    } else if (context.getPlatformName().equals("linux")) {
                        if (theDump.getProcessor() == 1) {
                            regName = this.ia32RegNameTransform(regName);
                        } else if (theDump.getProcessor() == 2) {
                            regName = this.ppcRegNameTransform(regName);
                        }
                    }
                    this.registers.add(new ImageRegisterProxy(regName, r.getValue(regNo)));
                    ++regNo;
                }
            }
            catch (IOException e) {
                this.registers.add(new CorruptDataImpl("IOException while determining SDFFRegisterSet " + e));
            }
            try {
                sdffHeaderFile.seek(x - 8L);
                x += sdffHeaderFile.readLong();
            }
            catch (IOException ioE) {
                System.out.println("IOException in SDFFThread");
            }
        }
        Trace.writeToTrace(" Looking for JSTACKTR subsections " + offset);
        x = offset_in_file;
        whereToEndSearch = offset_in_file + this.length;
        eyeCatcher = SdffConstants.SEGMENT_Eye_SdffJstackTr.getBytes();
        x = FileSearcher.findNextInFile(sdffHeaderFile, eyeCatcher, x, whereToEndSearch, 1);
        Trace.writeToTrace("  ... returned offset is x" + Long.toHexString(x));
        if (x != -1L && x < whereToEndSearch) {
            SDFFJavaStack jStack;
            this.javaStack = jStack = new SDFFJavaStack(x - 8L, sdffHeaderFile, context);
        }
        Trace.writeToTrace(" Looking for NSTACKTR subsections " + offset);
        x = offset_in_file;
        whereToEndSearch = offset_in_file + this.length;
        eyeCatcher = SdffConstants.SEGMENT_Eye_SdffNstackTr.getBytes();
        x = FileSearcher.findNextInFile(sdffHeaderFile, eyeCatcher, x, whereToEndSearch, 1);
        Trace.writeToTrace("  ... returned offset is x" + Long.toHexString(x));
        if (x != -1L && x < whereToEndSearch) {
            SDFFNativeStack nStack;
            this.nativeStack = nStack = new SDFFNativeStack(x - 8L, sdffHeaderFile, context);
        }
    }

    public String ia32RegNameTransform(String regName) {
        String name = regName.toUpperCase();
        if (name.equals("EFL")) {
            name = "FLAGS";
        }
        return name;
    }

    public String ppcRegNameTransform(String regName) {
        StringBuffer regNameBuf = new StringBuffer(regName.toUpperCase());
        if (regName.startsWith("gpr")) {
            regNameBuf.delete(0, 2);
        } else if (regName.startsWith("fpr")) {
            regNameBuf.delete(1, 3);
        } else {
            if (regName.equals("link")) {
                return "LR";
            }
            if (regName.equals("nip")) {
                return "IAR";
            }
            if (regName.equals("ccr")) {
                return "CR";
            }
        }
        return regNameBuf.toString();
    }

    public boolean getIsJava() {
        return this.execEnv > 0L;
    }

    public long getEEAddress() {
        return this.execEnv;
    }

    public String getID() throws CorruptDataException {
        return Long.toHexString(this.threadID);
    }

    public NativeStackProxy getNativeStack() {
        return this.nativeStack;
    }

    public Iterator getStackFrames() {
        return this.getNativeStack().iterator();
    }

    public Long getStackBase() throws CorruptDataException {
        if (this.MyDataLocator == null) {
            this.MyDataLocator = new DataLocator(this, this.context);
        }
        if (this.myStackBase == null && this.execEnv > 0L) {
            try {
                if (this.platformName.equals("windows")) {
                    this.myStackBase = this.MyDataLocator.getLong("(execenv)getEEAddress().(sys_thread)sys_thr.nt_tib.(long)StackBase|\"0\"");
                }
                if (this.platformName.equals("linux")) {
                    this.myStackBase = this.MyDataLocator.getLong("(execenv)getEEAddress().(sys_thread)sys_thr.stack.main.(long)base|(execenv)getEEAddress().(sys_thread)sys_thr.stack_bottom|\"0\"");
                }
                if (this.platformName.equals("aix") || this.platformName.equals("zos")) {
                    this.myStackBase = this.MyDataLocator.getLong("(execenv)getEEAddress().(sys_thread)sys_thr.(Long)stack_base|\"0\"");
                }
            }
            catch (MemoryAccessException e) {
                CorruptDataException cde = new CorruptDataException(new CorruptDataImpl(e.getPointer(), "Unable to access stack base: " + e.getMessage()));
                cde.initCause(e);
                throw cde;
            }
        }
        return this.myStackBase;
    }

    public Long getStackLimit() throws CorruptDataException {
        if (this.MyDataLocator == null) {
            this.MyDataLocator = new DataLocator(this, this.context);
        }
        if (this.myStackLimit == null && this.execEnv > 0L) {
            try {
                if (this.platformName.equals("windows")) {
                    this.myStackLimit = this.MyDataLocator.getLong("(execenv)getEEAddress().(sys_thread)sys_thr.nt_tib.(long)StackLimit|\"0\"");
                }
                if (this.platformName.equals("linux")) {
                    this.myStackLimit = this.MyDataLocator.getLong("(execenv)getEEAddress().(sys_thread)sys_thr.stack.main.(long)top|(execenv)getEEAddress().(sys_thread)sys_thr.stack_top|\"0\"");
                }
                if (this.platformName.equals("aix")) {
                    this.myStackLimit = this.MyDataLocator.getLong("(execenv)getEEAddress().(sys_thread)sys_thr.stack_limit|\"0\"");
                }
                if (this.platformName.equals("zos")) {
                    this.myStackLimit = this.MyDataLocator.getLong("(execenv)getEEAddress().(sys_thread)sys_thr.saved_stack_limit|\"0\"");
                }
            }
            catch (MemoryAccessException e) {
                CorruptDataException cde = new CorruptDataException(new CorruptDataImpl(e.getPointer(), "Unable to access stack base: " + e.getMessage()));
                cde.initCause(e);
                throw cde;
            }
        }
        return this.myStackLimit;
    }

    public void getVectorOfStackSections() {
        long stackbase = 0L;
        long stackSize = 0L;
        String sectionName = null;
        Vector<ImageSectionImpl> myStackSections = new Vector<ImageSectionImpl>();
        try {
            if (this.getStackBase() != null && this.getStackLimit() != null) {
                stackbase = this.myStackBase;
                stackSize = this.myStackBase - this.myStackLimit;
            }
        }
        catch (CorruptDataException e) {
            this.stackSections = new Vector();
            this.stackSections.add(e.getCorruptData());
            stackbase = 0L;
            stackSize = 0L;
        }
        if (stackbase == 0L && stackSize == 0L && (this.platformName.equals("windows") || this.platformName.equals("linux"))) {
            if (this.stackptr == 0L && this.platformName.equals("windows")) {
                Iterator regIt = this.getRegisters();
                while (regIt.hasNext()) {
                    ImageRegisterProxy reg;
                    Object obj = regIt.next();
                    if (obj instanceof CorruptData || !(reg = (ImageRegisterProxy)obj).getName().trim().equals("ebp")) continue;
                    this.stackptr = reg.getValue().longValue();
                    break;
                }
            }
            Iterator sectionIterator = this.context.getImageSections();
            while (sectionIterator.hasNext()) {
                ImageSectionImpl section = (ImageSectionImpl)sectionIterator.next();
                long sectionBase = section.getBaseAddress().getAddress();
                long sectionSize = section.getSize();
                if (sectionBase >= this.stackptr || this.stackptr >= sectionBase + sectionSize) continue;
                stackbase = sectionBase;
                stackSize = sectionSize;
                sectionName = "Native Stack section";
                break;
            }
        }
        if (stackbase != 0L && stackSize != 0L) {
            ImagePointerProxy base = new ImagePointerProxy(stackbase, this.context);
            ImagePointerEffigy myBasePointer = (ImagePointerEffigy)Effigy.create("ImagePointerEffigy", base, this.context, this.context.getPlatformName());
            myStackSections.add(new ImageSectionImpl(myBasePointer, stackSize, sectionName, false, false, false, false));
        }
        this.stackSections = myStackSections;
    }

    public Iterator getStackSections() {
        if (this.stackSections == null) {
            this.getVectorOfStackSections();
        }
        return this.stackSections.iterator();
    }

    public Properties getProperties() {
        return new Properties();
    }

    public int hashCode() {
        return (int)this.threadID ^ this.context.hashCode();
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof ImageThreadEffigy) {
            ImageThreadEffigy local = (ImageThreadEffigy)obj;
            isEqual = this.registers.equals(((SDFFThread)local.getProxy()).registers);
        }
        return isEqual;
    }

    public JavaStackProxy getJavaStack() {
        return this.javaStack;
    }

    public Iterator getJavaFrames() {
        this.javaStack.setRuntime(this.jvm);
        return this.javaStack.iterator();
    }

    public Iterator getRegisters() {
        return this.registers.iterator();
    }

    public void setRuntime(JavaRuntimeProxyImpl jvm) {
        this.jvm = jvm;
    }
}

