/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.sdffReader;

import com.ibm.dtfj.sov.sdffReader.SdffArchive;
import com.ibm.dtfj.sov.utils.FileCRC32;
import com.ibm.dtfj.sov.utils.Trace;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class SdffArchiveInputStream {
    private JarInputStream jarIn;
    private String extractSdffHeaderName;
    private String extractOriginalDumpName;
    private long sdffHeaderCrc32FromManifest;
    private long originalDumpCrc32FromManifest;
    private String sdffHeaderNameFromManifest;
    private String originalDumpNameFromManifest;
    private int newSdffFormatVersion;
    private long dumpTimestamp = -1L;
    private long headerTimestamp = -1L;
    static int BUFFER_SIZE = 32768;

    public SdffArchiveInputStream(File SDFFFile) throws IOException {
        JarEntry currentJarEntry;
        Trace.writeToTrace("Entry to SdffArchiveInputStream constructor (" + SDFFFile + ")");
        this.jarIn = null;
        this.jarIn = new JarInputStream(new FileInputStream(SDFFFile));
        Trace.writeToTrace("SdffArchiveInputStream opened Jar, getting manifest (" + SDFFFile + ")");
        Manifest jarManifest = this.jarIn.getManifest();
        Trace.writeToTrace("SdffArchiveInputStream got manifest (" + SDFFFile + ")");
        Attributes jarManifestMainAttributes = jarManifest.getMainAttributes();
        String newSdffVersion = jarManifestMainAttributes.getValue(Attributes.Name.MANIFEST_VERSION);
        if (!newSdffVersion.equals("1")) {
            Trace.writeToTrace("SdffArchiveInputStream: sdff manifest version is " + newSdffVersion + " but should be " + "1");
            throw new IOException("sdff manifest version is " + newSdffVersion + " but should be " + "1");
        }
        Trace.writeToTrace("SdffArchiveInputStream manifest version OK for (" + SDFFFile + ")");
        String newSdffVendor = jarManifestMainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        if (!newSdffVendor.equals("IBM JTC (Hursley Park, UK)")) {
            Trace.writeToTrace("SdffArchiveInputStream:sdff manifest vendor is " + newSdffVendor + " but should be " + "IBM JTC (Hursley Park, UK)");
            throw new IOException("sdff manifest vendor is " + newSdffVendor + " but should be " + "IBM JTC (Hursley Park, UK)");
        }
        Trace.writeToTrace("SdffArchiveInputStream manifest vendor OK for (" + SDFFFile + ")");
        this.newSdffFormatVersion = Integer.parseInt(jarManifestMainAttributes.getValue(SdffArchive.FORMAT_VERSION));
        if (this.newSdffFormatVersion != 1 && this.newSdffFormatVersion != 2) {
            Trace.writeToTrace("SdffArchiveInputStream:sdff format version is " + this.newSdffFormatVersion + " but should be " + 1 + "or" + 2);
            throw new RuntimeException("sdff format version is " + this.newSdffFormatVersion + " but should be " + 1 + "or" + 2);
        }
        Trace.writeToTrace("SdffArchiveInputStream format version OK for (" + SDFFFile + ")");
        this.sdffHeaderNameFromManifest = jarManifestMainAttributes.getValue(SdffArchive.SDFF_HEADER_NAME);
        this.sdffHeaderCrc32FromManifest = Long.parseLong(jarManifestMainAttributes.getValue(SdffArchive.SDFF_HEADER_CRC32));
        this.originalDumpNameFromManifest = jarManifestMainAttributes.getValue(SdffArchive.ORIGINAL_DUMP_NAME);
        this.originalDumpCrc32FromManifest = Long.parseLong(jarManifestMainAttributes.getValue(SdffArchive.ORIGINAL_DUMP_CRC32));
        SdffArchiveData sda = null;
        try {
            Trace.writeToTrace("SdffArchiveInputStream getting SDFF header (" + SDFFFile + ")");
            currentJarEntry = this.jarIn.getNextJarEntry();
            this.headerTimestamp = currentJarEntry.getTime();
            sda = new SdffArchiveData(new String(currentJarEntry.getExtra()));
            if (sda.contentType == null || !sda.contentType.equals("SDFF Header")) {
                Trace.writeToTrace("SdffArchiveInputStream:Did not find an sdff header");
                throw new IOException("Did not find an sdff header");
            }
            File sdffHeader = new File(currentJarEntry.getName());
            this.extractSdffHeaderName = sdffHeader.getName();
        }
        catch (Throwable e) {
            e.printStackTrace();
            Trace.writeToTrace("SdffArchiveInputStream didn't get header for (" + SDFFFile + ")" + " expected content type '" + "SDFF Header" + "'" + " but found '" + sda.contentType + "'");
            throw new IOException(e.toString());
        }
        if (!this.extractSdffHeaderName.equals(this.sdffHeaderNameFromManifest)) {
            Trace.writeToTrace("SdffArchiveInputStream - Sdff header name " + this.extractSdffHeaderName + " differs from that in the manifest " + this.sdffHeaderNameFromManifest);
            throw new RuntimeException("Corrupted Sdff Archive - invalid sdff header name");
        }
        this.extractSdffHeaderName = this.normalize(this.extractSdffHeaderName);
        try {
            Trace.writeToTrace("SdffArchiveInputStream getting original dump (" + SDFFFile + ")");
            currentJarEntry = this.jarIn.getNextJarEntry();
            this.dumpTimestamp = currentJarEntry.getTime();
            sda = new SdffArchiveData(new String(currentJarEntry.getExtra()));
            if (sda.contentType == null || !sda.contentType.equals("Original Dump")) {
                Trace.writeToTrace("SdffArchiveInputStream:Did not find the original dump");
                throw new IOException("Did not find the original dump");
            }
            File originalDump = new File(currentJarEntry.getName());
            this.extractOriginalDumpName = originalDump.getName();
        }
        catch (Throwable e) {
            e.printStackTrace();
            Trace.writeToTrace("SdffArchiveInputStream didn't get original dump for (" + SDFFFile + ")" + " expected content type '" + "Original Dump" + "'" + " but found '" + sda.contentType + "'");
            throw new IOException(e.toString());
        }
        if (!this.extractOriginalDumpName.equals(this.originalDumpNameFromManifest)) {
            Trace.writeToTrace("SdffArchiveInputStream - original dump name " + this.extractOriginalDumpName + " differs from that in the manifest " + this.originalDumpNameFromManifest);
            throw new IOException("Corrupted Sdff Archive - invalid original dump name");
        }
        this.extractOriginalDumpName = this.normalize(this.extractOriginalDumpName);
        this.close();
        this.jarIn = new JarInputStream(new FileInputStream(SDFFFile));
    }

    private String normalize(String fileName) {
        StringBuffer normalizedName = new StringBuffer(fileName);
        char[] badChar = ")?<>\\/\":|".toCharArray();
        boolean swapped = false;
        block0: for (int i = 0; i < normalizedName.length(); ++i) {
            for (int j = 0; j < badChar.length; ++j) {
                if (normalizedName.charAt(i) != badChar[j]) continue;
                normalizedName.setCharAt(i, '_');
                swapped = true;
                continue block0;
            }
        }
        if (swapped) {
            System.err.println("WARNING: filename \"" + fileName + "\" contains bad characters and has been transformed to \"" + normalizedName.toString() + "\"");
            return normalizedName.toString();
        }
        return fileName;
    }

    public void extractHeader(boolean andDump, String sdffDir, String dumpDir, String libDir) throws IOException {
        JarEntry currentJarEntry = this.jarIn.getNextJarEntry();
        SdffArchiveData sda = new SdffArchiveData(new String(currentJarEntry.getExtra()));
        this.checkedExtractFile(this.extractSdffHeaderName, this.sdffHeaderCrc32FromManifest, sda.size, sdffDir, false);
        if (andDump) {
            currentJarEntry = this.jarIn.getNextJarEntry();
            sda = new SdffArchiveData(new String(currentJarEntry.getExtra()));
            this.checkedExtractFile(this.extractOriginalDumpName, this.originalDumpCrc32FromManifest, sda.size, dumpDir, false);
        }
        if (libDir != null) {
            Trace.writeToTrace("SdffArchiveInputStream: Extracting libraries to " + libDir);
            while ((currentJarEntry = this.jarIn.getNextJarEntry()) != null) {
                sda = new SdffArchiveData(new String(currentJarEntry.getExtra()));
                if (!sda.contentType.equals("Library")) continue;
                this.checkedExtractFile(currentJarEntry.getName(), sda.crc, sda.size, libDir, false);
            }
        }
    }

    private void checkedExtractFile(String fileName, long expectedChecksum, long expectedSize, String extractDir, boolean force) throws IOException {
        Trace.writeToTrace("SdffArchiveInputStream.checkedExtractFile  File is " + fileName + " Extract directory is " + extractDir + " expectedChecksum is " + expectedChecksum + " (0x" + Long.toHexString(expectedChecksum) + ")" + " expectedSize is " + expectedSize);
        String fullPath = extractDir != null ? extractDir + File.separator + fileName : fileName;
        File extractFile = new File(fullPath);
        if (!extractFile.exists()) {
            this.doExtract(extractFile, expectedChecksum, expectedSize);
            return;
        }
        try {
            this.checkExtractedFile(extractFile, expectedChecksum, expectedSize);
            Trace.writeToTrace(extractFile.getPath() + " already exists with correct checksum and size - will not extract");
            return;
        }
        catch (IOException e) {
            if (force) {
                Trace.writeToTrace(extractFile.getPath() + " already exists but with the wrong checksum or size -" + " as force is set, will extract over it");
                this.doExtract(extractFile, expectedChecksum, expectedSize);
                return;
            }
            Trace.writeToTrace(extractFile.getPath() + " already exists but with the wrong checksum or size - cannot extract without force option");
            throw new IOException(extractFile.getPath() + " already exists but with the wrong checksum or size - cannot extract without force option");
        }
    }

    private void doExtract(File extractFile, long expectedChecksum, long expectedSize) throws IOException {
        byte[] buf = new byte[BUFFER_SIZE];
        BufferedOutputStream os = null;
        os = new BufferedOutputStream(new FileOutputStream(extractFile), buf.length);
        try {
            int len;
            while ((len = this.jarIn.read(buf, 0, buf.length)) != -1) {
                os.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            Trace.writeToTrace("SdffArchiveInputStream.doExtract: " + e);
            e.printStackTrace();
        }
        try {
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.checkExtractedFile(extractFile, expectedChecksum, expectedSize);
    }

    private void checkExtractedFile(File extractFile, long expectedChecksum, long expectedSize) throws IOException {
        long theChecksum;
        if (this.newSdffFormatVersion == 1) {
            theChecksum = new FileCRC32(extractFile).getValue();
        } else {
            if (extractFile.length() != expectedSize) {
                Trace.writeToTrace("SdffArchiveInputStream.doExtract: Length for " + extractFile.getName() + " is " + extractFile.length() + " but was expected to be " + expectedSize);
                throw new IOException("SdffArchiveInputStream.doExtract: Length for " + extractFile.getName() + " is " + extractFile.length() + " but was expected to be " + expectedSize);
            }
            theChecksum = new FileCRC32(extractFile, 4096L).getValue();
        }
        if (theChecksum != expectedChecksum) {
            Trace.writeToTrace("SdffArchiveInputStream.doExtract: Checksum for " + extractFile.getName() + " is calculated as " + theChecksum + " but was expected to be " + expectedChecksum);
            throw new IOException("SdffArchiveInputStream.doExtract: Checksum for " + extractFile.getName() + " is calculated as " + theChecksum + " but was expected to be " + expectedChecksum);
        }
    }

    public void close() {
        try {
            this.jarIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getExtractSdffHeaderName() {
        return this.extractSdffHeaderName;
    }

    public String getExtractOriginalDumpName() {
        return this.extractOriginalDumpName;
    }

    int getNewSdffFormatVersion() {
        return this.newSdffFormatVersion;
    }

    long getDumpTimestamp() {
        if (this.headerTimestamp != this.dumpTimestamp) {
            return this.dumpTimestamp;
        }
        return -1L;
    }

    private class SdffArchiveData {
        String contentType;
        long crc;
        long size;

        SdffArchiveData(String extraData) {
            StringTokenizer st = new StringTokenizer(extraData, "/");
            this.contentType = st.nextToken();
            String crcAsString = st.nextToken();
            this.crc = Long.parseLong(crcAsString);
            if (SdffArchiveInputStream.this.getNewSdffFormatVersion() == 1) {
                this.size = 0L;
            } else {
                String sizeAsString = st.nextToken();
                this.size = Long.parseLong(sizeAsString);
            }
        }
    }
}

