/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.sdffReader;

import com.ibm.dtfj.sov.sdffReader.SdffConstants;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class SdffStd {
    public long sectionLen;
    public long sectionType;
    public byte[] sectionEye = new byte[8];
    public long sectionVer;

    public static long getSize() {
        return 32L;
    }

    public SdffStd(long type, long ver) {
        String[] SEGMENT_EYECATCHER = new String[]{SdffConstants.SEGMENT_Eye_SdffHead, SdffConstants.SEGMENT_Eye_SdffPrth, SdffConstants.SEGMENT_Eye_SdffMmem, SdffConstants.SEGMENT_Eye_SdffMem, SdffConstants.SEGMENT_Eye_SdffRas};
        this.sectionType = type;
        this.sectionEye = SEGMENT_EYECATCHER[(int)type].getBytes();
        this.sectionVer = ver;
    }

    public SdffStd(byte[] bytes) throws IOException {
        ByteArrayInputStream ba = new ByteArrayInputStream(bytes);
        DataInputStream da = new DataInputStream(ba);
        this.sectionLen = da.readLong();
        this.sectionType = da.readLong();
        da.readFully(this.sectionEye);
        this.sectionVer = da.readLong();
    }

    public boolean checkMatch() {
        boolean bresult = true;
        String y = new String(this.sectionEye);
        if (y.equals(SdffConstants.SEGMENT_Eye_SdffHead)) {
            if ((int)this.sectionType != SdffConstants.SEGMENT_SdffHead) {
                bresult = false;
            }
        } else if (y.equals(SdffConstants.SEGMENT_Eye_SdffPrth)) {
            if ((int)this.sectionType != SdffConstants.SEGMENT_Sdffprth) {
                bresult = false;
            }
        } else if (y.equals(SdffConstants.SEGMENT_Eye_SdffMmem)) {
            if ((int)this.sectionType != SdffConstants.SEGMENT_Sdffmmap) {
                bresult = false;
            }
        } else if (y.equals(SdffConstants.SEGMENT_Eye_SdffMem)) {
            if ((int)this.sectionType != SdffConstants.SEGMENT_Sdffmem) {
                bresult = false;
            }
        } else if (y.equals(SdffConstants.SEGMENT_Eye_SdffRas)) {
            if ((int)this.sectionType != SdffConstants.SEGMENT_SdffRas) {
                bresult = false;
            }
        } else {
            bresult = false;
        }
        return bresult;
    }
}

