/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.svcReader;

import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.data.DataObjectDescriptor;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.image.ImageProcessProxy;
import com.ibm.dtfj.sov.image.WordLength;
import com.ibm.dtfj.sov.image.WordType;
import com.ibm.dtfj.sov.imp.ImagePointerEffigy;
import com.ibm.dtfj.sov.imp.ImageProcessEffigy;
import com.ibm.dtfj.sov.java.JavaRuntimeProxy;
import com.ibm.dtfj.sov.java.Ras;
import com.ibm.dtfj.sov.svcReader.SvcImageImpl;
import com.ibm.dtfj.sov.svcReader.SvcProcessImpl;
import com.ibm.jvm.svcdump.AddressSpace;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public class SvcAddressSpaceImpl
implements AddressSpaceProxy {
    SvcImageImpl image;
    AddressSpace space;
    ImageProcess process;
    private JavaRuntimeProxy jvmProxy;
    long currentOffset = 0L;

    SvcAddressSpaceImpl(SvcImageImpl image, AddressSpace space) {
        this.image = image;
        this.space = space;
        AddressSpaceProxy copyOfMe = this.getCopy();
        this.process = (ImageProcess)((Object)Effigy.create("ImageProcessEffigy", new SvcProcessImpl(image, space, this), copyOfMe, this.getPlatformName()));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id " + this.space.getId() + "\n");
        return sb.toString();
    }

    public Iterator getProcesses() {
        return new Iterator(){
            boolean more = true;

            public boolean hasNext() {
                return this.more;
            }

            public Object next() {
                this.more = false;
                return SvcAddressSpaceImpl.this.process;
            }

            public void remove() {
                throw new Error("operation not supported");
            }
        };
    }

    public ImageProcess getCurrentProcess() {
        return this.process;
    }

    public byte[] getMetaData() {
        return null;
    }

    public long readByte(long address) throws MemoryAccessException {
        try {
            return this.space.readByte(address);
        }
        catch (Exception e) {
            throw new MemoryAccessException(this.getImagePointer(address), "Exception " + e + ", could not read address 0x" + SvcAddressSpaceImpl.hex(address));
        }
    }

    public long readInt(long address) throws MemoryAccessException {
        try {
            long l = this.space.readInt(address);
            return l & 0xFFFFFFFFL;
        }
        catch (Exception e) {
            throw new MemoryAccessException(this.getImagePointer(address), "Exception " + e + ", could not read address 0x" + SvcAddressSpaceImpl.hex(address));
        }
    }

    public long readLong(long address) throws MemoryAccessException {
        try {
            return this.space.readLong((int)address);
        }
        catch (Exception e) {
            throw new MemoryAccessException(this.getImagePointer(address), "Exception " + e + ", could not read address 0x" + SvcAddressSpaceImpl.hex(address));
        }
    }

    public long readShort(long address) throws MemoryAccessException {
        try {
            long l = this.space.readShort((int)address);
            return l & 0xFFFFFFFFL;
        }
        catch (Exception e) {
            throw new MemoryAccessException(this.getImagePointer(address), "Exception " + e + ", could not read address 0x" + SvcAddressSpaceImpl.hex(address));
        }
    }

    public String readString(long address) throws MemoryAccessException {
        try {
            return this.space.readString((int)address);
        }
        catch (Exception e) {
            throw new MemoryAccessException(this.getImagePointer(address), "Exception " + e + ", could not read address 0x" + SvcAddressSpaceImpl.hex(address));
        }
    }

    public char[] readCharArray(long address) throws MemoryAccessException {
        try {
            this.space.seek(address);
        }
        catch (IOException e) {
            System.err.println("SvcAddressSpaceImpl.readCharArray(0x" + SvcAddressSpaceImpl.hex(address) + ") Exception");
            throw new MemoryAccessException(this.getImagePointer(address), "Exception " + e + ", could not read address 0x" + SvcAddressSpaceImpl.hex(address));
        }
        return this.readCharArray();
    }

    private char[] readCharArray() throws MemoryAccessException {
        int arraySize = (int)this.readInt();
        this.readInt();
        char[] result = new char[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            result[i] = (char)this.readShort();
        }
        return result;
    }

    private long readInt() throws MemoryAccessException {
        try {
            return this.space.readInt();
        }
        catch (IOException e) {
            System.err.println("SvcAddressSpaceImpl.readInt() Exception");
            throw new MemoryAccessException(null, "Exception " + e + ", could not read address 0x");
        }
    }

    private long readLong() throws MemoryAccessException {
        try {
            return this.space.readLong();
        }
        catch (IOException e) {
            System.err.println("SvcAddressSpaceImpl.readInt() Exception");
            throw new MemoryAccessException(null, "Exception " + e + ", could not read address 0x");
        }
    }

    private long readShort() throws MemoryAccessException {
        try {
            return this.space.readShort();
        }
        catch (IOException e) {
            System.err.println("SvcAddressSpaceImpl.readInt() Exception");
            throw new MemoryAccessException(null, "Exception " + e + ", could not read address 0x");
        }
    }

    public long readPointer(long address) throws MemoryAccessException {
        try {
            return this.readInt(address) & 0xFFFFFFFFL;
        }
        catch (Exception e) {
            throw new MemoryAccessException(this.getImagePointer(address), "Exception " + e + ", could not read address 0x" + SvcAddressSpaceImpl.hex(address));
        }
    }

    public byte[] readBytes(long address, long len) throws MemoryAccessException {
        try {
            return this.space.readBytes(address, len);
        }
        catch (Exception e) {
            System.err.println("SvcAddressSpaceImpl.readCharArray(0x" + SvcAddressSpaceImpl.hex(address) + ") Exception");
            throw new MemoryAccessException(this.getImagePointer(address), "Exception " + e + ", could not read address 0x" + SvcAddressSpaceImpl.hex(address));
        }
    }

    private ImagePointer getImagePointer(long address) {
        ImagePointerEffigy myPointer = (ImagePointerEffigy)Effigy.create("ImagePointerEffigy", this.getPointer(address), (AddressSpaceProxy)this, this.getPlatformName());
        return myPointer;
    }

    public Ras getRas() {
        return this.image.getRas();
    }

    public WordLength getWordLength() {
        return this.image.getWordLength();
    }

    public WordType getWordType() {
        return this.image.getWordType();
    }

    public String id() {
        return this.space.toString();
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    public String getPlatformName() {
        return "zos";
    }

    public void setJavaRuntimeProxy(JavaRuntimeProxy jvmProxy) {
        this.jvmProxy = jvmProxy;
    }

    public JavaRuntimeProxy getJavaRuntimeProxy() {
        return this.jvmProxy;
    }

    public ImagePointerProxy getPointer(long address) {
        return new ImagePointerProxy(address, this);
    }

    public DataObjectDescriptor getDescriptor(String name) {
        return this.image.getDescriptor(name);
    }

    public Iterator getImageSections() {
        Vector theVector = new Vector();
        return theVector.iterator();
    }

    public ImageProcessProxy getCurrentProcessProxy() {
        return ((ImageProcessEffigy)this.process).getProxy();
    }

    public AddressSpaceProxy getCopy() {
        try {
            return (AddressSpaceProxy)this.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("SvcAddressSpaceImpl.getCopy() couldn't clone oneself.");
            e.printStackTrace();
            return null;
        }
    }

    public int hashCode() {
        return this.space.getId();
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof AddressSpaceProxy) {
            AddressSpaceProxy local = (AddressSpaceProxy)obj;
            isEqual = this.space.getId() == ((SvcAddressSpaceImpl)local).space.getId();
        }
        return isEqual;
    }
}

