/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.svcReader;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.sov.data.DataLocator;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.BigEnd;
import com.ibm.dtfj.sov.image.ImageProxy;
import com.ibm.dtfj.sov.image.ImageProxyImpl;
import com.ibm.dtfj.sov.image.UnsupportedFormatException;
import com.ibm.dtfj.sov.image.WordLength;
import com.ibm.dtfj.sov.image.WordType;
import com.ibm.dtfj.sov.java.ProxyFactory;
import com.ibm.dtfj.sov.java.Ras;
import com.ibm.dtfj.sov.svcReader.SvcAddressSpaceImpl;
import com.ibm.dtfj.sov.svcReader.SvcRas;
import com.ibm.jvm.dump.format.DvRas;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Tcb;
import java.io.File;
import java.util.Iterator;

public class SvcImageImpl
extends ImageProxyImpl
implements ImageProxy {
    Dump svcDump = null;
    WordLength wordLength = new WordLength(32);
    WordType wordType = new BigEnd();

    public SvcImageImpl(File sourceFile) throws UnsupportedFormatException {
        String filename = sourceFile.getPath();
        try {
            this.svcDump = new Dump(filename);
            ProxyFactory.setImageType(this.getImageType());
        }
        catch (Exception e) {
            throw new UnsupportedFormatException(filename + " does not appear to be an svcdump");
        }
    }

    public Iterator getAddressSpaces() {
        final AddressSpace[] spaces = (AddressSpace[])this.svcDump.getAddressSpaces();
        return new Iterator(){
            int index;

            public boolean hasNext() {
                while (this.index < spaces.length && !SvcImageImpl.this.isJavaInAddressSpace(spaces[this.index])) {
                    ++this.index;
                }
                return this.index < spaces.length;
            }

            public Object next() {
                SvcAddressSpaceImpl obj = null;
                if (this.hasNext()) {
                    obj = new SvcAddressSpaceImpl(SvcImageImpl.this, spaces[this.index++]);
                }
                return obj;
            }

            public void remove() {
                throw new Error("operation not supported");
            }
        };
    }

    public String getArchitecture() {
        return "32-bit big-endian";
    }

    public String getSystemType() {
        return "zos";
    }

    public String getProcessorSubType() {
        return "unknown subtype";
    }

    public int getCurrentProcessor() {
        return -1;
    }

    public int getProcessorCount() {
        return -1;
    }

    public byte[] getMetaData() {
        return null;
    }

    public byte[] getCTypedefs() {
        return this.svcDump.getCTypedefs();
    }

    public Ras getRas() {
        DvRas svcRas = this.svcDump.getRas();
        SvcRas theRas = new SvcRas(this, svcRas);
        return theRas;
    }

    public WordType getWordType() {
        return this.wordType;
    }

    public WordLength getWordLength() {
        return this.wordLength;
    }

    public int getImageType() {
        return 1;
    }

    public String getImageDescription() {
        String returnString = "";
        return "Z/OS svcDump file [version " + returnString + "]";
    }

    public String getSystemSubType() {
        return "zos";
    }

    public String getProcessorType() {
        return "390 processor";
    }

    public long getInstalledMemory() throws DataUnavailable {
        throw new DataUnavailable("Unimplemented method getInstalledMemory()");
    }

    public long getCreationTime() throws DataUnavailable {
        return this.svcDump.getCreationTime();
    }

    public boolean isJavaInAddressSpace(AddressSpace space) {
        boolean theReturn = false;
        Tcb[] theTcb = space.tcbs();
        if (null == theTcb) {
            return theReturn;
        }
        for (int i = 0; i < theTcb.length; ++i) {
            if (!theTcb[i].isJava()) continue;
            theReturn = true;
        }
        return theReturn;
    }

    protected DataLocator getHpiReader() throws CorruptDataException {
        Iterator iter;
        DataLocator hpiReader = null;
        if (this.context == null && (iter = this.getAddressSpaces()).hasNext()) {
            this.context = (AddressSpaceProxy)iter.next();
        }
        if (this.context == null) {
            return null;
        }
        DataObject hpiras = new DataObject(null, "hpi_ras_t", this.context);
        hpiras.setAddress(this.getRas().hpiRas);
        hpiReader = (DataLocator)hpiras.getReader();
        return hpiReader;
    }
}

