/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.svcReader;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.EnvVarProxy;
import com.ibm.dtfj.sov.image.ImageModuleProxy;
import com.ibm.dtfj.sov.image.ImageProcessProxy;
import com.ibm.dtfj.sov.image.ImageSectionImpl;
import com.ibm.dtfj.sov.image.ImageThreadProxy;
import com.ibm.dtfj.sov.imp.JavaRuntimeEffigy;
import com.ibm.dtfj.sov.java.JavaThreadProxy;
import com.ibm.dtfj.sov.java.Ras;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaThreadProxyImpl;
import com.ibm.dtfj.sov.svcReader.SvcImageImpl;
import com.ibm.dtfj.sov.svcReader.SvcThreadImpl;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Cp1047;
import com.ibm.jvm.svcdump.Dll;
import com.ibm.jvm.svcdump.Tcb;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class SvcProcessImpl
implements ImageProcessProxy {
    SvcImageImpl image;
    AddressSpace space;
    AddressSpaceProxy context;
    JavaRuntimeEffigy javaVM = null;
    ArrayList threads;
    Tcb[] theTcbs;
    int samplecaa = 0;
    Properties envVars = null;
    private long jvm = -1L;
    ArrayList runtimes = null;
    Iterator envVarsIterator = null;
    private String commandLine = null;
    boolean populatedJavaThreads = false;
    ArrayList javaThreads = null;
    HashMap execenv_and_threads = new HashMap();

    SvcProcessImpl(SvcImageImpl image, AddressSpace space, AddressSpaceProxy context) {
        this.image = image;
        this.space = space;
        this.context = context;
        this.theTcbs = space.tcbs();
        this.threads = new ArrayList();
        for (int i = 0; i < this.theTcbs.length; ++i) {
            this.threads.add(new SvcThreadImpl(image, this.theTcbs[i], context));
        }
    }

    public String javaHomeDir() {
        return "Not Available";
    }

    public String javaDllDir() {
        return "Not Available";
    }

    public String javaVersion() {
        return "Not Available";
    }

    public String classPath() {
        return "";
    }

    public String getID() {
        return Integer.toHexString(this.space.getId());
    }

    public Iterator getThreads() {
        return this.threads.iterator();
    }

    public boolean getIsJava() {
        boolean theReturn = false;
        if (null == this.theTcbs) {
            return theReturn;
        }
        for (int i = 0; i < this.theTcbs.length; ++i) {
            if (!this.theTcbs[i].isJava()) continue;
            theReturn = true;
        }
        return theReturn;
    }

    public ImageThreadProxy getCurrentThread() {
        return null;
    }

    public Properties getEnvironment() throws DataUnavailable, CorruptDataException {
        if (this.envVars == null) {
            try {
                this.envVars = new Properties();
                int ceeedb = this.space.readInt((long)(this.samplecaa + 752));
                int envar = this.space.readInt((long)(ceeedb + 88));
                int env = 0;
                while ((env = this.space.readInt((long)envar)) != 0) {
                    int c;
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    while ((c = this.space.readUnsignedByte((long)env++)) != 0) {
                        bytes.write(c);
                    }
                    String name = Cp1047.getString((byte[])bytes.toByteArray());
                    int eq = name.indexOf(61);
                    if (eq >= 0) {
                        String key = name.substring(0, eq);
                        String value = name.substring(eq + 1);
                        this.envVars.setProperty(key, value);
                    }
                    envar += 4;
                }
            }
            catch (IOException e) {
                System.err.println("SvcProcessImpl.getEnvironment() IOException");
            }
        }
        return this.envVars;
    }

    public String getSignalName() {
        switch (this.getSignalNumber()) {
            case 0: {
                return "NULL";
            }
            case 1: {
                return "HUP";
            }
            case 2: {
                return "INT";
            }
            case 3: {
                return "ABRT";
            }
            case 4: {
                return "ILL";
            }
            case 5: {
                return "POLL";
            }
            case 6: {
                return "URG";
            }
            case 7: {
                return "STOP";
            }
            case 8: {
                return "FPE";
            }
            case 9: {
                return "KILL";
            }
            case 10: {
                return "BUS";
            }
            case 11: {
                return "SEGV";
            }
            case 12: {
                return "SYS";
            }
            case 13: {
                return "PIPE";
            }
            case 14: {
                return "ALRM";
            }
            case 15: {
                return "TERM";
            }
            case 16: {
                return "USR1";
            }
            case 17: {
                return "USR2";
            }
            case 18: {
                return "ABND";
            }
            case 19: {
                return "CONT";
            }
            case 20: {
                return "CHLD";
            }
            case 21: {
                return "TTIN";
            }
            case 22: {
                return "TTOU";
            }
            case 23: {
                return "IO";
            }
            case 24: {
                return "QUIT";
            }
            case 25: {
                return "TSTP";
            }
            case 26: {
                return "TRAP";
            }
            case 27: {
                return "IOERR";
            }
            case 28: {
                return "WINCH";
            }
            case 29: {
                return "XCPU";
            }
            case 30: {
                return "XFSZ";
            }
            case 31: {
                return "VTALRM";
            }
            case 32: {
                return "PROF";
            }
            case 33: {
                return "DCE";
            }
            case 34: {
                return "DUMP";
            }
        }
        return "";
    }

    public int getSignalNumber() {
        return -1;
    }

    public Iterator getLibraries() {
        Dll[] dlls;
        ArrayList<ImageModuleProxy> libs = new ArrayList<ImageModuleProxy>();
        try {
            dlls = this.space.dlls();
        }
        catch (Exception e) {
            return new ArrayList().iterator();
        }
        int libCount = dlls.length;
        for (int i = 0; i < libCount; ++i) {
            ArrayList<ImageSectionImpl> sectionVec = new ArrayList<ImageSectionImpl>();
            sectionVec.add(new ImageSectionImpl(this.context, dlls[i].getWsa(), -1L, "unknown", false, false, false, false));
            libs.add(new ImageModuleProxy(dlls[i].getName(), sectionVec));
        }
        return libs.iterator();
    }

    public Iterator getLocks() {
        return new ArrayList().iterator();
    }

    public Iterator getRuntimes() {
        if (this.runtimes == null) {
            this.runtimes = new ArrayList();
        }
        Iterator threadsIterator = this.getThreads();
        ImageThreadProxy t = null;
        while (threadsIterator.hasNext()) {
            t = (ImageThreadProxy)threadsIterator.next();
            if (!t.getIsJava()) continue;
            try {
                DataObject execEnvDO = new DataObject(null, "execenv", this.context);
                execEnvDO.setAddress(t.getEEAddress());
                this.jvm = execEnvDO.getReader().getLong("(Long)jvmP");
                this.javaVM = (JavaRuntimeEffigy)Effigy.create("JavaRuntimeEffigy", this.context.getPointer(this.jvm).getAddress(), this.context, this.context.getPlatformName());
                this.javaVM.setProcessAndJVM(this, this.jvm);
                this.runtimes.add(this.javaVM);
                break;
            }
            catch (CorruptDataException e) {
                System.err.println("SvcProcessImpl.getRuntimes() CorruptDataException");
            }
            catch (MemoryAccessException e) {
                System.err.println("SvcProcessImpl.getRuntimes() MemoryAccessException");
            }
        }
        return this.runtimes.iterator();
    }

    public Ras getRas() {
        return this.image.getRas();
    }

    public byte[] getMetaData() {
        return null;
    }

    private Iterator getEnvVarsIterator() {
        if (this.envVarsIterator == null) {
            ArrayList<EnvVarProxy> envVarsArrayList = new ArrayList<EnvVarProxy>();
            try {
                Iterator<Map.Entry<Object, Object>> envIterator = this.getEnvironment().entrySet().iterator();
                while (envIterator.hasNext()) {
                    envVarsArrayList.add(new EnvVarProxy(envIterator.next().toString()));
                }
                this.envVarsIterator = envVarsArrayList.iterator();
            }
            catch (DataUnavailable e) {
                System.err.println("SvcProcessImpl.getEnvVarsIterator() DataUnavailable");
            }
            catch (CorruptDataException e) {
                System.err.println("SvcProcessImpl.getEnvVarsIterator() CorruptDataException");
            }
        }
        return this.envVarsIterator;
    }

    public String getCommandLine() {
        if (this.commandLine == null) {
            this.commandLine = "Not Available";
            Iterator envVarIterator = this.getEnvVarsIterator();
            while (envVarIterator.hasNext()) {
                EnvVarProxy envVar = (EnvVarProxy)envVarIterator.next();
                if (!envVar.getName().equals("IBM_JAVA_COMMAND_LINE")) continue;
                this.commandLine = envVar.getValue();
            }
        }
        return this.commandLine;
    }

    public ImageModuleProxy getExecutable() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("SvcProcessImpl.getExecutable() missing executable information.");
    }

    public int getPointerSize() {
        return this.context.getWordLength().size * 8;
    }

    public Iterator getJavaThreads() {
        if (!this.populatedJavaThreads) {
            this.populateArrayListOfJavaThreads();
        }
        if (0 == this.javaThreads.size()) {
            System.err.println("There are no java threads associated with this runtime");
            return null;
        }
        return this.javaThreads.iterator();
    }

    public void populateArrayListOfJavaThreads() {
        Iterator thrs = this.threads.iterator();
        this.javaThreads = new ArrayList();
        JavaRuntimeProxyImpl runtime = (JavaRuntimeProxyImpl)this.javaVM.getProxy();
        while (thrs.hasNext()) {
            SvcThreadImpl t = (SvcThreadImpl)thrs.next();
            if (!t.getIsJava()) continue;
            try {
                JavaThreadProxyImpl jt = new JavaThreadProxyImpl(t, this.context, runtime);
                this.javaThreads.add(jt);
                this.execenv_and_threads.put(new Long(t.getEEAddress()), jt);
            }
            catch (CorruptDataException e) {
                this.javaThreads.add(e.getCorruptData());
            }
        }
        this.populatedJavaThreads = true;
    }

    public JavaThreadProxy getJavaThread(Long eeAddress) {
        if (!this.populatedJavaThreads) {
            this.populateArrayListOfJavaThreads();
        }
        if (0 == this.javaThreads.size()) {
            System.err.println("There are no java threads associated with this runtime");
            return null;
        }
        return (JavaThreadProxy)this.execenv_and_threads.get(eeAddress);
    }
}

