/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.svcReader;

import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.ImageRegisterProxy;
import com.ibm.dtfj.sov.image.ImageStackFrameProxy;
import com.ibm.dtfj.sov.image.ImageThreadProxy;
import com.ibm.dtfj.sov.image.NativeStackProxy;
import com.ibm.dtfj.sov.imp.ImageThreadEffigy;
import com.ibm.dtfj.sov.java.JavaStackFrameProxy;
import com.ibm.dtfj.sov.java.JavaStackProxy;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import com.ibm.dtfj.sov.svcReader.SvcImageImpl;
import com.ibm.jvm.svcdump.Caa;
import com.ibm.jvm.svcdump.JavaFrame;
import com.ibm.jvm.svcdump.JavaStack;
import com.ibm.jvm.svcdump.NativeFrame;
import com.ibm.jvm.svcdump.NativeStack;
import com.ibm.jvm.svcdump.Tcb;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class SvcThreadImpl
implements ImageThreadProxy {
    SvcImageImpl image;
    Tcb tcb = null;
    AddressSpaceProxy context = null;
    Caa caa = null;
    NativeStackProxy nativeStackProxy = null;
    JavaStackProxy javaStackProxy = null;
    private JavaRuntimeProxyImpl jvm;

    SvcThreadImpl(SvcImageImpl theImage, Tcb theTcb, AddressSpaceProxy theContext) {
        this.image = theImage;
        this.tcb = theTcb;
        this.context = theContext;
    }

    public String getId() {
        return this.tcb.hexId();
    }

    public String getID() {
        return this.tcb.hexId();
    }

    public boolean getIsJava() {
        return this.tcb.isJava();
    }

    public long getEEAddress() {
        if (this.getIsJava()) {
            return this.tcb.ee();
        }
        return 0L;
    }

    public NativeStackProxy getNativeStack() {
        if (this.nativeStackProxy == null) {
            NativeStack nativeStack = (NativeStack)this.tcb.getNativeStack();
            int frameCount = (int)nativeStack.getNumFrames();
            this.nativeStackProxy = new NativeStackProxy(frameCount);
            for (int i = 0; i < frameCount; ++i) {
                NativeFrame nativeFrame = (NativeFrame)nativeStack.getFrame(i);
                ImageStackFrameProxy nativeFrameProxy = new ImageStackFrameProxy(this.context);
                nativeFrameProxy.setFrameType(nativeFrame.getFrameType());
                nativeFrameProxy.setMb(nativeFrame.getMb());
                nativeFrameProxy.setName("::" + nativeFrame.toString());
                nativeFrameProxy.setPc(nativeFrame.getPc());
                nativeFrameProxy.setBp(nativeFrame.getSp());
                this.nativeStackProxy.add(nativeFrameProxy);
            }
        }
        return this.nativeStackProxy;
    }

    public int getNativeFrameCount() {
        return this.getNativeStack().size();
    }

    public Iterator getNativeFrames() {
        return this.getNativeStack().iterator();
    }

    public Iterator getRegisters() {
        Vector<ImageRegisterProxy> theRegisters = new Vector<ImageRegisterProxy>();
        int[] regs = this.tcb.failingRegisters();
        if (regs != null) {
            theRegisters.add(new ImageRegisterProxy("gpr0", (long)regs[0] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr1", (long)regs[1] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr2", (long)regs[2] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr3", (long)regs[3] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr4", (long)regs[4] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr5", (long)regs[5] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr6", (long)regs[6] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr7", (long)regs[7] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr8", (long)regs[8] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr9", (long)regs[9] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr10", (long)regs[10] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr11", (long)regs[11] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr12", (long)regs[12] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr13", (long)regs[13] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr14", (long)regs[14] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("gpr15", (long)regs[15] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("psw0", (long)regs[16] & 0xFFFFFFFFL));
            theRegisters.add(new ImageRegisterProxy("psw1", (long)regs[17] & 0xFFFFFFFFL));
        }
        return theRegisters.iterator();
    }

    public Iterator getStackFrames() {
        return this.getNativeStack().iterator();
    }

    public Iterator getStackSections() {
        Vector theVector = new Vector();
        return theVector.iterator();
    }

    public Properties getProperties() {
        return new Properties();
    }

    public JavaStackProxy getJavaStack() {
        if (this.javaStackProxy == null) {
            JavaStack javaStack = (JavaStack)this.tcb.getJavaStack();
            if (javaStack == null) {
                this.javaStackProxy = new JavaStackProxy(0);
                return this.javaStackProxy;
            }
            int frameCount = (int)javaStack.getNumFrames();
            this.javaStackProxy = new JavaStackProxy(frameCount);
            for (int i = 0; i < frameCount; ++i) {
                JavaFrame javaFrame = (JavaFrame)javaStack.getFrame(i);
                JavaStackFrameProxy javaFrameProxy = new JavaStackFrameProxy(0L, this.context);
                javaFrameProxy.setArgs(javaFrame.getArgs());
                javaFrameProxy.setFrameType(javaFrame.getFrameType());
                javaFrameProxy.setMb(javaFrame.getMb());
                javaFrameProxy.setName(javaFrame.toString());
                javaFrameProxy.setPc(javaFrame.getPc());
                javaFrameProxy.setSp(javaFrame.getSp());
                javaFrameProxy.setVars(javaFrame.getVars());
                this.javaStackProxy.add(javaFrameProxy);
                javaFrame.argsAddress();
                javaFrame.frameid();
            }
        }
        return this.javaStackProxy;
    }

    public Iterator getJavaFrames() {
        return this.getJavaStack().iterator();
    }

    private String hex(long theValue) {
        return Long.toHexString(theValue);
    }

    public void setRuntime(JavaRuntimeProxyImpl jvm) {
        this.jvm = jvm;
    }

    public int hashCode() {
        return this.tcb.tid() ^ this.context.hashCode();
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof ImageThreadEffigy) {
            ImageThreadEffigy local = (ImageThreadEffigy)obj;
            isEqual = this.tcb.tid() == ((SvcThreadImpl)local.getProxy()).tcb.tid();
        }
        return isEqual;
    }
}

