/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.utils;

import com.ibm.dtfj.sov.image.WordLength;
import com.ibm.dtfj.sov.image.WordType;
import com.ibm.dtfj.sov.utils.Mapper;
import com.ibm.dtfj.sov.utils.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DumpReader {
    RandomAccessFile core;
    Mapper mapper;
    public WordType endType;
    public WordLength wordLength;

    public DumpReader(RandomAccessFile file, WordType type, WordLength size, Mapper mapper) {
        this.core = file;
        this.endType = type;
        this.wordLength = size;
        this.mapper = mapper;
    }

    public void read(byte[] b) throws IOException {
        this.core.readFully(b);
    }

    public void read(byte[] b, int off, int len) throws IOException {
        this.core.read(b, off, len);
    }

    public long readBytes(int len) throws IOException {
        byte[] b = new byte[len];
        this.core.read(b);
        return this.endType.toLong(b);
    }

    public byte[] readBytes(long addr, long len) throws IOException {
        byte[] b = new byte[(int)len];
        this.setAddress(addr);
        this.core.read(b);
        return b;
    }

    public byte[] readBytes(long len) throws IOException {
        byte[] b = new byte[(int)len];
        this.core.read(b);
        return b;
    }

    public String readStringPtr() throws IOException {
        int i;
        long addr = this.readAddress();
        long pos = this.core.getFilePointer();
        Trace.writeToTrace("Ptr = " + Long.toHexString(addr) + " filepos = " + Long.toHexString(pos));
        this.setAddress(addr);
        int size = 512;
        byte[] b = new byte[size];
        for (i = 0; i < size; ++i) {
            b[i] = this.core.readByte();
            if (b[i] == 0) break;
        }
        Trace.writeToTrace("String = " + new String(b, 0, i));
        this.setPos(pos);
        return new String(b, 0, i);
    }

    public String readString() throws IOException {
        int stringSize;
        long stringStart = this.getPos();
        for (stringSize = 0; stringSize < Integer.MAX_VALUE && this.core.readByte() != 0; ++stringSize) {
        }
        this.setPos(stringStart);
        byte[] b = new byte[stringSize];
        this.core.readFully(b);
        return new String(b, 0, stringSize);
    }

    public String readString(long address) throws IOException {
        this.setAddress(address);
        return this.readString();
    }

    public char[] readCharArray() throws IOException {
        int arraySize;
        Trace.writeToTrace("DumpReader.readCharArray at " + this.getPos());
        if (this.wordLength.size == 4) {
            arraySize = (int)this.readInt();
            this.readInt();
        } else {
            arraySize = (int)this.readLong();
            this.readLong();
        }
        Trace.writeToTrace("DumpReader.readCharArray - length is " + arraySize);
        char[] result = new char[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            Trace.writeToTrace("DumpReader.readCharArray - reading at address 0x" + Long.toHexString(this.getAddress(this.getPos())));
            result[i] = this.readChar();
            Trace.writeToTrace("DumpReader.readCharArray - char[" + i + "] is '" + result[i] + "'");
        }
        return result;
    }

    public char readChar() throws IOException {
        char c = (char)this.readBytes(2);
        return c;
    }

    public String readString(int len) throws IOException {
        byte[] b = new byte[len];
        this.core.read(b);
        return new String(b);
    }

    public long readByte() throws IOException {
        return this.readBytes(1);
    }

    public long readShort() throws IOException {
        return this.readBytes(2);
    }

    public long readInt() throws IOException {
        return this.readBytes(4);
    }

    public long readLong() throws IOException {
        return this.readBytes(8);
    }

    public long getPos() throws IOException {
        return this.core.getFilePointer();
    }

    public void setPos(long newOffset) throws IOException {
        Trace.writeToTrace("DumpReader.setPos(): Seeking to " + newOffset);
        this.core.seek(newOffset);
    }

    public void setAddress(long Address) throws IOException {
        long newOffset = this.mapper.getOffset(Address);
        Trace.writeToTrace("DumpReader.setAddress(): address is 0x" + Long.toHexString(Address) + " offset is " + newOffset);
        this.setPos(newOffset);
    }

    public long getAddress(long pos) {
        try {
            return this.mapper.getAddress(pos);
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public long readAddressOffset() throws IOException {
        long offset = this.readBytes(this.wordLength.size);
        if (this.wordLength.size == 4) {
            int off = (int)offset;
            Trace.writeToTrace("Offset is l:" + offset + " i:" + off);
            offset = off;
            Trace.writeToTrace("Offset is l:" + offset);
        }
        return offset;
    }

    public long readAddress() throws IOException {
        return this.readBytes(this.wordLength.size);
    }

    public long readByte(long address) throws IOException {
        this.setAddress(address);
        return this.readByte();
    }

    public long readInt(long address) throws IOException {
        this.setAddress(address);
        return this.readInt();
    }

    public long readLong(long address) throws IOException {
        this.setAddress(address);
        return this.readLong();
    }

    public long Short(long address) throws IOException {
        this.setAddress(address);
        return this.readShort();
    }

    public long readPointer(long address) throws IOException {
        this.setAddress(address);
        return this.readBytes(this.wordLength.size);
    }

    public char[] readCharArray(long address) throws IOException {
        this.setAddress(address);
        return this.readCharArray();
    }
}

