/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.utils;

import com.ibm.dtfj.sov.utils.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileSearcher {
    private static final int BUFSIZE = 4096;

    public static long findNextInFile(RandomAccessFile raf, byte[] whatFor, long firstCandidateOffset, long lastCandidateOffset, int boundary) throws IOException {
        Trace.writeToTrace("findNextInFile entry what=" + new String(whatFor) + " startpoint=0x" + Long.toHexString(firstCandidateOffset) + " endpoint=0x" + Long.toHexString(lastCandidateOffset));
        if (boundary == 0) {
            boundary = 1;
        }
        try {
            int bufferOffset;
            for (long bufferStart = firstCandidateOffset + firstCandidateOffset % (long)boundary; bufferStart <= lastCandidateOffset; bufferStart += (long)bufferOffset) {
                Trace.writeToTrace(" Reading from file at offset 0x" + Long.toHexString(bufferStart));
                byte[] buffer = new byte[4096];
                raf.seek(bufferStart);
                int bytesRead = raf.read(buffer);
                if (bytesRead != -1) {
                    int lastStartOffset = (int)Math.min((long)(bytesRead - whatFor.length), lastCandidateOffset - bufferStart);
                    for (bufferOffset = 0; bufferOffset <= lastStartOffset; bufferOffset += boundary) {
                        int i = 0;
                        while (whatFor[i] == buffer[i + bufferOffset]) {
                            if (++i != whatFor.length) continue;
                            return bufferStart + (long)bufferOffset;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException aobEx) {
            Trace.writeToTrace("findNextInFile caught ArrayIndexOutOfBoundsException");
        }
        return -1L;
    }
}

