/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class JoinedIterator
implements Iterator {
    private Iterator[] iterators;
    private Iterator currentIterator;
    private int currentIteratorIndex;
    private int length;

    public JoinedIterator(Iterator[] iterators, int length) throws IllegalArgumentException {
        if (iterators.length == 0 || length == 0) {
            throw new IllegalArgumentException("Need at least one iterator.");
        }
        if (length > iterators.length) {
            throw new IllegalArgumentException("Parameter length (" + length + " is > array size(" + iterators.length + ")");
        }
        for (int i = 0; i < length; ++i) {
            Iterator it = iterators[i];
            if (it != null) continue;
            throw new IllegalArgumentException("Encountered null iterators at index " + i);
        }
        this.currentIterator = iterators[0];
        this.currentIteratorIndex = 0;
        this.iterators = iterators;
        this.length = length;
    }

    public boolean hasNext() {
        if (this.currentIterator.hasNext()) {
            return true;
        }
        if (this.currentIteratorIndex == this.length - 1) {
            return false;
        }
        ++this.currentIteratorIndex;
        this.currentIterator = this.iterators[this.currentIteratorIndex];
        return this.hasNext();
    }

    public Object next() {
        if (this.currentIterator.hasNext()) {
            return this.currentIterator.next();
        }
        throw new NoSuchElementException("All iterators exhausted.");
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

