/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.aspects.logging;

import com.ibm.ws.install.ni.framework.logging.LoggingPlugin;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;

public class JoinPointLogUtils {
    private static int m_nIndentation = 0;
    private static final String S_ARG_SEPARATOR = ", ";
    private static final String S_NULL = "null";
    private static final String S_PARENTHESES = "()";
    private static final String S_ENTER_INDICATOR = "> ";
    private static final String S_EXIT_INDICATOR = "< ";
    private static final String S_RETURN_VALUE_INDICATOR = " : ";
    private static final String S_WARNING_INDICATOR = "W\t";
    private static final String S_INFO_INDICATOR = "I\t";
    private static final char C_TAB = '\t';
    private static final char C_LEFT_PARENTHESES = '(';
    private static final char C_RIGHT_PARENTHESES = ')';
    private static final char C_AT = '@';
    private static final char C_DOT = '.';

    public static void logEntry(int nLevel, int nDetailLevel, JoinPoint joinpoint) {
        Signature signature = joinpoint.getSignature();
        String sClassName = signature.getDeclaringTypeName();
        String sMethodName = signature.getName();
        StringBuffer stringbuffer = new StringBuffer();
        if (m_nIndentation < 0) {
            m_nIndentation = 0;
        }
        stringbuffer.append(S_ENTER_INDICATOR).append(m_nIndentation).append('\t');
        ++m_nIndentation;
        stringbuffer.append(sClassName).append('.').append(sMethodName);
        switch (nDetailLevel) {
            case 5: 
            case 6: {
                stringbuffer.append(S_PARENTHESES);
                break;
            }
            case 7: {
                JoinPointLogUtils.appendArgList(stringbuffer, joinpoint.getArgs());
                break;
            }
            default: {
                return;
            }
        }
        LoggingPlugin.logMessage(nLevel, sClassName, sMethodName, stringbuffer.toString());
    }

    public static void logExit(int nLevel, int nDetailLevel, JoinPoint joinpoint, Object returnValue) {
        Signature signature = joinpoint.getSignature();
        String sClassName = signature.getDeclaringTypeName();
        String sMethodName = signature.getName();
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append(S_EXIT_INDICATOR).append(--m_nIndentation).append('\t');
        stringbuffer.append(sClassName).append('.').append(sMethodName).append(S_PARENTHESES);
        if (nDetailLevel == 7) {
            stringbuffer.append(S_RETURN_VALUE_INDICATOR).append(returnValue);
        }
        LoggingPlugin.logMessage(nLevel, sClassName, sMethodName, stringbuffer.toString());
    }

    public static void logExit(int nLevel, int nDetailLevel, JoinPoint joinpoint) {
        Signature signature = joinpoint.getSignature();
        String sClassName = signature.getDeclaringTypeName();
        String sMethodName = signature.getName();
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append(S_EXIT_INDICATOR).append(--m_nIndentation).append('\t');
        stringbuffer.append(sClassName).append('.').append(sMethodName).append(S_PARENTHESES);
        LoggingPlugin.logMessage(nLevel, sClassName, sMethodName, stringbuffer.toString());
    }

    public static void logException(int nLevel, int nDetailLevel, JoinPoint joinpoint, Throwable exception) {
        if (exception == null) {
            return;
        }
        JoinPointLogUtils.logException(nLevel, nDetailLevel, joinpoint, exception, exception.getMessage());
    }

    public static void logException(int nLevel, int nDetailLevel, JoinPoint joinpoint, Throwable exception, String sReason) {
        if (m_nIndentation < 0 || exception == null) {
            return;
        }
        Signature signature = joinpoint.getSignature();
        String sClassName = signature.getDeclaringTypeName();
        String sMethodName = signature.getName();
        StringBuffer stringbuffer = new StringBuffer();
        if (sReason == null) {
            sReason = exception.getMessage();
        }
        stringbuffer.append(S_WARNING_INDICATOR).append(--m_nIndentation).append('\t').append(sReason);
        LoggingPlugin.logException(2, sClassName, sMethodName, stringbuffer.toString(), exception);
    }

    private static StringBuffer appendArgList(StringBuffer stringbuffer, Object[] aoArgs) {
        stringbuffer.append('(');
        int length = aoArgs.length;
        int i = 0;
        while (i < length) {
            if (aoArgs[i] != null) {
                try {
                    stringbuffer.append(aoArgs[i]);
                }
                catch (Throwable throwable) {
                    stringbuffer.append(aoArgs[i].getClass().getName()).append('@');
                    stringbuffer.append(Integer.toHexString(aoArgs[i].hashCode()));
                }
            } else {
                stringbuffer.append(S_NULL);
            }
            if (i < length - 1) {
                stringbuffer.append(S_ARG_SEPARATOR);
            }
            ++i;
        }
        stringbuffer.append(')');
        return stringbuffer;
    }
}

