/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.bootstrap;

import com.ibm.ws.install.ni.framework.NIFConstants;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.bootstrap.BootstrapException;
import com.ibm.ws.install.ni.framework.bootstrap.BootstrapPlugin;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.payloadid.PayloadidPool;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.xml.sax.SAXException;

public class BootstrapPayloadidDefinitionPlugin
extends BootstrapPlugin {
    private static final String S_PARAM_PAYLOADIDSSUBDIR = "payloadidsSubdir";
    private static final String S_PARAM_FILENAMEPATTERN = "filenamePattern";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public BootstrapPayloadidDefinitionPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected void bootstrap() throws BootstrapException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.populatePayloadidPool();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private void populatePayloadidPool() throws BootstrapException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                String sPayloadidsSubdir = this.getParamValue(S_PARAM_PAYLOADIDSSUBDIR);
                String sFileNamePattern = this.getParamValue(S_PARAM_FILENAMEPATTERN);
                Pattern pattern = Pattern.compile(sFileNamePattern);
                FileSystemEntry fsePayloadidsSubdir = new FileSystemEntry(NIFConstants.getCurrentAppDirectoryURI(this.getInstallToolkitBridge()), "framework/" + sPayloadidsSubdir, this.getInstallToolkitBridge());
                FileSystemEntry[] afseAll = fsePayloadidsSubdir.getEntriesDirectlyUnderThisDir();
                Vector<FileSystemEntry> vfseApplicables = new Vector<FileSystemEntry>();
                int i = 0;
                while (afseAll != null && i < afseAll.length) {
                    String sEntryName = afseAll[i].getEntryName();
                    Matcher matcher = pattern.matcher(sEntryName);
                    if (matcher.matches()) {
                        vfseApplicables.add(afseAll[i]);
                    }
                    ++i;
                }
                PayloadidPool.addToPayloadidPool(vfseApplicables.toArray(new FileSystemEntry[vfseApplicables.size()]), this.getInstallToolkitBridge());
            }
            catch (IOException e) {
                throw new BootstrapException(e.getMessage(), e.getLocalizedMessage());
            }
            catch (URISyntaxException e) {
                throw new BootstrapException(e.getMessage(), e.getLocalizedMessage());
            }
            catch (ParserConfigurationException e) {
                throw new BootstrapException(e.getMessage(), e.getLocalizedMessage());
            }
            catch (SAXException e) {
                throw new BootstrapException(e.getMessage(), e.getLocalizedMessage());
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("BootstrapPayloadidDefinitionPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.bootstrap.BootstrapPayloadidDefinitionPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.bootstrap.BootstrapPayloadidDefinitionPlugin----"), 32);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-bootstrap-com.ibm.ws.install.ni.framework.bootstrap.BootstrapPayloadidDefinitionPlugin---com.ibm.ws.install.ni.framework.bootstrap.BootstrapException:-void-"), 39);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-populatePayloadidPool-com.ibm.ws.install.ni.framework.bootstrap.BootstrapPayloadidDefinitionPlugin---com.ibm.ws.install.ni.framework.bootstrap.BootstrapException:-void-"), 49);
    }
}

