/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.fileactions;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.fileactions.FileActionPlugin;
import com.ibm.ws.install.ni.framework.fileactions.NIFFileActionIOException;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import java.io.IOException;
import java.util.Hashtable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class RemoveFileActionPlugin
extends FileActionPlugin {
    private static final String S_FILE_ACTION_ID = "remove";
    private static final String S_INVERSE_FILE_ACTION_ID = "add";
    private static final String S_FILE_ACTION_REM_SYMLINK_ID = "removesymlink";
    private static final String S_REMOVEFILEACTIONPLUGIN_IOEXCEPTIONDESCRIPTION_KEY = "RemoveFileActionPlugin.IOExceptionDescription";
    private static final String S_FILE_NOT_WRITEABLE = "The following file is not writeable: ";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    public RemoveFileActionPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void execute(Hashtable hashtable) throws IOException {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)hashtable2);
        try {
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (this.doesTheFileToBeOperatedUponAlreadyExistInInstallRoot((Hashtable)hashtableFileDetails) || RemoveFileActionPlugin.getFileActionID((Hashtable)hashtableFileDetails).equals(S_FILE_ACTION_REM_SYMLINK_ID)) {
                if (FileActionPlugin.isBackupFlagActive((Hashtable)hashtableFileDetails)) {
                    FileSystemEntry fseInstallLocationPath = (FileSystemEntry)hashtableFileDetails.get("installlocation");
                    FileSystemEntry fseBackupRepositoryPath = (FileSystemEntry)hashtableFileDetails.get("backuprepository");
                    String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
                    FileSystemEntry fseFrom = new FileSystemEntry(fseInstallLocationPath.getURI(), sRelativeFilePath, this.getInstallToolkitBridge());
                    FileSystemEntry fseTo = new FileSystemEntry(fseBackupRepositoryPath.getURI(), sRelativeFilePath, this.getInstallToolkitBridge());
                    if (FileActionPlugin.isCheckPermissionsNeeded((Hashtable)hashtableFileDetails)) {
                        FileActionPlugin.checkWritePermissions(fseFrom);
                    }
                    try {
                        fseFrom.copyTo(fseTo);
                    }
                    catch (IOException e) {
                        throw new NIFFileActionIOException(e, fseFrom.getURI().getPath());
                    }
                }
                FileSystemEntry fseInstallLocationPath = (FileSystemEntry)hashtableFileDetails.get("installlocation");
                String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
                FileSystemEntry fseTo = new FileSystemEntry(fseInstallLocationPath.getURI(), sRelativeFilePath, this.getInstallToolkitBridge());
                try {
                    fseTo.delete();
                }
                catch (IOException e) {
                    boolean callDeleteOnExit = new Boolean(System.getProperty("deleteOnExit"));
                    if (callDeleteOnExit) {
                        fseTo.deleteOnExit();
                    }
                    throw new NIFFileActionIOException(e.getMessage(), this.getIOExceptionDescription(fseTo.getURI().getPath()), fseTo.getURI().getPath());
                }
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$3$4cd3d8fa(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isThisFileActionAcceptable(Hashtable hashtable) {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)hashtable2);
        try {
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sFileActionID = FileActionPlugin.getFileActionID((Hashtable)hashtableFileDetails);
            boolean bl = S_FILE_ACTION_ID.equals(sFileActionID);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String getInverseFileActionID(Hashtable hashtable) {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)hashtable2);
        try {
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = !this.doesTheFileToBeOperatedUponAlreadyExistInInstallRoot((Hashtable)hashtableFileDetails) ? "nop" : S_INVERSE_FILE_ACTION_ID;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean doesTheFileToBeOperatedUponAlreadyExistInInstallRoot(Hashtable hashtable) {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)hashtable2);
        try {
            boolean bl;
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            FileSystemEntry fseInstallRoot = (FileSystemEntry)hashtableFileDetails.get("installlocation");
            String sRelativePath = hashtableFileDetails.get("relativepath").toString();
            try {
                FileSystemEntry fseCheck = new FileSystemEntry(fseInstallRoot.getURI(), sRelativePath, this.getInstallToolkitBridge());
                bl = fseCheck.exists();
            }
            catch (IOException iOException) {
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getIOExceptionDescription(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string2);
        try {
            void sPathOfTheFileToBeRemoved;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string3 = NIFResourceBundleUtils.getLocaleString(S_REMOVEFILEACTIONPLUGIN_IOEXCEPTIONDESCRIPTION_KEY, (String)sPathOfTheFileToBeRemoved);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string3, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("RemoveFileActionPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.fileactions.RemoveFileActionPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.fileactions.RemoveFileActionPlugin----"), 26);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-execute-com.ibm.ws.install.ni.framework.fileactions.RemoveFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:-java.io.IOException:-void-"), 46);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-isThisFileActionAcceptable-com.ibm.ws.install.ni.framework.fileactions.RemoveFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:--boolean-"), 149);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getInverseFileActionID-com.ibm.ws.install.ni.framework.fileactions.RemoveFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:--java.lang.String-"), 174);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-doesTheFileToBeOperatedUponAlreadyExistInInstallRoot-com.ibm.ws.install.ni.framework.fileactions.RemoveFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:--boolean-"), 194);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getIOExceptionDescription-com.ibm.ws.install.ni.framework.fileactions.RemoveFileActionPlugin-java.lang.String:-sPathOfTheFileToBeRemoved:--java.lang.String-"), 225);
    }
}

