/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.fileactions;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.fileactions.NIFFileActionIOException;
import com.ibm.ws.install.ni.framework.fileactions.ZIPFileOperation;
import com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.install.ni.framework.io.FileSystem;
import com.ibm.ws.install.ni.framework.io.FileSystemNotSupportedException;
import com.ibm.ws.install.ni.framework.io.ZIPFileSystem;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.xml.sax.SAXException;

public class ZIPFileOperationController {
    private static InstallToolkitBridge m_itb;
    private static Hashtable m_htTargetFileToOperationsMaps;
    private static final String S_ZIPFILEOPERATION_DESCRIPTION_KEY = "ZIPFileOperation.IOExceptionDescription";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    static {
        Factory factory = new Factory("ZIPFileOperationController.java", Class.forName("com.ibm.ws.install.ni.framework.fileactions.ZIPFileOperationController"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.fileactions.ZIPFileOperationController----"), 33);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-initialize-com.ibm.ws.install.ni.framework.fileactions.ZIPFileOperationController-com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge:-itb:--void-"), 40);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-reset-com.ibm.ws.install.ni.framework.fileactions.ZIPFileOperationController----void-"), 49);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-add-com.ibm.ws.install.ni.framework.fileactions.ZIPFileOperationController-java.net.URI:java.lang.String:java.lang.String:java.net.URI:java.lang.String:-uriTargetFile:sEntryName:sOperation:uriSourceFile:sSourceEntryName:--void-"), 65);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-performAllZIPOperations-com.ibm.ws.install.ni.framework.fileactions.ZIPFileOperationController---java.io.IOException:javax.xml.parsers.ParserConfigurationException:org.xml.sax.SAXException:java.lang.IllegalAccessException:java.lang.InstantiationException:com.ibm.ws.install.ni.framework.io.FileSystemNotSupportedException:java.lang.ClassNotFoundException:-void-"), 92);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getIOExceptionDescription-com.ibm.ws.install.ni.framework.fileactions.ZIPFileOperationController-java.lang.String:-sTarget:--java.lang.String-"), 128);
        m_itb = null;
        m_htTargetFileToOperationsMaps = null;
    }

    public ZIPFileOperationController() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static void initialize(InstallToolkitBridge installToolkitBridge) {
        InstallToolkitBridge installToolkitBridge2 = installToolkitBridge;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)installToolkitBridge2);
        try {
            InstallToolkitBridge itb;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            m_itb = itb;
            m_htTargetFileToOperationsMaps = new Hashtable();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static void reset() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            m_itb = null;
            m_htTargetFileToOperationsMaps = null;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void add(URI uRI, String string, String string2, URI uRI2, String string3) {
        URI uRI3 = uRI;
        String string4 = string;
        String string5 = string2;
        URI uRI4 = uRI2;
        String string6 = string3;
        Object[] objectArray = new Object[]{uRI3, string4, string5, uRI4, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object[])objectArray);
        try {
            void sSourceEntryName;
            void uriSourceFile;
            void sOperation;
            void sEntryName;
            URI uriTargetFile;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            Vector<ZIPFileOperation> vfileoperation = (Vector<ZIPFileOperation>)m_htTargetFileToOperationsMaps.get(uriTargetFile);
            if (vfileoperation == null) {
                vfileoperation = new Vector<ZIPFileOperation>();
            }
            vfileoperation.add(new ZIPFileOperation(uriTargetFile, (String)sEntryName, (String)sOperation, (URI)uriSourceFile, (String)sSourceEntryName));
            m_htTargetFileToOperationsMaps.put(uriTargetFile, vfileoperation);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static void performAllZIPOperations() throws IOException, ParserConfigurationException, SAXException, IllegalAccessException, InstantiationException, FileSystemNotSupportedException, ClassNotFoundException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            Enumeration enuTargetFiles = m_htTargetFileToOperationsMaps.keys();
            while (enuTargetFiles.hasMoreElements()) {
                URI uriTargetFileThis = (URI)enuTargetFiles.nextElement();
                Vector vZIPFileOperations = (Vector)m_htTargetFileToOperationsMaps.get(uriTargetFileThis);
                ZIPFileSystem zipfsThis = (ZIPFileSystem)FileSystem.getFileSystem(uriTargetFileThis, m_itb);
                try {
                    zipfsThis.performAllZIPOperationsForThisTargetFile(uriTargetFileThis, vZIPFileOperations);
                }
                catch (IOException e) {
                    throw new NIFFileActionIOException(e.getMessage(), ZIPFileOperationController.getIOExceptionDescription(uriTargetFileThis.getPath()), uriTargetFileThis.getPath());
                }
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static String getIOExceptionDescription(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)string2);
        try {
            String sTarget;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string3 = NIFResourceBundleUtils.getLocaleString(S_ZIPFILEOPERATION_DESCRIPTION_KEY, sTarget);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string3, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

