/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.fileactions;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.fileactions.FileActionPlugin;
import com.ibm.ws.install.ni.framework.fileactions.NIFFileActionIOException;
import com.ibm.ws.install.ni.framework.fileactions.ZIPFileOperationController;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.utils.URIUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ZIPReplaceFileActionPlugin
extends FileActionPlugin {
    private static final String S_FILE_ACTION_ID = "zip-replace";
    private static final String S_INVERSE_FILE_ACTION_ID = "zip-replace";
    private static final String S_ZIP_REMOVE_FILE_ACTION_ID = "zip-remove";
    private static final String S_EXTENSIONS_PARAM = "extensions";
    private static final String[] AS_REQUIRED_PARAMS;
    private static final String S_SEMI_COLON = ";";
    private static final String S_INVALID_ENTRY_PATH = "Invalid entry path: ";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;

    static {
        Factory factory = new Factory("ZIPReplaceFileActionPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin----"), 30);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-execute-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:-java.io.IOException:-void-"), 51);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-resolveSourceFileSystemEntry-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:-java.io.IOException:-com.ibm.ws.install.ni.framework.io.FileSystemEntry-"), 302);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-resolveTargetFileSystemEntry-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:-java.io.IOException:-com.ibm.ws.install.ni.framework.io.FileSystemEntry-"), 332);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isThisReallyABackupForAnAddOperation-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:--boolean-"), 364);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-registerThisZIPFileOperation-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:-java.io.IOException:-void-"), 400);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getSourceRootURIFromSourceRepository-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.net.URI:-uriSourceRepository:-java.io.IOException:-java.net.URI-"), 455);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-isChecksumUpdateRequired-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:--boolean-"), 101);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-isThisFileActionAcceptable-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:--boolean-"), 116);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin----[Ljava.lang.String;-"), 137);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getInverseFileActionID-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:--java.lang.String-"), 151);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getInstallFileSystemEntry-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:-java.io.IOException:-com.ibm.ws.install.ni.framework.io.FileSystemEntry-"), 171);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getTargetRootFileSystemEntry-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.util.Hashtable:-hashtableFileDetails:-java.io.IOException:-com.ibm.ws.install.ni.framework.io.FileSystemEntry-"), 215);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getEntryNameFromFSRelativePath-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.lang.String:-sRelativePath:-java.io.IOException:-java.lang.String-"), 256);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getFSRelativePathStopPosition-com.ibm.ws.install.ni.framework.fileactions.ZIPReplaceFileActionPlugin-java.lang.String:-sRelativePath:-java.io.IOException:-int-"), 275);
        AS_REQUIRED_PARAMS = new String[]{S_EXTENSIONS_PARAM};
    }

    public ZIPReplaceFileActionPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void execute(Hashtable hashtable) throws IOException {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)hashtable2);
        try {
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (!this.isThisReallyABackupForAnAddOperation((Hashtable)hashtableFileDetails)) {
                if (FileActionPlugin.isBackupFlagActive((Hashtable)hashtableFileDetails)) {
                    FileSystemEntry fseFrom = this.resolveSourceFileSystemEntry((Hashtable)hashtableFileDetails);
                    FileSystemEntry fseTo = this.resolveTargetFileSystemEntry((Hashtable)hashtableFileDetails);
                    if (FileActionPlugin.isCheckPermissionsNeeded((Hashtable)hashtableFileDetails)) {
                        FileActionPlugin.checkWritePermissions(fseFrom);
                    }
                    try {
                        fseFrom.copyTo(fseTo);
                    }
                    catch (IOException e) {
                        throw new NIFFileActionIOException(e, fseTo.getURI().getPath());
                    }
                } else {
                    this.registerThisZIPFileOperation((Hashtable)hashtableFileDetails);
                }
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$3$4cd3d8fa(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected boolean isChecksumUpdateRequired(Hashtable hashtable) {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)hashtable2);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = true;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return true;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isThisFileActionAcceptable(Hashtable hashtable) {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)hashtable2);
        try {
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sFileActionID = FileActionPlugin.getFileActionID((Hashtable)hashtableFileDetails);
            boolean bl = "zip-replace".equals(sFileActionID);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_REQUIRED_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_REQUIRED_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String getInverseFileActionID(Hashtable hashtable) {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)hashtable2);
        try {
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.isThisReallyABackupForAnAddOperation((Hashtable)hashtableFileDetails) ? S_ZIP_REMOVE_FILE_ACTION_ID : "zip-replace";
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private FileSystemEntry getInstallFileSystemEntry(Hashtable hashtable) throws IOException {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)hashtable2);
        try {
            FileSystemEntry fileSystemEntry;
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
            FileSystemEntry fseInstallLocation = (FileSystemEntry)hashtableFileDetails.get("installlocation");
            String sInstallLocationPath = fseInstallLocation.getURI().getPath();
            int nFSRelativePathStopPosition = this.getFSRelativePathStopPosition(sRelativeFilePath);
            String sZIPFSPath = sRelativeFilePath.substring(0, nFSRelativePathStopPosition);
            String sZIPFSRelativePath = sRelativeFilePath.substring(nFSRelativePathStopPosition + 1);
            try {
                URI uriTarget = URIUtils.convertPathToDefaultTargetMachineFSURI(String.valueOf(sInstallLocationPath) + "/" + sZIPFSPath, this.getInstallToolkitBridge());
                fileSystemEntry = new FileSystemEntry(uriTarget, sZIPFSRelativePath, this.getInstallToolkitBridge());
            }
            catch (URISyntaxException e) {
                throw new IOException(e.getMessage());
            }
            FileSystemEntry fileSystemEntry2 = fileSystemEntry;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(fileSystemEntry2, joinPoint);
            return fileSystemEntry;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private FileSystemEntry getTargetRootFileSystemEntry(Hashtable hashtable) throws IOException {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)hashtable2);
        try {
            FileSystemEntry fileSystemEntry;
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sRelativeFilePath = hashtableFileDetails.get("relativepath").toString();
            FileSystemEntry fseInstallLocation = (FileSystemEntry)hashtableFileDetails.get("installlocation");
            String sInstallLocationPath = fseInstallLocation.getURI().getPath();
            int nFSRelativePathStopPosition = this.getFSRelativePathStopPosition(sRelativeFilePath);
            String sZIPFSPath = sRelativeFilePath.substring(0, nFSRelativePathStopPosition);
            try {
                URI uriTarget = URIUtils.convertPathToDefaultTargetMachineFSURI(String.valueOf(sInstallLocationPath) + "/" + sZIPFSPath, this.getInstallToolkitBridge());
                fileSystemEntry = new FileSystemEntry(uriTarget, this.getInstallToolkitBridge());
            }
            catch (URISyntaxException e) {
                throw new IOException(e.getMessage());
            }
            FileSystemEntry fileSystemEntry2 = fileSystemEntry;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(fileSystemEntry2, joinPoint);
            return fileSystemEntry;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getEntryNameFromFSRelativePath(String string) throws IOException {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string2);
        try {
            void sRelativePath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            int nFSRelativePathStopPosition = this.getFSRelativePathStopPosition((String)sRelativePath);
            String string3 = sRelativePath.substring(nFSRelativePathStopPosition + 1);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string3, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getFSRelativePathStopPosition(String string) throws IOException {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string2);
        try {
            void sRelativePath;
            String sExtensionThis;
            block4: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                String sExtensions = this.getParamValue(S_EXTENSIONS_PARAM);
                StringTokenizer st = new StringTokenizer(sExtensions, S_SEMI_COLON);
                while (st.hasMoreTokens()) {
                    sExtensionThis = "." + st.nextToken();
                    if (sRelativePath.indexOf(sExtensionThis) == -1) {
                        continue;
                    }
                    break block4;
                }
                throw new IOException(S_INVALID_ENTRY_PATH + (String)sRelativePath);
            }
            int n = sRelativePath.indexOf(sExtensionThis) + sExtensionThis.length();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private FileSystemEntry resolveSourceFileSystemEntry(Hashtable hashtable) throws IOException {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)hashtable2);
        try {
            FileSystemEntry fileSystemEntry;
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (FileActionPlugin.isBackupFlagActive((Hashtable)hashtableFileDetails)) {
                fileSystemEntry = this.getInstallFileSystemEntry((Hashtable)hashtableFileDetails);
            } else {
                FileSystemEntry fseSourceRepository = (FileSystemEntry)hashtableFileDetails.get("sourcerepository");
                String sRelativePath = hashtableFileDetails.get("relativepath").toString();
                fileSystemEntry = new FileSystemEntry(fseSourceRepository.getURI(), sRelativePath, this.getInstallToolkitBridge());
            }
            FileSystemEntry fileSystemEntry2 = fileSystemEntry;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(fileSystemEntry2, joinPoint);
            return fileSystemEntry;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private FileSystemEntry resolveTargetFileSystemEntry(Hashtable hashtable) throws IOException {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)hashtable2);
        try {
            FileSystemEntry fileSystemEntry;
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (FileActionPlugin.isBackupFlagActive((Hashtable)hashtableFileDetails)) {
                FileSystemEntry fseBackupRepository = (FileSystemEntry)hashtableFileDetails.get("backuprepository");
                String sRelativePath = hashtableFileDetails.get("relativepath").toString();
                fileSystemEntry = new FileSystemEntry(fseBackupRepository.getURI(), sRelativePath, this.getInstallToolkitBridge());
            } else {
                fileSystemEntry = this.getInstallFileSystemEntry((Hashtable)hashtableFileDetails);
            }
            FileSystemEntry fileSystemEntry2 = fileSystemEntry;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(fileSystemEntry2, joinPoint);
            return fileSystemEntry;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isThisReallyABackupForAnAddOperation(Hashtable hashtable) {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)hashtable2);
        try {
            boolean bl;
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                bl = !this.resolveSourceFileSystemEntry((Hashtable)hashtableFileDetails).exists() && FileActionPlugin.isBackupFlagActive((Hashtable)hashtableFileDetails);
            }
            catch (IOException iOException) {
                bl = FileActionPlugin.isBackupFlagActive((Hashtable)hashtableFileDetails);
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void registerThisZIPFileOperation(Hashtable hashtable) throws IOException {
        Hashtable hashtable2 = hashtable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)hashtable2);
        try {
            void hashtableFileDetails;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            URI uriTargetFile = this.getTargetRootFileSystemEntry((Hashtable)hashtableFileDetails).getURI();
            String sRelativePath = hashtableFileDetails.get("relativepath").toString();
            String sEntryName = this.getEntryNameFromFSRelativePath(sRelativePath);
            String sOperation = "zip-replace";
            URI uriSourceRepository = ((FileSystemEntry)hashtableFileDetails.get("sourcerepository")).getURI();
            URI uriSourceFile = this.getSourceRootURIFromSourceRepository(uriSourceRepository);
            FileSystemEntry fseSourceEntry = new FileSystemEntry(uriSourceRepository, sRelativePath, this.getInstallToolkitBridge());
            String sSourceEntryName = this.getEntryNameFromFSRelativePath(URLDecoder.decode(fseSourceEntry.getURI().toString(), "UTF-8"));
            ZIPFileOperationController.add(uriTargetFile, sEntryName, sOperation, uriSourceFile, sSourceEntryName);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private URI getSourceRootURIFromSourceRepository(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriSourceRepository;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            FileSystemEntry fse = new FileSystemEntry((URI)uriSourceRepository, this.getInstallToolkitBridge());
            URI uRI3 = fse.getParentDirOrFSRoot().getParentDirOrFSRoot().getURI();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(uRI3, joinPoint);
            return uRI3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

