/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.install;

import com.ibm.ws.install.ni.framework.NIFException;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.install.NIFInstallPlugin;
import com.ibm.ws.install.ni.framework.io.FileSystem;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class CopyFilesInstallPlugin
extends NIFInstallPlugin {
    private static final String S_PARAM_SOURCEDIRURI = "sourceDirURI";
    private static final String S_PARAM_SOURCEFILENAMEPATTERN = "sourceFileNamePattern";
    private static final String S_PARAM_TARGETDIRURI = "targetDirURI";
    private static final String S_PARAM_CONDITION = "condition";
    private static final String S_PARAM_TARGETPERMISSIONS = "targetPermissions";
    private static final String S_PARAM_OVERWRITE = "overwrite";
    private static final String[] AS_REQUIRED_PARAMS;
    private static final String[] AS_OPTIONAL_PARAMS;
    private static final String S_DEFAULT_PERMISSIONS = "755";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;

    static {
        Factory factory = new Factory("CopyFilesInstallPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.install.CopyFilesInstallPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.install.CopyFilesInstallPlugin----"), 29);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-execute-com.ibm.ws.install.ni.framework.install.CopyFilesInstallPlugin---com.ibm.ws.install.ni.framework.NIFException:-int-"), 34);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getCondition-com.ibm.ws.install.ni.framework.install.CopyFilesInstallPlugin----boolean-"), 87);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getTargetPermissions-com.ibm.ws.install.ni.framework.install.CopyFilesInstallPlugin----int-"), 100);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getAllFilesToBeCopied-com.ibm.ws.install.ni.framework.install.CopyFilesInstallPlugin---java.net.URISyntaxException:java.io.IOException:-[Lcom.ibm.ws.install.ni.framework.io.FileSystemEntry;-"), 114);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getSourceDir-com.ibm.ws.install.ni.framework.install.CopyFilesInstallPlugin---java.net.URISyntaxException:java.io.IOException:-com.ibm.ws.install.ni.framework.io.FileSystemEntry-"), 147);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getTargetDir-com.ibm.ws.install.ni.framework.install.CopyFilesInstallPlugin---java.net.URISyntaxException:java.io.IOException:-com.ibm.ws.install.ni.framework.io.FileSystemEntry-"), 161);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.install.CopyFilesInstallPlugin----[Ljava.lang.String;-"), 174);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.install.CopyFilesInstallPlugin----[Ljava.lang.String;-"), 184);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-shouldOverWrite-com.ibm.ws.install.ni.framework.install.CopyFilesInstallPlugin----boolean-"), 189);
        AS_REQUIRED_PARAMS = new String[0];
        AS_OPTIONAL_PARAMS = new String[]{S_PARAM_SOURCEDIRURI, S_PARAM_TARGETDIRURI, S_PARAM_SOURCEFILENAMEPATTERN, S_PARAM_CONDITION, S_PARAM_TARGETPERMISSIONS, S_PARAM_OVERWRITE};
    }

    public CopyFilesInstallPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public int execute() throws NIFException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            int n;
            block15: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
                if (!this.getCondition()) {
                    n = 0;
                } else {
                    try {
                        FileSystemEntry[] afseSource = this.getAllFilesToBeCopied();
                        if (afseSource == null || afseSource.length == 0) {
                            n = 0;
                            break block15;
                        }
                        FileSystemEntry fseTargetDir = this.getTargetDir();
                        if (!fseTargetDir.exists()) {
                            fseTargetDir.mkdirs();
                        }
                        int i = 0;
                        while (i < afseSource.length) {
                            if (afseSource[i].exists()) {
                                FileSystemEntry fseTarget = new FileSystemEntry(fseTargetDir.getURI(), afseSource[i].getEntryName(), this.getInstallToolkitBridge());
                                boolean fDoCopy = false;
                                if (!fseTarget.exists()) {
                                    fDoCopy = true;
                                } else if (this.shouldOverWrite()) {
                                    FileSystem.flushAllFileSystems();
                                    fseTarget.delete();
                                    fDoCopy = true;
                                }
                                if (fDoCopy) {
                                    afseSource[i].copyTo(fseTarget);
                                    fseTarget.setPermissions(this.getTargetPermissions());
                                }
                            }
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        throw new NIFException(e, (Throwable)e);
                    }
                    catch (URISyntaxException e) {
                        throw new NIFException(e, (Throwable)e);
                    }
                    n = 0;
                }
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public boolean getCondition() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sCondition = this.getParamValue(S_PARAM_CONDITION);
            boolean bl = sCondition == null || sCondition.trim().length() == 0 ? true : new Boolean(sCondition);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public int getTargetPermissions() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sPermissions = this.getParamValue(S_PARAM_TARGETPERMISSIONS);
            if (sPermissions == null || sPermissions.trim().length() == 0) {
                sPermissions = S_DEFAULT_PERMISSIONS;
            }
            int n = Integer.parseInt(sPermissions.trim());
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected FileSystemEntry[] getAllFilesToBeCopied() throws URISyntaxException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            FileSystemEntry[] fileSystemEntryArray;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            FileSystemEntry fseParent = this.getSourceDir();
            String sSourceFileNamePattern = this.getParamValue(S_PARAM_SOURCEFILENAMEPATTERN);
            if (sSourceFileNamePattern == null || sSourceFileNamePattern.trim().length() == 0) {
                FileSystemEntry[] fileSystemEntryArray2 = new FileSystemEntry[1];
                fileSystemEntryArray = fileSystemEntryArray2;
                fileSystemEntryArray2[0] = fseParent;
            } else {
                FileSystemEntry[] afseChildren = fseParent.getEntriesDirectlyUnderThisDir();
                if (afseChildren == null || afseChildren.length == 0) {
                    fileSystemEntryArray = null;
                } else {
                    Pattern pattern = Pattern.compile(this.getParamValue(S_PARAM_SOURCEFILENAMEPATTERN));
                    Vector<FileSystemEntry> vfse = new Vector<FileSystemEntry>();
                    int i = 0;
                    while (i < afseChildren.length) {
                        String sFilename = afseChildren[i].getEntryName();
                        if (pattern.matcher(sFilename).matches()) {
                            vfse.add(afseChildren[i]);
                        }
                        ++i;
                    }
                    fileSystemEntryArray = vfse.toArray(new FileSystemEntry[vfse.size()]);
                }
            }
            FileSystemEntry[] fileSystemEntryArray3 = fileSystemEntryArray;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(fileSystemEntryArray3, joinPoint);
            return fileSystemEntryArray;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected FileSystemEntry getSourceDir() throws URISyntaxException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            FileSystemEntry fileSystemEntry = new FileSystemEntry(new URI(this.getParamValue(S_PARAM_SOURCEDIRURI)), this.getInstallToolkitBridge());
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(fileSystemEntry, joinPoint);
            return fileSystemEntry;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected FileSystemEntry getTargetDir() throws URISyntaxException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            FileSystemEntry fileSystemEntry = new FileSystemEntry(new URI(this.getParamValue(S_PARAM_TARGETDIRURI)), this.getInstallToolkitBridge());
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(fileSystemEntry, joinPoint);
            return fileSystemEntry;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_REQUIRED_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_REQUIRED_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_OPTIONAL_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_OPTIONAL_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean shouldOverWrite() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sOverWrite = this.getParamValue(S_PARAM_OVERWRITE);
            boolean bl = sOverWrite == null || sOverWrite.trim().length() == 0 ? false : new Boolean(sOverWrite);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

