/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.io;

import com.ibm.ws.install.ni.framework.NIFException;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.install.NIFInstallPlugin;
import com.ibm.ws.install.ni.framework.io.FileSystem;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.utils.StringUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class DeleteFilesPlugin
extends NIFInstallPlugin {
    private final String S_PARAM_URIOFFILESTOBEDELETED = "URIOfFilesToBeDeleted";
    private final String S_PARAM_DELETEONEXIT = "deleteOnExit";
    private final String S_PARAM_CONDITION = "condition";
    private final String[] AS_OPTIONAL_PARAMS;
    private final String[] AS_REQUIRED_PARAMS;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;

    public DeleteFilesPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.S_PARAM_URIOFFILESTOBEDELETED = "URIOfFilesToBeDeleted";
            this.S_PARAM_DELETEONEXIT = "deleteOnExit";
            this.S_PARAM_CONDITION = "condition";
            this.AS_OPTIONAL_PARAMS = new String[]{"URIOfFilesToBeDeleted", "deleteOnExit", "condition"};
            this.AS_REQUIRED_PARAMS = new String[0];
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public int execute() throws NIFException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (!new Boolean(this.getCondition()).booleanValue()) {
                n = 0;
            } else {
                String[] asURIsToBeDeleted = this.getURIOfFilesToBeDeleted();
                if (asURIsToBeDeleted == null || asURIsToBeDeleted.length == 0) {
                    n = 0;
                } else {
                    try {
                        FileSystem.flushAllFileSystems();
                    }
                    catch (IOException e) {
                        throw new NIFException(e, (Throwable)e);
                    }
                    boolean fDeleteOnExit = new Boolean(this.getDeleteOnExit());
                    int i = 0;
                    while (i < asURIsToBeDeleted.length) {
                        try {
                            FileSystemEntry fseThis = new FileSystemEntry(new URI(asURIsToBeDeleted[i]), this.getInstallToolkitBridge());
                            if (fseThis.exists()) {
                                if (fseThis.isDirectory()) {
                                    fseThis.deleteThisDirectoryRecursively();
                                } else if (!fDeleteOnExit) {
                                    fseThis.delete();
                                } else {
                                    fseThis.deleteOnExit();
                                }
                            }
                        }
                        catch (URISyntaxException e) {
                            throw new NIFException(e, (Throwable)e);
                        }
                        catch (IOException e) {
                            throw new NIFException(e, (Throwable)e);
                        }
                        ++i;
                    }
                    n = 0;
                }
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String[] getURIOfFilesToBeDeleted() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            String[] stringArray;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] as = this.getParamValues("URIOfFilesToBeDeleted");
            if (as == null || as.length == 0) {
                stringArray = null;
            } else {
                Vector vsReturn = new Vector();
                int i = 0;
                while (i < as.length) {
                    vsReturn.addAll(StringUtils.convertStringToTokenVector(as[i], ";"));
                    ++i;
                }
                stringArray = vsReturn.toArray(new String[vsReturn.size()]);
            }
            String[] stringArray2 = stringArray;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray2, joinPoint);
            return stringArray;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getDeleteOnExit() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = new Boolean(this.getParamValue("deleteOnExit")).toString();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getCondition() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String s = this.getParamValue("condition");
            String string = s == null || s.trim().length() == 0 ? Boolean.TRUE.toString() : new Boolean(s).toString();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = this.AS_OPTIONAL_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return this.AS_OPTIONAL_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = this.AS_REQUIRED_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return this.AS_REQUIRED_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("DeleteFilesPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.io.DeleteFilesPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.io.DeleteFilesPlugin----"), 148);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-execute-com.ibm.ws.install.ni.framework.io.DeleteFilesPlugin---com.ibm.ws.install.ni.framework.NIFException:-int-"), 34);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getURIOfFilesToBeDeleted-com.ibm.ws.install.ni.framework.io.DeleteFilesPlugin----[Ljava.lang.String;-"), 89);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getDeleteOnExit-com.ibm.ws.install.ni.framework.io.DeleteFilesPlugin----java.lang.String-"), 108);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getCondition-com.ibm.ws.install.ni.framework.io.DeleteFilesPlugin----java.lang.String-"), 120);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.io.DeleteFilesPlugin----[Ljava.lang.String;-"), 134);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.io.DeleteFilesPlugin----[Ljava.lang.String;-"), 143);
    }
}

