/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.io;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.ws.install.ni.framework.NIFConstants;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridgeException;
import com.ibm.ws.install.ni.framework.io.FileSystem;
import com.ibm.ws.install.ni.framework.os.ExecEngine;
import com.ibm.ws.install.ni.framework.os.PlatformConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class DiskFileSystem
extends FileSystem {
    private static final String S_DISK_FS_SCHEME = "file";
    private static final String S_INVALID_FS_FOR_SYMLINK_ATTEMPT = "Invalid filesystem for symbolic link attempt or host and target filesystems don't match.";
    private static final String S_SOFTLINK_OPTION = "-s";
    private static final String S_FORCE_OPTION = "-f";
    private static final String S_LN_LOCATION_1 = "/bin/ln";
    private static final String S_LN_LOCATION_2 = "/usr/bin/ln";
    private static final String S_NO_LN_1 = "Symbolic linking ";
    private static final String S_NO_LN_2 = "->";
    private static final String S_NO_LN_3 = " failed as ln command was not found.";
    private static final String S_GENERIC_FAILURE_1 = "Symbolic linking ";
    private static final String S_GENERIC_FAILURE_2 = "->";
    private static final String S_GENERIC_FAILURE_3 = " failed.";
    private static final int N_LN_SUCCESS_CODE = 0;
    private static final String S_MKDIR_FAILED = "mkdirs failed for: ";
    private static final String S_DELETE_FAILED = "Failed to delete: ";
    private static final String S_RENAME_FAILED_1 = "Failed to rename: ";
    private static final String S_RENAME_FAILED_2 = ", to: ";
    private static final int AS_400_CCSID = 819;
    private static final String S_DOTDOT = "..";
    private static final String S_EMPTY = "";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;
    private static final JoinPoint.StaticPart ajc$tjp_25;
    private static final JoinPoint.StaticPart ajc$tjp_26;
    private static final JoinPoint.StaticPart ajc$tjp_27;
    private static final JoinPoint.StaticPart ajc$tjp_28;
    private static final JoinPoint.StaticPart ajc$tjp_29;
    private static final JoinPoint.StaticPart ajc$tjp_30;
    private static final JoinPoint.StaticPart ajc$tjp_31;
    private static final JoinPoint.StaticPart ajc$tjp_32;
    private static final JoinPoint.StaticPart ajc$tjp_33;
    private static final JoinPoint.StaticPart ajc$tjp_34;

    public DiskFileSystem() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long getSize(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            long l = new File((URI)uriPath).length();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.longObject((long)l), joinPoint);
            return l;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setLastModifiedTime(URI uRI, long l) throws IOException {
        URI uRI2 = uRI;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)uRI2, (Object)Conversions.longObject((long)l2));
        try {
            void lTime;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            new File((URI)uriPath).setLastModified((long)lTime);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream readEntry(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            FileInputStream fileInputStream = new FileInputStream(new File((URI)uriPath));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(fileInputStream, joinPoint);
            return fileInputStream;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream writeEntry(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            OutputStream outputStream = this.writeEntry((URI)uriPath, false);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(outputStream, joinPoint);
            return outputStream;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream writeEntry(URI uRI, boolean bl) throws IOException {
        URI uRI2 = uRI;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)uRI2, (Object)Conversions.booleanObject((boolean)bl2));
        try {
            OutputStream outputStream;
            void fAppend;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (!this.exists(this.getParent((URI)uriPath))) {
                this.mkdirs(this.getParent((URI)uriPath));
            }
            if (PlatformConstants.isCurrentPlatformOS400()) {
                try {
                    AS400 as400 = this.getInstallToolkitBridge().getAS400Object();
                    IFSFileOutputStream ifsfileoutputstream = new IFSFileOutputStream(as400, new IFSFile(as400, new File((URI)uriPath).getAbsolutePath()), -1, (boolean)fAppend, 819);
                    outputStream = ifsfileoutputstream;
                }
                catch (AS400SecurityException e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                outputStream = this.getInstallToolkitBridge().getUnifiedFileIO().writeFile(new File((URI)uriPath).getAbsolutePath(), (boolean)fAppend);
            }
            OutputStream outputStream2 = outputStream;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(outputStream2, joinPoint);
            return outputStream;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteEntry(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            File file = new File((URI)uriPath);
            if (!file.delete() && file.exists()) {
                throw new IOException(S_DELETE_FAILED + uriPath);
            }
            this.deleteIfItIsAnEmptyDir(file.getParentFile());
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteEntryOnExit(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            new File((URI)uriPath).deleteOnExit();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPermissions(URI uRI, int n) throws IOException {
        URI uRI2 = uRI;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)uRI2, (Object)Conversions.intObject((int)n2));
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                if (!PlatformConstants.isOS400Install()) {
                    void nPermissions;
                    void uriPath;
                    this.getUnifiedFileIOObject().setPermissions(new File((URI)uriPath).getAbsolutePath(), (int)nPermissions);
                }
            }
            catch (InstallToolkitBridgeException e) {
                throw new IOException(e.getMessage());
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getPermissions(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)uRI2);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                void uriPath;
                n = PlatformConstants.isOS400Install() ? 755 : this.getUnifiedFileIOObject().getPermissions(new File((URI)uriPath).getAbsolutePath());
            }
            catch (InstallToolkitBridgeException e) {
                throw new IOException(e.getMessage());
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long getLastModified(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            long l = new File((URI)uriPath).lastModified();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.longObject((long)l), joinPoint);
            return l;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createSymbolicLink(URI uRI, String string) throws IOException {
        URI uRI2 = uRI;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)uRI2, (Object)string2);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (!PlatformConstants.isOS400Install()) {
                void sPathToLinkTo;
                File fileSymbolicLink;
                void uriSymbolicLinkPath;
                if (!uriSymbolicLinkPath.getScheme().equalsIgnoreCase(S_DISK_FS_SCHEME)) {
                    throw new IOException(S_INVALID_FS_FOR_SYMLINK_ATTEMPT);
                }
                if (!new File(this.getParent((URI)uriSymbolicLinkPath)).exists()) {
                    this.mkdirs(this.getParent((URI)uriSymbolicLinkPath));
                }
                if ((fileSymbolicLink = new File((URI)uriSymbolicLinkPath)).exists()) {
                    fileSymbolicLink.delete();
                }
                String sLink = new File((URI)uriSymbolicLinkPath).getAbsolutePath();
                String sLNCommand = this.getLNCommand();
                if (sLNCommand == null) {
                    throw new IOException("Symbolic linking " + sLink + "->" + (String)sPathToLinkTo + S_NO_LN_3);
                }
                String[] asArgs = new String[]{sLNCommand, S_SOFTLINK_OPTION, S_FORCE_OPTION, sPathToLinkTo, sLink};
                ExecEngine ee = new ExecEngine();
                ee.executeIncomingArguments(asArgs, NIFConstants.N_DEFAULT_PROCESS_TIME_OUT_TIME);
                if (ee.getProcessRetCode() != 0) {
                    throw new IOException("Symbolic linking " + sLink + "->" + (String)sPathToLinkTo + S_GENERIC_FAILURE_3);
                }
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public URI getFSURI(URI uRI, String string) throws URISyntaxException {
        URI uRI2 = uRI;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)uRI2, (Object)string2);
        try {
            void sEntryPath;
            void uriParent;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            URI uRI3 = new File(new File((URI)uriParent).getAbsolutePath(), (String)sEntryPath).toURI();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(uRI3, joinPoint);
            return uRI3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean exists(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            boolean bl = new File((URI)uriPath).exists();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDirectory(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            boolean bl = new File((URI)uriPath).isDirectory();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void mkdirs(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (!new File((URI)uriPath).mkdirs()) {
                throw new IOException(S_MKDIR_FAILED + uriPath);
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public URI getParent(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            URI uRI3 = new File((URI)uriPath).getParentFile().toURI();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(uRI3, joinPoint);
            return uRI3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getEntryName(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            String string = new File((URI)uriPath).getName();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getCanonicalPath(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            String string = new File((URI)uriPath).getCanonicalPath();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getAbsolutePath(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            String string = new File((URI)uriPath).getAbsolutePath();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void renameTo(URI uRI, URI uRI2) throws IOException {
        URI uRI3 = uRI;
        URI uRI4 = uRI2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)uRI3, (Object)uRI4);
        try {
            void uriPathTo;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (!new File((URI)uriPath).renameTo(new File((URI)uriPathTo))) {
                throw new IOException(S_RENAME_FAILED_1 + uriPath + S_RENAME_FAILED_2 + uriPathTo);
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public URI[] getDirectoryEntries(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)uRI2);
        try {
            URI[] uRIArray;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            File[] afiles = new File((URI)uriPath).listFiles();
            if (afiles != null) {
                URI[] auris = new URI[afiles.length];
                int i = 0;
                while (i < afiles.length) {
                    auris[i] = afiles[i].toURI();
                    ++i;
                }
                uRIArray = auris;
            } else {
                uRIArray = new URI[]{};
            }
            URI[] uRIArray2 = uRIArray;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(uRIArray2, joinPoint);
            return uRIArray;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getSymbolicLinkTarget(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)uRI2);
        try {
            String sCanonicalPath;
            String sAbsolutePath;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            File f = new File(uriPath.normalize());
            String string = !f.exists() ? null : ((sAbsolutePath = f.getAbsolutePath()).equals(sCanonicalPath = f.getCanonicalPath()) ? null : this.getRelativePathFromPath1ToPath2(sAbsolutePath, sCanonicalPath));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public void flushFileSystemFor(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)uRI2);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setHidden(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)uRI2);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (PlatformConstants.isCurrentPlatformWindows()) {
                void uriPath;
                String sPath = new File((URI)uriPath).getAbsolutePath();
                String[] asCommandArguments = new String[]{"attrib", "+h", sPath};
                ExecEngine eeThis = new ExecEngine();
                eeThis.executeIncomingArgumentsAsync(asCommandArguments);
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String getSupportedScheme() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = S_DISK_FS_SCHEME;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return S_DISK_FS_SCHEME;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected void flush() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deleteIfItIsAnEmptyDir(File file) {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)file2);
        try {
            void fileCurrentDir;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            File[] children = fileCurrentDir.listFiles();
            if (children != null && children.length == 0) {
                fileCurrentDir.delete();
                this.deleteIfItIsAnEmptyDir(fileCurrentDir.getParentFile());
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getRelativePathFromPath1ToPath2(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)string3, (Object)string4);
        try {
            void sPath2;
            void sPath1;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sPatha = new File((String)sPath1).toURI().normalize().getPath();
            String sPathb = new File((String)sPath2).toURI().normalize().getPath();
            StringTokenizer st1 = new StringTokenizer(sPatha, File.separator);
            StringTokenizer st2 = new StringTokenizer(sPathb, File.separator);
            String sReturn = S_EMPTY;
            while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
                sReturn = st2.nextToken();
                if (!st1.nextToken().equals(sReturn)) break;
            }
            while (st1.hasMoreTokens()) {
                st1.nextToken();
                sReturn = S_DOTDOT + File.separator + sReturn;
            }
            while (st2.hasMoreTokens()) {
                sReturn = String.valueOf(sReturn) + File.separator + st2.nextToken();
            }
            String string5 = sReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string5, joinPoint);
            return string5;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private String getLNCommand() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sLNCommand = null;
            if (new File(S_LN_LOCATION_1).exists()) {
                sLNCommand = S_LN_LOCATION_1;
            }
            if (new File(S_LN_LOCATION_2).exists()) {
                sLNCommand = S_LN_LOCATION_2;
            }
            String string = sLNCommand;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isReadable(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            boolean bl = new File((URI)uriPath).canRead();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isWriteable(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this, (Object)uRI2);
        try {
            boolean bl;
            block12: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
                try {
                    void uriPath;
                    File testFile = new File((URI)uriPath);
                    if (PlatformConstants.isCurrentPlatformWindows() && !testFile.exists()) {
                        bl = this.canMakeDirsInThisPath(testFile);
                        break block12;
                    }
                    while (true) {
                        if (testFile.exists()) {
                            if (!testFile.isDirectory()) break;
                            bl = this.isThisPathWritable(testFile);
                            break block12;
                        }
                        testFile = testFile.getParentFile();
                    }
                    if (PlatformConstants.isCurrentPlatformWindows()) {
                        try {
                            FileOutputStream fileoutputstreamThisFile = new FileOutputStream(testFile, true);
                            fileoutputstreamThisFile.close();
                            bl = true;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            bl = false;
                        }
                        catch (IOException iOException) {
                            bl = false;
                        }
                    } else {
                        bl = testFile.canWrite();
                    }
                }
                catch (SecurityException securityException) {
                    bl = false;
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isThisPathWritable(File file) {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this, (Object)file2);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                void dir;
                File fTemp = File.createTempFile("_write_", "_test_", (File)dir);
                fTemp.delete();
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
            }
            catch (SecurityException securityException) {
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean canMakeDirsInThisPath(File file) {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)file2);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                void dir;
                if (dir.mkdirs()) {
                    this.deleteIfItIsAnEmptyDir((File)dir);
                    bl = true;
                } else {
                    bl = false;
                }
            }
            catch (SecurityException securityException) {
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void copyThisEntryInThisSourceToThisZipFileWithThisName(URI uRI, String string, ZipOutputStream zipOutputStream, String string2) throws IOException {
        URI uRI2 = uRI;
        String string3 = string;
        ZipOutputStream zipOutputStream2 = zipOutputStream;
        String string4 = string2;
        Object[] objectArray = new Object[]{uRI2, string3, zipOutputStream2, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object[])objectArray);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                void sSourceEntryName;
                void uriSourceFile;
                void zopTo;
                void sTargetEntryName;
                ZipEntry zipentryThis = new ZipEntry((String)sTargetEntryName);
                zopTo.putNextEntry(zipentryThis);
                InputStream in = this.getEntry(this.normalizeLocationURI((URI)uriSourceFile, (String)sSourceEntryName)).getInputStream();
                this.transferInputStreamToOutputStreamCompletely(in, (OutputStream)zopTo);
                in.close();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("DiskFileSystem.java", Class.forName("com.ibm.ws.install.ni.framework.io.DiskFileSystem"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.io.DiskFileSystem----"), 46);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getSize-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-long-"), 56);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getLastModified-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:--long-"), 240);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createSymbolicLink-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:java.lang.String:-uriSymbolicLinkPath:sPathToLinkTo:-java.io.IOException:-void-"), 253);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFSURI-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:java.lang.String:-uriParent:sEntryPath:-java.net.URISyntaxException:-java.net.URI-"), 324);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-exists-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:--boolean-"), 341);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isDirectory-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:--boolean-"), 353);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-mkdirs-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-void-"), 364);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getParent-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.net.URI-"), 380);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getEntryName-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.lang.String-"), 395);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getCanonicalPath-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.lang.String-"), 407);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getAbsolutePath-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.lang.String-"), 419);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setLastModifiedTime-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:long:-uriPath:lTime:-java.io.IOException:-void-"), 68);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-renameTo-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:java.net.URI:-uriPath:uriPathTo:-java.io.IOException:-void-"), 431);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getDirectoryEntries-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:--[Ljava.net.URI;-"), 455);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getSymbolicLinkTarget-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.lang.String-"), 484);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-flushFileSystemFor-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-void-"), 509);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setHidden-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:--void-"), 520);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getSupportedScheme-com.ibm.ws.install.ni.framework.io.DiskFileSystem----java.lang.String-"), 538);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-flush-com.ibm.ws.install.ni.framework.io.DiskFileSystem---java.io.IOException:-void-"), 552);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-deleteIfItIsAnEmptyDir-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.io.File:-fileCurrentDir:--void-"), 565);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getRelativePathFromPath1ToPath2-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.lang.String:java.lang.String:-sPath1:sPath2:--java.lang.String-"), 586);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getLNCommand-com.ibm.ws.install.ni.framework.io.DiskFileSystem---java.io.IOException:-java.lang.String-"), 625);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-readEntry-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.io.InputStream-"), 84);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isReadable-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:--boolean-"), 651);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isWriteable-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:--boolean-"), 664);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isThisPathWritable-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.io.File:-dir:--boolean-"), 727);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-canMakeDirsInThisPath-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.io.File:-dir:--boolean-"), 753);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-copyThisEntryInThisSourceToThisZipFileWithThisName-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:java.lang.String:java.util.zip.ZipOutputStream:java.lang.String:-uriSourceFile:sSourceEntryName:zopTo:sTargetEntryName:-java.io.IOException:-void-"), 781);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-writeEntry-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.io.OutputStream-"), 97);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-writeEntry-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:boolean:-uriPath:fAppend:-java.io.IOException:-java.io.OutputStream-"), 112);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-deleteEntry-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-void-"), 154);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-deleteEntryOnExit-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-void-"), 175);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setPermissions-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:int:-uriPath:nPermissions:-java.io.IOException:-void-"), 188);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPermissions-com.ibm.ws.install.ni.framework.io.DiskFileSystem-java.net.URI:-uriPath:-java.io.IOException:-int-"), 215);
    }
}

