/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.io;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.prereq.PrereqPlugin;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class FilePermissionsCheckingPlugin
extends PrereqPlugin {
    private String m_sPrereqFailureMessage;
    private String m_sCachedFlag;
    private static final String S_PARAM_PERMISSIONTYPE = "permissiontype";
    private static final String S_PARAM_CHECKPERMISSIONS = "checkpermissions";
    private static final String S_PARAM_URI = "uri";
    private static final String S_PARAM_PARENT_DIR_URI = "parentdiruri";
    private static final String S_WRITE = "write";
    private static final String S_KEY_USER_NAME = "user.name";
    private static final String[] AS_REQUIRED_PARAMS;
    private static final String[] AS_OPTIONAL_PARAMS;
    private static final String S_MESSAGE_KEY_PERMISION_TYPE_NOT_SUPPORTED = "FilePermissionsChecking.PermissionTypeNotSupported";
    private static final String S_MESSAGE_KEY_WRITE_CHECKING_FAILED = "FilePermissionsChecking.WriteCheckingFailedMessage";
    private static final String S_NEW_LINE_CHAR = "\n";
    private static final String S_TAB_CHAR = "\t";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;

    static {
        Factory factory = new Factory("FilePermissionsCheckingPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.io.FilePermissionsCheckingPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.io.FilePermissionsCheckingPlugin----"), 215);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-init-com.ibm.ws.install.ni.framework.io.FilePermissionsCheckingPlugin----void-"), 27);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.io.FilePermissionsCheckingPlugin----java.lang.String-"), 41);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.io.FilePermissionsCheckingPlugin----java.lang.String-"), 94);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.io.FilePermissionsCheckingPlugin----[Ljava.lang.String;-"), 104);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.io.FilePermissionsCheckingPlugin----[Ljava.lang.String;-"), 114);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getFlagForWrite-com.ibm.ws.install.ni.framework.io.FilePermissionsCheckingPlugin---java.io.IOException:java.net.URISyntaxException:-boolean-"), 125);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getAllEntriesToBeChecked-com.ibm.ws.install.ni.framework.io.FilePermissionsCheckingPlugin---java.net.URISyntaxException:java.io.IOException:-[Lcom.ibm.ws.install.ni.framework.io.FileSystemEntry;-"), 156);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getPrereqFailureMessageWrite-com.ibm.ws.install.ni.framework.io.FilePermissionsCheckingPlugin-java.lang.String:java.util.Vector:-sCurrentAccount:vuriPaths:--java.lang.String-"), 199);
        AS_REQUIRED_PARAMS = new String[]{S_PARAM_PERMISSIONTYPE, S_PARAM_CHECKPERMISSIONS};
        AS_OPTIONAL_PARAMS = new String[]{S_PARAM_URI, S_PARAM_PARENT_DIR_URI};
    }

    public FilePermissionsCheckingPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_sPrereqFailureMessage = null;
            this.m_sCachedFlag = null;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public void init() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            super.init();
            this.m_sCachedFlag = null;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            String sCheckPermissions = this.getParamValue(S_PARAM_CHECKPERMISSIONS);
            if (!new Boolean(sCheckPermissions).booleanValue()) {
                string = Boolean.TRUE.toString();
            } else if (this.m_sCachedFlag != null) {
                string = this.m_sCachedFlag;
            } else {
                String sPermissionType = this.getParamValue(S_PARAM_PERMISSIONTYPE);
                try {
                    if (sPermissionType.equalsIgnoreCase(S_WRITE)) {
                        this.m_sCachedFlag = new Boolean(this.getFlagForWrite()).toString();
                    } else {
                        this.m_sPrereqFailureMessage = NIFResourceBundleUtils.getLocaleString(S_MESSAGE_KEY_PERMISION_TYPE_NOT_SUPPORTED, sPermissionType);
                        this.m_sCachedFlag = Boolean.FALSE.toString();
                    }
                }
                catch (IOException iOException) {
                    this.m_fUnexpectedExceptionOccured = true;
                    this.m_sCachedFlag = Boolean.FALSE.toString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.m_fUnexpectedExceptionOccured = true;
                    this.m_sCachedFlag = Boolean.FALSE.toString();
                }
                string = this.m_sCachedFlag;
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            String string = this.m_sPrereqFailureMessage;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_REQUIRED_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_REQUIRED_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_OPTIONAL_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_OPTIONAL_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean getFlagForWrite() throws IOException, URISyntaxException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Vector<URI> vuriPaths = new Vector<URI>();
            FileSystemEntry[] afseToBeChecked = this.getAllEntriesToBeChecked();
            int i = 0;
            while (i < afseToBeChecked.length) {
                if (!afseToBeChecked[i].writeable()) {
                    vuriPaths.add(afseToBeChecked[i].getURI());
                }
                ++i;
            }
            if (vuriPaths.size() == 0) {
                bl = true;
            } else {
                this.m_sPrereqFailureMessage = this.getPrereqFailureMessageWrite(System.getProperty(S_KEY_USER_NAME), vuriPaths);
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private FileSystemEntry[] getAllEntriesToBeChecked() throws URISyntaxException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Vector<FileSystemEntry> vfseToBeChecked = new Vector<FileSystemEntry>();
            String[] asURI = this.getParamValues(S_PARAM_URI);
            int i = 0;
            while (asURI != null && i < asURI.length) {
                FileSystemEntry fseThis = new FileSystemEntry(new URI(asURI[i]), this.getInstallToolkitBridge());
                vfseToBeChecked.add(fseThis);
                ++i;
            }
            String[] asParentURI = this.getParamValues(S_PARAM_PARENT_DIR_URI);
            int i2 = 0;
            while (asParentURI != null && i2 < asParentURI.length) {
                FileSystemEntry fseThis = new FileSystemEntry(new URI(asParentURI[i2]), this.getInstallToolkitBridge());
                FileSystemEntry[] fseChildren = fseThis.getDirectoryEntries();
                int x = 0;
                while (fseChildren != null && x < fseChildren.length) {
                    vfseToBeChecked.add(fseChildren[x]);
                    ++x;
                }
                ++i2;
            }
            FileSystemEntry[] fileSystemEntryArray = vfseToBeChecked.toArray(new FileSystemEntry[vfseToBeChecked.size()]);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(fileSystemEntryArray, joinPoint);
            return fileSystemEntryArray;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getPrereqFailureMessageWrite(String string, Vector vector) {
        String string2 = string;
        Vector vector2 = vector;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string2, (Object)vector2);
        try {
            void sCurrentAccount;
            void vuriPaths;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sMessage = S_NEW_LINE_CHAR;
            int i = 0;
            while (i < vuriPaths.size()) {
                sMessage = String.valueOf(sMessage) + S_TAB_CHAR + vuriPaths.elementAt(i) + S_NEW_LINE_CHAR;
                ++i;
            }
            sMessage = NIFResourceBundleUtils.getLocaleString(S_MESSAGE_KEY_WRITE_CHECKING_FAILED, new String[]{sCurrentAccount, sMessage});
            String string3 = String.valueOf(sMessage) + S_NEW_LINE_CHAR;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string3, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

