/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.io;

import com.ibm.ws.install.ni.framework.NIFConstants;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.fileactions.ZIPFileOperation;
import com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridgeException;
import com.ibm.ws.install.ni.framework.io.FileSystem;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.io.FileSystemNotSupportedException;
import com.ibm.ws.install.ni.framework.io.UnclosableZIPOutputStream;
import com.ibm.ws.install.ni.framework.os.ExecEngine;
import com.ibm.ws.install.ni.framework.os.PlatformConstants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.xml.sax.SAXException;

public class ZIPFileSystem
extends FileSystem {
    private Vector m_vuziposCached;
    private Hashtable m_hashtableZipFilesCached;
    private static final String S_ZIP_FS_SCHEME = "zip";
    private static final String S_TEMP_FILE_PREFIX = ".~$";
    private static final String S_ZIP = "zip";
    private static final String S_UTF_8 = "UTF-8";
    private static final String S_EMPTY = "";
    private static final String S_OPERATION_NOT_SUPPORTED = "Operation not supported for ZIPFileSystem.";
    private static final String S_DELETE_ENTRY_ON_EXIT_NOT_SUPPORTED = "Operation not supported for ZIPFileSystem for internal ZIP entries.";
    private static final String S_DELETE_FAILED = "Failed to delete: ";
    private static final String S_ZIPENTRY_OBJECT = "zipentryobject";
    private static final String S_ZIPINPUTSTREAM_OBJECT = "zipinputstreamobject";
    private static final String S_FILE_NOT_FOUND = "File not found: ";
    private static final String S_ATTRIB_COMMAND = "attrib";
    private static final String S_ATTR_HIDDEN = "+h";
    private static final String S_DISK_FS_SCHEME = "file";
    private static final String S_INVALID_FS_FOR_SYMLINK_ATTEMPT = "Invalid filesystem for symbolic link attempt or host and target filesystems don't match.";
    private static final String S_SOFTLINK_OPTION = "-s";
    private static final String S_FORCE_OPTION = "-f";
    private static final String S_LN_LOCATION_1 = "/bin/ln";
    private static final String S_LN_LOCATION_2 = "/usr/bin/ln";
    private static final String S_NO_LN_1 = "Symbolic linking ";
    private static final String S_NO_LN_2 = "->";
    private static final String S_NO_LN_3 = " failed as ln command was not found.";
    private static final String S_GENERIC_FAILURE_1 = "Symbolic linking ";
    private static final String S_GENERIC_FAILURE_2 = "->";
    private static final String S_GENERIC_FAILURE_3 = " failed.";
    private static final int N_LN_SUCCESS_CODE = 0;
    private static final String S_DOT_TMP = ".tmp";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;
    private static final JoinPoint.StaticPart ajc$tjp_25;
    private static final JoinPoint.StaticPart ajc$tjp_26;
    private static final JoinPoint.StaticPart ajc$tjp_27;
    private static final JoinPoint.StaticPart ajc$tjp_28;
    private static final JoinPoint.StaticPart ajc$tjp_29;
    private static final JoinPoint.StaticPart ajc$tjp_30;
    private static final JoinPoint.StaticPart ajc$tjp_31;
    private static final JoinPoint.StaticPart ajc$tjp_32;
    private static final JoinPoint.StaticPart ajc$tjp_33;
    private static final JoinPoint.StaticPart ajc$tjp_34;
    private static final JoinPoint.StaticPart ajc$tjp_35;
    private static final JoinPoint.StaticPart ajc$tjp_36;
    private static final JoinPoint.StaticPart ajc$tjp_37;
    private static final JoinPoint.StaticPart ajc$tjp_38;
    private static final JoinPoint.StaticPart ajc$tjp_39;
    private static final JoinPoint.StaticPart ajc$tjp_40;
    private static final JoinPoint.StaticPart ajc$tjp_41;
    private static final JoinPoint.StaticPart ajc$tjp_42;
    private static final JoinPoint.StaticPart ajc$tjp_43;
    private static final JoinPoint.StaticPart ajc$tjp_44;
    private static final JoinPoint.StaticPart ajc$tjp_45;
    private static final JoinPoint.StaticPart ajc$tjp_46;
    private static final JoinPoint.StaticPart ajc$tjp_47;
    private static final JoinPoint.StaticPart ajc$tjp_48;
    private static final JoinPoint.StaticPart ajc$tjp_49;
    private static final JoinPoint.StaticPart ajc$tjp_50;
    private static final JoinPoint.StaticPart ajc$tjp_51;
    private static final JoinPoint.StaticPart ajc$tjp_52;
    private static final JoinPoint.StaticPart ajc$tjp_53;
    private static final JoinPoint.StaticPart ajc$tjp_54;
    private static final JoinPoint.StaticPart ajc$tjp_55;
    private static final JoinPoint.StaticPart ajc$tjp_56;
    private static final JoinPoint.StaticPart ajc$tjp_57;
    private static final JoinPoint.StaticPart ajc$tjp_58;
    private static final JoinPoint.StaticPart ajc$tjp_59;
    private static final JoinPoint.StaticPart ajc$tjp_60;
    private static final JoinPoint.StaticPart ajc$tjp_61;
    private static final JoinPoint.StaticPart ajc$tjp_62;
    private static final JoinPoint.StaticPart ajc$tjp_63;
    private static final JoinPoint.StaticPart ajc$tjp_64;
    private static final JoinPoint.StaticPart ajc$tjp_65;
    private static final JoinPoint.StaticPart ajc$tjp_66;
    private static final JoinPoint.StaticPart ajc$tjp_67;
    private static final JoinPoint.StaticPart ajc$tjp_68;
    private static final JoinPoint.StaticPart ajc$tjp_69;
    private static final JoinPoint.StaticPart ajc$tjp_70;

    public ZIPFileSystem() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_vuziposCached = new Vector();
            this.m_hashtableZipFilesCached = new Hashtable();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void performAllZIPOperationsForThisTargetFile(URI uRI, Vector vector) throws IOException {
        URI uRI2 = uRI;
        Vector vector2 = vector;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)uRI2, (Object)vector2);
        try {
            void vZIPFileOperations;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (vZIPFileOperations != null && vZIPFileOperations.size() != 0) {
                void uriTargetFile;
                this.reinitThisFSForReading((URI)uriTargetFile);
                File fTargetFile = new File(uriTargetFile.getPath());
                File fTargetFileTmp = this.createTempFileForThisFile(fTargetFile);
                ZipOutputStream zipoutputstreamTargetTmp = new ZipOutputStream(new FileOutputStream(fTargetFileTmp));
                ZipFile zipfileTarget = this.getZipFileForReading((URI)uriTargetFile);
                this.moveAllEntriesFromThisZipFileToAnotherOneUnlessItIsToBeUpdated(zipfileTarget, zipoutputstreamTargetTmp, (Vector)vZIPFileOperations);
                this.ensureThisZipFileClosed(fTargetFile);
                try {
                    this.applyZIPFileOperationsToZIPFile((Vector)vZIPFileOperations, zipoutputstreamTargetTmp);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                zipoutputstreamTargetTmp.flush();
                zipoutputstreamTargetTmp.close();
                this.ensureThisZipFileClosed(fTargetFileTmp);
                this.moveFile(fTargetFileTmp, fTargetFile);
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long getSize(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)uRI2);
        try {
            long l;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (ZIPFileSystem.isEntireFSBeingTargetted((URI)uriPath)) {
                l = ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).length();
            } else {
                Hashtable hashtableThisEntry = this.getZIPEntryForThisURI((URI)uriPath);
                ZipEntry zipentryThis = (ZipEntry)hashtableThisEntry.get(S_ZIPENTRY_OBJECT);
                ZipInputStream inThis = (ZipInputStream)hashtableThisEntry.get(S_ZIPINPUTSTREAM_OBJECT);
                long nReturn = zipentryThis.getSize();
                inThis.close();
                l = nReturn;
            }
            long l2 = l;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.longObject((long)l2), joinPoint);
            return l;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setLastModifiedTime(URI uRI, long l) throws IOException {
        URI uRI2 = uRI;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)uRI2, (Object)Conversions.longObject((long)l2));
        try {
            void lTime;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (ZIPFileSystem.isEntireFSBeingTargetted((URI)uriPath)) {
                ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).setLastModified((long)lTime);
            } else {
                Hashtable hashtableThisEntry = this.getZIPEntryForThisURI((URI)uriPath);
                ZipEntry zipentryThis = (ZipEntry)hashtableThisEntry.get(S_ZIPENTRY_OBJECT);
                ZipInputStream inThis = (ZipInputStream)hashtableThisEntry.get(S_ZIPINPUTSTREAM_OBJECT);
                zipentryThis.setTime((long)lTime);
                inThis.close();
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream readEntry(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)uRI2);
        try {
            ZipFile zipfileThis;
            ZipEntry zipEntry;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            FileInputStream fileInputStream = ZIPFileSystem.isEntireFSBeingTargetted((URI)uriPath) ? new FileInputStream(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath)) : ((zipEntry = (zipfileThis = this.getZipFileForReading((URI)uriPath)).getEntry(ZIPFileSystem.getEntryPathForThisURI((URI)uriPath))) == null ? null : zipfileThis.getInputStream(zipEntry));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(fileInputStream, joinPoint);
            return fileInputStream;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream writeEntry(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)uRI2);
        try {
            OutputStream outputStream;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (ZIPFileSystem.isEntireFSBeingTargetted((URI)uriPath)) {
                outputStream = new FileOutputStream(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath));
            } else {
                File fileContainer = ZIPFileSystem.getFileContainerForThisFS((URI)uriPath);
                this.ensureThisZipFileClosed(fileContainer);
                ZipOutputStream zipoutputstreamThis = this.getZIPOutputStreamForAddingNewEntries((URI)uriPath);
                zipoutputstreamThis.putNextEntry(new ZipEntry(ZIPFileSystem.getEntryPathForThisURI((URI)uriPath)));
                outputStream = zipoutputstreamThis;
            }
            FileOutputStream fileOutputStream = outputStream;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(fileOutputStream, joinPoint);
            return outputStream;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream writeEntry(URI uRI, boolean bl) throws IOException {
        URI uRI2 = uRI;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)uRI2, (Object)Conversions.booleanObject((boolean)bl2));
        try {
            OutputStream outputStream;
            block9: {
                void fAppend;
                void uriPath;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
                if (ZIPFileSystem.isEntireFSBeingTargetted((URI)uriPath)) {
                    if (!ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).exists()) {
                        ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).getParentFile().mkdirs();
                    }
                    outputStream = new FileOutputStream(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath), (boolean)fAppend);
                } else if (fAppend == false) {
                    outputStream = this.writeEntry((URI)uriPath);
                } else {
                    OutputStream outReturn;
                    File fileContainer = ZIPFileSystem.getFileContainerForThisFS((URI)uriPath);
                    this.ensureThisZipFileClosed(fileContainer);
                    InputStream in = null;
                    try {
                        in = this.readEntry((URI)uriPath);
                    }
                    catch (IOException iOException) {
                        outputStream = this.writeEntry((URI)uriPath);
                        break block9;
                    }
                    File fileTemp = this.transferCurrentInputStreamToATempFile(in);
                    this.deleteEntry((URI)uriPath);
                    outputStream = outReturn = this.transferContentsOfGivenTemporaryFileToGivenZIPEntry((URI)uriPath, fileTemp);
                }
            }
            OutputStream outputStream2 = outputStream;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(outputStream2, joinPoint);
            return outputStream;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteEntry(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            this.ensureThisZipFileClosed(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath));
            if (ZIPFileSystem.isEntireFSBeingTargetted((URI)uriPath)) {
                if (!ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).delete() && ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).exists()) {
                    throw new IOException(S_DELETE_FAILED + uriPath);
                }
            } else {
                this.reinitThisFSForReading((URI)uriPath);
                File fileTmpDir = this.getUnifiedFileIOObject().createTempDir();
                this.extractThisZIPFileToThisDir(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath), fileTmpDir);
                if (!new File(fileTmpDir, ZIPFileSystem.getEntryPathForThisURI((URI)uriPath)).delete()) {
                    throw new IOException(S_DELETE_FAILED + uriPath);
                }
                File fileTmpZIP = File.createTempFile(S_TEMP_FILE_PREFIX, "zip");
                boolean fZipFileCreated = this.zipThisDirectoryToThisZIPFile(fileTmpDir, fileTmpZIP);
                new FileSystemEntry(fileTmpDir.toURI(), this.getInstallToolkitBridge()).deleteThisDirectoryRecursively();
                if (fZipFileCreated) {
                    this.ensureThisZipFileClosed(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath));
                    this.moveFile(fileTmpZIP, ZIPFileSystem.getFileContainerForThisFS((URI)uriPath));
                } else {
                    fileTmpZIP.deleteOnExit();
                    if (!ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).delete()) {
                        throw new IOException(S_DELETE_FAILED + ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).toString());
                    }
                }
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteEntryOnExit(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            this.ensureThisZipFileClosed(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath));
            if (!ZIPFileSystem.isEntireFSBeingTargetted((URI)uriPath)) {
                throw new IOException(S_DELETE_ENTRY_ON_EXIT_NOT_SUPPORTED);
            }
            ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).deleteOnExit();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPermissions(URI uRI, int n) throws IOException {
        URI uRI2 = uRI;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)uRI2, (Object)Conversions.intObject((int)n2));
        try {
            void nPermissions;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (ZIPFileSystem.isEntireFSBeingTargetted((URI)uriPath)) {
                this.setParentFSPermissions((URI)uriPath, (int)nPermissions);
            } else {
                Hashtable hashtableThisEntry = this.getZIPEntryForThisURI((URI)uriPath);
                ZipEntry zipentryThis = (ZipEntry)hashtableThisEntry.get(S_ZIPENTRY_OBJECT);
                ZipInputStream inThis = (ZipInputStream)hashtableThisEntry.get(S_ZIPINPUTSTREAM_OBJECT);
                zipentryThis.setExtra(Integer.toString((int)nPermissions).getBytes(S_UTF_8));
                inThis.close();
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getPermissions(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)uRI2);
        try {
            int n;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (ZIPFileSystem.isEntireFSBeingTargetted((URI)uriPath)) {
                n = this.getParentFSPermissions((URI)uriPath);
            } else {
                Hashtable hashtableThisEntry = this.getZIPEntryForThisURI((URI)uriPath);
                ZipEntry zipentryThis = (ZipEntry)hashtableThisEntry.get(S_ZIPENTRY_OBJECT);
                ZipInputStream inThis = (ZipInputStream)hashtableThisEntry.get(S_ZIPINPUTSTREAM_OBJECT);
                String sPermissions = new String(zipentryThis.getExtra(), S_UTF_8);
                inThis.close();
                try {
                    n = Integer.parseInt(sPermissions);
                }
                catch (NumberFormatException e) {
                    throw new IOException(e.getMessage());
                }
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createSymbolicLink(URI uRI, String string) throws IOException {
        URI uRI2 = uRI;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)uRI2, (Object)string2);
        try {
            void sPathToLinkTo;
            void uriSymbolicLinkPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (!ZIPFileSystem.isEntireFSBeingTargetted((URI)uriSymbolicLinkPath)) {
                throw new IOException(S_OPERATION_NOT_SUPPORTED);
            }
            this.createFSSymbolicLink((URI)uriSymbolicLinkPath, (String)sPathToLinkTo);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long getLastModified(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            Hashtable hashtableThisEntry = this.getZIPEntryForThisURI((URI)uriPath);
            ZipEntry zipentryThis = (ZipEntry)hashtableThisEntry.get(S_ZIPENTRY_OBJECT);
            ZipInputStream inThis = (ZipInputStream)hashtableThisEntry.get(S_ZIPINPUTSTREAM_OBJECT);
            long lLastModified = zipentryThis.getTime();
            inThis.close();
            long l = lLastModified;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.longObject((long)l), joinPoint);
            return l;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public URI getFSURI(URI uRI, String string) throws URISyntaxException {
        URI uRI2 = uRI;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)uRI2, (Object)string2);
        try {
            void sEntryPath;
            String sExistingPath;
            void uriParent;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            Object sPathReturn = null;
            sPathReturn = ZIPFileSystem.getEntryPathForThisURI((URI)uriParent) != null ? ((sExistingPath = ZIPFileSystem.getEntryPathForThisURI((URI)uriParent)).endsWith("/") ? String.valueOf(sExistingPath) + (String)sEntryPath : String.valueOf(sExistingPath) + "/" + (String)sEntryPath) : sEntryPath;
            URI uriFS = ZIPFileSystem.getFSURIForThisEntry((URI)uriParent);
            URI uRI3 = ZIPFileSystem.getURIGivenFSURIAndEntryPath(uriFS, sPathReturn);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(uRI3, joinPoint);
            return uRI3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean exists(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this, (Object)uRI2);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                void uriPath;
                File fContainer = ZIPFileSystem.getFileContainerForThisFS((URI)uriPath);
                if (!fContainer.exists()) {
                    bl = false;
                } else if (ZIPFileSystem.isEntireFSBeingTargetted((URI)uriPath)) {
                    bl = true;
                } else {
                    boolean fNeedCloseZipFile = !this.hasThisZipFileContainerBeenCached((URI)uriPath);
                    ZipFile zipfileThis = this.getZipFileForReading((URI)uriPath);
                    if (zipfileThis == null) {
                        bl = false;
                    } else {
                        String sEntryPath = ZIPFileSystem.getEntryPathForThisURI((URI)uriPath);
                        if (sEntryPath == null) {
                            bl = false;
                        } else {
                            ZipEntry zipEntry = zipfileThis.getEntry(sEntryPath);
                            if (zipEntry == null) {
                                bl = false;
                            } else {
                                InputStream inputstreamThis = zipfileThis.getInputStream(zipEntry);
                                if (inputstreamThis != null && inputstreamThis.available() != 0) {
                                    inputstreamThis.close();
                                    if (fNeedCloseZipFile) {
                                        this.ensureThisZipFileClosed(fContainer);
                                    }
                                    bl = true;
                                } else {
                                    if (inputstreamThis != null) {
                                        inputstreamThis.close();
                                    }
                                    if (fNeedCloseZipFile) {
                                        this.ensureThisZipFileClosed(fContainer);
                                    }
                                    bl = false;
                                }
                            }
                        }
                    }
                }
            }
            catch (ZipException zipException) {
                bl = false;
            }
            catch (IOException iOException) {
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDirectory(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            boolean bl = uriPath.toString().endsWith("/");
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void mkdirs(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            ZipOutputStream zipoutputstreamThis = this.getZIPOutputStreamForAddingNewEntries((URI)uriPath);
            String sZIPEntryPath = ZIPFileSystem.getEntryPathForThisURI((URI)uriPath);
            if (!sZIPEntryPath.substring(sZIPEntryPath.length() - 1).equals("/")) {
                sZIPEntryPath = String.valueOf(sZIPEntryPath) + "/";
            }
            zipoutputstreamThis.putNextEntry(new ZipEntry(sZIPEntryPath));
            zipoutputstreamThis.close();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public URI getParent(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)uRI2);
        try {
            URI uRI3;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (ZIPFileSystem.getEntryPathForThisURI((URI)uriPath) != null) {
                String sPathThis = ZIPFileSystem.getEntryPathForThisURI((URI)uriPath);
                try {
                    String sParentPath = null;
                    sParentPath = sPathThis.indexOf("/") != -1 ? String.valueOf(sPathThis.substring(0, sPathThis.lastIndexOf("/"))) + "/" : "/";
                    uRI3 = ZIPFileSystem.getURIGivenFSURIAndEntryPath(ZIPFileSystem.getFSURIForThisEntry((URI)uriPath), sParentPath);
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                uRI3 = uriPath;
            }
            void var6_7 = uRI3;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(var6_7, joinPoint);
            return uRI3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public URI getParentDirOrFSRoot(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this, (Object)uRI2);
        try {
            URI uRI3;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            if (ZIPFileSystem.getEntryPathForThisURI((URI)uriPath) != null) {
                String sPathThis = ZIPFileSystem.getEntryPathForThisURI((URI)uriPath);
                if (sPathThis.endsWith("/")) {
                    sPathThis = sPathThis.substring(0, sPathThis.length() - "/".length());
                }
                try {
                    String sParentPath = null;
                    if (sPathThis.indexOf("/") != -1) {
                        sParentPath = String.valueOf(sPathThis.substring(0, sPathThis.lastIndexOf("/"))) + "/";
                        uRI3 = ZIPFileSystem.getURIGivenFSURIAndEntryPath(ZIPFileSystem.getFSURIForThisEntry((URI)uriPath), sParentPath);
                    }
                    uRI3 = new URI(uriPath.getScheme(), uriPath.getAuthority(), uriPath.getPath(), uriPath.getQuery(), null);
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                uRI3 = uriPath;
            }
            void var6_7 = uRI3;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(var6_7, joinPoint);
            return uRI3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getEntryName(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this, (Object)uRI2);
        try {
            String sEntryName;
            String sPathThis;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            String string = ZIPFileSystem.getEntryPathForThisURI((URI)uriPath) != null ? ((sPathThis = ZIPFileSystem.getEntryPathForThisURI((URI)uriPath)).indexOf("/") != -1 ? (sEntryName = sPathThis.substring(sPathThis.lastIndexOf("/"))) : sPathThis) : ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).getName();
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getCanonicalPath(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            String string = new File(uriPath.getPath()).getCanonicalPath();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getAbsolutePath(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            String string = new File(uriPath.getPath()).getAbsolutePath();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getAbsolutePathWithFlagment(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            String sReturn = this.getAbsolutePath((URI)uriPath);
            String sFragment = uriPath.getFragment();
            if (sFragment != null && !sFragment.equals(S_EMPTY)) {
                if (!sReturn.endsWith("#")) {
                    sReturn = String.valueOf(sReturn) + "#";
                }
                sReturn = String.valueOf(sReturn) + sFragment;
            }
            String string = sReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void renameTo(URI uRI, URI uRI2) throws IOException {
        URI uRI3 = uRI;
        URI uRI4 = uRI2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, (Object)this, (Object)this, (Object)uRI3, (Object)uRI4);
        try {
            void uriPathTo;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            this.copyTo((URI)uriPath, (URI)uriPathTo);
            this.deleteEntry((URI)uriPath);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public URI[] getDirectoryEntries(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            URI[] uRIArray = this.getDirectoryEntries((URI)uriPath, false);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(uRIArray, joinPoint);
            return uRIArray;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public URI[] getDirectoryEntries(URI uRI, boolean bl) {
        URI uRI2 = uRI;
        boolean bl2 = bl;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, (Object)this, (Object)this, (Object)uRI2, (Object)Conversions.booleanObject((boolean)bl2));
        try {
            URI[] uRIArray;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                void uriPath;
                ZipFile zipfileThis = this.getZipFileForReading((URI)uriPath);
                Enumeration<? extends ZipEntry> enumerationZipEntries = zipfileThis.entries();
                String sPathThis = ZIPFileSystem.getEntryPathForThisURI((URI)uriPath);
                if (sPathThis == null) {
                    sPathThis = S_EMPTY;
                }
                if (!sPathThis.endsWith("/")) {
                    sPathThis = String.valueOf(sPathThis) + "/";
                }
                if (!sPathThis.startsWith("/")) {
                    sPathThis = "/" + sPathThis;
                }
                Vector<URI> vuris = new Vector<URI>();
                while (enumerationZipEntries.hasMoreElements()) {
                    void fDirectChildrenOnly;
                    ZipEntry zipentryThis = enumerationZipEntries.nextElement();
                    String sPathThisEntry = zipentryThis.getName();
                    if (!sPathThisEntry.startsWith("/")) {
                        sPathThisEntry = "/" + sPathThisEntry;
                    }
                    if (!sPathThisEntry.startsWith(sPathThis) || sPathThisEntry.equals(sPathThis) || fDirectChildrenOnly != false && !this.isDirectChildren(sPathThis, sPathThisEntry)) continue;
                    vuris.add(new URI(uriPath.getScheme(), uriPath.getAuthority(), uriPath.getPath(), null, sPathThisEntry));
                }
                URI[] auris = new URI[vuris.size()];
                int i = 0;
                while (i < vuris.size()) {
                    auris[i] = (URI)vuris.elementAt(i);
                    ++i;
                }
                uRIArray = auris;
            }
            catch (ZipException zipException) {
                uRIArray = new URI[]{};
            }
            catch (IOException iOException) {
                uRIArray = new URI[]{};
            }
            catch (URISyntaxException uRISyntaxException) {
                uRIArray = new URI[]{};
            }
            URI[] uRIArray2 = uRIArray;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(uRIArray2, joinPoint);
            return uRIArray;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public URI[] getEntriesDirectlyUnderThisDir(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_26, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            URI[] uRIArray = this.getDirectoryEntries((URI)uriPath, true);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(uRIArray, joinPoint);
            return uRIArray;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSymbolicLinkTarget(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_27, (Object)this, (Object)this, (Object)uRI2);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            throw new IOException(S_OPERATION_NOT_SUPPORTED);
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void flushFileSystemFor(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_28, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            this.reinitThisFSForReading((URI)uriPath);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setHidden(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_29, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (ZIPFileSystem.isEntireFSBeingTargetted((URI)uriPath) && PlatformConstants.isCurrentPlatformWindows()) {
                String sPath = new File((URI)uriPath).getAbsolutePath();
                String[] asCommandArguments = new String[]{S_ATTRIB_COMMAND, S_ATTR_HIDDEN, sPath};
                ExecEngine eeThis = new ExecEngine();
                eeThis.executeIncomingArgumentsAsync(asCommandArguments);
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void copyThisEntryInThisSourceToThisZipFileWithThisName(URI uRI, String string, ZipOutputStream zipOutputStream, String string2) throws IOException {
        URI uRI2 = uRI;
        String string3 = string;
        ZipOutputStream zipOutputStream2 = zipOutputStream;
        String string4 = string2;
        Object[] objectArray = new Object[]{uRI2, string3, zipOutputStream2, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_30, (Object)this, (Object)this, (Object[])objectArray);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                void sTargetEntryName;
                void zopTo;
                void sSourceEntryName;
                void uriSourceFile;
                ZipFile zipfileSource = this.getZipFileForReading((URI)uriSourceFile);
                ZipEntry zipentrySource = new ZipEntry((String)sSourceEntryName);
                this.copyZipEntry(zipfileSource, zipentrySource, (ZipOutputStream)zopTo, (String)sTargetEntryName);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String getSupportedScheme() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_31, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = "zip";
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return "zip";
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected void flush() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_32, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.closeAllCachedZIPOutputStreams();
            this.closeAllCachedZipFiles();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected boolean isDirectChildren(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_33, (Object)this, (Object)this, (Object)string3, (Object)string4);
        try {
            boolean bl;
            String sChildEntry;
            String sParentEntry;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (sParentEntry.startsWith("/")) {
                sParentEntry = sParentEntry.substring(1);
            }
            if (!sParentEntry.endsWith("/")) {
                sParentEntry = sParentEntry.substring(0, sParentEntry.length() - 1);
            }
            if (sChildEntry.startsWith("/")) {
                sChildEntry = sChildEntry.substring(1);
            }
            if (!sChildEntry.endsWith("/")) {
                sChildEntry = sChildEntry.substring(0, sChildEntry.length() - 1);
            }
            if (!sChildEntry.startsWith(sParentEntry)) {
                bl = false;
            } else {
                String sTail = sChildEntry.substring(sParentEntry.length());
                if (sTail.startsWith("/")) {
                    sTail = sTail.substring(1);
                }
                if (sTail.endsWith("/")) {
                    sTail = sTail.substring(0, sTail.length() - 1);
                }
                bl = sTail != null && !sTail.trim().equals(S_EMPTY) && sTail.indexOf("/") < 0;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void moveFile(File file, File file2) throws IOException {
        File file3 = file;
        File file4 = file2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_34, (Object)this, (Object)this, (Object)file3, (Object)file4);
        try {
            void fileToMove;
            void fileToMoveTo;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (fileToMoveTo.exists() && !fileToMoveTo.delete()) {
                throw new IOException(S_DELETE_FAILED + fileToMoveTo.toString());
            }
            if (!fileToMove.renameTo((File)fileToMoveTo)) {
                this.copyDiskFiles((File)fileToMove, (File)fileToMoveTo);
                fileToMove.delete();
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void copyDiskFiles(File file, File file2) throws IOException {
        File file3 = file;
        File file4 = file2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_35, (Object)this, (Object)this, (Object)file3, (Object)file4);
        try {
            void fileDestination;
            void fileSource;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            FileInputStream in = new FileInputStream((File)fileSource);
            FileOutputStream out = new FileOutputStream((File)fileDestination);
            this.transferInputStreamToOutputStreamCompletely(in, out);
            in.close();
            out.close();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private ZipFile getZipFileForReading(URI uRI) throws ZipException, IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_36, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.reinitThisFSForReading((URI)uriPath);
            File fileContainer = ZIPFileSystem.getFileContainerForThisFS((URI)uriPath);
            ZipFile zipfileContainer = (ZipFile)this.m_hashtableZipFilesCached.get(fileContainer);
            if (zipfileContainer == null) {
                zipfileContainer = new ZipFile(fileContainer);
                this.m_hashtableZipFilesCached.put(fileContainer, zipfileContainer);
            }
            ZipFile zipFile = zipfileContainer;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(zipFile, joinPoint);
            return zipFile;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasThisZipFileContainerBeenCached(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_37, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            File fileContainer = ZIPFileSystem.getFileContainerForThisFS((URI)uriPath);
            boolean bl = this.m_hashtableZipFilesCached.get(fileContainer) != null;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void ensureThisZipFileClosed(File file) throws IOException {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_38, (Object)this, (Object)this, (Object)file2);
        try {
            void file3;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            ZipFile zipfileContainer = (ZipFile)this.m_hashtableZipFilesCached.get(file3);
            if (zipfileContainer != null) {
                zipfileContainer.close();
                this.m_hashtableZipFilesCached.remove(file3);
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private void closeAllCachedZipFiles() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_39, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (this.m_hashtableZipFilesCached != null) {
                Enumeration enu = this.m_hashtableZipFilesCached.elements();
                while (enu.hasMoreElements()) {
                    ZipFile zipfileThis = (ZipFile)enu.nextElement();
                    zipfileThis.close();
                }
                this.m_hashtableZipFilesCached.clear();
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private ZipOutputStream getZIPOutputStreamForAddingNewEntries(URI uRI) throws IOException, FileNotFoundException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_40, (Object)this, (Object)this, (Object)uRI2);
        try {
            UnclosableZIPOutputStream zipoutputstream;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (!ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).getParentFile().exists()) {
                ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).getParentFile().mkdirs();
            }
            if ((zipoutputstream = this.getCachedZIPOutputStream(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath))) == null) {
                File fileTmpDir = this.getUnifiedFileIOObject().createTempDir();
                this.extractThisZIPFileToThisDirIfItExists(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath), fileTmpDir);
                FileOutputStream outputstreamZIPFile = new FileOutputStream(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath), false);
                zipoutputstream = new UnclosableZIPOutputStream((OutputStream)outputstreamZIPFile, ZIPFileSystem.getFileContainerForThisFS((URI)uriPath));
                this.m_vuziposCached.add(zipoutputstream);
                this.zipThisDirectoryToThisZIPFile(fileTmpDir, zipoutputstream);
                new FileSystemEntry(fileTmpDir.toURI(), this.getInstallToolkitBridge()).deleteThisDirectoryRecursively();
            }
            UnclosableZIPOutputStream unclosableZIPOutputStream = zipoutputstream;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(unclosableZIPOutputStream, joinPoint);
            return unclosableZIPOutputStream;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reinitThisFSForReading(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_41, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            UnclosableZIPOutputStream uzosThis = this.getCachedZIPOutputStream(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath));
            if (uzosThis != null) {
                uzosThis.closeWrappedStream();
                this.m_vuziposCached.remove(uzosThis);
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private UnclosableZIPOutputStream getCachedZIPOutputStream(File file) {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_42, (Object)this, (Object)this, (Object)file2);
        try {
            UnclosableZIPOutputStream unclosableZIPOutputStream;
            block4: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                int i = 0;
                while (i < this.m_vuziposCached.size()) {
                    void fileFSContainer;
                    UnclosableZIPOutputStream uziposThis = (UnclosableZIPOutputStream)this.m_vuziposCached.elementAt(i);
                    if (uziposThis.getParentZIPFile().equals(fileFSContainer)) {
                        unclosableZIPOutputStream = uziposThis;
                        break block4;
                    }
                    ++i;
                }
                unclosableZIPOutputStream = null;
            }
            UnclosableZIPOutputStream unclosableZIPOutputStream2 = unclosableZIPOutputStream;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(unclosableZIPOutputStream2, joinPoint);
            return unclosableZIPOutputStream;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private void closeAllCachedZIPOutputStreams() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_43, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            int i = 0;
            while (i < this.m_vuziposCached.size()) {
                UnclosableZIPOutputStream uziposThis = (UnclosableZIPOutputStream)this.m_vuziposCached.elementAt(i);
                uziposThis.closeWrappedStream();
                ++i;
            }
            this.m_vuziposCached.removeAllElements();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean zipThisDirectoryToThisZIPFile(File file, File file2) throws IOException, FileNotFoundException {
        File file3 = file;
        File file4 = file2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_44, (Object)this, (Object)this, (Object)file3, (Object)file4);
        try {
            boolean bl;
            void fileDirToZip;
            void fileZIP;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream((File)fileZIP)));
            if (this.zipThisDirectoryToThisZIPFile((File)fileDirToZip, out)) {
                out.close();
                bl = true;
            } else {
                out.flush();
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean zipThisDirectoryToThisZIPFile(File file, ZipOutputStream zipOutputStream) throws IOException, FileNotFoundException {
        File file2 = file;
        ZipOutputStream zipOutputStream2 = zipOutputStream;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_45, (Object)this, (Object)this, (Object)file2, (Object)zipOutputStream2);
        try {
            void fileDirToZip;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Vector vfileFilesToZip = this.getUnifiedFileIOObject().getFilesInDirectoryRecursive((File)fileDirToZip);
            int i = 0;
            while (i < vfileFilesToZip.size()) {
                void out;
                File fileToZipThis = (File)vfileFilesToZip.elementAt(i);
                String sThisEntryName = this.getNormalizedRelativeNameZipEntryName(fileToZipThis, (File)fileDirToZip);
                ZipEntry zipentryThis = new ZipEntry(sThisEntryName);
                out.putNextEntry(zipentryThis);
                if (!fileToZipThis.isDirectory()) {
                    FileInputStream in = new FileInputStream(fileToZipThis);
                    this.transferInputStreamToOutputStreamCompletely(in, (OutputStream)out);
                    in.close();
                }
                ++i;
            }
            boolean bl = vfileFilesToZip.size() > 0;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getNormalizedRelativeNameZipEntryName(File file, File file2) {
        File file3 = file;
        File file4 = file2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_46, (Object)this, (Object)this, (Object)file3, (Object)file4);
        try {
            void fileDirBeingZipped;
            void fileToZip;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sEntryName = fileToZip.getAbsolutePath().substring(fileDirBeingZipped.getAbsolutePath().toString().length());
            if (sEntryName.indexOf(92) >= 0) {
                sEntryName = sEntryName.replace('\\', '/');
            }
            if (sEntryName.startsWith("/")) {
                sEntryName = sEntryName.substring(1, sEntryName.length());
            }
            if (fileToZip.isDirectory()) {
                if (!sEntryName.substring(sEntryName.length() - 1).equals("/")) {
                    sEntryName = String.valueOf(sEntryName) + "/";
                }
            } else if (sEntryName.endsWith("/")) {
                sEntryName = sEntryName.substring(0, sEntryName.length() - 1);
            }
            String string = sEntryName;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void extractThisZIPFileToThisDirIfItExists(File file, File file2) throws ZipException, IOException, FileNotFoundException {
        File file3 = file;
        File file4 = file2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_47, (Object)this, (Object)this, (Object)file3, (Object)file4);
        try {
            void fileZIP;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (fileZIP.exists()) {
                void fileDirToExtractTo;
                this.extractThisZIPFileToThisDir((File)fileZIP, (File)fileDirToExtractTo);
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void extractThisZIPFileToThisDir(File file, File file2) throws ZipException, IOException, FileNotFoundException {
        File file3 = file;
        File file4 = file2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_48, (Object)this, (Object)this, (Object)file3, (Object)file4);
        try {
            void fileZIP;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            ZipFile zipfile = new ZipFile((File)fileZIP);
            Enumeration<? extends ZipEntry> enumeationZIPEntries = zipfile.entries();
            while (enumeationZIPEntries.hasMoreElements()) {
                void fileDirToExtractTo;
                ZipEntry zipentryThis = enumeationZIPEntries.nextElement();
                String sFileNameThis = zipentryThis.getName();
                if (zipentryThis.isDirectory()) {
                    new File((File)fileDirToExtractTo, sFileNameThis).mkdirs();
                    continue;
                }
                File fileThis = new File((File)fileDirToExtractTo, sFileNameThis);
                fileThis.getParentFile().mkdirs();
                InputStream in = zipfile.getInputStream(zipentryThis);
                FileOutputStream out = new FileOutputStream(fileThis);
                this.transferInputStreamToOutputStreamCompletely(in, out);
                in.close();
                ((OutputStream)out).close();
            }
            zipfile.close();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private OutputStream transferContentsOfGivenTemporaryFileToGivenZIPEntry(URI uRI, File file) throws IOException, FileNotFoundException {
        URI uRI2 = uRI;
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_49, (Object)this, (Object)this, (Object)uRI2, (Object)file2);
        try {
            void fileTemp;
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            OutputStream outReturn = this.writeEntry((URI)uriPath);
            FileInputStream inTemp = new FileInputStream((File)fileTemp);
            this.transferInputStreamToOutputStreamCompletely(inTemp, outReturn);
            ((InputStream)inTemp).close();
            fileTemp.delete();
            OutputStream outputStream = outReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(outputStream, joinPoint);
            return outputStream;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private File transferCurrentInputStreamToATempFile(InputStream inputStream) throws IOException, FileNotFoundException {
        InputStream inputStream2 = inputStream;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_50, (Object)this, (Object)this, (Object)inputStream2);
        try {
            void in;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            File fileTemp = File.createTempFile(S_TEMP_FILE_PREFIX, null);
            FileOutputStream out = new FileOutputStream(fileTemp);
            this.transferInputStreamToOutputStreamCompletely((InputStream)in, out);
            ((OutputStream)out).close();
            in.close();
            File file = fileTemp;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(file, joinPoint);
            return file;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static String getEntryPathForThisURI(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_51, null, null, (Object)uRI2);
        try {
            URI uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = uriPath.getFragment() == null ? null : (uriPath.getFragment().startsWith("/") ? uriPath.getFragment().substring(1) : uriPath.getFragment());
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static URI getURIGivenFSURIAndEntryPath(URI uRI, String string) throws URISyntaxException {
        URI uRI2 = uRI;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_52, null, null, (Object)uRI2, (Object)string2);
        try {
            void sEntryPath;
            URI uriFS;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            URI uRI3 = new URI(uriFS.getScheme(), uriFS.getAuthority(), uriFS.getPath(), uriFS.getQuery(), (String)sEntryPath);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(uRI3, joinPoint);
            return uRI3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static boolean isEntireFSBeingTargetted(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_53, null, null, (Object)uRI2);
        try {
            URI uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = ZIPFileSystem.getEntryPathForThisURI(uriPath) == null;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static File getFileContainerForThisFS(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_54, null, null, (Object)uRI2);
        try {
            URI uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sContainerPath = null;
            sContainerPath = uriPath.getAuthority() != null ? String.valueOf(uriPath.getAuthority()) + uriPath.getPath() : uriPath.getPath();
            File file = new File(sContainerPath);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(file, joinPoint);
            return file;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static URI getFSURIForThisEntry(URI uRI) throws URISyntaxException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_55, null, null, (Object)uRI2);
        try {
            URI uriEntry;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            URI uRI3 = new URI(uriEntry.getScheme(), uriEntry.getAuthority(), uriEntry.getPath(), uriEntry.getQuery(), null);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(uRI3, joinPoint);
            return uRI3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Hashtable getZIPEntryForThisURI(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_56, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Hashtable hashtableReturn = this.getZIPEntryForThisURIReturnNullIfNotFound((URI)uriPath);
            if (hashtableReturn == null) {
                throw new IOException(S_FILE_NOT_FOUND + uriPath.toString());
            }
            Hashtable hashtable = hashtableReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(hashtable, joinPoint);
            return hashtable;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Hashtable getZIPEntryForThisURIReturnNullIfNotFound(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_57, (Object)this, (Object)this, (Object)uRI2);
        try {
            Hashtable<String, ZipConstants> hashtable;
            block5: {
                void uriPath;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                if (ZIPFileSystem.isEntireFSBeingTargetted((URI)uriPath)) {
                    hashtable = null;
                } else {
                    this.reinitThisFSForReading((URI)uriPath);
                    ZipInputStream in = new ZipInputStream(new FileInputStream(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath)));
                    while (in.available() != 0) {
                        ZipEntry zipentryThis = in.getNextEntry();
                        if (zipentryThis == null || !zipentryThis.getName().equals(ZIPFileSystem.getEntryPathForThisURI((URI)uriPath))) continue;
                        Hashtable<String, ZipConstants> hashtableReturn = new Hashtable<String, ZipConstants>();
                        hashtableReturn.put(S_ZIPENTRY_OBJECT, zipentryThis);
                        hashtableReturn.put(S_ZIPINPUTSTREAM_OBJECT, in);
                        hashtable = hashtableReturn;
                        break block5;
                    }
                    in.close();
                    hashtable = null;
                }
            }
            Hashtable<String, ZipConstants> hashtable2 = hashtable;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(hashtable2, joinPoint);
            return hashtable;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setParentFSPermissions(URI uRI, int n) throws IOException {
        URI uRI2 = uRI;
        int n2 = n;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_58, (Object)this, (Object)this, (Object)uRI2, (Object)Conversions.intObject((int)n2));
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                if (!PlatformConstants.isOS400Install()) {
                    void nPermissions;
                    void uriPath;
                    this.getUnifiedFileIOObject().setPermissions(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).getAbsolutePath(), (int)nPermissions);
                }
            }
            catch (InstallToolkitBridgeException e) {
                throw new IOException(e.getMessage());
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getParentFSPermissions(URI uRI) throws IOException {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_59, (Object)this, (Object)this, (Object)uRI2);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                void uriPath;
                n = PlatformConstants.isOS400Install() ? 755 : this.getUnifiedFileIOObject().getPermissions(ZIPFileSystem.getFileContainerForThisFS((URI)uriPath).getAbsolutePath());
            }
            catch (InstallToolkitBridgeException e) {
                throw new IOException(e.getMessage());
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createFSSymbolicLink(URI uRI, String string) throws IOException {
        URI uRI2 = uRI;
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_60, (Object)this, (Object)this, (Object)uRI2, (Object)string2);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (!PlatformConstants.isOS400Install()) {
                void sPathToLinkTo;
                File fileSymbolicLink;
                void uriSymbolicLinkPath;
                if (!uriSymbolicLinkPath.getScheme().equalsIgnoreCase(S_DISK_FS_SCHEME)) {
                    throw new IOException(S_INVALID_FS_FOR_SYMLINK_ATTEMPT);
                }
                if (!ZIPFileSystem.getFileContainerForThisFS(this.getParent((URI)uriSymbolicLinkPath)).exists()) {
                    this.mkdirs(this.getParent((URI)uriSymbolicLinkPath));
                }
                if ((fileSymbolicLink = ZIPFileSystem.getFileContainerForThisFS((URI)uriSymbolicLinkPath)).exists()) {
                    fileSymbolicLink.delete();
                }
                String sLink = ZIPFileSystem.getFileContainerForThisFS((URI)uriSymbolicLinkPath).getAbsolutePath();
                String sLNCommand = this.getLNCommand();
                if (sLNCommand == null) {
                    throw new IOException("Symbolic linking " + sLink + "->" + (String)sPathToLinkTo + S_NO_LN_3);
                }
                String[] asArgs = new String[]{sLNCommand, S_SOFTLINK_OPTION, S_FORCE_OPTION, sPathToLinkTo, sLink};
                ExecEngine ee = new ExecEngine();
                ee.executeIncomingArguments(asArgs, NIFConstants.N_DEFAULT_PROCESS_TIME_OUT_TIME);
                if (ee.getProcessRetCode() != 0) {
                    throw new IOException("Symbolic linking " + sLink + "->" + (String)sPathToLinkTo + S_GENERIC_FAILURE_3);
                }
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private String getLNCommand() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_61, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sLNCommand = null;
            if (new File(S_LN_LOCATION_1).exists()) {
                sLNCommand = S_LN_LOCATION_1;
            }
            if (new File(S_LN_LOCATION_2).exists()) {
                sLNCommand = S_LN_LOCATION_2;
            }
            String string = sLNCommand;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isReadable(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_62, (Object)this, (Object)this, (Object)uRI2);
        try {
            void uriPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            boolean bl = new File((URI)uriPath).canRead();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isWriteable(URI uRI) {
        URI uRI2 = uRI;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_63, (Object)this, (Object)this, (Object)uRI2);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                void uriPath;
                File testFile = new File(uriPath.getPath());
                while (!testFile.exists()) {
                    testFile = testFile.getParentFile();
                }
                if (testFile.isDirectory()) {
                    bl = this.isThisPathWritable(testFile);
                } else if (PlatformConstants.isCurrentPlatformWindows()) {
                    try {
                        FileOutputStream fileoutputstreamThisFile = new FileOutputStream(testFile, true);
                        fileoutputstreamThisFile.close();
                        bl = true;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        bl = false;
                    }
                    catch (IOException iOException) {
                        bl = false;
                    }
                } else {
                    bl = testFile.canWrite();
                }
            }
            catch (SecurityException securityException) {
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isThisPathWritable(File file) {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_64, (Object)this, (Object)this, (Object)file2);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            try {
                void dir;
                File fTemp = File.createTempFile("_write_", "_test_", (File)dir);
                fTemp.delete();
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
            }
            catch (SecurityException securityException) {
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void copyZipEntry(ZipFile zipFile, ZipEntry zipEntry, ZipOutputStream zipOutputStream, String string) throws IOException {
        ZipFile zipFile2 = zipFile;
        ZipEntry zipEntry2 = zipEntry;
        ZipOutputStream zipOutputStream2 = zipOutputStream;
        String string2 = string;
        Object[] objectArray = new Object[]{zipFile2, zipEntry2, zipOutputStream2, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_65, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void from;
            void fromFile;
            void toFile;
            void targetName;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            ZipEntry to = new ZipEntry((String)targetName);
            toFile.putNextEntry(to);
            this.copyZipEntry(fromFile.getInputStream((ZipEntry)from), (ZipOutputStream)toFile);
            toFile.closeEntry();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void copyZipEntry(InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        InputStream inputStream2 = inputStream;
        ZipOutputStream zipOutputStream2 = zipOutputStream;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_66, (Object)this, (Object)this, (Object)inputStream2, (Object)zipOutputStream2);
        try {
            void from;
            int length;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            byte[] data = new byte[1000];
            while ((length = from.read(data)) > 0) {
                void to;
                to.write(data, 0, length);
            }
            from.close();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isThisZipEntryTargetedByTheseOperations(String string, Vector vector) {
        String string2 = string;
        Vector vector2 = vector;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_67, (Object)this, (Object)this, (Object)string2, (Object)vector2);
        try {
            boolean bl;
            block4: {
                void vZIPFileOperations;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                int i = 0;
                while (i < vZIPFileOperations.size()) {
                    void sEntryName;
                    ZIPFileOperation operationThis = (ZIPFileOperation)vZIPFileOperations.elementAt(i);
                    if (operationThis.getEntryName().equals(sEntryName)) {
                        bl = true;
                        break block4;
                    }
                    ++i;
                }
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private File createTempFileForThisFile(File file) throws IOException {
        File file2 = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_68, (Object)this, (Object)this, (Object)file2);
        try {
            void f;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sFileTmp = String.valueOf(f.getPath()) + S_DOT_TMP;
            File fFileTmp = new File(sFileTmp);
            if (fFileTmp.exists() && !fFileTmp.delete()) {
                throw new IOException(S_DELETE_FAILED + fFileTmp.getAbsolutePath());
            }
            File file3 = fFileTmp;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(file3, joinPoint);
            return file3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void moveAllEntriesFromThisZipFileToAnotherOneUnlessItIsToBeUpdated(ZipFile zipFile, ZipOutputStream zipOutputStream, Vector vector) throws IOException {
        ZipFile zipFile2 = zipFile;
        ZipOutputStream zipOutputStream2 = zipOutputStream;
        Vector vector2 = vector;
        Object[] objectArray = new Object[]{zipFile2, zipOutputStream2, vector2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_69, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void zipfileFrom;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Enumeration<? extends ZipEntry> enu = zipfileFrom.entries();
            while (enu.hasMoreElements()) {
                void zopTo;
                void vZIPFileOperations;
                ZipEntry zipentryThis = enu.nextElement();
                String sEntryThis = zipentryThis.getName();
                if (this.isThisZipEntryTargetedByTheseOperations(sEntryThis, (Vector)vZIPFileOperations)) continue;
                this.copyZipEntry((ZipFile)zipfileFrom, zipentryThis, (ZipOutputStream)zopTo, zipentryThis.getName());
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyZIPFileOperationsToZIPFile(Vector vector, ZipOutputStream zipOutputStream) throws IOException, ClassNotFoundException, SAXException, ParserConfigurationException, IllegalAccessException, InstantiationException, FileSystemNotSupportedException {
        Vector vector2 = vector;
        ZipOutputStream zipOutputStream2 = zipOutputStream;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_70, (Object)this, (Object)this, (Object)vector2, (Object)zipOutputStream2);
        try {
            void vZIPFileOperations;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            int i = 0;
            while (i < vZIPFileOperations.size()) {
                ZIPFileOperation zfoThis = (ZIPFileOperation)vZIPFileOperations.elementAt(i);
                if (!zfoThis.getOperation().equalsIgnoreCase("zip-remove")) {
                    void zopTo;
                    FileSystem fsSource = FileSystem.getFileSystem(zfoThis.getSourceFile(), this.getInstallToolkitBridge());
                    fsSource.copyThisEntryInThisSourceToThisZipFileWithThisName(zfoThis.getSourceFile(), zfoThis.getSourceEntryName(), (ZipOutputStream)zopTo, zfoThis.getEntryName());
                }
                ++i;
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ZIPFileSystem.java", Class.forName("com.ibm.ws.install.ni.framework.io.ZIPFileSystem"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.io.ZIPFileSystem----"), 2212);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-performAllZIPOperationsForThisTargetFile-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:java.util.Vector:-uriTargetFile:vZIPFileOperations:-java.io.IOException:-void-"), 67);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPermissions-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-int-"), 409);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createSymbolicLink-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:java.lang.String:-uriSymbolicLinkPath:sPathToLinkTo:-java.io.IOException:-void-"), 447);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getLastModified-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-long-"), 469);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFSURI-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:java.lang.String:-uriParent:sEntryPath:-java.net.URISyntaxException:-java.net.URI-"), 494);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-exists-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:--boolean-"), 533);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isDirectory-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:--boolean-"), 629);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-mkdirs-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-void-"), 640);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getParent-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.net.URI-"), 666);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getParentDirOrFSRoot-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.net.URI-"), 714);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getEntryName-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.lang.String-"), 771);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getSize-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-long-"), 114);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getCanonicalPath-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.lang.String-"), 802);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getAbsolutePath-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.lang.String-"), 814);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getAbsolutePathWithFlagment-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.lang.String-"), 829);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-renameTo-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:java.net.URI:-uriPath:uriPathTo:-java.io.IOException:-void-"), 853);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getDirectoryEntries-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:--[Ljava.net.URI;-"), 874);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getDirectoryEntries-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:boolean:-uriPath:fDirectChildrenOnly:--[Ljava.net.URI;-"), 888);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getEntriesDirectlyUnderThisDir-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:--[Ljava.net.URI;-"), 979);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getSymbolicLinkTarget-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.lang.String-"), 997);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-flushFileSystemFor-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-void-"), 1008);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setHidden-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:--void-"), 1021);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setLastModifiedTime-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:long:-uriPath:lTime:-java.io.IOException:-void-"), 144);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-copyThisEntryInThisSourceToThisZipFileWithThisName-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:java.lang.String:java.util.zip.ZipOutputStream:java.lang.String:-uriSourceFile:sSourceEntryName:zopTo:sTargetEntryName:-java.io.IOException:-void-"), 1049);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getSupportedScheme-com.ibm.ws.install.ni.framework.io.ZIPFileSystem----java.lang.String-"), 1076);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-flush-com.ibm.ws.install.ni.framework.io.ZIPFileSystem---java.io.IOException:-void-"), 1090);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-isDirectChildren-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.lang.String:java.lang.String:-sParentEntry:sChildEntry:--boolean-"), 1107);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-moveFile-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.File:java.io.File:-fileToMove:fileToMoveTo:-java.io.IOException:-void-"), 1154);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-copyDiskFiles-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.File:java.io.File:-fileSource:fileDestination:-java.io.IOException:-void-"), 1183);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getZipFileForReading-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.util.zip.ZipException:java.io.IOException:-java.util.zip.ZipFile-"), 1207);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-hasThisZipFileContainerBeenCached-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-boolean-"), 1236);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-ensureThisZipFileClosed-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.File:-file:-java.io.IOException:-void-"), 1251);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-closeAllCachedZipFiles-com.ibm.ws.install.ni.framework.io.ZIPFileSystem---java.io.IOException:-void-"), 1268);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-readEntry-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.io.InputStream-"), 177);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getZIPOutputStreamForAddingNewEntries-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:java.io.FileNotFoundException:-java.util.zip.ZipOutputStream-"), 1298);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-reinitThisFSForReading-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-void-"), 1343);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getCachedZIPOutputStream-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.File:-fileFSContainer:--com.ibm.ws.install.ni.framework.io.UnclosableZIPOutputStream-"), 1368);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-closeAllCachedZIPOutputStreams-com.ibm.ws.install.ni.framework.io.ZIPFileSystem---java.io.IOException:-void-"), 1388);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-zipThisDirectoryToThisZIPFile-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.File:java.io.File:-fileDirToZip:fileZIP:-java.io.IOException:java.io.FileNotFoundException:-boolean-"), 1414);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-zipThisDirectoryToThisZIPFile-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.File:java.util.zip.ZipOutputStream:-fileDirToZip:out:-java.io.IOException:java.io.FileNotFoundException:-boolean-"), 1444);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getNormalizedRelativeNameZipEntryName-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.File:java.io.File:-fileToZip:fileDirBeingZipped:--java.lang.String-"), 1487);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-extractThisZIPFileToThisDirIfItExists-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.File:java.io.File:-fileZIP:fileDirToExtractTo:-java.util.zip.ZipException:java.io.IOException:java.io.FileNotFoundException:-void-"), 1529);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-extractThisZIPFileToThisDir-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.File:java.io.File:-fileZIP:fileDirToExtractTo:-java.util.zip.ZipException:java.io.IOException:java.io.FileNotFoundException:-void-"), 1547);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-transferContentsOfGivenTemporaryFileToGivenZIPEntry-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:java.io.File:-uriPath:fileTemp:-java.io.IOException:java.io.FileNotFoundException:-java.io.OutputStream-"), 1591);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-writeEntry-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.io.OutputStream-"), 207);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-transferCurrentInputStreamToATempFile-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.InputStream:-in:-java.io.IOException:java.io.FileNotFoundException:-java.io.File-"), 1615);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getEntryPathForThisURI-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:--java.lang.String-"), 1634);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getURIGivenFSURIAndEntryPath-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:java.lang.String:-uriFS:sEntryPath:-java.net.URISyntaxException:-java.net.URI-"), 1661);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-isEntireFSBeingTargetted-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:--boolean-"), 1681);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getFileContainerForThisFS-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.io.File-"), 1700);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getFSURIForThisEntry-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriEntry:-java.net.URISyntaxException:-java.net.URI-"), 1725);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getZIPEntryForThisURI-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.util.Hashtable-"), 1748);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getZIPEntryForThisURIReturnNullIfNotFound-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-java.util.Hashtable-"), 1778);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-setParentFSPermissions-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:int:-uriPath:nPermissions:-java.io.IOException:-void-"), 1824);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getParentFSPermissions-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-int-"), 1852);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-writeEntry-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:boolean:-uriPath:fAppend:-java.io.IOException:-java.io.OutputStream-"), 238);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-createFSSymbolicLink-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:java.lang.String:-uriSymbolicLinkPath:sPathToLinkTo:-java.io.IOException:-void-"), 1879);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getLNCommand-com.ibm.ws.install.ni.framework.io.ZIPFileSystem---java.io.IOException:-java.lang.String-"), 1951);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isReadable-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:--boolean-"), 1979);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-isWriteable-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:--boolean-"), 1992);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isThisPathWritable-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.File:-dir:--boolean-"), 2049);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-copyZipEntry-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.util.zip.ZipFile:java.util.zip.ZipEntry:java.util.zip.ZipOutputStream:java.lang.String:-fromFile:from:toFile:targetName:-java.io.IOException:-void-"), 2075);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-copyZipEntry-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.InputStream:java.util.zip.ZipOutputStream:-from:to:-java.io.IOException:-void-"), 2094);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isThisZipEntryTargetedByTheseOperations-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.lang.String:java.util.Vector:-sEntryName:vZIPFileOperations:--boolean-"), 2115);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-createTempFileForThisFile-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.io.File:-f:-java.io.IOException:-java.io.File-"), 2130);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-moveAllEntriesFromThisZipFileToAnotherOneUnlessItIsToBeUpdated-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.util.zip.ZipFile:java.util.zip.ZipOutputStream:java.util.Vector:-zipfileFrom:zopTo:vZIPFileOperations:-java.io.IOException:-void-"), 2154);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-deleteEntry-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-void-"), 290);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-applyZIPFileOperationsToZIPFile-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.util.Vector:java.util.zip.ZipOutputStream:-vZIPFileOperations:zopTo:-java.io.IOException:java.lang.ClassNotFoundException:org.xml.sax.SAXException:javax.xml.parsers.ParserConfigurationException:java.lang.IllegalAccessException:java.lang.InstantiationException:com.ibm.ws.install.ni.framework.io.FileSystemNotSupportedException:-void-"), 2183);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-deleteEntryOnExit-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:-uriPath:-java.io.IOException:-void-"), 353);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setPermissions-com.ibm.ws.install.ni.framework.io.ZIPFileSystem-java.net.URI:int:-uriPath:nPermissions:-java.io.IOException:-void-"), 377);
    }
}

