/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.logging;

import com.ibm.ws.install.ni.framework.NIFConstants;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridge;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.plugin.NIFPlugin;
import com.ibm.ws.install.ni.framework.plugin.NIFPluginUtils;
import com.ibm.ws.install.ni.framework.xml.XMLUtils;
import com.ibm.ws.install.utils.xml.SimpleXMLParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class LoggingPlugin
extends NIFPlugin {
    public static final int N_FINEST = 7;
    public static final int N_FINER = 6;
    public static final int N_FINE = 5;
    public static final int N_CONFIG = 4;
    public static final int N_INFO = 3;
    public static final int N_WARNING = 2;
    public static final int N_SEVERE = 1;
    public static final int N_NONE = 0;
    public static final int N_OFF = 0;
    private static LoggingPlugin[] m_alogp = null;
    private static HashMap hashmapLogLevelMap = new HashMap();
    private static final String[] AS_EMPTY = new String[0];
    protected static final String S_LOG_FILE_PATH_PARAM = "logpath";
    protected static final String S_LOG_LEVEL_PARAM = "traceLevel";
    private static final String[] AS_REQUIRED_PARAMS = new String[]{"logpath", "traceLevel"};
    protected static final String S_LOG_FORMAT_PARAM = "traceFormat";
    protected static final String S_LOG_COMPONENT_PARAM = "traceComponent";
    private static final String[] AS_OPTIONAL_PARAMS = new String[]{"traceFormat", "traceComponent"};
    protected static final String S_TEXT = "text";
    protected static final String S_XML = "xml";
    protected static final String S_ALL = "all";
    protected static final String S_OFF = "off";
    static /* synthetic */ Class class$0;

    public static void bootstrapLoggingSubsystem(InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException, URISyntaxException {
        LoggingPlugin.registerLoggers(itb);
    }

    public static void logMessage(int nLevel, String sSourceClass, String sSourceMethod, String sMessage) {
        if (!LoggingPlugin.hasLoggingSubsystemBeenBootstrapped()) {
            if (nLevel <= 3) {
                System.out.println(sMessage);
            }
            return;
        }
        try {
            int i = 0;
            while (i < m_alogp.length) {
                m_alogp[i].logThisMessage(nLevel, sSourceClass, sSourceMethod, sMessage);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void logException(int nLevel, String sSourceClass, String sSourceMethod, String sMessage, Throwable throwable) {
        if (!LoggingPlugin.hasLoggingSubsystemBeenBootstrapped()) {
            if (nLevel <= 3) {
                System.out.println(sMessage);
                throwable.printStackTrace();
            }
            return;
        }
        try {
            int i = 0;
            while (i < m_alogp.length) {
                m_alogp[i].logThisException(nLevel, sSourceClass, sSourceMethod, sMessage, throwable);
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    protected abstract void logThisMessage(int var1, String var2, String var3, String var4) throws IOException;

    protected abstract void logThisException(int var1, String var2, String var3, String var4, Throwable var5) throws IOException;

    protected String[] getRequiredParams() {
        return AS_REQUIRED_PARAMS;
    }

    protected String[] getOptionalParams() {
        return AS_OPTIONAL_PARAMS;
    }

    protected FileSystemEntry getLogFilePath() throws IOException {
        try {
            String path = this.getParamValue(S_LOG_FILE_PATH_PARAM);
            return new FileSystemEntry(new URI(path), this.getInstallToolkitBridge());
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected int getLogLevel() {
        String sLogLevel = this.getParamValue(S_LOG_LEVEL_PARAM);
        try {
            int level = Integer.parseInt(sLogLevel);
            return level;
        }
        catch (NumberFormatException numberFormatException) {
            sLogLevel = sLogLevel.toLowerCase();
            Integer integerLevel = (Integer)hashmapLogLevelMap.get(sLogLevel);
            if (integerLevel != null) {
                return integerLevel;
            }
            if (sLogLevel.equalsIgnoreCase(S_OFF)) {
                return 0;
            }
            return 3;
        }
    }

    protected String getLogFormat() {
        try {
            String logFormat = this.getParamValue(S_LOG_FORMAT_PARAM);
            if (logFormat == null || logFormat.length() == 0) {
                return S_TEXT;
            }
            return logFormat;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected boolean isEnabled() {
        return true;
    }

    private static boolean hasLoggingSubsystemBeenBootstrapped() {
        return m_alogp != null;
    }

    private static void registerLoggers(InstallToolkitBridge itb) throws IOException, ParserConfigurationException, SAXException, InstantiationException, IllegalAccessException, ClassNotFoundException, URISyntaxException {
        block9: {
            try {
                if (LoggingPlugin.hasLoggingSubsystemBeenBootstrapped()) {
                    break block9;
                }
                LoggingPlugin.initializeLogLevelMap();
                FileSystemEntry fseLoggersDB = new FileSystemEntry(NIFConstants.getCurrentAppDirectoryURI(itb), "framework/loggers.xml", itb);
                SimpleXMLParser sxp = XMLUtils.getSimpleXMLParserFromFileSystemEntry(fseLoggersDB);
                NIFPlugin[] anifp = NIFPlugin.createPlugins(sxp.getDocument(), "loggers/logging-plugin", itb);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.ibm.ws.install.ni.framework.logging.LoggingPlugin");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                NIFPluginUtils.enforceAllThesePluginsAssignableFromThisClass(clazz, anifp);
                m_alogp = new LoggingPlugin[0];
                Vector<LoggingPlugin> vector = new Vector<LoggingPlugin>();
                int i = 0;
                while (i < anifp.length) {
                    LoggingPlugin logp = (LoggingPlugin)anifp[i];
                    if (logp.isEnabled()) {
                        vector.addElement(logp);
                    }
                    ++i;
                }
                m_alogp = vector.size() > 0 ? vector.toArray(m_alogp) : null;
            }
            finally {
                NIFTracingAspect.aspectOf().ajc$after$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$12$3108cb60();
            }
        }
    }

    public static int getMaximumLoggingLevel() {
        int nMaximumLoggingLevel = 0;
        if (!LoggingPlugin.hasLoggingSubsystemBeenBootstrapped()) {
            System.out.println("Logging subsytem has not been bootstrapped.");
            return 0;
        }
        int i = 0;
        while (i < m_alogp.length) {
            nMaximumLoggingLevel = Math.max(nMaximumLoggingLevel, m_alogp[i].getLogLevel());
            ++i;
        }
        return nMaximumLoggingLevel;
    }

    private static void initializeLogLevelMap() {
        Integer nLogLevel = null;
        String sLogLevel = null;
        nLogLevel = new Integer(0);
        sLogLevel = "none";
        hashmapLogLevelMap.put(sLogLevel, nLogLevel);
        nLogLevel = new Integer(1);
        sLogLevel = "severe";
        hashmapLogLevelMap.put(sLogLevel, nLogLevel);
        nLogLevel = new Integer(2);
        sLogLevel = "warning";
        hashmapLogLevelMap.put(sLogLevel, nLogLevel);
        nLogLevel = new Integer(4);
        sLogLevel = "config";
        hashmapLogLevelMap.put(sLogLevel, nLogLevel);
        nLogLevel = new Integer(5);
        sLogLevel = "fine";
        hashmapLogLevelMap.put(sLogLevel, nLogLevel);
        nLogLevel = new Integer(6);
        sLogLevel = "finer";
        hashmapLogLevelMap.put(sLogLevel, nLogLevel);
        nLogLevel = new Integer(7);
        sLogLevel = "finest";
        hashmapLogLevelMap.put(sLogLevel, nLogLevel);
    }
}

