/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.logging;

import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.logging.LoggingPlugin;
import com.ibm.ws.install.ni.framework.logging.TextLoggingFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextLoggingBridge
extends LoggingPlugin {
    private Logger m_logger = null;
    private static final Level[] ALEVEL_NI_TO_J2SE_LEVEL_CONVERSION_TABLE = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST};

    public void init() {
        super.init();
        try {
            if (this.isEnabled()) {
                this.createLogger();
            }
        }
        catch (IOException iOException) {
            this.m_logger = null;
        }
    }

    protected void logThisMessage(int nLevel, String sSourceClass, String sSourceMethod, String sMessage) throws IOException {
        if (!this.isLoggerInitializedProperly()) {
            return;
        }
        this.m_logger.logp(this.convertNIFLevelToJ2SELevel(nLevel), sSourceClass, sSourceMethod, sMessage);
    }

    protected void logThisException(int nLevel, String sSourceClass, String sSourceMethod, String sMessage, Throwable throwable) throws IOException {
        if (!this.isLoggerInitializedProperly()) {
            return;
        }
        this.m_logger.logp(this.convertNIFLevelToJ2SELevel(nLevel), sSourceClass, sSourceMethod, sMessage);
        this.m_logger.logp(this.convertNIFLevelToJ2SELevel(nLevel), sSourceClass, sSourceMethod, this.getStackTrace(throwable));
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringwriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringwriter));
        return stringwriter.toString();
    }

    private boolean isLoggerInitializedProperly() {
        return this.m_logger != null;
    }

    private void createLogger() throws IOException {
        FileSystemEntry fseLogFile = this.getLogFilePath();
        if (!fseLogFile.getParent().exists()) {
            fseLogFile.getParent().mkdirs();
        }
        FileHandler filehandler = new FileHandler(this.getLogFilePathFromURI(fseLogFile.getURI()));
        filehandler.setLevel(this.convertNIFLevelToJ2SELevel(this.getLogLevel()));
        filehandler.setFormatter(new TextLoggingFormatter());
        this.m_logger = Logger.getLogger(this.getClass().getName());
        this.m_logger.addHandler(filehandler);
        this.m_logger.setLevel(this.convertNIFLevelToJ2SELevel(this.getLogLevel()));
        this.m_logger.setUseParentHandlers(false);
    }

    private String getLogFilePathFromURI(URI uriLogFile) {
        if (uriLogFile.getAuthority() != null) {
            return String.valueOf(uriLogFile.getAuthority()) + "/" + uriLogFile.getPath();
        }
        return uriLogFile.getPath();
    }

    private Level convertNIFLevelToJ2SELevel(int nNIFLevel) {
        return ALEVEL_NI_TO_J2SE_LEVEL_CONVERSION_TABLE[nNIFLevel];
    }

    protected boolean isEnabled() {
        return (this.getLogFormat() == null || this.getLogFormat().equalsIgnoreCase("text") || this.getLogFormat().equalsIgnoreCase("all")) && this.getLogLevel() != 0;
    }
}

