/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.maintenanceplugins;

import com.ibm.ws.install.ni.framework.NIFException;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridgeException;
import com.ibm.ws.install.ni.framework.prereq.PrereqPlugin;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ProfileDiskSpacePrereqPlugin
extends PrereqPlugin {
    private long m_lProfileRootFreeSpace;
    private long m_lTempRootFreeSpace;
    private String[] m_asPartitionNames;
    private static final String S_PROFILE_ROOT_PARAM = "profileroot";
    private static final String S_TEMP_ROOT_PARAM = "temproot";
    private static final String S_PROFILE_ROOT_SPACE_REQUIRED_PARAM = "profilerootspacerequired";
    private static final String S_TEMP_ROOT_SPACE_REQUIRED_PARAM = "temprootspacerequired";
    private static final String S_IGNORETHISPREREQONUNINSTALL_PARAM = "ignorethisprereqonuninstall";
    private static final String S_PROFILE_PATH_CUSTOM_PROPERTY_PARAM = "profilepathcustomproperty";
    private static final String S_ISBACKUPPACKAGE_PARAM = "isbackuppackage";
    private static final String S_DISABLE_DISK_SPACE_CHECK_PARAM = "disableDiskSpaceCheck";
    private static final String[] AS_REQUIRED_PARAMS;
    private static final String[] AS_OPTIONAL_PARAMS;
    private static final String S_PREREQ_FAILURE_MESSAGE_KEY = "ProfileDiskSpacePrereqPlugin.prereqFailureMessage";
    private static final Pattern PATTERN_DISK_SPACE;
    private static final int N_GROUP_DISK_SPACE = 1;
    private static final int N_GROUP_DISK_SPACE_UNITS = 2;
    private static final long L_BYTES_MULTIPLIER = 1L;
    private static final long L_KB_MULTIPLIER = 1024L;
    private static final long L_MB_MULTIPLIER = 0x100000L;
    private static final long L_GB_MULTIPLIER = 0x40000000L;
    private static final String S_FORMAT_ERROR = "Space requirement format error for: ";
    private static final String[] AS_BYTES_UNITS;
    private static final String[] AS_KB_UNITS;
    private static final String[] AS_MB_UNITS;
    private static final String[] AS_GB_UNITS;
    private static final String S_NULL = "null";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;

    static {
        Factory factory = new Factory("ProfileDiskSpacePrereqPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin----"), 373);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-init-com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin----void-"), 36);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-convertSpaceToBytes-com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin-java.lang.String:-sSpace:-com.ibm.ws.install.ni.framework.NIFException:-long-"), 288);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isProfilePathCustomPropertySet-com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin----boolean-"), 336);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isDiskSpaceCheckDisabled-com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin----boolean-"), 354);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin----java.lang.String-"), 67);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin----java.lang.String-"), 141);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin----[Ljava.lang.String;-"), 179);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin----[Ljava.lang.String;-"), 189);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getProfileRoot-com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin----java.lang.String-"), 199);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getTempRoot-com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin----java.lang.String-"), 216);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-areThesePathsOnTheSamePartition-com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin-java.lang.String:java.lang.String:[Ljava.lang.String;:-sPathA:sPathB:aPartitionNames:-com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridgeException:-boolean-"), 232);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getPartitionFreeSpace-com.ibm.ws.install.ni.framework.maintenanceplugins.ProfileDiskSpacePrereqPlugin-java.lang.String:[Ljava.lang.String;:-sPath:aPartitionNames:-com.ibm.ws.install.ni.framework.installtoolkitbridge.InstallToolkitBridgeException:-long-"), 266);
        AS_REQUIRED_PARAMS = new String[]{S_PROFILE_ROOT_PARAM, S_TEMP_ROOT_PARAM, S_PROFILE_ROOT_SPACE_REQUIRED_PARAM, S_TEMP_ROOT_SPACE_REQUIRED_PARAM, S_IGNORETHISPREREQONUNINSTALL_PARAM, S_ISBACKUPPACKAGE_PARAM};
        AS_OPTIONAL_PARAMS = new String[]{S_PROFILE_PATH_CUSTOM_PROPERTY_PARAM, S_DISABLE_DISK_SPACE_CHECK_PARAM};
        PATTERN_DISK_SPACE = Pattern.compile("(\\d+)\\s*(.*?)");
        AS_BYTES_UNITS = new String[]{"BYTES", "B"};
        AS_KB_UNITS = new String[]{"KB", "K"};
        AS_MB_UNITS = new String[]{"MB", "M"};
        AS_GB_UNITS = new String[]{"GB", "G"};
    }

    public ProfileDiskSpacePrereqPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_lProfileRootFreeSpace = -1L;
            this.m_lTempRootFreeSpace = -1L;
            this.m_asPartitionNames = new String[0];
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public void init() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            super.init();
            try {
                this.m_asPartitionNames = this.getInstallToolkitBridge().getUnifiedFileIO().getPartitionNames();
                this.m_lProfileRootFreeSpace = this.getPartitionFreeSpace(this.getProfileRoot(), this.m_asPartitionNames);
                this.m_lTempRootFreeSpace = this.getPartitionFreeSpace(this.getTempRoot(), this.m_asPartitionNames);
            }
            catch (InstallToolkitBridgeException installToolkitBridgeException) {}
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            try {
                if (this.isDiskSpaceCheckDisabled()) {
                    string = Boolean.TRUE.toString();
                } else {
                    long lTotalSpaceRequiredInInstallRoot;
                    boolean fIgnoreInstallSpaceRequirementsOnUninstall = new Boolean(this.getParamValue(S_IGNORETHISPREREQONUNINSTALL_PARAM));
                    boolean fIsBackupPackage = new Boolean(this.getParamValue(S_ISBACKUPPACKAGE_PARAM));
                    string = fIgnoreInstallSpaceRequirementsOnUninstall && fIsBackupPackage ? Boolean.TRUE.toString() : (this.m_lProfileRootFreeSpace < this.convertSpaceToBytes(this.getParamValue(S_PROFILE_ROOT_SPACE_REQUIRED_PARAM)) ? Boolean.FALSE.toString() : (this.m_lTempRootFreeSpace < this.convertSpaceToBytes(this.getParamValue(S_TEMP_ROOT_SPACE_REQUIRED_PARAM)) ? Boolean.FALSE.toString() : (this.areThesePathsOnTheSamePartition(this.getProfileRoot(), this.getTempRoot(), this.m_asPartitionNames) && this.m_lProfileRootFreeSpace < (lTotalSpaceRequiredInInstallRoot = this.convertSpaceToBytes(this.getParamValue(S_PROFILE_ROOT_SPACE_REQUIRED_PARAM)) + this.convertSpaceToBytes(this.getParamValue(S_TEMP_ROOT_SPACE_REQUIRED_PARAM))) ? Boolean.FALSE.toString() : Boolean.TRUE.toString())));
                }
            }
            catch (NIFException nIFException) {
                this.m_fUnexpectedExceptionOccured = true;
                string = Boolean.FALSE.toString();
            }
            catch (InstallToolkitBridgeException installToolkitBridgeException) {
                this.m_fUnexpectedExceptionOccured = true;
                string = Boolean.FALSE.toString();
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            try {
                String sPrereqFailureMessage;
                String sRequiredSpaceInstallRoot = Long.toString(this.convertSpaceToBytes(this.getParamValue(S_PROFILE_ROOT_SPACE_REQUIRED_PARAM)) / 0x100000L);
                String sRequiredSpaceTempRoot = Long.toString(this.convertSpaceToBytes(this.getParamValue(S_TEMP_ROOT_SPACE_REQUIRED_PARAM)) / 0x100000L);
                string = sPrereqFailureMessage = NIFResourceBundleUtils.getLocaleString(S_PREREQ_FAILURE_MESSAGE_KEY, new String[]{this.getProfileRoot(), sRequiredSpaceInstallRoot, new Long(this.m_lProfileRootFreeSpace / 0x100000L).toString(), this.getTempRoot(), sRequiredSpaceTempRoot, new Long(this.m_lTempRootFreeSpace / 0x100000L).toString()});
            }
            catch (NIFException e) {
                string = e.getMessage();
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_REQUIRED_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_REQUIRED_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_OPTIONAL_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_OPTIONAL_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private String getProfileRoot() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.isProfilePathCustomPropertySet() ? this.getParamValue(S_PROFILE_PATH_CUSTOM_PROPERTY_PARAM) : this.getParamValue(S_PROFILE_ROOT_PARAM);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private String getTempRoot() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.getParamValue(S_TEMP_ROOT_PARAM);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean areThesePathsOnTheSamePartition(String string, String string2, String[] stringArray) throws InstallToolkitBridgeException {
        String string3 = string;
        String string4 = string2;
        String[] stringArray2 = stringArray;
        Object[] objectArray = new Object[]{string3, string4, stringArray2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void sPathB;
            void aPartitionNames;
            void sPathA;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sPartitionNameA = this.getInstallToolkitBridge().getUnifiedFileIO().getPartitionName((String)sPathA, (String[])aPartitionNames);
            String sPartitionNameB = this.getInstallToolkitBridge().getUnifiedFileIO().getPartitionName((String)sPathB, (String[])aPartitionNames);
            boolean bl = sPartitionNameA.equals(sPartitionNameB);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private long getPartitionFreeSpace(String string, String[] stringArray) throws InstallToolkitBridgeException {
        String string2 = string;
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string2, (Object)stringArray2);
        try {
            long lPartitionFreeSpace;
            void aPartitionNames;
            void sPath;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sPartitionName = this.getInstallToolkitBridge().getUnifiedFileIO().getPartitionName((String)sPath, (String[])aPartitionNames);
            long l = lPartitionFreeSpace = this.getInstallToolkitBridge().getUnifiedFileIO().getPartitionFreeSpace(sPartitionName);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.longObject((long)l), joinPoint);
            return l;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private long convertSpaceToBytes(String string) throws NIFException {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string2);
        try {
            void sSpace;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Matcher matcherDiskSpace = PATTERN_DISK_SPACE.matcher((CharSequence)sSpace);
            if (!matcherDiskSpace.matches()) {
                throw new NIFException(S_FORMAT_ERROR + (String)sSpace);
            }
            long lDiskSpace = Long.parseLong(matcherDiskSpace.group(1));
            String sDiskSpaceUnits = matcherDiskSpace.group(2);
            long l = Arrays.asList(AS_BYTES_UNITS).contains(sDiskSpaceUnits.toUpperCase()) ? lDiskSpace * 1L : (Arrays.asList(AS_KB_UNITS).contains(sDiskSpaceUnits.toUpperCase()) ? lDiskSpace * 1024L : (Arrays.asList(AS_MB_UNITS).contains(sDiskSpaceUnits.toUpperCase()) ? lDiskSpace * 0x100000L : (Arrays.asList(AS_GB_UNITS).contains(sDiskSpaceUnits.toUpperCase()) ? lDiskSpace * 0x40000000L : lDiskSpace * 1L)));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.longObject((long)l), joinPoint);
            return l;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isProfilePathCustomPropertySet() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = !this.getParamValue(S_PROFILE_PATH_CUSTOM_PROPERTY_PARAM).equals(S_NULL);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isDiskSpaceCheckDisabled() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = new Boolean(System.getProperty(S_DISABLE_DISK_SPACE_CHECK_PARAM)) != false ? true : new Boolean(this.getParamValue(S_DISABLE_DISK_SPACE_CHECK_PARAM)) != false;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

