/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.maintenanceplugins;

import com.ibm.ws.install.ni.framework.NIFException;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.prereq.PrereqPlugin;
import com.ibm.ws.install.ni.framework.product.ProductPlugin;
import com.ibm.ws.install.ni.framework.product.VersionUtils;
import com.ibm.ws.install.ni.framework.registry.NIFRegistryPlugin;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import com.ibm.ws.install.ni.framework.utils.URIUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.xml.sax.SAXException;

public class VersionCheck
extends PrereqPlugin {
    private static String m_sCurrentProductVersion;
    private static final int N_VERSION_HIGHER = 1;
    private static final String S_REQUIRED_PRODUCT_NAME_PARAM = "requiredproductname";
    private static final String S_REQUIRED_PRODUCT_NAME_VERSION = "requiredproductversion";
    private static final String[] AS_REQUIRED_PARAMS;
    private static final String[] AS_OPTIONAL_PARAMS;
    private static final String S_MESSAGE_KEY = "versioncheckfailure.text";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;

    static {
        Factory factory = new Factory("VersionCheck.java", Class.forName("com.ibm.ws.install.ni.framework.maintenanceplugins.VersionCheck"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.maintenanceplugins.VersionCheck----"), 18);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.maintenanceplugins.VersionCheck----java.lang.String-"), 28);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.maintenanceplugins.VersionCheck----java.lang.String-"), 49);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.maintenanceplugins.VersionCheck----[Ljava.lang.String;-"), 77);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.maintenanceplugins.VersionCheck----[Ljava.lang.String;-"), 87);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isCurrentProductAtMinimumLevel-com.ibm.ws.install.ni.framework.maintenanceplugins.VersionCheck---java.lang.ClassNotFoundException:javax.xml.parsers.ParserConfigurationException:org.xml.sax.SAXException:java.net.URISyntaxException:java.lang.IllegalAccessException:java.lang.InstantiationException:java.io.IOException:com.ibm.ws.install.ni.framework.NIFException:-boolean-"), 99);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getExistingProductVersion-com.ibm.ws.install.ni.framework.maintenanceplugins.VersionCheck---java.lang.ClassNotFoundException:javax.xml.parsers.ParserConfigurationException:org.xml.sax.SAXException:java.net.URISyntaxException:java.lang.IllegalAccessException:java.lang.InstantiationException:java.io.IOException:com.ibm.ws.install.ni.framework.NIFException:-java.lang.String-"), 132);
        m_sCurrentProductVersion = "6.1.0.0";
        AS_REQUIRED_PARAMS = new String[0];
        AS_OPTIONAL_PARAMS = new String[]{S_REQUIRED_PRODUCT_NAME_PARAM, S_REQUIRED_PRODUCT_NAME_VERSION};
    }

    public VersionCheck() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            try {
                string = new Boolean(this.isCurrentProductAtMinimumLevel()).toString();
            }
            catch (Exception exception) {
                this.m_fUnexpectedExceptionOccured = true;
                string = Boolean.FALSE.toString();
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (this.m_fUnexpectedExceptionOccured) {
                string = this.getPrereqGenericExceptionFailureMessage();
            } else {
                String sRequiredProductName = this.getParamValue(S_REQUIRED_PRODUCT_NAME_PARAM);
                String sRequiredProductVersion = this.getParamValue(S_REQUIRED_PRODUCT_NAME_VERSION);
                string = NIFResourceBundleUtils.getLocaleString(S_MESSAGE_KEY, new String[]{sRequiredProductName, sRequiredProductVersion, ProductPlugin.getProductOfferingName(ProductPlugin.getCurrentProductOffering()), m_sCurrentProductVersion});
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_REQUIRED_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_REQUIRED_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_OPTIONAL_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_OPTIONAL_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isCurrentProductAtMinimumLevel() throws ClassNotFoundException, ParserConfigurationException, SAXException, URISyntaxException, IllegalAccessException, InstantiationException, IOException, NIFException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sRequiredProductVersion = this.getParamValue(S_REQUIRED_PRODUCT_NAME_VERSION);
            String sVersionOfExistingProduct = this.getExistingProductVersion();
            int nVersion = VersionUtils.compareVersions(sRequiredProductVersion, sVersionOfExistingProduct);
            boolean bl = nVersion != 1;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private String getExistingProductVersion() throws ClassNotFoundException, ParserConfigurationException, SAXException, URISyntaxException, IllegalAccessException, InstantiationException, IOException, NIFException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFRegistryPlugin nifrp = NIFRegistryPlugin.getNIFRegistryPlugin(this.getInstallToolkitBridge());
            m_sCurrentProductVersion = nifrp.getWASSpecificVersionByOfferingLocationURI(URIUtils.convertPathToDefaultTargetMachineFSURI(ProductPlugin.getCurrentProductInstallRoot(), this.getInstallToolkitBridge()));
            if (m_sCurrentProductVersion == null) {
                m_sCurrentProductVersion = nifrp.getVersionByOfferingLocationURIAndOffering("CLIENT", URIUtils.convertPathToDefaultTargetMachineFSURI(ProductPlugin.getCurrentProductInstallRoot(), this.getInstallToolkitBridge()));
            }
            String string = m_sCurrentProductVersion;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

