/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.nifstack;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.macro.MacroResolver;
import com.ibm.ws.install.ni.framework.nifstack.NIFStack;
import com.ibm.ws.install.ni.framework.payloadid.DependsOnInfo;
import com.ibm.ws.install.ni.framework.prereq.PrereqPlugin;
import com.ibm.ws.install.ni.framework.product.VersionUtils;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.xml.sax.SAXException;

public class StackPakversionPrereqChecking
extends PrereqPlugin {
    private String m_sPrereqFailureMessage;
    private String m_sCachedFlag;
    private static final String S_INSTALLROOT_PARAM = "installroot";
    private static final String S_BACKUPPATHURI_PARAM = "backuppathuri";
    private static final String S_ISBACKUPPACKAGE_PARAM = "isbackuppackage";
    private static final String S_RETURNTRUEIF_PARAM = "returnTRUEIf";
    private static final String S_DEPENDSON_PARAM = "dependsOn";
    private static final String[] asRequired;
    private static final String[] asOptional;
    private static final String S_MISSING_DEPENDENCY_MESSAGE_KEY = "StackPakversionPrereqChecking.missingDependency";
    private static final String S_EMPTY = "";
    private static final String S_NEWLINE = "\n";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;

    static {
        Factory factory = new Factory("StackPakversionPrereqChecking.java", Class.forName("com.ibm.ws.install.ni.framework.nifstack.StackPakversionPrereqChecking"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.nifstack.StackPakversionPrereqChecking----"), 168);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-init-com.ibm.ws.install.ni.framework.nifstack.StackPakversionPrereqChecking----void-"), 33);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.nifstack.StackPakversionPrereqChecking----java.lang.String-"), 47);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.nifstack.StackPakversionPrereqChecking----java.lang.String-"), 104);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.nifstack.StackPakversionPrereqChecking----[Ljava.lang.String;-"), 114);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.nifstack.StackPakversionPrereqChecking----[Ljava.lang.String;-"), 124);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-makeSureTheStackIsOpened-com.ibm.ws.install.ni.framework.nifstack.StackPakversionPrereqChecking----boolean-"), 130);
        asRequired = new String[]{S_INSTALLROOT_PARAM, S_BACKUPPATHURI_PARAM, S_ISBACKUPPACKAGE_PARAM, S_DEPENDSON_PARAM};
        asOptional = new String[]{S_RETURNTRUEIF_PARAM};
    }

    public StackPakversionPrereqChecking() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_sPrereqFailureMessage = null;
            this.m_sCachedFlag = null;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public void init() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            super.init();
            this.m_sCachedFlag = null;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$7$a54399fc(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (this.m_sCachedFlag != null) {
                string = this.m_sCachedFlag;
            } else if (new Boolean(this.getParamValue(S_RETURNTRUEIF_PARAM)).booleanValue()) {
                string = this.m_sCachedFlag = Boolean.TRUE.toString();
            } else if (!this.makeSureTheStackIsOpened()) {
                string = this.m_sCachedFlag = Boolean.FALSE.toString();
            } else {
                this.m_sCachedFlag = Boolean.TRUE.toString();
                this.m_sPrereqFailureMessage = S_EMPTY;
                DependsOnInfo[] adoiDependsOnInfo = NIFStack.checkStackDependency(this.getParamValue(S_DEPENDSON_PARAM));
                int i = 0;
                while (i < adoiDependsOnInfo.length) {
                    if (!adoiDependsOnInfo[i].isSatisfied()) {
                        this.m_sCachedFlag = Boolean.FALSE.toString();
                        String sPayloadidDesc = MacroResolver.resolveMacro(adoiDependsOnInfo[i].getPayloadidDesc(), this.getInstallToolkitBridge(), this.getPluginDefinitionDocument());
                        String sComparingOperation = VersionUtils.getLocaleString(adoiDependsOnInfo[i].getComparingOperation());
                        String sBaseVersion = adoiDependsOnInfo[i].getBaseVersion();
                        this.m_sPrereqFailureMessage = String.valueOf(this.m_sPrereqFailureMessage) + NIFResourceBundleUtils.getLocaleString(S_MISSING_DEPENDENCY_MESSAGE_KEY, new String[]{sPayloadidDesc, sComparingOperation, sBaseVersion}) + S_NEWLINE;
                    }
                    ++i;
                }
                string = this.m_sCachedFlag;
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            String string = this.m_sPrereqFailureMessage;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = asRequired;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return asRequired;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = asOptional;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return asOptional;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean makeSureTheStackIsOpened() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (NIFStack.isOpen()) {
                bl = true;
            } else {
                try {
                    NIFStack.open(new FileSystemEntry(new URI(this.getParamValue(S_BACKUPPATHURI_PARAM)), this.getInstallToolkitBridge()), this.getInstallToolkitBridge());
                    bl = true;
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    bl = false;
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                    bl = false;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    bl = false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    bl = false;
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

