/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.os;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.prereq.PrereqPlugin;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import com.ibm.ws.install.ni.framework.utils.ParsePropertiesFile;
import com.ibm.ws.install.ni.framework.utils.URIUtils;
import com.ibm.ws.install.ni.framework.xml.XMLUtils;
import com.ibm.ws.install.utils.xml.SimpleXMLParser;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class InstallImageOSArchPrereqPlugin
extends PrereqPlugin {
    private static Properties m_MdvBuildOSArchMappingProp;
    private static final String S_EMPTY = "";
    private static final String S_FILE_EXT_PAK = ".pak";
    private static final String S_ISBACKUPPACKAGE_PARAM = "isbackuppackage";
    private static final String S_INSTALL_PAK_PATH_PARAM = "installImagePathContainsOSandArchs";
    private static final String S_TARGET_OS_ARCHS_PARAM = "targetOSandArchs";
    private static final String[] AS_REQUIRED_PARAMS;
    private static final String[] AS_EMPTY;
    private static final String S_PREREQ_FAILURE_MESSAGE_KEY = "InstallImageOSArchPrereqPlugin.installImageOSandArchsPrereqFailureMessage";
    private static final String S_SKIPPED_OS_TOKEN = "TARGETOSandARCHS";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;

    static {
        Factory factory = new Factory("InstallImageOSArchPrereqPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.os.InstallImageOSArchPrereqPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.os.InstallImageOSArchPrereqPlugin----"), 36);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.os.InstallImageOSArchPrereqPlugin----java.lang.String-"), 46);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.os.InstallImageOSArchPrereqPlugin----[Ljava.lang.String;-"), 258);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.os.InstallImageOSArchPrereqPlugin----java.lang.String-"), 83);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getInstallImagePathContainsOSandArchs-com.ibm.ws.install.ni.framework.os.InstallImageOSArchPrereqPlugin---java.net.URISyntaxException:java.io.IOException:-com.ibm.ws.install.ni.framework.io.FileSystemEntry-"), 94);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-loadMdvBuildOSArchMapping-com.ibm.ws.install.ni.framework.os.InstallImageOSArchPrereqPlugin---java.io.IOException:java.net.URISyntaxException:-void-"), 126);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getInstallImageOSArch-com.ibm.ws.install.ni.framework.os.InstallImageOSArchPrereqPlugin---java.io.IOException:java.net.URISyntaxException:javax.xml.parsers.ParserConfigurationException:org.xml.sax.SAXException:-java.lang.String-"), 144);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-matchTargetOSandArchs-com.ibm.ws.install.ni.framework.os.InstallImageOSArchPrereqPlugin-java.lang.String:java.lang.String:-sInstallImageOSandArchs:sMDVOSandArchs:--boolean-"), 194);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isThisABackupPackage-com.ibm.ws.install.ni.framework.os.InstallImageOSArchPrereqPlugin----boolean-"), 216);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isTargetOSandArchsEmpty-com.ibm.ws.install.ni.framework.os.InstallImageOSArchPrereqPlugin----boolean-"), 228);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.os.InstallImageOSArchPrereqPlugin----[Ljava.lang.String;-"), 248);
        m_MdvBuildOSArchMappingProp = null;
        AS_REQUIRED_PARAMS = new String[]{S_ISBACKUPPACKAGE_PARAM, S_INSTALL_PAK_PATH_PARAM, S_TARGET_OS_ARCHS_PARAM};
        AS_EMPTY = new String[0];
    }

    public InstallImageOSArchPrereqPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (this.isThisABackupPackage() || this.isTargetOSandArchsEmpty()) {
                string = Boolean.TRUE.toString();
            } else {
                try {
                    String sInstallImageOSandArchs = this.getInstallImageOSArch().trim();
                    if (sInstallImageOSandArchs == null || sInstallImageOSandArchs.equals(S_EMPTY) || sInstallImageOSandArchs.equalsIgnoreCase(S_SKIPPED_OS_TOKEN)) {
                        string = Boolean.TRUE.toString();
                    } else {
                        this.loadMdvBuildOSArchMapping();
                        string = new Boolean(this.matchTargetOSandArchs(sInstallImageOSandArchs, this.getParamValue(S_TARGET_OS_ARCHS_PARAM))).toString();
                    }
                }
                catch (Exception exception) {
                    this.m_fUnexpectedExceptionOccured = true;
                    string = Boolean.FALSE.toString();
                }
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            String string = this.m_fUnexpectedExceptionOccured ? this.getPrereqGenericExceptionFailureMessage() : NIFResourceBundleUtils.getLocaleString(S_PREREQ_FAILURE_MESSAGE_KEY);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private FileSystemEntry getInstallImagePathContainsOSandArchs() throws URISyntaxException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            FileSystemEntry fileSystemEntry;
            block5: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                String sPaths = this.getParamValue(S_INSTALL_PAK_PATH_PARAM);
                Vector vsPaths = this.getExpandedParams(sPaths);
                FileSystemEntry fseBackupPathDefault = null;
                int i = 0;
                while (i < vsPaths.size()) {
                    String sPathThis = (String)vsPaths.elementAt(i);
                    FileSystemEntry fseBackupPathThis = new FileSystemEntry(URIUtils.convertPathToURI(sPathThis, this.getInstallToolkitBridge()), this.getInstallToolkitBridge());
                    if (fseBackupPathThis.exists()) {
                        fileSystemEntry = fseBackupPathThis;
                        break block5;
                    }
                    if (i == 0) {
                        fseBackupPathDefault = fseBackupPathThis;
                    }
                    ++i;
                }
                fileSystemEntry = fseBackupPathDefault;
            }
            FileSystemEntry fileSystemEntry2 = fileSystemEntry;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(fileSystemEntry2, joinPoint);
            return fileSystemEntry;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private void loadMdvBuildOSArchMapping() throws IOException, URISyntaxException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            FileSystemEntry fseMdvMapping = new FileSystemEntry(URIUtils.convertPathToURI("framework/properties/mdv.build.os.arch.mappings", this.getInstallToolkitBridge()), this.getInstallToolkitBridge());
            if (fseMdvMapping != null) {
                m_MdvBuildOSArchMappingProp = ParsePropertiesFile.loadProperties(fseMdvMapping.getAbsolutePath());
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private String getInstallImageOSArch() throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            String string;
            block5: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                FileSystemEntry fseBackupPath = this.getInstallImagePathContainsOSandArchs();
                FileSystemEntry fse = null;
                fse = fseBackupPath.getAbsolutePath().endsWith(S_FILE_EXT_PAK) ? new FileSystemEntry(fseBackupPath.getURI(), "maintenance.xml", this.getInstallToolkitBridge()) : new FileSystemEntry(fseBackupPath.getURI(), this.getInstallToolkitBridge());
                if (fse.exists()) {
                    SimpleXMLParser sxp = XMLUtils.getSimpleXMLParserFromFileSystemEntry(fse);
                    Vector vNode = sxp.getNodes("install-package/installFactoryInformation");
                    Vector vNodeParams = SimpleXMLParser.getAllNamedChildNodes((Node)((Node)vNode.get(0)), (String)"param");
                    int i = 0;
                    while (i < vNodeParams.size()) {
                        Node nodeParamThis = (Node)vNodeParams.elementAt(i);
                        if (SimpleXMLParser.getNodeAttributeValue((Node)nodeParamThis, (String)"name").equals(S_TARGET_OS_ARCHS_PARAM)) {
                            string = SimpleXMLParser.getNodeAttributeValue((Node)nodeParamThis, (String)"value");
                            break block5;
                        }
                        ++i;
                    }
                }
                string = S_EMPTY;
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean matchTargetOSandArchs(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string3, (Object)string4);
        try {
            void sInstallImageOSandArchs;
            void sMDVOSandArchs;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sConvertedMDVOSandArchs = (String)m_MdvBuildOSArchMappingProp.get(sMDVOSandArchs);
            boolean bl = sInstallImageOSandArchs.equals(sConvertedMDVOSandArchs.trim());
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isThisABackupPackage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = Boolean.valueOf(this.getParamValue(S_ISBACKUPPACKAGE_PARAM));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isTargetOSandArchsEmpty() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sTargetOSandArchs = this.getParamValue(S_TARGET_OS_ARCHS_PARAM);
            boolean bl = sTargetOSandArchs == null || sTargetOSandArchs.equals(S_EMPTY);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_REQUIRED_PARAMS;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_REQUIRED_PARAMS;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = AS_EMPTY;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return AS_EMPTY;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

