/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.os;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.os.OSPrereqPlugin;
import com.ibm.ws.install.ni.framework.os.PlatformConstants;
import com.ibm.ws.install.ni.framework.product.VersionUtils;
import com.ibm.ws.install.ni.framework.utils.ArrayUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class LinuxPrereqPlugin
extends OSPrereqPlugin {
    private static String[] m_sPatchFlags;
    private boolean m_fOSVendor;
    private boolean m_fOSVersion;
    private boolean m_fOSArch;
    private boolean m_fOSPatch;
    private static int m_nVersionNotMatchWeight;
    private static final String S_VENDOR_PARAM = "vendor";
    private static final String S_RELEASEINFOFILE_PARAM = "releaseinfofile";
    private static final String S_PATCHLEVEL = "PATCHLEVEL";
    private static final String[] S_RPM_CMD;
    private static final String[] S_UNAME_CMD;
    private static final String[] AS_REQUIRED_PARAMS;
    private static final String[] AS_OPTIONAL_PARAMS;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;

    static {
        Factory factory = new Factory("LinuxPrereqPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin----"), 443);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin----java.lang.String-"), 38);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkPatches-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin-[Ljava.lang.String;:-sPatchArray:-java.io.IOException:-[Ljava.lang.String;-"), 293);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkLinuxRPM-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin-java.lang.String:java.lang.String:-sIn:sInVersion:-java.io.IOException:-java.lang.String-"), 330);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkRedhatUpdateLevel-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin-java.lang.String:-sInVersion:-java.io.IOException:-java.lang.String-"), 361);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkSLESSPLevel-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin-java.lang.String:-sInVersion:-java.io.IOException:-java.lang.String-"), 405);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin----java.lang.String-"), 87);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getWeight-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin----java.lang.String-"), 113);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin----[Ljava.lang.String;-"), 124);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin----[Ljava.lang.String;-"), 144);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isOSVendorAcceptable-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin---java.io.IOException:-boolean-"), 164);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isOSArchAcceptable-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin----boolean-"), 201);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isOSVersionAcceptable-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin---java.io.IOException:-boolean-"), 219);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isOSPatchAcceptable-com.ibm.ws.install.ni.framework.os.LinuxPrereqPlugin---java.io.IOException:-boolean-"), 271);
        m_sPatchFlags = null;
        m_nVersionNotMatchWeight = 0;
        S_RPM_CMD = new String[]{"rpm", "-qa", ""};
        S_UNAME_CMD = new String[]{"uname", "-m"};
        AS_REQUIRED_PARAMS = new String[0];
        AS_OPTIONAL_PARAMS = new String[]{S_VENDOR_PARAM, S_RELEASEINFOFILE_PARAM};
    }

    public LinuxPrereqPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_fOSVendor = false;
            this.m_fOSVersion = false;
            this.m_fOSArch = false;
            this.m_fOSPatch = false;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            String string;
            block11: {
                block10: {
                    NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
                    if (this.isOSCheckDisabled()) {
                        string = Boolean.TRUE.toString();
                    } else if (PlatformConstants.getCurrentPlatform() != 4) {
                        string = Boolean.FALSE.toString();
                    } else {
                        try {
                            this.m_fOSVendor = this.isOSVendorAcceptable();
                            this.m_fOSVersion = this.isOSVersionAcceptable();
                            this.m_fOSArch = this.isOSArchAcceptable();
                            this.m_fOSPatch = this.isOSPatchAcceptable();
                            if (!this.m_fOSVendor || !this.m_fOSVersion) {
                                ++m_nVersionNotMatchWeight;
                            }
                            if (this.m_fOSVendor && this.m_fOSVersion && this.m_fOSArch && this.m_fOSPatch) {
                                string = Boolean.TRUE.toString();
                            }
                            break block10;
                        }
                        catch (Exception exception) {
                            this.m_fUnexpectedExceptionOccured = true;
                            string = Boolean.FALSE.toString();
                        }
                    }
                    break block11;
                }
                string = Boolean.FALSE.toString();
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (this.m_fUnexpectedExceptionOccured) {
                string = this.getPrereqGenericExceptionFailureMessage();
            } else {
                String sIn = this.getParamValue("version");
                String sVersion = this.getVersionNumber(sIn, "(\\d+[.]*)+");
                String sVendor = this.getParamValue(S_VENDOR_PARAM);
                String sOSString = String.valueOf(sVendor) + " " + sVersion;
                string = PlatformConstants.getCurrentPlatform() != 4 ? this.getInvalidPlatformMessage(sVendor, sVersion) : this.getOSPrereqWarningMessage(this.m_fOSVendor, this.m_fOSVersion, this.m_fOSArch, this.m_fOSPatch, m_sPatchFlags, sOSString);
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getWeight() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.getWeightValue(this.m_fOSVendor, this.m_fOSVersion, this.m_fOSArch, this.m_fOSPatch, m_nVersionNotMatchWeight);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Object[] asReturn = new String[AS_REQUIRED_PARAMS.length + super.getRequiredParams().length];
            ArrayUtils.appendArray(asReturn, AS_REQUIRED_PARAMS, 0);
            ArrayUtils.appendArray(asReturn, super.getRequiredParams(), AS_REQUIRED_PARAMS.length);
            Object[] objectArray = asReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(objectArray, joinPoint);
            return asReturn;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Object[] asReturn = new String[AS_OPTIONAL_PARAMS.length + super.getOptionalParams().length];
            ArrayUtils.appendArray(asReturn, AS_OPTIONAL_PARAMS, 0);
            ArrayUtils.appendArray(asReturn, super.getOptionalParams(), AS_OPTIONAL_PARAMS.length);
            Object[] objectArray = asReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(objectArray, joinPoint);
            return asReturn;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isOSVendorAcceptable() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            boolean bl;
            block6: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                File fileReleaseInfoFile = new File(this.getParamValue(S_RELEASEINFOFILE_PARAM));
                if (!fileReleaseInfoFile.exists()) {
                    bl = false;
                } else {
                    BufferedReader bufferedreaderIn = new BufferedReader(new FileReader(fileReleaseInfoFile));
                    String sVendorParams = this.getParamValue(S_VENDOR_PARAM);
                    String sLine = bufferedreaderIn.readLine();
                    while (sLine != null) {
                        if (sLine.indexOf(sVendorParams) >= 0) {
                            bl = true;
                            break block6;
                        }
                        sLine = bufferedreaderIn.readLine();
                    }
                    bl = false;
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isOSArchAcceptable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sArch = this.getStandardOutputFromProcessCall(S_UNAME_CMD).trim();
            Vector vsArchParams = this.getParamListAsStringVector("arch");
            boolean bl = vsArchParams.contains(sArch);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isOSVersionAcceptable() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            File fileReleaseInfoFile = new File(this.getParamValue(S_RELEASEINFOFILE_PARAM));
            if (!fileReleaseInfoFile.exists()) {
                bl = false;
            } else {
                BufferedReader bufferedreaderIn = new BufferedReader(new FileReader(fileReleaseInfoFile));
                String sVersion = "";
                String sVersionParams = this.getParamValue("version");
                String sLine = bufferedreaderIn.readLine();
                while (sLine != null) {
                    if (!sLine.equals("")) {
                        sVersion = this.getVersionNumber(sLine, "(\\d+[.]*)+");
                        break;
                    }
                    sLine = bufferedreaderIn.readLine();
                }
                try {
                    boolean fResult;
                    bl = fResult = VersionUtils.isVersionAcceptableToTheseVersionParams(sVersion, sVersionParams);
                }
                catch (NumberFormatException numberFormatException) {
                    this.m_fUnexpectedExceptionOccured = true;
                    bl = false;
                }
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isOSPatchAcceptable() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] sPatchParams = this.getParamValues("patch");
            if (sPatchParams == null) {
                bl = true;
            } else {
                m_sPatchFlags = this.checkPatches(sPatchParams);
                bl = this.getBooleanFlag(m_sPatchFlags);
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String[] checkPatches(String[] stringArray) throws IOException {
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)stringArray2);
        try {
            void sPatchArray;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] sPatchFlags = new String[((void)sPatchArray).length];
            int i = 0;
            while (i < ((void)sPatchArray).length) {
                String[] sPatchElement = sPatchArray[i].split(";");
                String sPatchName = sPatchElement[0].trim();
                String sPatchVersion = sPatchElement[1].trim();
                sPatchFlags[i] = sPatchName.equalsIgnoreCase("Update") ? this.checkRedhatUpdateLevel(sPatchVersion) : (sPatchName.equalsIgnoreCase("SP") ? this.checkSLESSPLevel(sPatchVersion) : this.checkLinuxRPM(sPatchName, sPatchVersion));
                ++i;
            }
            String[] stringArray3 = sPatchFlags;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray3, joinPoint);
            return sPatchFlags;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String checkLinuxRPM(String string, String string2) throws IOException {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string3, (Object)string4);
        try {
            String string5;
            block4: {
                void sIn;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                LinuxPrereqPlugin.S_RPM_CMD[LinuxPrereqPlugin.S_RPM_CMD.length - 1] = sIn;
                BufferedReader bufferedreaderIn = new BufferedReader(new StringReader(this.getStandardOutputFromProcessCall(S_RPM_CMD)));
                String sLine = bufferedreaderIn.readLine();
                while (sLine != null) {
                    void sInVersion;
                    if (sLine.indexOf((String)sIn) >= 0 && sLine.indexOf((String)sInVersion) >= 0) {
                        string5 = "true";
                        break block4;
                    }
                    sLine = bufferedreaderIn.readLine();
                }
                string5 = "false";
            }
            String string6 = string5;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string6, joinPoint);
            return string5;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String checkRedhatUpdateLevel(String string) throws IOException {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string2);
        try {
            String string3;
            block6: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                File fileReleaseInfoFile = new File(this.getParamValue(S_RELEASEINFOFILE_PARAM));
                if (!fileReleaseInfoFile.exists()) {
                    string3 = "false";
                } else {
                    BufferedReader bufferedreaderIn = new BufferedReader(new FileReader(fileReleaseInfoFile));
                    String sLine = bufferedreaderIn.readLine();
                    while (sLine != null) {
                        void sInVersion;
                        String sVersion;
                        if (!sLine.equals("") && sLine.indexOf("Update") >= 0 && (sVersion = this.getVersionNumber(sLine.substring(sLine.indexOf("Update")).trim(), "(\\d+[.]*)+")).equals(sInVersion)) {
                            string3 = "true";
                            break block6;
                        }
                        sLine = bufferedreaderIn.readLine();
                    }
                    string3 = "false";
                }
            }
            String string4 = string3;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string4, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String checkSLESSPLevel(String string) throws IOException {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)string2);
        try {
            String string3;
            block6: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                File fileReleaseInfoFile = new File(this.getParamValue(S_RELEASEINFOFILE_PARAM));
                if (!fileReleaseInfoFile.exists()) {
                    string3 = "false";
                } else {
                    BufferedReader bufferedreaderIn = new BufferedReader(new FileReader(fileReleaseInfoFile));
                    String sLine = bufferedreaderIn.readLine();
                    while (sLine != null) {
                        void sInVersion;
                        String sVersion;
                        if (!sLine.equals("") && sLine.indexOf(S_PATCHLEVEL) >= 0 && (sVersion = this.getVersionNumber(sLine.substring(sLine.indexOf(S_PATCHLEVEL)).trim(), "(\\d+[.]*)+")).equals(sInVersion)) {
                            string3 = "true";
                            break block6;
                        }
                        sLine = bufferedreaderIn.readLine();
                    }
                    string3 = "false";
                }
            }
            String string4 = string3;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string4, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

