/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.os;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.io.FileSystemEntry;
import com.ibm.ws.install.ni.framework.os.OSPrereqPlugin;
import com.ibm.ws.install.ni.framework.os.PlatformConstants;
import com.ibm.ws.install.ni.framework.product.VersionUtils;
import com.ibm.ws.install.ni.framework.resourcebundle.NIFResourceBundleUtils;
import com.ibm.ws.install.ni.framework.utils.ArrayUtils;
import com.ibm.ws.install.ni.framework.utils.URIUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class OS400PrereqPlugin
extends OSPrereqPlugin {
    private String m_sSystemCurrentOS;
    private boolean m_fOSVersion;
    private boolean m_fOSPatch;
    private static int m_nVersionNotMatchWeight;
    private StringBuffer m_sbMissingPTFs;
    private static final String S_VERSION_PARAM = "version";
    private static final String S_OS_VERSION = "os.version";
    private static final String S_CANNOT_RETRIEVE_OS_VERSION = "Can not retrieve OS version";
    private static final String S_VERSION = "V";
    private static final String S_RELEASE = "R";
    private static final String S_MODIFICATION = "M";
    private static final Pattern PATTERN_OS_VERSION;
    private static final int N_VERSION_NUMBER = 2;
    private static final int N_RELEASE_NUMBER = 4;
    private static final int N_MODIFICATION_NUMBER = 6;
    private static final String[] AS_OPTIONAL_PARAMS;
    private static final String[] AS_REQUIRED_PARAMS;
    private static final String S_DOT = ".";
    private static final String S_EOL = "\n";
    private static final String S_PTF_INFO_SEP = ";";
    private static final String S_PTF = " PTF: ";
    private static final String V5R3 = "V5R3";
    private static final String V5R4 = "V5R4";
    private static final String V5R3PTFs = "$ITB:J{user.dir}/lib/v5r3PTFs";
    private static final String V5R4PTFs = "$ITB:J{user.dir}/lib/v5r4PTFs";
    private static final String REQPTFs = "$ITB:J{user.dir}/lib/requiredPTFs";
    private static final String PTFFORMAT = "PTFR0100";
    private static final String PTFCMD = "/QSYS.LIB/QPZRTVFX.PGM";
    private static final String MSGID_PTFNOTFOUND = "CPF6602";
    private static final String MSGID_PRDNOTINSTD = "CPF35BE";
    private static final int NEVER_LOADED = 0;
    private static final int NOT_APPLIED = 1;
    private static final int TEMP_APPLIED = 2;
    private static final int PERM_APPLIED = 3;
    private static final int PERM_REMOVED = 4;
    private static final int DAMAGED = 5;
    private static final int SUPERSEDED = 6;
    private static final String CLOSEDB = "1";
    private static final String S_OS_PREREQ_FAILURE_MESSAGE_KEY = "OS400PrereqPlugin.osPrereqFailureMessage";
    private static final String S_OS_PATCH_PREREQ_FAILURE_MESSAGE_KEY = "OSPrereqPlugin.osPatchPrereqFailureMessage";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;

    static {
        Factory factory = new Factory("OS400PrereqPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin----"), 444);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin----java.lang.String-"), 47);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin----[Ljava.lang.String;-"), 400);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isOSVersionAcceptable-com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin-com.ibm.as400.access.AS400:-as400:-com.ibm.as400.access.AS400SecurityException:java.io.IOException:java.lang.Exception:-boolean-"), 420);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin----java.lang.String-"), 87);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOSPrereqWarningMessage-com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin-boolean:boolean:boolean:java.lang.String:java.lang.String:-fOSVersion:fOSArch:fOSPatch:sPTFInfos:sOSString:--java.lang.String-"), 115);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getWeight-com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin----java.lang.String-"), 150);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkOSVersion-com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin-com.ibm.as400.access.AS400:-as400:-com.ibm.as400.access.AS400SecurityException:java.io.IOException:java.lang.Exception:-java.lang.String-"), 163);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isOSPatchAcceptable-com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin-com.ibm.as400.access.AS400:-as400:-java.lang.Exception:-boolean-"), 209);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-checkPTF-com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin-com.ibm.as400.access.AS400:java.lang.String:java.lang.String:java.lang.String:-as400:prdid:rls:ptfid:--boolean-"), 259);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-mkPTFParm-com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin-com.ibm.as400.access.AS400:java.lang.String:java.lang.String:java.lang.String:-as400:prdid:rls:ptfid:-java.lang.Exception:-[B-"), 339);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.os.OS400PrereqPlugin----[Ljava.lang.String;-"), 380);
        m_nVersionNotMatchWeight = 0;
        PATTERN_OS_VERSION = Pattern.compile("^([Vv])(\\d+)([Rr])(\\d+)([Mm])(\\d+)");
        AS_OPTIONAL_PARAMS = new String[0];
        AS_REQUIRED_PARAMS = new String[]{S_VERSION_PARAM};
    }

    public OS400PrereqPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_sSystemCurrentOS = null;
            this.m_fOSVersion = false;
            this.m_fOSPatch = false;
            this.m_sbMissingPTFs = new StringBuffer();
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (this.isOSCheckDisabled()) {
                string = Boolean.TRUE.toString();
            } else if (!PlatformConstants.isOS400Install()) {
                string = Boolean.FALSE.toString();
            } else {
                try {
                    AS400 as400 = this.getInstallToolkitBridge().getAS400Object();
                    this.m_fOSVersion = this.isOSVersionAcceptable(as400);
                    this.m_fOSPatch = this.isOSPatchAcceptable(as400);
                    boolean fResult = false;
                    if (this.m_fOSVersion && this.m_fOSPatch) {
                        fResult = true;
                    }
                    string = new Boolean(fResult).toString();
                }
                catch (Exception exception) {
                    this.m_fUnexpectedExceptionOccured = true;
                    string = Boolean.FALSE.toString();
                }
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            String string = this.m_fUnexpectedExceptionOccured ? this.getPrereqGenericExceptionFailureMessage() : (!PlatformConstants.isOS400Install() ? "" : this.getOSPrereqWarningMessage(this.m_fOSVersion, true, this.m_fOSPatch, this.m_sbMissingPTFs.toString(), this.m_sSystemCurrentOS));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String getOSPrereqWarningMessage(boolean bl, boolean bl2, boolean bl3, String string, String string2) {
        boolean bl4 = bl;
        boolean bl5 = bl2;
        boolean bl6 = bl3;
        String string3 = string;
        String string4 = string2;
        Object[] objectArray = new Object[]{Conversions.booleanObject((boolean)bl4), Conversions.booleanObject((boolean)bl5), Conversions.booleanObject((boolean)bl6), string3, string4};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void fOSPatch;
            void fOSVersion;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sOSPrereqWarningMessage = "";
            if (fOSVersion == false) {
                sOSPrereqWarningMessage = NIFResourceBundleUtils.getLocaleString(S_OS_PREREQ_FAILURE_MESSAGE_KEY);
                System.setProperty("osVersionFlag", "false");
                System.setProperty("osArchFlag", "true");
                System.setProperty("osPatchFlag", "true");
            } else if (fOSPatch == false) {
                void sPTFInfos;
                void sOSString;
                sOSPrereqWarningMessage = NIFResourceBundleUtils.getLocaleString(S_OS_PATCH_PREREQ_FAILURE_MESSAGE_KEY, new String[]{sOSString, sPTFInfos});
                System.setProperty("osVersionFlag", "true");
                System.setProperty("osArchFlag", "true");
                System.setProperty("osPatchFlag", "false");
                System.setProperty("patchList", (String)sPTFInfos);
                System.setProperty("osString", (String)sOSString);
            }
            String string5 = sOSPrereqWarningMessage;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string5, joinPoint);
            return string5;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getWeight() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.getWeightValue(this.m_fOSVersion, true, true, m_nVersionNotMatchWeight);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String checkOSVersion(AS400 aS400) throws AS400SecurityException, IOException, Exception {
        AS400 aS4002 = aS400;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)aS4002);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (PlatformConstants.isOS400RemoteInstall()) {
                void as400;
                this.m_sSystemCurrentOS = S_VERSION + as400.getVersion() + S_RELEASE + as400.getRelease() + S_MODIFICATION + as400.getModification();
                string = String.valueOf(as400.getVersion()) + S_DOT + as400.getRelease() + S_DOT + as400.getModification();
            } else {
                this.m_sSystemCurrentOS = System.getProperty(S_OS_VERSION);
                Matcher matcherVersion = PATTERN_OS_VERSION.matcher(this.m_sSystemCurrentOS);
                if (matcherVersion.matches()) {
                    string = String.valueOf(matcherVersion.group(2)) + S_DOT + matcherVersion.group(4) + S_DOT + matcherVersion.group(6);
                } else {
                    throw new IOException(S_CANNOT_RETRIEVE_OS_VERSION);
                }
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isOSPatchAcceptable(AS400 aS400) throws Exception {
        AS400 aS4002 = aS400;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)aS4002);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String ptfFilePath = null;
            ptfFilePath = this.m_sSystemCurrentOS.startsWith(V5R3) ? V5R3PTFs : (this.m_sSystemCurrentOS.startsWith(V5R4) ? V5R4PTFs : REQPTFs);
            FileSystemEntry fseFilePath = URIUtils.convertPathToDefaultSourceMachineFSE(ptfFilePath, this.getInstallToolkitBridge());
            if (!fseFilePath.exists()) {
                bl = true;
            } else {
                BufferedReader reader = new BufferedReader(new InputStreamReader(fseFilePath.getInputStream()));
                String ptfInfo = reader.readLine();
                this.m_sbMissingPTFs = new StringBuffer();
                boolean result = true;
                while (ptfInfo != null) {
                    void as400;
                    String[] ptf = ptfInfo.split(S_PTF_INFO_SEP);
                    boolean flag = this.checkPTF((AS400)as400, ptf[0], ptf[1], ptf[2]);
                    if (!flag) {
                        this.m_sbMissingPTFs.append(String.valueOf(ptf[0]) + S_PTF + ptf[2] + S_EOL);
                        result = false;
                    }
                    ptfInfo = reader.readLine();
                }
                reader.close();
                bl = result;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkPTF(AS400 aS400, String string, String string2, String string3) {
        AS400 aS4002 = aS400;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        Object[] objectArray = new Object[]{aS4002, string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            try {
                void ptfid;
                void rls;
                void prdid;
                void as400;
                ProgramCall pc = new ProgramCall((AS400)as400);
                ProgramParameter[] parmlist = new ProgramParameter[5];
                AS400Bin4 intConv = new AS400Bin4();
                AS400Text char8Conv = new AS400Text(8, as400.getCcsid(), (AS400)as400);
                AS400Text convert4 = new AS400Text(128, as400.getCcsid(), (AS400)as400);
                parmlist[0] = new ProgramParameter(128);
                parmlist[1] = new ProgramParameter(intConv.toBytes(128));
                byte[] ptfFormat = this.mkPTFParm((AS400)as400, (String)prdid, (String)rls, (String)ptfid);
                parmlist[2] = new ProgramParameter(ptfFormat);
                parmlist[3] = new ProgramParameter(char8Conv.toBytes((Object)PTFFORMAT));
                parmlist[4] = new ProgramParameter(new byte[4]);
                pc.setProgram(PTFCMD, parmlist);
                if (!pc.run()) {
                    AS400Message[] messagelist = pc.getMessageList();
                    bl = messagelist.length == 1 && messagelist[0].getID().equalsIgnoreCase(MSGID_PTFNOTFOUND) || messagelist.length == 1 && messagelist[0].getID().equalsIgnoreCase(MSGID_PRDNOTINSTD) ? false : false;
                } else {
                    byte[] value = new byte[4];
                    int i = 0;
                    while (i < 4) {
                        value[i] = parmlist[0].getOutputData()[i];
                        ++i;
                    }
                    int value1 = intConv.toInt(value);
                    if (value1 >= 0) {
                        String output = (String)convert4.toObject(parmlist[0].getOutputData());
                        int status = Integer.parseInt(output.substring(40, 41));
                        switch (status) {
                            case 0: {
                                bl = false;
                                break;
                            }
                            case 1: {
                                bl = false;
                                break;
                            }
                            case 2: {
                                bl = true;
                                break;
                            }
                            case 3: {
                                bl = true;
                                break;
                            }
                            case 4: {
                                bl = false;
                                break;
                            }
                            case 5: {
                                bl = false;
                                break;
                            }
                            case 6: {
                                bl = true;
                                break;
                            }
                            default: {
                                bl = false;
                                break;
                            }
                        }
                    } else {
                        bl = false;
                    }
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] mkPTFParm(AS400 aS400, String string, String string2, String string3) throws Exception {
        AS400 aS4002 = aS400;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        Object[] objectArray = new Object[]{aS4002, string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object[])objectArray);
        try {
            void rls;
            void prdid;
            void ptfid;
            void as400;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            AS400Bin4 intConv = new AS400Bin4();
            AS400Text char25Conv = new AS400Text(25, as400.getCcsid(), (AS400)as400);
            AS400Text char7Conv = new AS400Text(7, as400.getCcsid(), (AS400)as400);
            AS400Text char6Conv = new AS400Text(6, as400.getCcsid(), (AS400)as400);
            AS400Text char1Conv = new AS400Text(1, as400.getCcsid(), (AS400)as400);
            byte[] ptfInfo = new byte[50];
            if (ptfid.length() != 7) {
                throw new Exception("Conversion failed ptfid: " + (String)ptfid);
            }
            char7Conv.toBytes((Object)ptfid, ptfInfo, 0);
            if (prdid.length() != 7) {
                throw new Exception("Conversion failed prdid: " + (String)prdid);
            }
            char7Conv.toBytes((Object)prdid, ptfInfo, 7);
            if (rls.length() != 6) {
                throw new Exception("Conversion failed rls: " + (String)rls);
            }
            char6Conv.toBytes((Object)rls, ptfInfo, 14);
            intConv.toBytes(as400.getCcsid(), ptfInfo, 20);
            char1Conv.toBytes((Object)CLOSEDB, ptfInfo, 24);
            char25Conv.toBytes((Object)"", ptfInfo, 25);
            byte[] byArray = ptfInfo;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(byArray, joinPoint);
            return ptfInfo;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Object[] asReturn = new String[AS_REQUIRED_PARAMS.length + super.getRequiredParams().length];
            ArrayUtils.appendArray(asReturn, AS_REQUIRED_PARAMS, 0);
            ArrayUtils.appendArray(asReturn, super.getRequiredParams(), AS_REQUIRED_PARAMS.length);
            Object[] objectArray = asReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(objectArray, joinPoint);
            return asReturn;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Object[] asReturn = new String[AS_OPTIONAL_PARAMS.length + super.getOptionalParams().length];
            ArrayUtils.appendArray(asReturn, AS_OPTIONAL_PARAMS, 0);
            ArrayUtils.appendArray(asReturn, super.getOptionalParams(), AS_OPTIONAL_PARAMS.length);
            Object[] objectArray = asReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(objectArray, joinPoint);
            return asReturn;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isOSVersionAcceptable(AS400 aS400) throws AS400SecurityException, IOException, Exception {
        AS400 aS4002 = aS400;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)aS4002);
        try {
            boolean bl;
            void as400;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sVersion = this.checkOSVersion((AS400)as400);
            String sVersionParams = this.getParamValue(S_VERSION_PARAM);
            try {
                boolean fResult;
                bl = fResult = VersionUtils.isVersionAcceptableToTheseVersionParams(sVersion, sVersionParams);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_fUnexpectedExceptionOccured = true;
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

