/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.os;

import com.ibm.ws.install.ni.framework.NIFConstants;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.os.ExecEngine;
import com.ibm.ws.install.ni.framework.os.ProcessEnvironment;
import com.ibm.ws.install.ni.framework.utils.ArrayUtils;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class PlatformConstants {
    public static final int N_UNKNOWN = 0;
    public static final int N_AIX = 1;
    public static final int N_HPUX = 2;
    public static final int N_SOLARIS = 3;
    public static final int N_LINUX = 4;
    public static final int N_WINDOWS = 5;
    public static final int N_Z_OS = 6;
    public static final int N_OS400 = 7;
    public static final int N_OS400_REMOTE = 8;
    private static final int N_UNDEFINED = -1;
    private static int nPlatformNumber;
    private static final String S_JAVA_OS_PROPERTY = "os.name";
    private static final String S_JAVA_OS_VERSION_PROPERTY = "os.version";
    private static final String S_AIX_PATTERN = "^.*aix.*$";
    private static final String S_HPUX_PATTERN = "^.*hp-ux.*$";
    private static final String S_SOLARIS_PATTERN = "^.*sunos.*$";
    private static final String S_LINUX_PATTERN = "^.*linux.*$";
    private static final String S_WINDOWS_PATTERN = "^.*windows.*$";
    private static final String S_Z_OS_PATTERN = "^.*z/os.*$";
    private static final String S_OS400_PATTERN = "^.*os/400.*$";
    private static final String S_WINDOWS_XP = "windows xp";
    private static final String S_WINDOWS_2000 = "windows 2000";
    private static final String S_WINDOWS_VISTA_VERSION = "6.0";
    private static final String[] AS_NETSCAPE;
    private static final String[] AS_MOZILLA;
    private static final String[] AS_IEXPLORE;
    private static final String[] AS_NONE;
    private static final String[] AS_SHELL_EXEC_WIN;
    private static final String[] AS_SHELL_EXEC_UNIX;
    private static final String[] AS_SHELL_EXEC_OS400;
    private static final String[] AS_EMPTY;
    private static final String S_WSADMIN_UNIX = "wsadmin.sh";
    private static final String S_WSADMIN_WINDOWS = "wsadmin.bat";
    private static final String S_WSADMIN_OS400 = "wsadmin";
    private static final String S_ANT_UNIX = "ant";
    private static final String S_ANT_WINDOWS = "ant.bat";
    private static final String S_ANT_OS400 = "ant";
    private static final String S_SPACE = " ";
    private static final String S_QUOTE = "\"";
    private static final String S_EMPTY = "";
    private static final String S_DOLLAR = "$";
    private static final String S_PERCENTAGE = "%";
    private static final String S_UNIX_SHELL_VARIABLE_BRACKET_START = "{";
    private static final String S_UNIX_SHELL_VARIABLE_BRACKET_STOP = "}";
    private static final String S_DOT = ".";
    private static final String S_PATTERN_CHECK_IF_STRING_HAS_ANY_SPACES = "^.*\\s.*$";
    private static final char C_QUOTE = '\"';
    private static final char C_SPACE = ' ';
    private static final String S_UTF_8 = "UTF-8";
    private static final String S_SPACE_HEX = "%20";
    private static final String S_WINDOWS_FS_PATH_SEPARATOR = "\\";
    private static final String S_UNIX_FS_PATH_SEPARATOR = "/";
    private static final String S_OS400_FS_PATH_SEPARATOR = "/";
    private static final String[] AS_WINOSNAME_VERSION_MAPPING;
    private static final String[] S_OSLEVEL_R_CMD;
    private static final String[] S_UNAME_DASH_A_CMD;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.StaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;
    private static final JoinPoint.StaticPart ajc$tjp_22;
    private static final JoinPoint.StaticPart ajc$tjp_23;
    private static final JoinPoint.StaticPart ajc$tjp_24;
    private static final JoinPoint.StaticPart ajc$tjp_25;

    static {
        Factory factory = new Factory("PlatformConstants.java", Class.forName("com.ibm.ws.install.ni.framework.os.PlatformConstants"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.os.PlatformConstants----"), 25);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isOS400Install-com.ibm.ws.install.ni.framework.os.PlatformConstants----boolean-"), 33);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isCurrentPlatformWindowsVista-com.ibm.ws.install.ni.framework.os.PlatformConstants----boolean-"), 249);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isCurrentPlatformWindows2000orXP-com.ibm.ws.install.ni.framework.os.PlatformConstants----boolean-"), 265);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isCurrentPlatformOS400-com.ibm.ws.install.ni.framework.os.PlatformConstants----boolean-"), 289);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-convertExecArrayToPlatformSpecificExecCommand-com.ibm.ws.install.ni.framework.os.PlatformConstants-[Ljava.lang.String;:-asExecArray:--java.lang.String-"), 311);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getCurrentPlatform-com.ibm.ws.install.ni.framework.os.PlatformConstants----int-"), 329);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getCurrentPlatformCode-com.ibm.ws.install.ni.framework.os.PlatformConstants----java.lang.String-"), 390);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getTargetPlatform-com.ibm.ws.install.ni.framework.os.PlatformConstants----int-"), 438);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getTargetPlatformCode-com.ibm.ws.install.ni.framework.os.PlatformConstants----java.lang.String-"), 455);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getEnvironmentVariableValue-com.ibm.ws.install.ni.framework.os.PlatformConstants-java.lang.String:-sName:--java.lang.String-"), 473);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-convertToShellVariable-com.ibm.ws.install.ni.framework.os.PlatformConstants-java.lang.String:-sName:--java.lang.String-"), 487);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isOS400NativeInstall-com.ibm.ws.install.ni.framework.os.PlatformConstants----boolean-"), 60);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-convertToShellParam-com.ibm.ws.install.ni.framework.os.PlatformConstants-java.lang.String:-sParam:--java.lang.String-"), 515);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getCurrentOSFSPathSeparator-com.ibm.ws.install.ni.framework.os.PlatformConstants----java.lang.String-"), 536);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getWindowsOSName-com.ibm.ws.install.ni.framework.os.PlatformConstants-java.lang.String:-sVersion:--java.lang.String-"), 563);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getCurrentOSUpdateLevel-com.ibm.ws.install.ni.framework.os.PlatformConstants----java.lang.String-"), 588);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-quoteStringsWithSpacesInTheArray-com.ibm.ws.install.ni.framework.os.PlatformConstants-[Ljava.lang.String;:-asStringArrayToModify:--void-"), 614);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-isQuoted-com.ibm.ws.install.ni.framework.os.PlatformConstants-java.lang.String:-sToCheck:--boolean-"), 635);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isOS400RemoteInstall-com.ibm.ws.install.ni.framework.os.PlatformConstants----boolean-"), 84);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getWebBrowserForThisPlatform-com.ibm.ws.install.ni.framework.os.PlatformConstants----[Ljava.lang.String;-"), 106);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getShellExecPrefixForCurrentPlatform-com.ibm.ws.install.ni.framework.os.PlatformConstants----[Ljava.lang.String;-"), 147);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isCurrentPlatformUNIX-com.ibm.ws.install.ni.framework.os.PlatformConstants----boolean-"), 172);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isCurrentPlatformAIX-com.ibm.ws.install.ni.framework.os.PlatformConstants----boolean-"), 195);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isCurrentPlatformHPUnix-com.ibm.ws.install.ni.framework.os.PlatformConstants----boolean-"), 214);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-isCurrentPlatformWindows-com.ibm.ws.install.ni.framework.os.PlatformConstants----boolean-"), 233);
        nPlatformNumber = -1;
        AS_NETSCAPE = new String[]{"netscape"};
        AS_MOZILLA = new String[]{"mozilla"};
        AS_IEXPLORE = new String[]{"cmd.exe", "/c", "\"start iexplore\""};
        AS_NONE = new String[]{S_EMPTY};
        AS_SHELL_EXEC_WIN = new String[]{"cmd.exe", "/c"};
        AS_SHELL_EXEC_UNIX = new String[]{"sh", "-c"};
        AS_SHELL_EXEC_OS400 = new String[]{"sh", "-c"};
        AS_EMPTY = new String[0];
        AS_WINOSNAME_VERSION_MAPPING = new String[]{"Windows 2000;5.0", "Windows XP;5.1", "Windows 2003;5.2"};
        S_OSLEVEL_R_CMD = new String[]{"oslevel", "-r"};
        S_UNAME_DASH_A_CMD = new String[]{"uname", "-a"};
    }

    public PlatformConstants() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean isOS400Install() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = PlatformConstants.isCurrentPlatformOS400() ? true : NIFConstants.getProperty("com.ibm.was.install") != null && (NIFConstants.getProperty("com.ibm.was.install").equals("os400Native") || NIFConstants.getProperty("com.ibm.was.install").equals("os400Remote"));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean isOS400NativeInstall() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = PlatformConstants.isCurrentPlatformOS400() ? true : NIFConstants.getProperty("com.ibm.was.install") != null && NIFConstants.getProperty("com.ibm.was.install").equals("os400Native");
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean isOS400RemoteInstall() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = NIFConstants.getProperty("com.ibm.was.install") != null && NIFConstants.getProperty("com.ibm.was.install").equals("os400Remote");
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String[] getWebBrowserForThisPlatform() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] asBrowser = null;
            switch (PlatformConstants.getCurrentPlatform()) {
                case 1: 
                case 2: 
                case 3: {
                    asBrowser = AS_NETSCAPE;
                    break;
                }
                case 4: {
                    asBrowser = AS_MOZILLA;
                    break;
                }
                case 5: {
                    asBrowser = AS_IEXPLORE;
                    break;
                }
                case 6: {
                    asBrowser = AS_NONE;
                    break;
                }
                case 7: {
                    asBrowser = AS_NONE;
                    break;
                }
                default: {
                    asBrowser = AS_NETSCAPE;
                    break;
                }
            }
            String[] stringArray = asBrowser;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return asBrowser;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String[] getShellExecPrefixForCurrentPlatform() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] stringArray = PlatformConstants.isCurrentPlatformUNIX() ? AS_SHELL_EXEC_UNIX : (PlatformConstants.isCurrentPlatformWindows() ? AS_SHELL_EXEC_WIN : (PlatformConstants.isCurrentPlatformOS400() ? AS_SHELL_EXEC_OS400 : AS_EMPTY));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray, joinPoint);
            return stringArray;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean isCurrentPlatformUNIX() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            int nCurrentPlatform = PlatformConstants.getCurrentPlatform();
            boolean bl = nCurrentPlatform == 1 || nCurrentPlatform == 2 || nCurrentPlatform == 3 || nCurrentPlatform == 4 || nCurrentPlatform == 6;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean isCurrentPlatformAIX() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            int nCurrentPlatform = PlatformConstants.getCurrentPlatform();
            boolean bl = nCurrentPlatform == 1;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean isCurrentPlatformHPUnix() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            int nCurrentPlatform = PlatformConstants.getCurrentPlatform();
            boolean bl = nCurrentPlatform == 2;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean isCurrentPlatformWindows() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = PlatformConstants.getCurrentPlatform() == 5;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean isCurrentPlatformWindowsVista() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null);
        try {
            String sOSVersion;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = PlatformConstants.isCurrentPlatformWindows() && (sOSVersion = System.getProperty(S_JAVA_OS_VERSION_PROPERTY)).trim().startsWith(S_WINDOWS_VISTA_VERSION);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean isCurrentPlatformWindows2000orXP() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, null, null);
        try {
            String sOSName;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            boolean bl = PlatformConstants.getCurrentPlatform() == 5 ? ((sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase()).indexOf(S_WINDOWS_XP) != -1 ? true : sOSName.indexOf(S_WINDOWS_2000) != -1) : false;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static boolean isCurrentPlatformOS400() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            int nCurrentPlatform = PlatformConstants.getCurrentPlatform();
            boolean bl = nCurrentPlatform == 7;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String convertExecArrayToPlatformSpecificExecCommand(String[] stringArray) {
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, null, null, (Object)stringArray2);
        try {
            String[] asExecArray;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            String[] asExecArrayCopy = new String[asExecArray.length];
            ArrayUtils.cloneArray(asExecArrayCopy, asExecArray);
            PlatformConstants.quoteStringsWithSpacesInTheArray(asExecArrayCopy);
            String string = ArrayUtils.join(S_SPACE, asExecArrayCopy);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static int getCurrentPlatform() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, null, null);
        try {
            int n;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            if (nPlatformNumber != -1) {
                n = nPlatformNumber;
            } else {
                String sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
                if (Pattern.matches(S_AIX_PATTERN, sOSName)) {
                    nPlatformNumber = 1;
                    n = 1;
                } else if (Pattern.matches(S_HPUX_PATTERN, sOSName)) {
                    nPlatformNumber = 2;
                    n = 2;
                } else if (Pattern.matches(S_SOLARIS_PATTERN, sOSName)) {
                    nPlatformNumber = 3;
                    n = 3;
                } else if (Pattern.matches(S_LINUX_PATTERN, sOSName)) {
                    nPlatformNumber = 4;
                    n = 4;
                } else if (Pattern.matches(S_WINDOWS_PATTERN, sOSName)) {
                    nPlatformNumber = 5;
                    n = 5;
                } else if (Pattern.matches(S_Z_OS_PATTERN, sOSName)) {
                    nPlatformNumber = 6;
                    n = 6;
                } else if (Pattern.matches(S_OS400_PATTERN, sOSName)) {
                    nPlatformNumber = 7;
                    n = 7;
                } else {
                    nPlatformNumber = 0;
                    n = 0;
                }
            }
            int n2 = n;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String getCurrentPlatformCode() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
            String string = Pattern.matches(S_AIX_PATTERN, sOSName) ? "aix" : (Pattern.matches(S_HPUX_PATTERN, sOSName) ? "hpux" : (Pattern.matches(S_SOLARIS_PATTERN, sOSName) ? "solaris" : (Pattern.matches(S_LINUX_PATTERN, sOSName) ? "linux" : (Pattern.matches(S_WINDOWS_PATTERN, sOSName) ? "windows" : (Pattern.matches(S_Z_OS_PATTERN, sOSName) ? "zos" : (Pattern.matches(S_OS400_PATTERN, sOSName) ? "os400" : "NA"))))));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static int getTargetPlatform() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            int nTargetPlatform = PlatformConstants.getCurrentPlatform();
            if (PlatformConstants.isOS400RemoteInstall()) {
                nTargetPlatform = 8;
            }
            int n = nTargetPlatform;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.intObject((int)n), joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String getTargetPlatformCode() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sTargetPlatform = PlatformConstants.getCurrentPlatformCode();
            if (PlatformConstants.isOS400RemoteInstall()) {
                sTargetPlatform = "os400Remote";
            }
            String string = sTargetPlatform;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String getEnvironmentVariableValue(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, null, null, (Object)string2);
        try {
            String sName;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            String string3 = ProcessEnvironment.getEnvironmentVariableValue(sName);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string3, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String convertToShellVariable(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, null, null, (Object)string2);
        try {
            String sName;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            String string3 = PlatformConstants.isCurrentPlatformUNIX() || PlatformConstants.isCurrentPlatformOS400() ? "${" + sName + S_UNIX_SHELL_VARIABLE_BRACKET_STOP : (PlatformConstants.isCurrentPlatformWindows() ? S_PERCENTAGE + sName + S_PERCENTAGE : sName);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string3, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String convertToShellParam(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, null, null, (Object)string2);
        try {
            String sReturn;
            String sParam;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
            String string3 = sParam.matches(S_PATTERN_CHECK_IF_STRING_HAS_ANY_SPACES) && !PlatformConstants.isQuoted(sParam) ? (sReturn = S_QUOTE + sParam + S_QUOTE) : sParam;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string3, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String getCurrentOSFSPathSeparator() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, null, null);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = PlatformConstants.isCurrentPlatformOS400() ? "/" : (PlatformConstants.isCurrentPlatformUNIX() ? "/" : (PlatformConstants.isCurrentPlatformWindows() ? S_WINDOWS_FS_PATH_SEPARATOR : "/"));
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String getWindowsOSName(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, null, null, (Object)string2);
        try {
            String string3;
            block4: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$5$7b38cfba(joinPoint);
                String[] asWinOSNameVersionMapping = AS_WINOSNAME_VERSION_MAPPING;
                int i = 0;
                while (i < asWinOSNameVersionMapping.length) {
                    String sVersion;
                    String sWinOSName = asWinOSNameVersionMapping[i].substring(0, asWinOSNameVersionMapping[i].indexOf(";"));
                    String sVersionThis = asWinOSNameVersionMapping[i].substring(asWinOSNameVersionMapping[i].indexOf(";") + 1);
                    if (sVersionThis.equals(sVersion)) {
                        string3 = sWinOSName;
                        break block4;
                    }
                    ++i;
                }
                string3 = S_EMPTY;
            }
            String string4 = string3;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$6$b7b26af1(string4, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public static String getCurrentOSUpdateLevel() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_23, null, null);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            ExecEngine execEngine = new ExecEngine();
            if (PlatformConstants.isCurrentPlatformUNIX() && PlatformConstants.getCurrentPlatform() == 1) {
                execEngine.executeIncomingArguments(S_OSLEVEL_R_CMD, NIFConstants.N_DEFAULT_PROCESS_TIME_OUT_TIME);
                string = execEngine.getProcessStdOut();
            } else {
                execEngine.executeIncomingArguments(S_UNAME_DASH_A_CMD, NIFConstants.N_DEFAULT_PROCESS_TIME_OUT_TIME);
                string = execEngine.getProcessStdOut();
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static void quoteStringsWithSpacesInTheArray(String[] stringArray) {
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_24, null, null, (Object)stringArray2);
        try {
            String[] asStringArrayToModify;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            int i = 0;
            while (i < asStringArrayToModify.length) {
                asStringArrayToModify[i] = PlatformConstants.convertToShellParam(asStringArrayToModify[i]);
                ++i;
            }
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private static boolean isQuoted(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_25, null, null, (Object)string2);
        try {
            boolean bl;
            block5: {
                String sToCheck;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                boolean fQuoted = false;
                int i = 0;
                while (i < sToCheck.length()) {
                    if (sToCheck.charAt(i) == '\"') {
                        boolean bl2 = fQuoted = !fQuoted;
                    }
                    if (sToCheck.charAt(i) == ' ' && !fQuoted) {
                        bl = false;
                        break block5;
                    }
                    ++i;
                }
                bl = true;
            }
            boolean bl3 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl3), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

