/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.os;

import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.os.OSPrereqPlugin;
import com.ibm.ws.install.ni.framework.os.PlatformConstants;
import com.ibm.ws.install.ni.framework.product.VersionUtils;
import com.ibm.ws.install.ni.framework.utils.ArrayUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class SolarisPrereqPlugin
extends OSPrereqPlugin {
    private static String[] m_sPatchFlags;
    private boolean m_fOSVersion;
    private boolean m_fOSArch;
    private boolean m_fOSPatch;
    private static int m_nVersionNotMatchWeight;
    private static final String S_SOLARIS = "Solaris";
    private static final String[] S_SHOWREV_CMD;
    private static final String[] S_ISAINFO_CMD;
    private static final String S_PATCH_ID_PATTERN = "\\d+[-]\\d+";
    private static final String[] AS_OPTIONAL_PARAMS;
    private static final String[] AS_REQUIRED_PARAMS;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;

    static {
        Factory factory = new Factory("SolarisPrereqPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.os.SolarisPrereqPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.os.SolarisPrereqPlugin----"), 292);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.os.SolarisPrereqPlugin----java.lang.String-"), 38);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getPatchID-com.ibm.ws.install.ni.framework.os.SolarisPrereqPlugin-java.lang.String:java.lang.String:-sIn:sPattern:--java.lang.String-"), 276);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.os.SolarisPrereqPlugin----java.lang.String-"), 84);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getWeight-com.ibm.ws.install.ni.framework.os.SolarisPrereqPlugin----java.lang.String-"), 109);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.os.SolarisPrereqPlugin----[Ljava.lang.String;-"), 120);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.os.SolarisPrereqPlugin----[Ljava.lang.String;-"), 140);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isOSArchAcceptable-com.ibm.ws.install.ni.framework.os.SolarisPrereqPlugin----boolean-"), 160);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isOSVersionAcceptable-com.ibm.ws.install.ni.framework.os.SolarisPrereqPlugin----boolean-"), 180);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isOSPatchAcceptable-com.ibm.ws.install.ni.framework.os.SolarisPrereqPlugin---java.io.IOException:-boolean-"), 208);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkPatches-com.ibm.ws.install.ni.framework.os.SolarisPrereqPlugin-[Ljava.lang.String;:-sPatchArray:-java.io.IOException:-[Ljava.lang.String;-"), 229);
        m_sPatchFlags = null;
        m_nVersionNotMatchWeight = 0;
        S_SHOWREV_CMD = new String[]{"showrev", "-p"};
        S_ISAINFO_CMD = new String[]{"isainfo", "-k"};
        AS_OPTIONAL_PARAMS = new String[0];
        AS_REQUIRED_PARAMS = new String[0];
    }

    public SolarisPrereqPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_fOSVersion = false;
            this.m_fOSArch = false;
            this.m_fOSPatch = false;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            String string;
            block11: {
                block10: {
                    NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
                    if (this.isOSCheckDisabled()) {
                        string = Boolean.TRUE.toString();
                    } else if (PlatformConstants.getCurrentPlatform() != 3) {
                        string = Boolean.FALSE.toString();
                    } else {
                        try {
                            this.m_fOSVersion = this.isOSVersionAcceptable();
                            this.m_fOSArch = this.isOSArchAcceptable();
                            this.m_fOSPatch = this.isOSPatchAcceptable();
                            if (!this.m_fOSVersion) {
                                ++m_nVersionNotMatchWeight;
                            }
                            if (this.m_fOSVersion && this.m_fOSArch && this.m_fOSPatch) {
                                string = Boolean.TRUE.toString();
                            }
                            break block10;
                        }
                        catch (Exception exception) {
                            this.m_fUnexpectedExceptionOccured = true;
                            string = Boolean.FALSE.toString();
                        }
                    }
                    break block11;
                }
                string = Boolean.FALSE.toString();
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (this.m_fUnexpectedExceptionOccured) {
                string = this.getPrereqGenericExceptionFailureMessage();
            } else {
                String sIn = this.getParamValue("version");
                String sVersion = this.getVersionNumber(sIn, "(\\d+[.]*)+");
                String sOSString = "Solaris " + sVersion;
                string = PlatformConstants.getCurrentPlatform() != 3 ? this.getInvalidPlatformMessage(S_SOLARIS, sVersion) : this.getOSPrereqWarningMessage(this.m_fOSVersion, this.m_fOSArch, this.m_fOSPatch, m_sPatchFlags, sOSString);
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getWeight() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.getWeightValue(this.m_fOSVersion, this.m_fOSArch, this.m_fOSPatch, m_nVersionNotMatchWeight);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Object[] asReturn = new String[AS_REQUIRED_PARAMS.length + super.getRequiredParams().length];
            ArrayUtils.appendArray(asReturn, AS_REQUIRED_PARAMS, 0);
            ArrayUtils.appendArray(asReturn, super.getRequiredParams(), AS_REQUIRED_PARAMS.length);
            Object[] objectArray = asReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(objectArray, joinPoint);
            return asReturn;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Object[] asReturn = new String[AS_OPTIONAL_PARAMS.length + super.getOptionalParams().length];
            ArrayUtils.appendArray(asReturn, AS_OPTIONAL_PARAMS, 0);
            ArrayUtils.appendArray(asReturn, super.getOptionalParams(), AS_OPTIONAL_PARAMS.length);
            Object[] objectArray = asReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(objectArray, joinPoint);
            return asReturn;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isOSArchAcceptable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sArch = this.getStandardOutputFromProcessCall(S_ISAINFO_CMD).trim();
            Vector sArchParams = this.getParamListAsStringVector("arch");
            boolean bl = sArchParams.contains(sArch);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isOSVersionAcceptable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sVersion = System.getProperty("os.version");
            String sVersionParams = this.getParamValue("version");
            try {
                boolean fResult;
                bl = fResult = VersionUtils.isVersionAcceptableToTheseVersionParams(sVersion, sVersionParams);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_fUnexpectedExceptionOccured = true;
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isOSPatchAcceptable() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] sPatchParams = this.getParamValues("patch");
            if (sPatchParams == null) {
                bl = true;
            } else {
                m_sPatchFlags = this.checkPatches(sPatchParams);
                bl = this.getBooleanFlag(m_sPatchFlags);
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String[] checkPatches(String[] stringArray) throws IOException {
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)stringArray2);
        try {
            void sPatchArray;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] sPatchFlags = new String[((void)sPatchArray).length];
            BufferedReader bufferedreaderIn = new BufferedReader(new StringReader(this.getStandardOutputFromProcessCall(S_SHOWREV_CMD)));
            String sLine = bufferedreaderIn.readLine();
            while (sLine != null) {
                int i = 0;
                while (i < ((void)sPatchArray).length) {
                    String[] sPatchElement = sPatchArray[i].split(";");
                    String sPatchName = sPatchElement[0].trim();
                    String sPatchID = this.getPatchID(sLine, S_PATCH_ID_PATTERN);
                    if (sPatchID.equals(sPatchName)) {
                        sPatchFlags[i] = "true";
                    }
                    ++i;
                }
                sLine = bufferedreaderIn.readLine();
            }
            int p = 0;
            while (p < sPatchFlags.length) {
                if (sPatchFlags[p] == null) {
                    sPatchFlags[p] = "false";
                }
                ++p;
            }
            String[] stringArray3 = sPatchFlags;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray3, joinPoint);
            return sPatchFlags;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getPatchID(String string, String string2) {
        String string3 = string;
        String string4 = string2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string3, (Object)string4);
        try {
            String sPatchID;
            void sIn;
            void sPattern;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Pattern patternLanguage = Pattern.compile((String)sPattern);
            Matcher matcher = patternLanguage.matcher((CharSequence)sIn);
            matcher.find();
            int nStart = matcher.start();
            int nStop = matcher.end();
            String string5 = sPatchID = sIn.substring(nStart, nStop);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string5, joinPoint);
            return string5;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

