/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.ni.framework.os;

import com.ibm.ws.install.ni.framework.NIFConstants;
import com.ibm.ws.install.ni.framework.aspects.logging.NIFTracingAspect;
import com.ibm.ws.install.ni.framework.os.ExecEngine;
import com.ibm.ws.install.ni.framework.os.OSPrereqPlugin;
import com.ibm.ws.install.ni.framework.os.PlatformConstants;
import com.ibm.ws.install.ni.framework.product.VersionUtils;
import com.ibm.ws.install.ni.framework.utils.ArrayUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class WindowsPrereqPlugin
extends OSPrereqPlugin {
    private static String[] m_sPatchFlags;
    private boolean m_fOSVersion;
    private boolean m_fOSArch;
    private boolean m_fOSPatch;
    private static int m_iCounter;
    private static int m_nVersionNotMatchWeight;
    private static final String[] S_REGEDIT_CMD;
    private static final String[] S_ECHO_PROCESSOR_ID_CMD;
    private static final String S_TEMP_REG_SP;
    private static final String S_TEMP_REG_HOTFIX;
    private static final String S_UTF_16 = "UTF-16";
    private static final String S_SP_VERSION_PATTERN = "\\d+";
    private static final String[] AS_OPTIONAL_PARAMS;
    private static final String[] AS_REQUIRED_PARAMS;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;

    static {
        Factory factory = new Factory("WindowsPrereqPlugin.java", Class.forName("com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin"));
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin----"), 393);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getFlag-com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin----java.lang.String-"), 41);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkServicePackVersion-com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin-java.lang.String:java.lang.String:java.lang.String:-sIn:sInVersion:sPattern:-java.io.IOException:-java.lang.String-"), 296);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkHotFix-com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin-java.lang.String:-sIn:-java.io.IOException:-java.lang.String-"), 351);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getPrereqFailureMessage-com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin----java.lang.String-"), 93);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getWeight-com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin----java.lang.String-"), 123);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getRequiredParams-com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin----[Ljava.lang.String;-"), 134);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-getOptionalParams-com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin----[Ljava.lang.String;-"), 154);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isOSArchAcceptable-com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin----boolean-"), 174);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isOSVersionAcceptable-com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin---java.io.IOException:-boolean-"), 194);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-isOSPatchAcceptable-com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin---java.io.IOException:-boolean-"), 230);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkPatches-com.ibm.ws.install.ni.framework.os.WindowsPrereqPlugin-[Ljava.lang.String;:-sPatchArray:-java.io.IOException:-[Ljava.lang.String;-"), 251);
        m_sPatchFlags = null;
        m_iCounter = 0;
        m_nVersionNotMatchWeight = 0;
        S_REGEDIT_CMD = new String[]{"regedit.exe", "/e", "", ""};
        S_ECHO_PROCESSOR_ID_CMD = new String[]{"cmd.exe", "/c", "echo", "%PROCESSOR_IDENTIFIER%"};
        S_TEMP_REG_SP = String.valueOf(System.getProperty("java.io.tmpdir")) + "/" + "tempRegSP";
        S_TEMP_REG_HOTFIX = String.valueOf(System.getProperty("java.io.tmpdir")) + "/" + "tempRegHotFix";
        AS_OPTIONAL_PARAMS = new String[0];
        AS_REQUIRED_PARAMS = new String[0];
    }

    public WindowsPrereqPlugin() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            this.m_fOSVersion = false;
            this.m_fOSArch = false;
            this.m_fOSPatch = false;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$10$ce9d105a(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getFlag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            String string;
            block13: {
                block12: {
                    NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
                    if (this.isOSCheckDisabled()) {
                        string = Boolean.TRUE.toString();
                    } else if (PlatformConstants.getCurrentPlatform() != 5) {
                        string = Boolean.FALSE.toString();
                    } else if (PlatformConstants.isOS400Install()) {
                        string = Boolean.FALSE.toString();
                    } else {
                        try {
                            this.m_fOSVersion = this.isOSVersionAcceptable();
                            this.m_fOSArch = this.isOSArchAcceptable();
                            this.m_fOSPatch = this.isOSPatchAcceptable();
                            if (!this.m_fOSVersion) {
                                ++m_nVersionNotMatchWeight;
                            }
                            if (this.m_fOSVersion && this.m_fOSArch && this.m_fOSPatch) {
                                string = Boolean.TRUE.toString();
                            }
                            break block12;
                        }
                        catch (Exception exception) {
                            this.m_fUnexpectedExceptionOccured = true;
                            string = Boolean.FALSE.toString();
                        }
                    }
                    break block13;
                }
                string = Boolean.FALSE.toString();
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getPrereqFailureMessage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            String string;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$2$8293217c(joinPoint);
            if (this.m_fUnexpectedExceptionOccured) {
                string = this.getPrereqGenericExceptionFailureMessage();
            } else {
                String sIn = this.getParamValue("version");
                String sVersion = this.getVersionNumber(sIn, "(\\d+[.]*)+");
                String sOSString = PlatformConstants.getWindowsOSName(sVersion);
                string = PlatformConstants.getCurrentPlatform() != 5 ? this.getInvalidPlatformMessage(sOSString, sVersion) : (PlatformConstants.isOS400Install() ? "" : this.getOSPrereqWarningMessage(this.m_fOSVersion, this.m_fOSArch, this.m_fOSPatch, m_sPatchFlags, sOSString));
            }
            String string2 = string;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$4$51bf5433(string2, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    public String getWeight() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String string = this.getWeightValue(this.m_fOSVersion, this.m_fOSArch, this.m_fOSPatch, m_nVersionNotMatchWeight);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string, joinPoint);
            return string;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getRequiredParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Object[] asReturn = new String[AS_REQUIRED_PARAMS.length + super.getRequiredParams().length];
            ArrayUtils.appendArray(asReturn, AS_REQUIRED_PARAMS, 0);
            ArrayUtils.appendArray(asReturn, super.getRequiredParams(), AS_REQUIRED_PARAMS.length);
            Object[] objectArray = asReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(objectArray, joinPoint);
            return asReturn;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    protected String[] getOptionalParams() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            Object[] asReturn = new String[AS_OPTIONAL_PARAMS.length + super.getOptionalParams().length];
            ArrayUtils.appendArray(asReturn, AS_OPTIONAL_PARAMS, 0);
            ArrayUtils.appendArray(asReturn, super.getOptionalParams(), AS_OPTIONAL_PARAMS.length);
            Object[] objectArray = asReturn;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(objectArray, joinPoint);
            return asReturn;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isOSArchAcceptable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        try {
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] sOutput = this.getStandardOutputFromProcessCall(S_ECHO_PROCESSOR_ID_CMD).trim().toLowerCase().split(" ");
            String sArch = sOutput[0];
            Vector sArchParams = this.getParamListAsStringVector("arch");
            boolean bl = sArchParams.contains(sArch);
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isOSVersionAcceptable() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String sIn = System.getProperty("os.version");
            String sVersion = this.getVersionNumber(sIn, "(\\d+[.]*)+");
            String sVersionParams = this.getParamValue("version");
            String osName = this.getParamValue("name");
            try {
                boolean fResult = VersionUtils.isVersionAcceptableToTheseVersionParams(sVersion, sVersionParams);
                if (osName != null) {
                    boolean osNameMatch = System.getProperty("os.name").equals(osName);
                    bl = fResult && osNameMatch;
                } else {
                    bl = fResult;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.m_fUnexpectedExceptionOccured = true;
                bl = false;
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    private boolean isOSPatchAcceptable() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        try {
            boolean bl;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] sPatchParams = this.getParamValues("patch");
            if (sPatchParams == null) {
                bl = true;
            } else {
                m_sPatchFlags = this.checkPatches(sPatchParams);
                bl = this.getBooleanFlag(m_sPatchFlags);
            }
            boolean bl2 = bl;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String[] checkPatches(String[] stringArray) throws IOException {
        String[] stringArray2 = stringArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)stringArray2);
        try {
            void sPatchArray;
            NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
            String[] sPatchFlags = new String[((void)sPatchArray).length];
            int i = 0;
            while (i < ((void)sPatchArray).length) {
                String[] sPatchElement = sPatchArray[i].split(";");
                String sPatchName = sPatchElement[0].trim();
                String sPatchVersion = sPatchElement[1].trim();
                if (sPatchName.indexOf("CSDVersion") >= 0) {
                    sPatchName = sPatchName.substring(0, sPatchName.indexOf("CSDVersion"));
                    sPatchFlags[i] = this.checkServicePackVersion(sPatchName, sPatchVersion, S_SP_VERSION_PATTERN);
                } else {
                    sPatchFlags[i] = this.checkHotFix(sPatchName);
                }
                ++i;
            }
            int p = 0;
            while (p < sPatchFlags.length) {
                if (sPatchFlags[p] == null) {
                    sPatchFlags[p] = "false";
                }
                ++p;
            }
            String[] stringArray3 = sPatchFlags;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(stringArray3, joinPoint);
            return sPatchFlags;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String checkServicePackVersion(String string, String string2, String string3) throws IOException {
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        Object[] objectArray = new Object[]{string4, string5, string6};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        try {
            String string7;
            block5: {
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                File fileTempRegSPOut = new File(S_TEMP_REG_SP);
                fileTempRegSPOut.deleteOnExit();
                if (!fileTempRegSPOut.exists()) {
                    void sIn;
                    WindowsPrereqPlugin.S_REGEDIT_CMD[WindowsPrereqPlugin.S_REGEDIT_CMD.length - 2] = fileTempRegSPOut.getCanonicalPath();
                    WindowsPrereqPlugin.S_REGEDIT_CMD[WindowsPrereqPlugin.S_REGEDIT_CMD.length - 1] = sIn;
                    ExecEngine execEngine = new ExecEngine();
                    execEngine.executeIncomingArguments(S_REGEDIT_CMD, NIFConstants.N_DEFAULT_PROCESS_TIME_OUT_TIME);
                }
                BufferedReader bufferedreaderIn = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileTempRegSPOut), S_UTF_16));
                String sLine = bufferedreaderIn.readLine();
                while (sLine != null) {
                    if (sLine.indexOf("CSDVersion") >= 0) {
                        void sInVersion;
                        void sPattern;
                        Pattern patternLanguage = Pattern.compile((String)sPattern);
                        Matcher matcher = patternLanguage.matcher(sLine);
                        matcher.find();
                        int nStart = matcher.start();
                        int nStop = matcher.end();
                        String sVersion = sLine.substring(nStart, nStop);
                        if (!sVersion.equals(sInVersion)) break;
                        string7 = "true";
                        break block5;
                    }
                    sLine = bufferedreaderIn.readLine();
                }
                string7 = "false";
            }
            String string8 = string7;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string8, joinPoint);
            return string7;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String checkHotFix(String string) throws IOException {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string2);
        try {
            String string3;
            block7: {
                void sIn;
                NIFTracingAspect.aspectOf().ajc$before$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$8$24a9e78e(joinPoint);
                String sCounter = Integer.toString(m_iCounter++);
                File fileTempRegHotFixOut = new File(String.valueOf(S_TEMP_REG_HOTFIX) + sCounter);
                fileTempRegHotFixOut.deleteOnExit();
                if (!fileTempRegHotFixOut.exists()) {
                    WindowsPrereqPlugin.S_REGEDIT_CMD[WindowsPrereqPlugin.S_REGEDIT_CMD.length - 2] = fileTempRegHotFixOut.getCanonicalPath();
                    WindowsPrereqPlugin.S_REGEDIT_CMD[WindowsPrereqPlugin.S_REGEDIT_CMD.length - 1] = sIn;
                    ExecEngine execEngine = new ExecEngine();
                    execEngine.executeIncomingArguments(S_REGEDIT_CMD, NIFConstants.N_DEFAULT_PROCESS_TIME_OUT_TIME);
                }
                if (!fileTempRegHotFixOut.exists()) {
                    string3 = "false";
                } else {
                    BufferedReader bufferedreaderIn = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileTempRegHotFixOut), S_UTF_16));
                    String sLine = bufferedreaderIn.readLine();
                    while (sLine != null) {
                        if (sLine.indexOf((String)sIn) >= 0) {
                            string3 = "true";
                            break block7;
                        }
                        sLine = bufferedreaderIn.readLine();
                    }
                    string3 = "false";
                }
            }
            String string4 = string3;
            NIFTracingAspect.aspectOf().ajc$afterReturning$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$9$419d36d4(string4, joinPoint);
            return string3;
        }
        catch (Throwable throwable) {
            NIFTracingAspect.aspectOf().ajc$afterThrowing$com_ibm_ws_install_ni_framework_aspects_logging_AbstractInstallerLogging$11$cb00ec41(throwable, joinPoint);
            throw throwable;
        }
    }
}

